//RevB Pinouts
//digital
//SDA       GP0 //I2C0
//SCL       GP1 //I2C0
//TOUCH IRQ GP13
//TOUCH CS  GP9
//LCD CS    GP4
//LCD RST   GP5
//MISO      GP12  //SPI1
//LCD DC    GP6
//SCK       GP10  //SPI1
//MOSI      GP11  //SPI1
//DCC1B     GP22
//DCC1A     GP21
//DCC2B     GP18
//DCC2A     GP20
//DCC2EN    GP19
//LED_PWM   GP3
//analog
//DCC1I     GP26
//DCC2I     GP27
//VSENSE    GP28

// in \libraries\TFT_eSPI\User_Setups
// just before #endif // USER_SETUP_LOADED, add (and comment out others):
//#include <User_Setups/PICO_ILI9488_DCC.h>     // Template file for a setup
// copy this file as PICO_ILI9488_DCC.h
/*
#define ILI9488_DRIVER
#define TFT_SPI_PORT 1
#define TFT_MISO 12
#define TFT_MOSI 11
#define TFT_SCLK 10
#define TFT_CS 4 // Chip select control pin
#define TFT_DC 6 // Data Command control pin
#define TFT_RST 5 // Reset pin (could connect to Arduino RESET pin)
#define TOUCH_CS 9 // Chip select pin (T_CS) of touch screen
#define SPI_FREQUENCY 27000000
#define SPI_TOUCH_FREQUENCY 2500000
*/

#define TOUCH_IRQ 13
#define LED_PWM 3
#define PICO_LED 25
#define DCC1I 27
#define DCC2I 26
#define VSENSE 28

uint16_t calData[5] = { 283, 3647, 233, 3412, 7 };  //from prototype

//critical buttons, handle individually
ButtonWidget dccOnButton = ButtonWidget(&tft);
ButtonWidget dccOffButton = ButtonWidget(&tft);
ButtonWidget stopAllButton = ButtonWidget(&tft);
//loco controls
ButtonWidget nButton = ButtonWidget(&tft);
ButtonWidget F0stat = ButtonWidget(&tft);
ButtonWidget F1stat = ButtonWidget(&tft);
ButtonWidget F2stat = ButtonWidget(&tft);
ButtonWidget F3stat = ButtonWidget(&tft);
ButtonWidget revButton = ButtonWidget(&tft);
ButtonWidget stopButton = ButtonWidget(&tft);
ButtonWidget forButton = ButtonWidget(&tft);
ButtonWidget F0Button = ButtonWidget(&tft);
ButtonWidget F1Button = ButtonWidget(&tft);
ButtonWidget F2Button = ButtonWidget(&tft);
ButtonWidget F3Button = ButtonWidget(&tft);
ButtonWidget* locoButtons[] = {&F0stat, &F1stat, &F2stat, &F3stat, &nButton, &revButton, &stopButton, &forButton, &F0Button, &F1Button, &F2Button, &F3Button};
uint8_t buttonCount = sizeof(locoButtons) / sizeof(locoButtons[0]);
TFT_eSprite knob = TFT_eSprite(&tft); 
SliderWidget slider = SliderWidget(&tft, &knob);
ButtonWidget loco0Button = ButtonWidget(&tft);
ButtonWidget loco1Button = ButtonWidget(&tft);
ButtonWidget loco2Button = ButtonWidget(&tft);
ButtonWidget loco3Button = ButtonWidget(&tft);
ButtonWidget loco4Button = ButtonWidget(&tft);
ButtonWidget progButton = ButtonWidget(&tft);
ButtonWidget setButton = ButtonWidget(&tft);
ButtonWidget* tabButtons[] = {&loco0Button, &loco1Button, &loco2Button, &loco3Button, &loco4Button, &progButton, &setButton};
uint8_t tabButtonCount = sizeof(tabButtons) / sizeof(tabButtons[0]);
ButtonWidget number0Button = ButtonWidget(&tft);
ButtonWidget number1Button = ButtonWidget(&tft);
ButtonWidget number2Button = ButtonWidget(&tft);
ButtonWidget number3Button = ButtonWidget(&tft);
ButtonWidget number4Button = ButtonWidget(&tft);
ButtonWidget number5Button = ButtonWidget(&tft);
ButtonWidget number6Button = ButtonWidget(&tft);
ButtonWidget number7Button = ButtonWidget(&tft);
ButtonWidget number8Button = ButtonWidget(&tft);
ButtonWidget number9Button = ButtonWidget(&tft);
ButtonWidget numberDotButton = ButtonWidget(&tft);
ButtonWidget numberEnterButton = ButtonWidget(&tft);
ButtonWidget numberCancelButton = ButtonWidget(&tft);
ButtonWidget numberDeleteButton = ButtonWidget(&tft);
ButtonWidget* numberButtons[] = {&number0Button,&number1Button,&number2Button,&number3Button,&number4Button,&number5Button,&number6Button,&number7Button,&number8Button,&number9Button,&numberEnterButton,&numberCancelButton,&numberDeleteButton,&numberDotButton};
uint8_t numberButtonCount = sizeof(numberButtons) / sizeof(numberButtons[0]);
//CV programming page
ButtonWidget cvCVenter = ButtonWidget(&tft);
ButtonWidget cvDoRead = ButtonWidget(&tft);
ButtonWidget cvDoWrite = ButtonWidget(&tft);
ButtonWidget cvValueEnter = ButtonWidget(&tft);
ButtonWidget cvExit = ButtonWidget(&tft);
ButtonWidget cvDirect = ButtonWidget(&tft);
ButtonWidget cvPhysical = ButtonWidget(&tft);
ButtonWidget cvPaged = ButtonWidget(&tft);
ButtonWidget cvOperations = ButtonWidget(&tft);
ButtonWidget cvLongAddress = ButtonWidget(&tft);
ButtonWidget* cvButtons[] = {&cvValueEnter,&cvCVenter,&cvDoRead,&cvDoWrite,&cvExit,&cvDirect,&cvPhysical,&cvPaged,&cvOperations,&cvLongAddress};
uint8_t cvButtonCount = sizeof(cvButtons) / sizeof(cvButtons[0]);
//Settings Page
ButtonWidget settingsExit = ButtonWidget(&tft);
ButtonWidget settingsI1Mult = ButtonWidget(&tft);
ButtonWidget settingsI2Mult = ButtonWidget(&tft);
ButtonWidget settingsVMult = ButtonWidget(&tft);
ButtonWidget settingsILimit = ButtonWidget(&tft);
ButtonWidget settingsIOffset = ButtonWidget(&tft);
ButtonWidget settingsLocos = ButtonWidget(&tft);
ButtonWidget* settingsButtons[] = {&settingsExit,&settingsI1Mult,&settingsI2Mult,&settingsVMult,&settingsILimit,&settingsIOffset,&settingsLocos};
uint8_t settingsButtonCount = sizeof(settingsButtons) / sizeof(settingsButtons[0]);

#define BUTTON_BORDER TFT_CYAN
#define CRIT_BUTTON_BORDER TFT_YELLOW
#define BUTTON_TEXT TFT_WHITE
#define BUTTON_BG TFT_BLACK
#define TEXT_BORDER TFT_BLACK
#define TEXT_TEXT TFT_CYAN
#define TEXT_BG TFT_BLACK
#define LAMP_BORDER TFT_GREY
#define LAMP_TEXT TFT_YELLOW
#define LAMP_BG TFT_BLACK
#define ERROR_COLOUR TFT_RED
#define OK_COLOUR TFT_GREEN

#define PRIORITY_PACKET_READY -1
#define PRIORITY_PACKET_JUSTPROCESSED -2

#define CV_DIRECT 1
#define CV_PHYSICAL 2
#define CV_PAGED 3
#define CV_OPERATIONS 4
#define CV_LONG_ADDRESS (-1)

int packetN=0;
int priorityPacket=PRIORITY_PACKET_READY;
#define LOCO_COUNT 5
loco_t locos[LOCO_COUNT];
dccPacket_t packets[LOCO_COUNT*2];  //2 per loco, speed and function
uint8_t activeLoco=0;
bool dccSwitchOn=0;
bool dccTripped=0;
unsigned long tripTime=0;
bool stateChange=0; //flag that displays should update
//globals
uint16_t touchX = 0, touchY = 0;
bool touchPressed;
#define KEYPAD_BUFFER 6
#define TIMED_UPDATE_INTERVAL 250
#define TRIP_TIMEOUT 1000
float dcc1Current=0;
float dcc2Current=0;
float supplyVoltage=0;
volatile bool getAnalogFlag=0;
//settings, also loco # and Functions
#define MULT_LIMIT 1.0
#define CURRENT_LIMIT_MAX 10.0
#define CURRENT_OFFSET_MAX 10.0
//A/ADC point
float dcc1Mult=0.0081;
float dcc2Mult=0.0081;
float vMult=0.0089;
float dccCurrentLimit=2.0;
float dccCurrentOffset=0.0;
float vLowerLimit=7;
float vUpperLimit=18;
int cvProgCV=1;
int cvReadValue=-1;
int cvWriteValue=0;
uint8_t cvMode=CV_DIRECT;

struct saveData_t {
  unsigned int okFlag;
  loco_t locos[LOCO_COUNT];
  float floats[5];
};

saveData_t saveData;  //RAM version copied to/from EEPROM
#define OK_FLAG_VALUE 0x09111243


//SLIP protocol
#define SLIP_PACKET_SIZE 32
#define SLIP_END (192)
#define SLIP_ESC (219)
#define SLIP_ESC_END (220)
#define SLIP_ESC_ESC (221)

#define SLIP_HEARTBEAT_PERIOD 5000
unsigned long slipHeartbeat=0;

#define SLIP_DCC_IMMEDIATE ('B')
#define SLIP_HOST_CHECK ('C')
#define SLIP_HOST_RESPONSE ('D')
#define SLIP_SYSTEM_COMMAND ('I')

struct slipPacket_t {  
  int byteCount;
  char data[SLIP_PACKET_SIZE];
};

typedef struct {
  unsigned char byte1;
  unsigned char byte2;
} slip_bytes_t;

slip_bytes_t slipEnd={SLIP_END,0};  //need to use this so it doesn't get encoded

unsigned char slipChecksum(slipPacket_t* p){
  int i;
  unsigned char cx=0;
  for(i=0;i<p->byteCount;i++){
    cx=cx^p->data[i];
  }
  return cx;
}

void addSlipChecksum(slipPacket_t* p){
  unsigned char cx;
  cx=slipChecksum(p);
  p->data[p->byteCount]=cx;
  p->byteCount++;
}

slip_bytes_t slipEncode(unsigned char b){ //SLIP encoding
    slip_bytes_t r;
    r.byte1=b;  //default
    r.byte2=0;
    if(b==SLIP_END){
        r.byte1=SLIP_ESC;
        r.byte2=SLIP_ESC_END;
    }else if(b==SLIP_ESC){
        r.byte1=SLIP_ESC;
        r.byte2=SLIP_ESC_ESC;        
    }
    return r;
}

void sendSlipByte(slip_bytes_t s){
    Serial1.write(s.byte1);
    if(s.byte2){
        Serial1.write(s.byte2);
    }
}

void sendSlipPacket(slipPacket_t* p){
  int i;
  for(i=0;i<p->byteCount;i++){
      sendSlipByte(slipEncode(p->data[i]));
  }
  sendSlipByte(slipEnd);
}


void sendSlipHostCheck(void){
  sendSlipByte(slipEncode(SLIP_HOST_CHECK));
  sendSlipByte(slipEncode(1));  //starting index should be 1
  sendSlipByte(slipEncode(1^SLIP_HOST_CHECK));
  sendSlipByte(slipEnd);
}

slipPacket_t processFeed(char c){ //feed c into machine and get results
  static slipPacket_t w={0,""}; //working
  slipPacket_t r={0,""};  //empty packet to return on no result
  static char last=0;
  if(c==SLIP_END){
    last=0; //reset
    if(slipChecksum(&w)==0){
      r=w;
    }else{
      //Serial.println("CX error");
    }
    w.byteCount=0;
  }else if(c==SLIP_ESC){
    last=SLIP_ESC;        //nothing added
  }else{
    if(last==SLIP_ESC){
      if(c==SLIP_ESC_END){
        w.data[w.byteCount]=SLIP_END;
        w.byteCount++;
      }else if(c==SLIP_ESC_ESC){
        w.data[w.byteCount]=SLIP_ESC;
        w.byteCount++;        
      } //otherwise ignore, unknown state
      last=0;
    }else{
      w.data[w.byteCount]=c;
      w.byteCount++;
    }
    last=0;
    if(w.byteCount>(SLIP_PACKET_SIZE-2)){w.byteCount=SLIP_PACKET_SIZE-2;} //avoid overflow, drop extra
  }
  return r;
}

dccPacket_t getDCCfromSLIP(slipPacket_t p){
  dccPacket_t d;
  int i;
  d.byteCount=0;
  if((p.byteCount) && (p.byteCount<=(PACKET_MAX_BYTES+2))){ //not too long
    if(p.data[0]==SLIP_DCC_IMMEDIATE){ //valid DCC encapsulation
      d.byteCount=p.byteCount-2;  //strip header and checksum
      for(i=0;i<PACKET_MAX_BYTES;i++){d.data[i]=p.data[i+1];}
    }
  }
  return d;
}

const char* getLocoList(void){  //get a char array of list of current locos
  int i;
  int s=0;
  int k=0;
  static char t[16*LOCO_COUNT]="";
  t[0]=0;
  for(i=0;i<LOCO_COUNT;i++){  //first k locos fit in array
    if(locos[i].address){
      s=strlen(t);
      sprintf(&t[s],"%d,",locos[i].address);
    }
    if(tft.textWidth(t)<220){k=i+1;}
  }
  t[0]=0;
  for(i=0;i<k;i++){
    if(locos[i].address){
      s=strlen(t);
      sprintf(&t[s],"%d,",locos[i].address);
    }
  }
  s=strlen(t);
  if(s==0){ //none selected
    sprintf(t,"---");    
  }else{
    if(k==LOCO_COUNT){t[s-1]=0;} //remove trailing comma if list complete
  }  
  return t;
}

void drawTextPanel(int w, int x, int y, const char* t){
  spr.createSprite(w,40,1);   //title
  spr.fillSprite(BUTTON_BG);
  spr.setTextColor(BUTTON_TEXT, BUTTON_BG);
  spr.printToSprite(t);
  spr.pushSprite(x,y);
  spr.deleteSprite();
}

void drawAllCrit(void){
  if(dccSwitchOn && (dccTripped==0)){
    dccOnButton.drawSmoothButton(true,3);
    dccOffButton.drawSmoothButton(false,3);
  }else{
    dccOnButton.drawSmoothButton(false,3);
    dccOffButton.drawSmoothButton(true,3);
  }
  stopAllButton.drawSmoothButton(false,3);
}

void handleDCC(void){  //edit locos[activeLoco] and update with these
  int i;
  //refresh packet contents
  for(i=0;i<LOCO_COUNT;i++){
    if(locos[i].address){
      speedPacket128(&packets[i*2],locos[i]);
      F04Packet(&packets[i*2+1],locos[i]);
    }else{
      idlePacket(&packets[i*2]);
      idlePacket(&packets[i*2+1]);
    }
  }
  while(packetQueueSpace()){
    //output priority packet?
    if(priorityPacket>-1){
      queuePacket(packets[priorityPacket]);
      priorityPacket=PRIORITY_PACKET_JUSTPROCESSED;
    }else{
      packetN=packetN+1;
      if(packetN>(LOCO_COUNT*2)){packetN=0;}
      while(checkPacketMatch(&packets[packetN],&pktIdle)&&(packetN<(LOCO_COUNT*2))){    //skip over idle
        packetN=packetN+1;
      }
      if(packetN>=(LOCO_COUNT*2)){packetN=0;}
      queuePacket(packets[packetN]);
      priorityPacket=PRIORITY_PACKET_READY; //we've processed a normal packet, so ready for another priority
    }
  }
  //trip logic, also handled by other core
  if(dcc1Current>dccCurrentLimit){
    dccTripped=1;
    tripTime=millis();
    drawAllCrit();
  }
  if(dccTripped && (millis()-tripTime)>TRIP_TIMEOUT){ //autoreset
    dccTripped=0; 
    drawAllCrit();
  }
  //DCC on/off/trip logic
  if(dccSwitchOn && (dccTripped==0)){
    dcc1on=1;
  }else{
    dcc1on=0;
  }
}

void UIsetup(void){
  int i;
  char t[16]="";
  strncpy(t,"      ",9);
  nButton.initButtonUL( 10, 10, 130, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"",9);
  F0stat.initButtonUL(280, 15,  40, 40, LAMP_BORDER, LAMP_BG, LAMP_TEXT, t, 1);
  F1stat.initButtonUL(330, 15,  40, 40, LAMP_BORDER, LAMP_BG, LAMP_TEXT, t, 1);
  F2stat.initButtonUL(380, 15,  40, 40, LAMP_BORDER, LAMP_BG, LAMP_TEXT, t, 1);
  F3stat.initButtonUL(430, 15,  40, 40, LAMP_BORDER, LAMP_BG, LAMP_TEXT, t, 1);
  strncpy(t,"REV",9);
  revButton.initButtonUL( 10, 70, 85, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"FOR",9);
  forButton.initButtonUL( 105, 70, 85, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"F0",9);
  F0Button.initButtonUL( 200, 70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"F1",9);
  F1Button.initButtonUL( 270, 70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"F2",9);
  F2Button.initButtonUL( 340, 70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"F3",9);
  F3Button.initButtonUL( 410, 70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"STOP",9);
  stopButton.initButtonUL( 10,130,110, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  strncpy(t,"ON",9);
  dccOnButton.initButtonUL( 10,260, 60, 50, CRIT_BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"OFF",9);
  dccOffButton.initButtonUL( 80,260, 80, 50, CRIT_BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"STOP",9);
  stopAllButton.initButtonUL(170,260, 100, 50, CRIT_BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  slider.createSlider(50, 320, TFT_GREY, TFT_BLACK, H_SLIDER);
  slider.createKnob(30, 40,10, TFT_WHITE, TFT_RED);
  slider.setSliderScale(0, 127);
  strncpy(t,"L1",9);
  loco0Button.initButtonUL( 10,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"L2",9);
  loco1Button.initButtonUL( 75,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"L3",9);
  loco2Button.initButtonUL(140,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"L4",9);
  loco3Button.initButtonUL(205,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"L5",9);
  loco4Button.initButtonUL(270,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"PR",9);
  progButton.initButtonUL(335,200, 55, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"SET",9);
  setButton.initButtonUL(400,200, 70, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  //these are inited, but not used immediately
  strncpy(t,".",9);
  numberDotButton.initButtonUL(10,130, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"0",9);
  number0Button.initButtonUL( 10,190, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"1",9);
  number1Button.initButtonUL( 80,190, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"2",9);
  number2Button.initButtonUL(150,190, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"3",9);
  number3Button.initButtonUL(220,190, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"4",9);
  number4Button.initButtonUL( 80,130, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"5",9);
  number5Button.initButtonUL(150,130, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"6",9);
  number6Button.initButtonUL(220,130, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"7",9);
  number7Button.initButtonUL( 80,70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"8",9);
  number8Button.initButtonUL(150,70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"9",9);
  number9Button.initButtonUL(220,70, 60, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"DELETE",9);
  numberDeleteButton.initButtonUL(290,190,180, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"CANCEL",9);
  numberCancelButton.initButtonUL(290,130,180, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"ENTER",9);
  numberEnterButton.initButtonUL(290,70,180, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  //CV programming page
  strncpy(t,"CV#",9);
  cvCVenter.initButtonUL(10,70,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"LONG",9);
  cvLongAddress.initButtonUL(120,70,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"READ",9);
  cvDoRead.initButtonUL(230,70,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);   
  strncpy(t,"WRITE",9);
  cvDoWrite.initButtonUL(350,70,120, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"0",9);
  cvValueEnter.initButtonUL(350,130,120,50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"BACK",9);
  cvExit.initButtonUL(350,190,120, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"DIR",9);
  cvDirect.initButtonUL(10,190,75, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"PAG",9);
  cvPaged.initButtonUL(95,190,75, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"PHY",9);
  cvPhysical.initButtonUL(180,190,75, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"OPS",9);
  cvOperations.initButtonUL(265,190,75, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  //Settings page  
  strncpy(t,"BACK",9);
  settingsExit.initButtonUL(330,10,140, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"I1 x",9);
  settingsI1Mult.initButtonUL(10,70,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"I2 x",9);
  settingsI2Mult.initButtonUL(10,130,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"V x",9);
  settingsVMult.initButtonUL(10,190,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"I LIM",9);
  settingsILimit.initButtonUL(250,70,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,"I O/S",9);
  settingsIOffset.initButtonUL(250,130,100, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  strncpy(t,getLocoList(),14);
  settingsLocos.initButtonUL(250,200,220, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
}

void drawLocoButtons(void){
  char t[16]="";
  sprintf(t,"%c:%3d      ",((locos[activeLoco].dir==DCC_FORWARD)?'F':'R'),locos[activeLoco].speed);
  tft.setTextColor(TFT_WHITE,TFT_BLACK,true);
  tft.setTextDatum(CC_DATUM);
  tft.setCursor(0,0);
  drawTextPanel(100,155,20,t);
  if(locos[activeLoco].dir==DCC_FORWARD){
    forButton.drawSmoothButton(true,3);
    revButton.drawSmoothButton(false,3);
  }else{
    forButton.drawSmoothButton(false,3);
    revButton.drawSmoothButton(true,3);
  }
  if(locos[activeLoco].F0==DCC_ON){
    F0stat.drawSmoothButton(true,3);
  }else{
    F0stat.drawSmoothButton(false,3);
  }
  if(locos[activeLoco].F1==DCC_ON){
    F1stat.drawSmoothButton(true,3);
  }else{
    F1stat.drawSmoothButton(false,3);
  }
  if(locos[activeLoco].F2==DCC_ON){
    F2stat.drawSmoothButton(true,3);
  }else{
    F2stat.drawSmoothButton(false,3);
  }
  if(locos[activeLoco].F3==DCC_ON){
    F3stat.drawSmoothButton(true,3);
  }else{
    F3stat.drawSmoothButton(false,3);
  }
}

void drawAllLocoButtons(void){
  int i;
  char t[16]="";
  if(locos[activeLoco].address==0){
    sprintf(t,"---");
  }else if(locos[activeLoco].useLongAddress){
    sprintf(t,"%05d",locos[activeLoco].address);    
  }else{
    sprintf(t,"%d",locos[activeLoco].address);
  }
  nButton.initButtonUL( 10, 10, 130, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1);
  nButton.drawSmoothButton(false,3,TFT_BLACK,t);
  for(i=0;i<tabButtonCount;i++){
    if(i==activeLoco){
      tabButtons[i]->drawSmoothButton(true,3);
    }else{
      tabButtons[i]->drawSmoothButton(false,3);
    }
  }  
  slider.drawSlider(140, 135);
  slider.setSliderPosition(0);
  slider.setSliderPosition(1);
  slider.setSliderPosition(locos[activeLoco].speed);
  if(dccSwitchOn){
    dccOnButton.drawSmoothButton(true,3);
    dccOffButton.drawSmoothButton(false,3);
  }else{
    dccOnButton.drawSmoothButton(false,3);
    dccOffButton.drawSmoothButton(true,3);
  }
  for(i=0;i<buttonCount;i++){locoButtons[i]->drawSmoothButton(false,3);}
  drawLocoButtons(); //and the ones that are frequently refreshed
}

void getAnalogs(void){
  getAnalogFlag=1;
  while(getAnalogFlag){}  //wait til other core can give us the values
  //values are now updated
/*  //this all happens on the other core:
  float n;
  n=analogRead(DCC1I);
  dcc1Current=n*dcc1Mult-dccCurrentOffset;
  if(dcc1Current<0){dcc1Current=0;}
  n=analogRead(DCC2I);
  dcc2Current=n*dcc2Mult;
  n=analogRead(VSENSE);
  supplyVoltage=n*vMult;
*/
}

void handleCrit(void){
  int i;
  slipPacket_t p;
  dccPacket_t d;
  if(touchPressed){
    if(dccOnButton.contains(touchX,touchY)){dccOnButton.press(true);}
    if(dccOffButton.contains(touchX,touchY)){dccOffButton.press(true);}
    if(stopAllButton.contains(touchX,touchY)){stopAllButton.press(true);}
  }else{
    dccOnButton.press(false);
    dccOffButton.press(false);
    stopAllButton.press(false);
  }
  if(dccOnButton.justPressed()){
    dccOnButton.drawSmoothButton(true,3);
    dccSwitchOn=1;
  }
  if(dccOnButton.justReleased()){dccOnButton.drawSmoothButton(false,3);}
  if(dccOffButton.justPressed()){
    dccOffButton.drawSmoothButton(true,3);
    dccSwitchOn=0;
  }
  if(dccOffButton.justReleased()){dccOffButton.drawSmoothButton(false,3);}  
  if(stopAllButton.justPressed()){
    for(i=0;i<LOCO_COUNT;i++){locos[i].speed=0;}
    stateChange=1;
    stopAllButton.drawSmoothButton(true,3);
  }
  if(stopAllButton.justReleased()){stopAllButton.drawSmoothButton(false,3);}
  getAnalogs();
  if((millis()-slipHeartbeat)>SLIP_HEARTBEAT_PERIOD){
    slipHeartbeat=millis();
    sendSlipHostCheck();
    Serial.println("Host check sent");
  }
  while(Serial1.available()){
    p=processFeed(Serial1.read());
    if(p.byteCount){
      //Serial.printf("%d: ",p.byteCount);
      for(i=0;i<p.byteCount;i++){
        //Serial.printf("%02x ",p.data[i]);
      }
      //Serial.println();
      d=getDCCfromSLIP(p);
      if(d.byteCount){
        if(queuePacket(d)){
          //Serial.println("Added:");
          //dumpPacket(&d);
        }else{
          //Serial.println("Queue full");
        }
      }else{
        //Serial.println("Not valid DCC");
      }
      if(p.byteCount){        //valid data
        if(p.data[0]==SLIP_HOST_RESPONSE){   //Host response
          if(p.byteCount==4){ //valid
            Serial.printf("Host %d at position %d, latency=%dms\r\n",p.data[2],p.data[1],millis()-slipHeartbeat);
          }
        }
        if(p.data[0]==SLIP_SYSTEM_COMMAND){   //system command
          if(p.data[1]==0){dccSwitchOn=0;Serial.println("Remote off command.");}
          if(p.data[1]==1){dccSwitchOn=1;Serial.println("Remote on command.");}
          if(dccSwitchOn){
            dccOnButton.drawSmoothButton(true,3);
            dccOffButton.drawSmoothButton(false,3);
          }else{
            dccOnButton.drawSmoothButton(false,3);
            dccOffButton.drawSmoothButton(true,3);
          }
        }
      }
    }
  }
}

void drawCrit(void){
  char t[16]="";
  static unsigned long lastTimedUpdate=0;
  if(dccOnButton.justReleased() || dccOffButton.justReleased()){
    if(dccSwitchOn){
      dccOnButton.drawSmoothButton(true,3);
      dccOffButton.drawSmoothButton(false,3);
    }else{
      dccOnButton.drawSmoothButton(false,3);
      dccOffButton.drawSmoothButton(true,3);
    }
  }
  if((millis()-lastTimedUpdate)>TIMED_UPDATE_INTERVAL){
    lastTimedUpdate=millis();
    spr.createSprite(80,40,1);
    spr.setTextColor(OK_COLOUR, TFT_BLACK);
    if(dcc1Current>dccCurrentLimit){spr.setTextColor(ERROR_COLOUR, TFT_BLACK);}
    if(dccTripped){spr.setTextColor(ERROR_COLOUR, TFT_BLACK);}
    spr.fillSprite(TFT_BLACK);
    sprintf(t,"%3.1fA",dcc1Current);    
    spr.printToSprite(t);
    spr.pushSprite(280,270);
    spr.deleteSprite();
    spr.createSprite(100,40,1);
    spr.setTextColor(OK_COLOUR, TFT_BLACK);
    if(supplyVoltage>vUpperLimit){spr.setTextColor(ERROR_COLOUR, TFT_BLACK);}
    if(supplyVoltage<vLowerLimit){spr.setTextColor(ERROR_COLOUR, TFT_BLACK);}
    spr.fillSprite(TFT_BLACK);
    sprintf(t,"%4.1fV",supplyVoltage);    
    spr.printToSprite(t);
    spr.pushSprite(370,270);
    spr.deleteSprite();
  }
}

void handleLocoButtons(void){
  int i;
  for(i=0;i<tabButtonCount;i++){
    if(touchPressed){
      if(tabButtons[i]->contains(touchX, touchY)){
        tabButtons[i]->press(true);
      }
    }else{
      tabButtons[i]->press(false);
    }   
    if((tabButtons[i]->justPressed()) && (i<LOCO_COUNT)){
      activeLoco=i;
      stateChange=1;
      drawAllLocoButtons();
    }
  }
  if(progButton.justPressed()){progButton.drawSmoothButton(true,3);}
  if(progButton.justReleased()){progButton.drawSmoothButton(false,3);}
  if(setButton.justPressed()){setButton.drawSmoothButton(true,3);}
  if(setButton.justReleased()){setButton.drawSmoothButton(false,3);}
  for(i=0;i<buttonCount;i++){
    if(touchPressed){
      if(locoButtons[i]->contains(touchX, touchY)){
        locoButtons[i]->press(true);
      }
    }else{
      locoButtons[i]->press(false);
    }        
  }
  if(F1Button.isPressed()){
      locos[activeLoco].F1=DCC_ON;
      F1stat.drawSmoothButton(true,3);
      if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
  }
  if(F1Button.justReleased()){
      locos[activeLoco].F1=DCC_OFF;
      F1stat.drawSmoothButton(false,3);
      if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
  }
  if(F2Button.justPressed()){
      locos[activeLoco].F2=DCC_ON;
      F2stat.drawSmoothButton(true,3);
      if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
  }
  if(F2Button.justReleased()){
      locos[activeLoco].F2=DCC_OFF;
      F2stat.drawSmoothButton(false,3);
      if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
  }
  if(F0Button.justPressed()){
    if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
    if(locos[activeLoco].F0==DCC_ON){
      locos[activeLoco].F0=DCC_OFF;
      F0stat.drawSmoothButton(false,3);
    }else{
      locos[activeLoco].F0=DCC_ON;
      F0stat.drawSmoothButton(true,3);
    }
  }
  if(F3Button.justPressed()){
    if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2+1;}	//function
    if(locos[activeLoco].F3==DCC_ON){
      locos[activeLoco].F3=DCC_OFF;
      F3stat.drawSmoothButton(false,3);
    }else{
      locos[activeLoco].F3=DCC_ON;
      F3stat.drawSmoothButton(true,3);
    }
  }
  for(i=4;i<buttonCount;i++){
    if(locoButtons[i]->justPressed()){locoButtons[i]->drawSmoothButton(true,3);}
    if(locoButtons[i]->justReleased()){locoButtons[i]->drawSmoothButton(false,3);}
  }  
  if(touchPressed){
    if(slider.checkTouch(touchX, touchY)) {
      if(slider.getSliderPosition()==1){slider.setSliderPosition(0);} //DCC uses speed step 1 to mark e-stop
      locos[activeLoco].speed=slider.getSliderPosition();
      if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2;}	//speed
      stateChange=1;
    }    
  }
  //other logic
  if(stopButton.justPressed()){
    locos[activeLoco].speed=0;
    slider.setSliderPosition(0);
    if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2;}	//speed
    stateChange=1;
  }
  if(revButton.justPressed()){
    stateChange=1;
    if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2;}	//speed
    if((locos[activeLoco].dir==DCC_FORWARD)&&(locos[activeLoco].speed!=0)){
      locos[activeLoco].speed=0;
      slider.setSliderPosition(0);
    }else{
      locos[activeLoco].dir=DCC_REVERSE;
    }
  }
  if(forButton.justPressed()){
    stateChange=1;
    if(priorityPacket==PRIORITY_PACKET_READY){priorityPacket=activeLoco*2;}	//speed
    if((locos[activeLoco].dir==DCC_REVERSE)&&(locos[activeLoco].speed!=0)){
      locos[activeLoco].speed=0;
      slider.setSliderPosition(0);      
    }else{
      locos[activeLoco].dir=DCC_FORWARD;
    }
  }
  if(forButton.justReleased() || revButton.justReleased()){ //update on release
    stateChange=1;  
  }
}

char* getKeypad(uint8_t n){  //n is buttons to draw, numberButtonCount is all, numberButtonCount-1 is all but '.' caller needs to redraw screen, return null ptr on cancel
  static char ret[KEYPAD_BUFFER+2]="";
  uint8_t retPtr=0;
  int i;
  bool updateFlag=1;
  ret[0]=0; //clear
  tft.fillScreen(TFT_BLACK);
  drawAllCrit();
  if(n>numberButtonCount){n=numberButtonCount;}
  for(i=0;i<n;i++){numberButtons[i]->drawSmoothButton(false,3);}
  while(1){
    touchPressed=tft.getTouch(&touchX, &touchY);
    handleCrit();
    drawCrit();
    for(i=0;i<n;i++){
      if(touchPressed){
        if(numberButtons[i]->contains(touchX, touchY)){
          numberButtons[i]->press(true);
        }
      }else{
        numberButtons[i]->press(false);
      }
      if(numberButtons[i]->justPressed()){numberButtons[i]->drawSmoothButton(true,3);}
      if(numberButtons[i]->justReleased()){numberButtons[i]->drawSmoothButton(false,3);}      
    }
    if(numberCancelButton.justReleased()){return 0;}
    if(numberEnterButton.justReleased()){return ret;}
    for(i=0;i<10;i++){
      if(numberButtons[i]->justPressed()){
        if(retPtr<KEYPAD_BUFFER){
          ret[retPtr]=i+'0';
          retPtr++;
          ret[retPtr]=0;
          updateFlag=1;
        }
      }
    }
    if((n==numberButtonCount) && numberDotButton.justPressed()){
      if(retPtr<KEYPAD_BUFFER){
        ret[retPtr]='.';
        retPtr++;
        ret[retPtr]=0;
        updateFlag=1;
      }
    }
    if(numberDeleteButton.justPressed()){
      if(retPtr>0){
        retPtr--;
        ret[retPtr]=0;
        updateFlag=1;
      }
    }
    if(updateFlag){
      spr.createSprite(180,40,1);
      spr.fillSprite(TFT_GREY);
      spr.setTextColor(BUTTON_TEXT, TFT_GREY);
      spr.printToSprite(" "); //padding
      spr.printToSprite(ret);
      spr.printToSprite("_"); //cursor
      spr.pushSprite(155,20);
      spr.deleteSprite();
      updateFlag=0;
    }
    handleDCC();
  }
}

void drawProgPage(void){  
  int i;
  char t[16]="";
  sprintf(t,"%3d",cvWriteValue);
  cvValueEnter.initButtonUL(350,130,120, 50, BUTTON_BORDER, BUTTON_BG, BUTTON_TEXT, t, 1); 
  cvValueEnter.drawSmoothButton(false,3);  
  //CV
  spr.createSprite(90,40,1); 
  spr.fillSprite(BUTTON_BG);
  spr.setTextColor(BUTTON_TEXT, BUTTON_BG);
  if(cvProgCV==CV_LONG_ADDRESS){
    spr.printToSprite("LONG");
  }else{
    sprintf(t,"%3d",cvProgCV);
    spr.printToSprite(t);
  }
  spr.pushSprite(20,140);
  spr.deleteSprite();
  //read value
  spr.createSprite(100,40,1);
  spr.fillSprite(BUTTON_BG);
  spr.setTextColor(BUTTON_TEXT, BUTTON_BG);
  if(cvReadValue>=0){
    sprintf(t,"%5d",cvReadValue);
  }else{
    sprintf(t,"  ---");
  }  
  spr.printToSprite(t);
  spr.pushSprite(240,140);
  spr.deleteSprite();  
  if(cvMode==CV_DIRECT){
    cvDirect.drawSmoothButton(true,3);
  }else{
    cvDirect.drawSmoothButton(false,3);
  }
  if(cvMode==CV_PHYSICAL){
    cvPhysical.drawSmoothButton(true,3);
  }else{
    cvPhysical.drawSmoothButton(false,3);
  }
  if(cvMode==CV_PAGED){
    cvPaged.drawSmoothButton(true,3);
  }else{
    cvPaged.drawSmoothButton(false,3);
  }
  if(cvMode==CV_OPERATIONS){
    cvOperations.drawSmoothButton(true,3);
  }else{
    cvOperations.drawSmoothButton(false,3);
  }
}

void drawProgStatus(const char* t){
  drawTextPanel(260,200,20,t);
}

void drawProgPageAll(void){
  int i;
  for(i=1;i<cvButtonCount;i++){cvButtons[i]->drawSmoothButton(false,3);}  //skip past cvValueEnter
  drawTextPanel(180,20,20,"CV PROG:");
  drawProgPage();
}

bool checkForCancel(void){        //handle crit and DCC1
  touchPressed=tft.getTouch(&touchX, &touchY);
  handleCrit();
  drawCrit();
  if(touchPressed){
    if(cvExit.contains(touchX, touchY)){
      cvExit.press(true);
    }
  }else{
    cvExit.press(false);
  }
  handleDCC();
  if(cvExit.justReleased()){return true;}
  return false;  
}

int progCountAckPackets(int n, float* qi, dccPacket_t* p){  //send n service mode packets, count acks
  int ackTotal=0;
  int pktCount=0;
  if(checkForCancel()){
    return -1;
  }
  while(pktCount<n){         
    handleDCC();
    getAnalogs();
    if(dcc2Current>((*qi)+DC_QI_THRESHOLD)){ackTotal++;}
    //Serial.printf("%5f,%5f,%5f\r\n",dcc2Current,*qi,DC_QI_THRESHOLD);
    delay(1);   //bound loop speed
    if(nextPkt2.byteCount==0){
      nextPkt2=*p;
      pktCount++;
    }        
  }
  pktCount=0;
  while(pktCount<DCC_RECOVERY_WRITE_COUNT){          //recovery bytes
    handleDCC();
    getAnalogs();
    if(nextPkt2.byteCount==0){
      nextPkt2=pktReset;
      pktCount++;
      *qi=((*qi)*(DCC_QI_SMOOTHING-1)+dcc2Current)/DCC_QI_SMOOTHING;
    }        
  }
  Serial.println(ackTotal);
  return ackTotal;
}

void resetPageRegister(void){
  dccPacket_t progPkt;  //for local use
  float qi=0;
  DCCservicePageNumberWrite(&progPkt,1);    //reset to 1st
  progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
}

int progStartUpResetpackets(int n, float* qi){    //send n reset packets
  int pktCount=0;
  while(pktCount<n){   //startup time, measure quiescent
    if(checkForCancel()){
      return -1;
    }
    if(nextPkt2.byteCount==0){
      nextPkt2=pktReset;
      pktCount++;
      *qi=((*qi)*(DCC_QI_SMOOTHING-1)+dcc2Current)/DCC_QI_SMOOTHING;
    }
  }
  return 0;
}

const char* doCVwriteOps(void){ //this works on main output, so different to others
  if((cvProgCV==1)||(cvProgCV==17)||(cvProgCV==18)||(cvProgCV==29)){
    return "Not allowed";   //shouldn't write to these in ops mode
  }
  if(dcc1on==DCC_OFF){
    return "Power off";   //can't send packets if DCC off
  }
  if(locos[activeLoco].address==0){
    return "No address";  //avoid broadcast
  }
  unsigned long t=millis();
  int packetCount=0;
  dccPacket_t progPkt;  //for local use
  DCCopsLongWrite(&progPkt,locos[activeLoco],cvProgCV,cvWriteValue);
  while(packetCount<DCC_OPS_MODE_COUNT){
    if((millis()-t)>DCC_OPS_MODE_TIMEOUT){
      return "Timeout";
    }
    if(packetQueueSpace()){
      queuePacket(progPkt);
      packetCount++;
    }
  }
  return "Sent";
}

const char* doCVwritePaged(void){
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  pkt2=pktReset;
  int ackTotal=0;
  dcc2on=1;
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  DCCservicePageNumberWrite(&progPkt,cvProgCV);
  ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    resetPageRegister();
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PAGED_MODE_COUNT/2)){
    resetPageRegister();
    dcc2on=0;
    return "Write error #1";
  }  
  DCCservicePagedWrite(&progPkt,cvProgCV,cvWriteValue);        //write cv with data  
  ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    resetPageRegister();
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PAGED_MODE_COUNT/2)){
    resetPageRegister();
    dcc2on=0;
    return "Write error #2";
  }
  DCCservicePagedVerify(&progPkt,cvProgCV,cvWriteValue);        //verify cv has data  
  ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    resetPageRegister();
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PAGED_MODE_COUNT/2)){
    resetPageRegister();
    dcc2on=0;
    return "Write error #3";
  }
  dcc2on=0;
  return "OK, verified";
}

const char* doCVwritePhys(void){
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  pkt2=pktReset;
  int ackTotal=0;
  switch(cvProgCV){
    case 1: 
    case 2: 
    case 3: 
    case 4: 
    case 7: 
    case 8: 
    case 29: break;
    default: return "Not supported";break;
  }
  dcc2on=1;
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  DCCservicePhysicalWrite(&progPkt,cvProgCV,cvWriteValue);        //write cv with data  
  ackTotal=progCountAckPackets(DCC_PHYS_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PHYS_MODE_COUNT/2)){
    dcc2on=0;
    return "Write error #1";
  }
  DCCservicePhysicalVerify(&progPkt,cvProgCV,cvWriteValue);        //verify cv has data  
  ackTotal=progCountAckPackets(DCC_PHYS_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PHYS_MODE_COUNT/2)){
    dcc2on=0;
    return "Write error #2";
  }
  dcc2on=0;
  return "OK, verified";
}

const char* doCVwriteDirect(void){
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  pkt2=pktReset;
  int ackTotal=0;
  dcc2on=1;
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  DCCserviceDirectWriteByte(&progPkt,cvProgCV,cvWriteValue);        //write cv with data  
  ackTotal=progCountAckPackets(DCC_DIRECT_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_DIRECT_MODE_COUNT/2)){
    dcc2on=0;
    return "Write error #1";
  }
  DCCserviceDirectVerifyByte(&progPkt,cvProgCV,cvWriteValue);        //verify cv has data  
  ackTotal=progCountAckPackets(DCC_DIRECT_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_DIRECT_MODE_COUNT/2)){
    dcc2on=0;
    return "Write error #2";
  }
  dcc2on=0;
  return "OK, verified";
}

const char* doCVreadPaged(void){  //read using Paged mode ie writes to page register
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  int ackTotal=0;
  pkt2=pktReset;
  int n;
  int page,idx;
  dcc2on=1;
  cvReadValue=-1; //until otherwise set
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  DCCservicePageNumberWrite(&progPkt,cvProgCV);
  ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    resetPageRegister();
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PAGED_MODE_COUNT/2)){
    resetPageRegister();
    dcc2on=0;
    return "Read error #1";
  }  
  DCCservicePageNumberVerify(&progPkt,cvProgCV);
  ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
  if(ackTotal==-1){
    dcc2on=0;
    return "Cancelled";
  }
  if(ackTotal<=(DCC_PAGED_MODE_COUNT/2)){
    resetPageRegister();
    dcc2on=0;
    return "Read error #2";
  }  
  for(n=0;n<256;n++){    
    DCCservicePagedVerify(&progPkt,cvProgCV,n);
    ackTotal=progCountAckPackets(DCC_PAGED_MODE_COUNT,&qi,&progPkt);
    if(ackTotal==-1){
      dcc2on=0;
      return "Cancelled";
    }
    //Serial.printf("%3d: %d\r\n",n,ackTotal);
    if(ackTotal>(DCC_PAGED_MODE_COUNT/2)){
      resetPageRegister();
      dcc2on=0;
      cvReadValue=n;   
      return "OK, done";
    }
  }
  resetPageRegister();
  dcc2on=0;
  return "Read error #3";
}

const char* doCVreadPhys(void){ //read cvProgCV using physical mode, only some CVs supported (1,2,3,4,7,8,29)
  switch(cvProgCV){
    case 1: 
    case 2: 
    case 3: 
    case 4: 
    case 7: 
    case 8: 
    case 29: break;
    default: return "Not supported";break;
  }
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  int ackTotal=0;
  pkt2=pktReset;
  int n;
  dcc2on=1;
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  for(n=0;n<256;n++){    
    DCCservicePhysicalVerify(&progPkt,cvProgCV,n);
    ackTotal=progCountAckPackets(DCC_PHYS_MODE_COUNT,&qi,&progPkt);
    if(ackTotal==-1){
      dcc2on=0;
      return "Cancelled";
    }
    //Serial.printf("%3d: %d\r\n",n,ackTotal);
    if(ackTotal>(DCC_PHYS_MODE_COUNT/2)){
      dcc2on=0;
      cvReadValue=n;   
      return "OK, done";
    }
  }
  dcc2on=0;
  cvReadValue=-1;
  return "Read error";
}

const char* doCVreadDirect(void){  //perform bit verifies on cvProgCV
  dccPacket_t progPkt;  //for local use
  float qi=0; //quiescent current
  int pktCount=0;
  pkt2=pktReset;
  byte bt,bv;
  int i,n,nbar;
  int ackBits[2][8]={{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}};
  int ackTotal=0;
  int ackLocal=0;
  dcc2on=1;
  if(progStartUpResetpackets(DCC_RESET_PACKET_COUNT,&qi)==-1){
    dcc2on=0;
    return "Cancelled";
  }
  for(bt=0;bt<8;bt++){
    for(bv=0;bv<2;bv++){
      DCCserviceDirectVerifyBit(&progPkt,cvProgCV,bt,bv);
      ackLocal=progCountAckPackets(DCC_DIRECT_MODE_COUNT,&qi,&progPkt);
      if(ackLocal==-1){
        dcc2on=0;
        return "Cancelled";
      }
      ackBits[bv][bt]=ackLocal;
      ackTotal=ackTotal+ackLocal;
    }
  }
  //manipulate bits into byte and check
  Serial.printf("Acks received= %d\r\n",ackTotal);
  ackTotal=ackTotal/16; //threshold per bit
  nbar=0;
  for(i=0;i<8;i++){
    if(ackBits[0][i]>ackTotal){nbar=nbar|(1<<i);}
  }
  n=0;
  for(i=0;i<8;i++){
    if(ackBits[1][i]>ackTotal){n=n|(1<<i);}
  }
  dcc2on=0;  
  if((n+nbar)==255){
    cvReadValue=n;
    return "OK, done";
  }else{
    cvReadValue=-1;
    if(ackTotal<2){return "Low acks";}
    return "Read error";
  }
}

const char* doLongAddressRead(void){  //call functions as needed
  int cv17=-1;
  int cv18=-1;
  const char* stat="";
  cvProgCV=17;
  cvReadValue=-1;
  if(cvMode==CV_DIRECT){
    stat=doCVreadDirect();
  }else if(cvMode==CV_PHYSICAL){
    stat=doCVreadPhys();
  }else if(cvMode==CV_PAGED){
    stat=doCVreadPaged();
  }      
  if(cvReadValue==-1){      //fail
    cvProgCV=CV_LONG_ADDRESS;
    return stat;
  }else{
    cv17=cvReadValue;
  }
  cvProgCV=18;
  cvReadValue=-1;
  if(cvMode==CV_DIRECT){
    stat=doCVreadDirect();
  }else if(cvMode==CV_PHYSICAL){
    stat=doCVreadPhys();
  }else if(cvMode==CV_PAGED){
    stat=doCVreadPaged();
  }      
  if(cvReadValue==-1){      //fail
    cvProgCV=CV_LONG_ADDRESS;
    return stat;
  }else{
    cv18=cvReadValue;
  }
  cvProgCV=CV_LONG_ADDRESS;
  cv18=(256*cv17+cv18);
  cvReadValue=cv18 & 0x3FFF;  //bottom 14 bits
  if((cv18 & 0xC000)!=0xC000){  //these bits need to be set for 100% compliance
    return "Data error";
  }
  if(cvReadValue>10239){
    return "Value error";
  }
  return "Read OK";
}

const char* doLongAddressWrite(void){
  int cv17,cv18;
  int cvWriteTemp=cvWriteValue;
  const char* stat="";
  cv17=((cvWriteValue/256)&0x3F)|0xC0;  //top 2 bits should be set
  cv18=cvWriteValue%256;
  cvProgCV=17;
  cvWriteValue=cv17;
  if(cvMode==CV_DIRECT){
    stat=doCVwriteDirect();
  }else if(cvMode==CV_PHYSICAL){
    stat=doCVwritePhys();
  }else if(cvMode==CV_PAGED){
    stat=doCVwritePaged();
  }      
  cvProgCV=CV_LONG_ADDRESS;
  cvWriteValue=cvWriteTemp; //revert
  if(stat!="OK, verified"){
    return stat;
  }
  cvProgCV=18;
  cvWriteValue=cv18;
  if(cvMode==CV_DIRECT){
    stat=doCVwriteDirect();
  }else if(cvMode==CV_PHYSICAL){
    stat=doCVwritePhys();
  }else if(cvMode==CV_PAGED){
    stat=doCVwritePaged();
  }      
  cvProgCV=CV_LONG_ADDRESS;
  cvWriteValue=cvWriteTemp; //revert
  return stat;
}

void doProgPage(void){
  int i;
  char* keypadResult=0;  
  const char* stat="Ready";
  char t[16]="";
  tft.fillScreen(TFT_BLACK);
  drawAllCrit();
  drawProgPageAll();  
  drawProgStatus(stat);
  while(1){
    touchPressed=tft.getTouch(&touchX, &touchY);
    handleCrit();
    drawCrit();
    for(i=0;i<cvButtonCount;i++){
      if(touchPressed){
        if(cvButtons[i]->contains(touchX, touchY)){
          cvButtons[i]->press(true);
        }
      }else{
        cvButtons[i]->press(false);
      }
      if(cvButtons[i]->justPressed()){cvButtons[i]->drawSmoothButton(true,3);}
      if(cvButtons[i]->justReleased()){cvButtons[i]->drawSmoothButton(false,3);}      
    }
    handleDCC();
    if(cvExit.justReleased()){return;}
    if(cvCVenter.justReleased()){
      keypadResult=getKeypad(numberButtonCount-1);  //don't allow dot
      if(keypadResult){
        i=atoi(keypadResult);
        if((i>=1)&&(i<=1023)){
          cvProgCV=i;
          cvReadValue=-1; //read value invalid
          if(cvWriteValue>255){cvWriteValue=0;} //reset if out of range
          stat="OK, Ready";
        }else{
          stat="Out of range";
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawProgPageAll();  
      drawProgStatus(stat);
    }
    if(cvLongAddress.justReleased()){
      cvProgCV=CV_LONG_ADDRESS;  //flag value
      cvReadValue=-1; //read value invalid
      drawProgPageAll();  
      drawProgStatus(stat);
    }
    if(cvValueEnter.justReleased()){
      keypadResult=getKeypad(numberButtonCount-1);  //don't allow dot
      if(keypadResult){
        i=atoi(keypadResult);
        if(cvProgCV==CV_LONG_ADDRESS){
          if((i>=0)&&(i<=10239)){
            cvWriteValue=i;
            stat="OK, Ready";
          }else{
            stat="Out of range";
          }
        }else{
          if((i>=0)&&(i<=255)){
            cvWriteValue=i;
            stat="OK, Ready";
          }else{
            stat="Out of range";
          }
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawProgPageAll();  
      drawProgStatus(stat);
    }
    if(cvProgCV==CV_LONG_ADDRESS){  //separate wrapper/handler using existing functions
      if(cvDoRead.justReleased()){
        drawProgStatus("READING");
        stat=doLongAddressRead();
        drawProgPageAll();  
        drawProgStatus(stat);
      }
      if(cvDoWrite.justReleased()){
        drawProgStatus("WRITING");
        stat=doLongAddressWrite();
        drawProgPageAll();  
        drawProgStatus(stat);
      }      
    }else{
      if(cvDoRead.justReleased()){
        drawProgStatus("READING");
        if(cvMode==CV_DIRECT){
          stat=doCVreadDirect();
        }else if(cvMode==CV_PHYSICAL){
          stat=doCVreadPhys();
        }else if(cvMode==CV_PAGED){
          stat=doCVreadPaged();
        }else if(cvMode==CV_OPERATIONS){
          stat="Not supported";
        }else{
          stat="Select mode";
        }      
        drawProgPageAll();  
        drawProgStatus(stat);
      }
      if(cvDoWrite.justReleased()){
        drawProgStatus("WRITING");
        if(cvMode==CV_DIRECT){
          stat=doCVwriteDirect();
        }else if(cvMode==CV_PHYSICAL){
          stat=doCVwritePhys();
        }else if(cvMode==CV_PAGED){
          stat=doCVwritePaged();
        }else if(cvMode==CV_OPERATIONS){
          sprintf(t,"Write:%5d",locos[activeLoco].address);
          drawProgStatus(t);
          stat=doCVwriteOps();
        }else{
          stat="Select mode";
        }      
        drawProgPageAll();  
        drawProgStatus(stat);
      }
    }
    if(cvDirect.justReleased()){cvMode=CV_DIRECT;drawProgPage();}
    if(cvPhysical.justReleased()){cvMode=CV_PHYSICAL;drawProgPage();}
    if(cvPaged.justReleased()){cvMode=CV_PAGED;drawProgPage();}
    if(cvOperations.justReleased()){cvMode=CV_OPERATIONS;drawProgPage();}  }
}

void drawSetPageAll(void){
  int i;
  int s=0;
  char t[16]="";
  const char* n;
  for(i=0;i<settingsButtonCount-1;i++){settingsButtons[i]->drawSmoothButton(false,3);}  //all except settingsLocos
  settingsLocos.drawSmoothButton(false,3,TFT_BLACK,getLocoList());
  drawTextPanel(180,20,20,"SETTINGS:"); //title
  sprintf(t,"%.4f",dcc1Mult);
  drawTextPanel(120,120,80,t);
  sprintf(t,"%.4f",dcc2Mult);
  drawTextPanel(120,120,140,t);
  sprintf(t,"%.4f",vMult);
  drawTextPanel(120,120,200,t);
  sprintf(t,"%4.2fA",dccCurrentLimit);
  drawTextPanel(120,360,80,t);
  sprintf(t,"%4.2fA",dccCurrentOffset);
  drawTextPanel(120,360,140,t);
}

void saveToFlash(void){
  int i;
  saveData.okFlag=OK_FLAG_VALUE;
  for(i=0;i<LOCO_COUNT;i++){
    saveData.locos[i]=locos[i];
  }
  saveData.floats[0]=dcc1Mult;
  saveData.floats[1]=dcc2Mult;
  saveData.floats[2]=vMult;
  saveData.floats[3]=dccCurrentLimit;
  saveData.floats[4]=dccCurrentOffset;
  EEPROM.put(1, saveData);
  EEPROM.commit();
  saveData.okFlag=0xFFFFFFFF; //ready for next read
}

void LoadFromFlash(void){
  int i;
  EEPROM.get(1, saveData);
  if(saveData.okFlag==OK_FLAG_VALUE){
    for(i=0;i<LOCO_COUNT;i++){
      locos[i]=saveData.locos[i];
      locos[i].speed=0;   //safety!
    }
    dcc1Mult=saveData.floats[0];
    dcc2Mult=saveData.floats[1];
    vMult=saveData.floats[2];
    dccCurrentLimit=saveData.floats[3];
    dccCurrentOffset=saveData.floats[4];
  }
}

void doSetPage(void){
  int i;
  float f;
  char* keypadResult=0;  
  tft.fillScreen(TFT_BLACK);
  drawAllCrit();
  drawSetPageAll();
  while(1){
    touchPressed=tft.getTouch(&touchX, &touchY);
    handleCrit();
    drawCrit();
    for(i=0;i<settingsButtonCount;i++){
      if(touchPressed){
        if(settingsButtons[i]->contains(touchX, touchY)){
          settingsButtons[i]->press(true);
        }
      }else{
        settingsButtons[i]->press(false);
      }
      if(settingsButtons[i]->justPressed()){settingsButtons[i]->drawSmoothButton(true,3);}
      if(settingsButtons[i]->justReleased()){settingsButtons[i]->drawSmoothButton(false,3);}      
    }
    //I1X
    if(settingsI1Mult.justReleased()){
      keypadResult=getKeypad(numberButtonCount);  //allow dot
      if(keypadResult){
        f=atof(keypadResult);
        if((f>0.001)&&(f<MULT_LIMIT)){
          dcc1Mult=f;
          saveToFlash();
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawSetPageAll();  
    }
    //I2X
    if(settingsI2Mult.justReleased()){
      keypadResult=getKeypad(numberButtonCount);  //allow dot
      if(keypadResult){
        f=atof(keypadResult);
        if((f>0.001)&&(f<MULT_LIMIT)){
          dcc2Mult=f;
          saveToFlash();
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawSetPageAll();  
    }
    //V X
    if(settingsVMult.justReleased()){
      keypadResult=getKeypad(numberButtonCount);  //allow dot
      if(keypadResult){
        f=atof(keypadResult);
        if((f>0.001)&&(f<MULT_LIMIT)){
          vMult=f;
          saveToFlash();
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawSetPageAll();  
    }
    //ILIM
    if(settingsILimit.justReleased()){
      keypadResult=getKeypad(numberButtonCount);  //allow dot
      if(keypadResult){
        f=atof(keypadResult);
        if((f>0.001)&&(f<CURRENT_LIMIT_MAX)){
          dccCurrentLimit=f;
          saveToFlash();
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawSetPageAll();  
    }
    //I OFFSET
    if(settingsIOffset.justReleased()){
      keypadResult=getKeypad(numberButtonCount);  //allow dot
      if(keypadResult){
        f=atof(keypadResult);
        if((f>0.001)&&(f<CURRENT_OFFSET_MAX)){
          dccCurrentOffset=f;
          saveToFlash();
        }
      }
      tft.fillScreen(TFT_BLACK);
      drawAllCrit();
      drawSetPageAll();  
    }
    //LOCOS
    if(settingsLocos.justReleased()){
      saveToFlash();
      settingsLocos.drawSmoothButton(false,3,TFT_BLACK,"SAVED");
    }
    handleDCC();
    if(settingsExit.justReleased()){return;}
  }
}

