
#include <SPI.h>
#include <TFT_eSPI.h> // Hardware-specific library
#include <TFT_eWidget.h>           // Widget library
#include "asimov_36.h"  //font
TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
TFT_eSprite spr = TFT_eSprite(&tft); // Sprite class needs to be invoked

#include <Arduino.h>
#include <Ticker.h>
#include "dcc.h"

#include <EEPROM.h>

#include "util.h"

void setup() {
  int i;
  Serial.begin(115200);
  Serial1.setRX(1);
  Serial1.setTX(0);
  Serial1.begin(9600);
  EEPROM.begin(4096);
  pinMode(TOUCH_IRQ,INPUT_PULLUP);
  pinMode(LED_PWM,OUTPUT);
  digitalWrite(LED_PWM,HIGH);
  pinMode(PICO_LED,OUTPUT);
  digitalWrite(PICO_LED,HIGH);
  tft.init();
  tft.setRotation(1);
  tft.fillScreen(TFT_BLACK);
  tft.setTouch(calData);
  tft.loadFont(asimov_36);  //smoothed font
  spr.setColorDepth(16); // 16-bit colour needed to show anti-aliased fonts
  spr.loadFont(asimov_36);  //smoothed font
  idlePacket(&pkt1);
  DCCinit();
  for(i=0;i<LOCO_COUNT;i++){  //some useful values to start with
    locos[i].address=0;
    locos[i].useLongAddress=DCC_OFF;
    locos[i].dir=DCC_FORWARD;
    locos[i].F0=DCC_OFF;
    locos[i].F1=DCC_OFF;
    locos[i].F2=DCC_OFF;
    locos[i].F3=DCC_OFF;
    locos[i].F4=DCC_OFF;
    locos[i].speed=0;
    speedPacket128(&packets[i*2],locos[i]);
    F04Packet(&packets[i*2+1],locos[i]);
  }
  LoadFromFlash();  
  if(packetQueueSpace()){queuePacket(packets[0]);}  //should be free, but let's be sure
  UIsetup();
  drawAllCrit();
  drawAllLocoButtons();  //ready for 1st page
}

void loop() {
  int i;
  char t[16]="";
  char* keypadResult=0;
  touchPressed=tft.getTouch(&touchX, &touchY);
  handleCrit();
  drawCrit();
  handleLocoButtons();
  if(progButton.justReleased()){  //go to CV programming page
    doProgPage();
    tft.fillScreen(TFT_BLACK);
    UIsetup();
    drawAllCrit();
    drawAllLocoButtons();  //ready for 1st page
  }
  if(setButton.justReleased()){ //go to settings page
    doSetPage();
    tft.fillScreen(TFT_BLACK);
    UIsetup();
    drawAllCrit();
    drawAllLocoButtons();  //ready for 1st page
  }
  if(nButton.justReleased()){ //get a number  
    if(locos[activeLoco].speed){
      locos[activeLoco].speed=0;    //ensure speed reset
      slider.setSliderPosition(0);
      stateChange=1;  //flag
    }else{
      keypadResult=getKeypad(numberButtonCount-1);  //don't allow dot
      if(keypadResult){
        i=atoi(keypadResult);
        if(i<0){i=0;}
        if(i>DCC_MAX_LONG_ADD){i=0;}
        if((i>DCC_MAX_SHORT_ADD)||(strlen(keypadResult)>2)){  //use long
          locos[activeLoco].address=i;
          locos[activeLoco].useLongAddress=1;
        }else{ //use short
          locos[activeLoco].address=i;
          locos[activeLoco].useLongAddress=0;
        }
        for(i=0;i<LOCO_COUNT;i++){  //avoid having one loco controlled by 2 controllers
          if((i!=activeLoco)&&(locos[activeLoco].address==locos[i].address)&&(locos[activeLoco].useLongAddress==locos[i].useLongAddress)){
            locos[activeLoco].address=0;
          }
        }
        locos[activeLoco].speed=0;    //ensure speed reset
        slider.setSliderPosition(0);
        locos[activeLoco].dir=DCC_FORWARD;     //and reset everything
        locos[activeLoco].F0=DCC_OFF;
        locos[activeLoco].F1=DCC_OFF;
        locos[activeLoco].F2=DCC_OFF;
        locos[activeLoco].F3=DCC_OFF;
        locos[activeLoco].F4=DCC_OFF;
      }
      //get ready for resuming
      tft.fillScreen(TFT_BLACK);
      UIsetup();
      drawAllCrit();
      drawAllLocoButtons();  //ready for 1st page
    }
  }
  if(stateChange){
    stateChange=0;
    drawLocoButtons();
    handleDCC();
    slider.setSliderPosition(locos[activeLoco].speed);
  }
  handleDCC();
}

void setup1(){
  analogReadResolution(12);
  //nothing to do here, just start getting values in loop1()
}

void loop1(){
  //these hold local versions
  static float c1=0;
  float n;
  n=analogRead(DCC1I);
  c1=n*dcc1Mult-dccCurrentOffset;
  if(c1<0){c1=0;}
  if(c1>dccCurrentLimit){
    digitalWrite(DCC1EN,LOW); //disable output now and let other logic tidy up
    dcc1on=0;
    dccTripped=1;
    tripTime=millis();
  }
  if(getAnalogFlag){  //read the others as needed
    n=analogRead(DCC2I);
    dcc2Current=n*dcc2Mult;
    n=analogRead(VSENSE);
    supplyVoltage=n*vMult;
    dcc1Current=c1;
    getAnalogFlag=0;
  }
}
