// This setup is for the Waveshare RP2040-LCD-0.96 board
// See SetupX_Template.h for all options available
#define USER_SETUP_ID 108

////////////////////////////////////////////////////////////////////////////////////////////
// Display driver type
////////////////////////////////////////////////////////////////////////////////////////////
#define ST7735_DRIVER
#define ST7735_GREENTAB160x80

////////////////////////////////////////////////////////////////////////////////////////////
// Display params
////////////////////////////////////////////////////////////////////////////////////////////
#define TFT_WIDTH  80
#define TFT_HEIGHT 160
#define TFT_INVERSION_ON

////////////////////////////////////////////////////////////////////////////////////////////
// RP2040 config and pins
////////////////////////////////////////////////////////////////////////////////////////////
#define SPI_FREQUENCY  27000000
#define RP2040_PIO_CLK_DIV 1
#define TFT_SPI_PORT 1

#define TFT_MOSI 11
#define TFT_SCLK 10
#define TFT_CS   9
#define TFT_DC   8
#define TFT_RST  12

////////////////////////////////////////////////////////////////////////////////////////////
// Fonts to be available
////////////////////////////////////////////////////////////////////////////////////////////
#define LOAD_GLCD   // Font 1. Original Adafruit 8 pixel font needs ~1820 bytes in FLASH
#define LOAD_FONT2  // Font 2. Small 16 pixel high font, needs ~3534 bytes in FLASH, 96 characters
#define LOAD_FONT4  // Font 4. Medium 26 pixel high font, needs ~5848 bytes in FLASH, 96 characters
#define LOAD_FONT6  // Font 6. Large 48 pixel font, needs ~2666 bytes in FLASH, only characters 1234567890:-.apm
#define LOAD_FONT7  // Font 7. 7 segment 48 pixel font, needs ~2438 bytes in FLASH, only characters 1234567890:.
#define LOAD_FONT8  // Font 8. Large 75 pixel font needs ~3256 bytes in FLASH, only characters 1234567890:-.
#define LOAD_GFXFF  // FreeFonts. Include access to the 48 Adafruit_GFX free fonts FF1 to FF48 and custom fonts

#define SMOOTH_FONT

////////////////////////////////////////////////////////////////////////////////////////////