#include <Arduino.h>
#include <Ticker.h>

#define DCC_PERIOD (0.000058)
#define DCC1A 20
#define DCC1B 18
#define DCC1EN 19
#define DCC2A 21
#define DCC2B 22

/*
#define DCC1A 17
#define DCC1B 16
#define DCC2A 19
#define DCC2B 18
*/
#define PACKET_MAX_BYTES 8
#define DCC_PACKET_QUEUE_SIZE 5
#define DCC_FORWARD 1
#define DCC_REVERSE 0
#define DCC_ON 1
#define DCC_OFF 0
#define DCC_MAX_LONG_ADD 10239
#define DCC_MAX_SHORT_ADD 99
#define DCC_RESET_PACKET_COUNT 30
#define DCC_DIRECT_MODE_COUNT 7
#define DCC_PHYS_MODE_COUNT 7
#define DCC_PAGED_MODE_COUNT 7
#define DCC_OPS_MODE_COUNT 7
#define DCC_OPS_MODE_TIMEOUT 100
#define DCC_RECOVERY_VERIFY_COUNT 2
#define DCC_RECOVERY_WRITE_COUNT 7
#define DCC_QI_SMOOTHING 16
#define DC_QI_THRESHOLD 0.06

struct dccPacket_t {  
  uint8_t byteCount;
  uint8_t data[PACKET_MAX_BYTES];
};

struct loco_t {
  unsigned int address:14;
  unsigned int useLongAddress:1;
  unsigned int speed:7; 
  unsigned int dir:1;   //1=forward
  unsigned int F0:1;
  unsigned int F1:1;
  unsigned int F2:1;
  unsigned int F3:1;
  unsigned int F4:1;
};

extern char dcc1on,dcc2on;
extern dccPacket_t pkt1, pkt2, pktIdle, nextPkt2, pktReset;   //current packets
//extern nextPkt1[DCC_PACKET_QUEUE_SIZE]; //buffer queue, user should use packetQueueSpace and queuePacket APIs

char packetQueueSpace(void);  //check is space available T/F
char queuePacket(dccPacket_t p);  //add to queue, performs check, T on success
void packQueue(void); //bump packets to top of queue
void dumpPacket(dccPacket_t* p);
void DCCinit(void);
void DCCcallback(void);
void idlePacket(dccPacket_t* p);  //load idle packet into p
void resetPacket(dccPacket_t* p); //load reset packet into p
void addChecksum(dccPacket_t* p); //add checksum byte
void addSpeed128(dccPacket_t* p, loco_t loco);
void addF04(dccPacket_t* p, loco_t loco);
void addAddress(dccPacket_t* p, loco_t loco);
void speedPacket128(dccPacket_t* p, loco_t loco);
void F04Packet(dccPacket_t* p, loco_t loco);
//service mode/programming packets
//direct mode
void DCCserviceDirectVerifyByte(dccPacket_t* p, int cv, byte data);        //verify cv has data  
void DCCserviceDirectVerifyBit(dccPacket_t* p, int cv, byte bt, byte bv);  //verify that cv has bit bt equal to bv
void DCCserviceDirectWriteByte(dccPacket_t* p, int cv, byte data);        //write cv with data  
void DCCserviceDirectWriteBit(dccPacket_t* p, int cv, byte bt, byte bv);  //write cv bit bt with bv
//Address only modes, effectively a subset of Physical modes with only CV 1 supported
void DCCserviceAddressOnlyVerify(dccPacket_t* p, byte data);        //verify address (7bits only) 
void DCCserviceAddressOnlyWrite(dccPacket_t* p, byte data);        //write address (7bits only) 
//physical modes
void DCCservicePhysicalVerify(dccPacket_t* p, int cv, byte data);        //verify mapped cv with data  
void DCCservicePhysicalWrite(dccPacket_t* p, int cv, byte data);        //write mapped cv with data  
//page register setting
void DCCservicePageNumberVerify(dccPacket_t* p, int cv);
void DCCservicePageNumberWrite(dccPacket_t* p, int cv);
//paged mode, note that these are the same as physical when page=1
void DCCservicePagedVerify(dccPacket_t* p, int cv, byte data);  //check that PageNumber is set prior
void DCCservicePagedWrite(dccPacket_t* p, int cv, byte data);  //check that PageNumber is set prior
//operations mode programming
void DCCopsLongWrite(dccPacket_t* p,loco_t loco,int cv, byte data);  //NB: address (from loco) needed s-9.2.1_dcc_extended_packet_formats: s2.3.7.3 Configuration Variable Access Instruction - Long Form
// packet comparison
char checkPacketMatch(dccPacket_t* p1, dccPacket_t* p2);    //simple equality over valid bytes (ie up to len)