#ifndef PORTBITS_H
#define	PORTBITS_H
/*
 * Generic unified port access structs for PIC16F1xxxx
 * #define checks ensure only actual port members are defined
 * can use port (a0..e3) defines for access to all port control structs
 * portbits.
 * trisbits.
 * latbits.
 * anselbits.
 * wpubits.
 * odconbits.
 * slrconbits.
 * inlvlbits.
 * iocxpbits/iocxnbits/iocxfbits.
 * pps. (note pps are bytes, not bits)
 * ALSO:
 * analogChans_t enum; eg ADPCH=a0;
 * 
 *  * Compiles to same BCF/BSF opcode as standard port names
 */

#include <xc.h> // include processor files - each processor file is guarded.  
//should work for most 16F1xxxx parts, minor changes

//check and add as needed:
//PIC16F131xx family
//PIC16F18126/46
#if defined(_16F18146) || defined(_16F18126) || defined(_16F13145) 
#define PORT_AUX_BASE (0x1E8C)
#define PORT_AUX_INTERVAL (10)
#define PORT_PPS_BASE (0x1D8C)
#define PORT_PPS_ARRAY_SIZE (24)
#define PPSO_PWM1S1P1_OUT (0xB)
#define PPSO_PWM1S1P2_OUT (0xC)
#define PPSO_PWM2S1P1_OUT (0xD)
#define PPSO_PWM2S1P2_OUT (0xE)
#define PPSO_LAT (0)
#endif

//PIC16F18114/15/24/25/44/45 family
#if defined(_16F18114) || defined(_16F18115) || defined(_16F18124) || defined(_16F18125) || defined(_16F18144) || defined(_16F18145)
#define PORT_AUX_BASE (0x1E8C)
#define PORT_AUX_INTERVAL (10)
#define PORT_PPS_BASE (0x1D8C)
#define PORT_PPS_ARRAY_SIZE (24)
#define PPSO_PWM1S1P1_OUT (0xB)
#define PPSO_PWM1S1P2_OUT (0xC)
#define PPSO_PWM2S1P1_OUT (0xD)
#define PPSO_PWM2S1P2_OUT (0xE)
#define PPSO_LAT (0)
#endif

//PIC16F15213/14/23/24/43/44 are same datasheet
#if defined(_16F15224) || defined(_16F15225)
#define PORT_AUX_BASE (0x1F38)
#define PORT_AUX_INTERVAL (11)
#define PORT_PPS_BASE (0x1F10)
#endif

#define PORT_PADDING_9 unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;
#define PORT_PADDING_10 unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;unsigned int :8;

//note that padding is one less than interval
#if(PORT_AUX_INTERVAL == 10)
#define PORT_PADDING PORT_PADDING_9
#else
#define PORT_PADDING PORT_PADDING_10
#endif

extern volatile unsigned char ppsArray[PORT_PPS_ARRAY_SIZE] __at(PORT_PPS_BASE);

typedef struct {
        unsigned int 
#ifdef _PORTA_RA0_SIZE
    a0
#endif
    :1; unsigned int
#ifdef _PORTA_RA1_SIZE
    a1
#endif
    :1; unsigned int
#ifdef _PORTA_RA2_SIZE
    a2
#endif
    :1; unsigned int
#ifdef _PORTA_RA3_SIZE
    a3
#endif
    :1; unsigned int
#ifdef _PORTA_RA4_SIZE
    a4
#endif
    :1; unsigned int
#ifdef _PORTA_RA5_SIZE
    a5
#endif
    :1; unsigned int
#ifdef _PORTA_RA6_SIZE
    a6
#endif
    :1; unsigned int
#ifdef _PORTA_RA7_SIZE
    a7
#endif
    :1; unsigned int
#ifdef _PORTB_RB0_SIZE
    b0
#endif
    :1; unsigned int
#ifdef _PORTB_RB1_SIZE
    b1
#endif
    :1; unsigned int
#ifdef _PORTB_RB2_SIZE
    b2
#endif
    :1; unsigned int
#ifdef _PORTB_RB3_SIZE
    b3
#endif
    :1; unsigned int
#ifdef _PORTB_RB4_SIZE
    b4
#endif
    :1; unsigned int
#ifdef _PORTB_RB5_SIZE
    b5
#endif
    :1; unsigned int
#ifdef _PORTB_RB6_SIZE
    b6
#endif
    :1; unsigned int
#ifdef _PORTB_RB7_SIZE
    b7
#endif
    :1; unsigned int
#ifdef _PORTC_RC0_SIZE
    c0
#endif
    :1; unsigned int
#ifdef _PORTC_RC1_SIZE
    c1
#endif
    :1; unsigned int
#ifdef _PORTC_RC2_SIZE
    c2
#endif
    :1; unsigned int
#ifdef _PORTC_RC3_SIZE
    c3
#endif
    :1; unsigned int
#ifdef _PORTC_RC4_SIZE
    c4
#endif
    :1; unsigned int
#ifdef _PORTC_RC5_SIZE
    c5
#endif
    :1; unsigned int
#ifdef _PORTC_RC6_SIZE
    c6
#endif
    :1; unsigned int
#ifdef _PORTC_RC7_SIZE
    c7
#endif
    :1; unsigned int
#ifdef _PORTD_RD0_SIZE
    d0
#endif
    :1; unsigned int
#ifdef _PORTD_RD1_SIZE
    d1
#endif
    :1; unsigned int
#ifdef _PORTD_RD2_SIZE
    d2
#endif
    :1; unsigned int
#ifdef _PORTD_RD3_SIZE
    d3
#endif
    :1; unsigned int
#ifdef _PORTD_RD4_SIZE
    d4
#endif
    :1; unsigned int
#ifdef _PORTD_RD5_SIZE
    d5
#endif
    :1; unsigned int
#ifdef _PORTD_RD6_SIZE
    d6
#endif
    :1; unsigned int
#ifdef _PORTD_RD7_SIZE
    d7
#endif
    :1; unsigned int
#ifdef _PORTE_RE0_SIZE
    e0
#endif
    :1; unsigned int
#ifdef _PORTE_RE1_SIZE
    e1
#endif
    :1; unsigned int
#ifdef _PORTE_RE2_SIZE
    e2
#endif
    :1; unsigned int
#ifdef _PORTE_RE3_SIZE
    e3
#endif
    :1;
} portbits_t;

extern volatile portbits_t portbits __at(0x00C);
extern volatile portbits_t trisbits __at(0x012);
extern volatile portbits_t latbits __at(0x018);

typedef struct {
    unsigned int
#if defined(_ANSELA_ANSA0_SIZE) || defined(_ANSELA_ANSELA0_SIZE)
    a0
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA1_SIZE) || defined(_ANSELA_ANSELA1_SIZE)
    a1
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA2_SIZE) || defined(_ANSELA_ANSELA2_SIZE)
    a2
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA3_SIZE) || defined(_ANSELA_ANSELA3_SIZE)
    a3
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA4_SIZE) || defined(_ANSELA_ANSELA4_SIZE)
    a4
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA5_SIZE) || defined(_ANSELA_ANSELA5_SIZE)
    a5
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA6_SIZE) || defined(_ANSELA_ANSELA6_SIZE)
    a6
#endif
    :1; unsigned int
#if defined(_ANSELA_ANSA7_SIZE) || defined(_ANSELA_ANSELA7_SIZE)
    a7
#endif
    :1; PORT_PADDING unsigned int
#if defined(_ANSELB_ANSB0_SIZE) || defined(_ANSELB_ANSELB0_SIZE)
    b0
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB1_SIZE) || defined(_ANSELB_ANSELB1_SIZE)
    b1
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB2_SIZE) || defined(_ANSELB_ANSELB2_SIZE)
    b2
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB3_SIZE) || defined(_ANSELB_ANSELB3_SIZE)
    b3
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB4_SIZE) || defined(_ANSELB_ANSELB4_SIZE)
    b4
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB5_SIZE) || defined(_ANSELB_ANSELB5_SIZE)
    b5
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB6_SIZE) || defined(_ANSELB_ANSELB6_SIZE)
    b6
#endif
    :1; unsigned int
#if defined(_ANSELB_ANSB7_SIZE) || defined(_ANSELB_ANSELB7_SIZE)
    b7
#endif
    :1; PORT_PADDING unsigned int
#if defined(_ANSELC_ANSC0_SIZE) || defined(_ANSELC_ANSELC0_SIZE)
    c0
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC1_SIZE) || defined(_ANSELC_ANSELC1_SIZE)
    c1
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC2_SIZE) || defined(_ANSELC_ANSELC2_SIZE)
    c2
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC3_SIZE) || defined(_ANSELC_ANSELC3_SIZE)
    c3
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC4_SIZE) || defined(_ANSELC_ANSELC4_SIZE)
    c4
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC5_SIZE) || defined(_ANSELC_ANSELC5_SIZE)
    c5
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC6_SIZE) || defined(_ANSELC_ANSELC6_SIZE)
    c6
#endif
    :1; unsigned int
#if defined(_ANSELC_ANSC7_SIZE) || defined(_ANSELC_ANSELC7_SIZE)
    c7
#endif
    :1; PORT_PADDING unsigned int
#if defined(_ANSELD_ANSD0_SIZE) || defined(_ANSELD_ANSELD0_SIZE)
    d0
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD1_SIZE) || defined(_ANSELD_ANSELD1_SIZE)
    d1
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD2_SIZE) || defined(_ANSELD_ANSELD2_SIZE)
    d2
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD3_SIZE) || defined(_ANSELD_ANSELD3_SIZE)
    d3
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD4_SIZE) || defined(_ANSELD_ANSELD4_SIZE)
    d4
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD5_SIZE) || defined(_ANSELD_ANSELD5_SIZE)
    d5
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD6_SIZE) || defined(_ANSELD_ANSELD6_SIZE)
    d6
#endif
    :1; unsigned int
#if defined(_ANSELD_ANSD7_SIZE) || defined(_ANSELD_ANSELD7_SIZE)
    d7
#endif
    :1; PORT_PADDING unsigned int
#if defined(_ANSELE_ANSE0_SIZE) || defined(_ANSELE_ANSELE0_SIZE)
    e0
#endif
    :1; unsigned int
#if defined(_ANSELE_ANSE1_SIZE) || defined(_ANSELE_ANSELE1_SIZE)
    e1
#endif
    :1; unsigned int
#if defined(_ANSELE_ANSE2_SIZE) || defined(_ANSELE_ANSELE2_SIZE)
    e2
#endif
    :1; unsigned int
#if defined(_ANSELE_ANSE3_SIZE) || defined(_ANSELE_ANSELE3_SIZE)
    e3
#endif
    :1;
} portauxbits_t;

extern volatile portauxbits_t anselbits     __at(PORT_AUX_BASE+0);
extern volatile portauxbits_t wpubits       __at(PORT_AUX_BASE+1);
extern volatile portauxbits_t odconbits     __at(PORT_AUX_BASE+2);
extern volatile portauxbits_t slrconbits    __at(PORT_AUX_BASE+3);
extern volatile portauxbits_t inlvlbits     __at(PORT_AUX_BASE+4);
extern volatile portauxbits_t iocxpbits     __at(PORT_AUX_BASE+5);
extern volatile portauxbits_t iocxnbits     __at(PORT_AUX_BASE+6);
extern volatile portauxbits_t iocxfbits     __at(PORT_AUX_BASE+7);

//analog channels:
typedef enum {
#if defined(_ANSELA_ANSA0_SIZE) || defined(_ANSELA_ANSELA0_SIZE)
    a0=0,
#endif
#if defined(_ANSELA_ANSA1_SIZE) || defined(_ANSELA_ANSELA1_SIZE)
    a1=1,
#endif
#if defined(_ANSELA_ANSA2_SIZE) || defined(_ANSELA_ANSELA2_SIZE)
    a2=2,
#endif
#if defined(_ANSELA_ANSA3_SIZE) || defined(_ANSELA_ANSELA3_SIZE)
    a3=3,
#endif
#if defined(_ANSELA_ANSA4_SIZE) || defined(_ANSELA_ANSELA4_SIZE)
    a4=4,
#endif
#if defined(_ANSELA_ANSA5_SIZE) || defined(_ANSELA_ANSELA5_SIZE)
    a5=5,
#endif
#if defined(_ANSELA_ANSA6_SIZE) || defined(_ANSELA_ANSELA6_SIZE)
    a6=6,
#endif
#if defined(_ANSELA_ANSA7_SIZE) || defined(_ANSELA_ANSELA7_SIZE)
    a7=7,
#endif
#if defined(_ANSELB_ANSB0_SIZE) || defined(_ANSELB_ANSELB0_SIZE)
    b0=8,
#endif
#if defined(_ANSELB_ANSB1_SIZE) || defined(_ANSELB_ANSELB1_SIZE)
    b1=9,
#endif
#if defined(_ANSELB_ANSB2_SIZE) || defined(_ANSELB_ANSELB2_SIZE)
    b2=10,
#endif
#if defined(_ANSELB_ANSB3_SIZE) || defined(_ANSELB_ANSELB3_SIZE)
    b3=11,
#endif
#if defined(_ANSELB_ANSB4_SIZE) || defined(_ANSELB_ANSELB4_SIZE)
    b4=12,
#endif
#if defined(_ANSELB_ANSB5_SIZE) || defined(_ANSELB_ANSELB5_SIZE)
    b5=13,
#endif
#if defined(_ANSELB_ANSB6_SIZE) || defined(_ANSELB_ANSELB6_SIZE)
    b6=14,
#endif
#if defined(_ANSELB_ANSB7_SIZE) || defined(_ANSELB_ANSELB7_SIZE)
    b7=15,
#endif
#if defined(_ANSELC_ANSC0_SIZE) || defined(_ANSELC_ANSELC0_SIZE)
    c0=16,
#endif
#if defined(_ANSELC_ANSC1_SIZE) || defined(_ANSELC_ANSELC1_SIZE)
    c1=17,
#endif
#if defined(_ANSELC_ANSC2_SIZE) || defined(_ANSELC_ANSELC2_SIZE)
    c2=18,
#endif
#if defined(_ANSELC_ANSC3_SIZE) || defined(_ANSELC_ANSELC3_SIZE)
    c3=19,
#endif
#if defined(_ANSELC_ANSC4_SIZE) || defined(_ANSELC_ANSELC4_SIZE)
    c4=20,
#endif
#if defined(_ANSELC_ANSC5_SIZE) || defined(_ANSELC_ANSELC5_SIZE)
    c5=21,
#endif
#if defined(_ANSELC_ANSC6_SIZE) || defined(_ANSELC_ANSELC6_SIZE)
    c6=22,
#endif
#if defined(_ANSELC_ANSC7_SIZE) || defined(_ANSELC_ANSELC7_SIZE)
    c7=23,
#endif
#if defined(_ANSELD_ANSD0_SIZE) || defined(_ANSELD_ANSELD0_SIZE)
    d0=24,
#endif
#if defined(_ANSELD_ANSD1_SIZE) || defined(_ANSELD_ANSELD1_SIZE)
    d1=25,
#endif
#if defined(_ANSELD_ANSD2_SIZE) || defined(_ANSELD_ANSELD2_SIZE)
    d2=26,
#endif
#if defined(_ANSELD_ANSD3_SIZE) || defined(_ANSELD_ANSELD3_SIZE)
    d3=27,
#endif
#if defined(_ANSELD_ANSD4_SIZE) || defined(_ANSELD_ANSELD4_SIZE)
    d4=28,
#endif
#if defined(_ANSELD_ANSD5_SIZE) || defined(_ANSELD_ANSELD5_SIZE)
    d5=29,
#endif
#if defined(_ANSELD_ANSD6_SIZE) || defined(_ANSELD_ANSELD6_SIZE)
    d6=30,
#endif
#if defined(_ANSELD_ANSD7_SIZE) || defined(_ANSELD_ANSELD7_SIZE)
    d7=31,
#endif
#if defined(_ANSELE_ANSE0_SIZE) || defined(_ANSELE_ANSELE0_SIZE)
    e0=32,
#endif
#if defined(_ANSELE_ANSE1_SIZE) || defined(_ANSELE_ANSELE1_SIZE)
    e1=33,
#endif
#if defined(_ANSELE_ANSE2_SIZE) || defined(_ANSELE_ANSELE2_SIZE)
    e2=34,
#endif
#if defined(_ANSELE_ANSE3_SIZE) || defined(_ANSELE_ANSELE3_SIZE)
    e3=35,
#endif

} analogChans_t ; 

typedef struct {
    unsigned char
#ifdef RA0PPS
    a0
#endif
    :8; unsigned char
#ifdef RA1PPS
    a1
#endif
    :8; unsigned char
#ifdef RA2PPS
    a2
#endif
    :8; unsigned char
#ifdef RA3PPS
    a3
#endif
    :8; unsigned char
#ifdef RA4PPS
    a4
#endif
    :8; unsigned char
#ifdef RA5PPS
    a5
#endif
    :8; unsigned char
#ifdef RA6PPS
    a6
#endif
    :8; unsigned char
#ifdef RA7PPS
    a7
#endif
    :8; unsigned char
#ifdef RB0PPS
    b0
#endif
    :8; unsigned char
#ifdef RB1PPS
    b1
#endif
    :8; unsigned char
#ifdef RB2PPS
    b2
#endif
    :8; unsigned char
#ifdef RB3PPS
    b3
#endif
    :8; unsigned char
#ifdef RB4PPS
    b4
#endif
    :8; unsigned char
#ifdef RB5PPS
    b5
#endif
    :8; unsigned char
#ifdef RB6PPS
    b6
#endif
    :8; unsigned char
#ifdef RB7PPS
    b7
#endif
    :8; unsigned char
#ifdef RC0PPS
    c0
#endif
    :8; unsigned char
#ifdef RC1PPS
    c1
#endif
    :8; unsigned char
#ifdef RC2PPS
    c2
#endif
    :8; unsigned char
#ifdef RC3PPS
    c3
#endif
    :8; unsigned char
#ifdef RC4PPS
    c4
#endif
    :8; unsigned char
#ifdef RC5PPS
    c5
#endif
    :8; unsigned char
#ifdef RC6PPS
    c6
#endif
    :8; unsigned char
#ifdef RC7PPS
    c7
#endif
    :8; unsigned char
#ifdef RD0PPS
    d0
#endif
    :8; unsigned char
#ifdef RD1PPS
    d1
#endif
    :8; unsigned char
#ifdef RD2PPS
    d2
#endif
    :8; unsigned char
#ifdef RD3PPS
    d3
#endif
    :8; unsigned char
#ifdef RD4PPS
    d4
#endif
    :8; unsigned char
#ifdef RD5PPS
    d5
#endif
    :8; unsigned char
#ifdef RD6PPS
    d6
#endif
    :8; unsigned char
#ifdef RD7PPS
    d7
#endif
    :8; unsigned char
#ifdef RE0PPS
    e0
#endif
    :8; unsigned char
#ifdef RE1PPS
    e1
#endif
    :8; unsigned char
#ifdef RE2PPS
    e2
#endif
    :8; unsigned char
#ifdef RE3PPS
    e3
#endif
    :8;
} pps_t;

extern volatile pps_t pps __at(PORT_PPS_BASE);

#endif	/* PORTBITS_H */

