#include "io.h"

unsigned int adcref1,dacref1;
unsigned int adcref2,dacref2;
unsigned int adcref4,dacref4;
unsigned int vccRef,vmRef;

void ioInit(void){
    //these are in DIA, see pic16f18126.h
    adcref1=readNVM(DIA_FVRA1X);
    dacref1=readNVM(DIA_FVRC1X);
    adcref2=readNVM(DIA_FVRA2X);
    dacref2=readNVM(DIA_FVRC2X);
    adcref4=readNVM(DIA_FVRA4X);
    dacref4=readNVM(DIA_FVRC4X);
    vccRef=adcref2*VCCFACTOR;
    vmRef=adcref2*VMFACTOR;    
    //PPS to default (not cleared on some resets)
    unsigned char intcon=INTCON;
    GIE=0;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.MCON1=0xB;
    pps.MCON2=0xC;
    pps.F0FCON=0;
    pps.F0RCON=0;
    pps.F1CON=0;
    pps.F2CON=0;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;   
    //all analog off, expect VSENSE
    ANSELA=0;
    ANSELC=0;
    anselbits.VSENSE=1;
    //outputs default to low/off
    trisbits.MCON1=0;
    latbits.MCON1=0;
    trisbits.MCON2=0;
    latbits.MCON2=0;
    trisbits.F0FCON=0;
    latbits.F0FCON=0;
    trisbits.F0RCON=0;
    latbits.F0RCON=0;
    trisbits.F1CON=0;
    latbits.F1CON=0;
    trisbits.F2CON=0;
    latbits.F2CON=0;
}

void pwmInit(void){
    //PWM1S1 (there is no S2)
    PWM1CON=0;          //reset
    PWM1ERS=0;
    PWM1CLK=2;          //FOSC=32MHz
    //PWM1CLK=5;          //MFINTOSC 500kHz
    PWM1LDS=0;
    PWM1PR=PWM_PERIOD;
    PWM1CPRE=(PWM_FREQ_DIV_MOTOR-1);    //prescale
    PWM1S1CFG=0;        //S1P1,S1P2 normal polarity, left aligned
    PWM1S1P1=0;         //duty
    PWM1S1P2=0;         //duty
    PWM1GIE=0;          //no ints    
    PWM1CONbits.LD=1;   //load
    PWM1CONbits.EN=1;   //on    
    //PWM2S1 (there is no S2)
    PWM2CON=0;          //reset
    PWM2ERS=0;
    PWM2CLK=2;          //FOSC=32MHz
    //PWM2CLK=5;          //MFINTOSC 500kHz
    PWM2LDS=0;
    PWM2PR=PWM_PERIOD;
    PWM2CPRE=(PWM_FREQ_DIV_FUNCTION-1);    //prescale
    PWM2S1CFG=0;        //S1P1,S1P2 normal polarity, left aligned
    PWM2S1P1=0;         //duty
    //PWM2S1P2=0;         //not used
    PWM2GIE=0;          //no ints    
    PWM2CONbits.LD=1;   //load
    PWM2CONbits.EN=1;   //on        
}

void pwmDeInit(void){
    PWM1CONbits.EN=0;   //off    
}

void t0init(void){      //count at 244Hz (ie no interrupts, use raw 16-bit counter value)
    //16bit
    T0CON0=0;               //reset, 8-bit, 1:1 postscale
    T0CON1=0;               //T0CKI, ASYNC off, PS=1:1
    TMR0L=0;
    TMR0H=0;                //reset
/*
    T0CON0bits.MD16=1;      //16-bit, period is 65536
    //T0CON1bits.CS=5;        //MFINTOSC 500kHz
    //T0CON1bits.CS=4;        //LFINTOSC 31kHz
    T0CON1bits.CS=2;        //FOSC/4    
    T0CON1bits.ASYNC=1;     //ASYNC
    //T0CON1bits.T0CKPS=11;    //1:2^n
    //T0CON0bits.OUTPS=14;    //1:15   1:15*65536 => 4Hz
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable
*/

    //8bit
    T0CON0=0;               //reset, 8-bit, 1:1    
    T0CON1bits.CS=2;        //FOSC/4=8MHz
    T0CON1bits.ASYNC=1;     //ASYNC
    T0CON1bits.T0CKPS=3;    //1:8
    T0CON0bits.OUTPS=0;     //1:1   //1MHz
    TMR0H=21;               //22us ticks
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable
}

unsigned long getT0long(void){  //watch for rollovers and provide extended count
    //should be correct as long as called frequently enough (every 4 min)
    static unsigned int t0Old=0;
    static unsigned long t0hi=0;
    unsigned int t0new=TMR0L; //fill using read sequence, LSB buffers MSB
    t0new=t0new|(((unsigned int)TMR0H) << 8);
    if(t0new<t0Old){//rollover has happened
        t0hi=t0hi+(1UL<<16);
    }
    t0Old=t0new;
    return t0hi|t0new;    
}

void initADC(void){
    ADCON0=0;           //reset ADC, single ended, use FOSC
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=0;
    ADCAP=0;            //extra capacitance
    //ADCLK=63;
    ADCON0bits.CS=1;    //ADCRC    
    ADCON0bits.ADFM0=1; //right justify, two's complement
    //ADREF=0;            //VDD    
    ADREF=3;            //FVR
    ADCON0bits.ADON=1;  //turn on, ready
}

void deInitADC(void){
    ADCON0=0;
}

unsigned int getADC(char c){
    char i;
    unsigned int r=0;
    ADCON0bits.IC=0;    //switch back to single ended
    ADPCH=ADC_VSS;
    ADCON0bits.GO=1;    //dummy VCC
    while(ADCON0bits.GO){}            
    ADPCH=c;
    ADCON0bits.GO=1;    //dummy
    while(ADCON0bits.GO){}                
    for(i=0;i<ADC_OS;i++){
        ADCON0bits.GO=1;
        while(ADCON0bits.GO){}            
        r=r+ADRES;
    }
    return r;
}

int getADCdiff(char p, char n){ //differential
    char i;
    int r=0;
    int a;
    ADCON0bits.IC=1;    //differential
    ADPCH=ADC_VSS;
    ADNCH=ADC_VSS;
    ADCON0bits.GO=1;    //dummy VCC
    while(ADCON0bits.GO){}            
    ADPCH=p;
    ADNCH=n;
    ADCON0bits.GO=1;    //dummy
    while(ADCON0bits.GO){}            
    for(i=0;i<ADC_OS;i++){
        ADCON0bits.GO=1;
        while(ADCON0bits.GO){}            
        a=(int)ADRES;
        r=r+a;
    }
    return r+(2*ADC_OS);    //systematic error?
}

unsigned int getVCC(void){  //in mV, needs DAC2 set to provide fraction of VCC
    unsigned long r;
    r=getADC(ADC_DAC2);
    if(DAC2DATL){
        r=(r*256)/DAC2DATL; //ADC steps
        r=(r*adcref2)/(4096UL*ADC_OS);
        return (unsigned int)(r);
    }else{
        return 9999;
    }
}

unsigned int readNVM(unsigned int add){ //maps top bit to NVMREGS
    NVMREGS=0;
    if(add&0x8000){NVMREGS=1;}
    NVMADR=add;
    NVMCON1bits.RD=1;   //start read
    return NVMDAT;    
}

void initFVR_DAC(char n){
    FVRCON=(FVRCON&0xF3)|0x80|((n<<2)&0xC);    
}

void initFVR_ADC(char n){
    FVRCON=(FVRCON&0xFC)|0x80|(n&3);
}

void deInitFVR(void){
    FVRCON=0;
}

void setFunctionState(char n, io_control_state_t s){
    static io_control_state_t ioState[DCC_FUNCTION_WIRE_COUNT];
    if(s!=ioState[n]){
        switch(n){
            case 0:   
                if(s==IO_PWM){
                    setPPS(F0FCON,PPSO_PWM2S1P1_OUT);                
                }else{
                    setPPS(F0FCON,PPSO_LAT);                
                    latbits.F0FCON=(unsigned char)s;
                }
                break;
            case 1:   
                if(s==IO_PWM){
                    setPPS(F0RCON,PPSO_PWM2S1P1_OUT);                
                }else{
                    setPPS(F0RCON,PPSO_LAT);                
                    latbits.F0RCON=(unsigned char)s;
                }
                break;
            case 2:   
                if(s==IO_PWM){
                    setPPS(F1CON,PPSO_PWM2S1P1_OUT);                
                }else{
                    setPPS(F1CON,PPSO_LAT);                
                    latbits.F1CON=(unsigned char)s;
                }
                break;
            case 3:   
                if(s==IO_PWM){
                    setPPS(F2CON,PPSO_PWM2S1P1_OUT);                
                }else{
                    setPPS(F2CON,PPSO_LAT);                
                    latbits.F2CON=(unsigned char)s;
                }
                break;
        }
    }
    ioState[n]=s;
/* 
    switch(n){
        case 0:            
            if(s==IO_PWM){
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F0FCON=0x0D; //PWM2S1P1_OUT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
            }else{
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F0FCON=0; //LAT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
                latbits.F0FCON=(unsigned char)s;
            }            
            break;
        case 1:
            if(s==IO_PWM){
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F0RCON=0x0D; //PWM2S1P1_OUT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
            }else{
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F0RCON=0; //LAT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
                latbits.F0RCON=(unsigned char)s;
            }
            break;
        case 2:
            if(s==IO_PWM){
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F1CON=0x0D; //PWM2S1P1_OUT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
            }else{
                latbits.F1CON=(unsigned char)s;
            }
            break;
        case 3:
            if(s==IO_PWM){
                GIE=0;
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
                pps.F2CON=0x0D; //PWM2S1P1_OUT
                PPSLOCK = 0x55; //Required sequence
                PPSLOCK = 0xAA; //Required sequence
                PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
                INTCON=intcon;   
            }else{
                latbits.F2CON=(unsigned char)s;
            }
            break;
    }
    ioState[n]=s;
*/
}

void setPPS(char n, char s){    //set PPS[analogChans_t]=s
    unsigned char intcon=INTCON;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    ppsArray[n]=s;
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=intcon;       
}