#include <Adafruit_TinyUSB.h>
#include <Arduino.h>
#include <Ticker.h>
#include "dcc.h"

loco_t loco;
dccPacket_t speedPacket, functionPacket;
int p=0;
int n=0;

void setup() {
  Serial.begin(115200);
  idlePacket(&pkt1);
  idlePacket(&nextPkt1);
  DCCinit();
  dcc1on=1;
  loco.address=3;
  loco.useLongAddress=0;
  loco.dir=DCC_FORWARD;
  loco.speed=0;
  loco.F0=0;
  loco.F1=0;
  loco.F2=0;
  loco.F3=0;
  loco.F4=0;
  updatePackets();
}

void loop() {
  unsigned long t;
  switch(n){
    case 1: loco.speed=64;loco.dir=DCC_FORWARD;break;
    case 2: loco.speed=0;loco.dir=DCC_FORWARD;break;
    case 3: loco.speed=64;loco.dir=DCC_REVERSE;break;
    case 4: loco.speed=0;loco.dir=DCC_REVERSE;break;
    case 5: loco.F0=1;loco.dir=DCC_FORWARD;break;
    case 6: loco.F0=1;loco.dir=DCC_REVERSE;break;
    case 7: loco.F0=0;loco.F1=1;loco.dir=DCC_FORWARD;break;
    case 8: loco.F1=0;loco.F2=1;loco.dir=DCC_FORWARD;break;
    case 9: loco.F2=0;loco.F3=1;loco.dir=DCC_FORWARD;break;
    case 10:loco.F3=0;loco.dir=DCC_FORWARD;break;
    default: n=0;break;
  }
  Serial.printf("%d ",n);
  showLoco(loco);  
  n=n+1;
  updatePackets();
  t=millis();
  while((millis()-t)<500){
    if(nextPkt1.byteCount==0){
      if(p){  //alternate using p as counter
        nextPkt1=speedPacket;
        p=0;  
      }else{
        nextPkt1=functionPacket;
        p=1;  
      }
    }
  }
}

void updatePackets(void){
  addAddress(&speedPacket,loco);
  addSpeed128(&speedPacket,loco);
  addAddress(&functionPacket,loco);
  addF04(&functionPacket,loco);
}

void showLoco(loco_t t){
  Serial.printf("%5d: %s %3d ",t.address,(t.dir==DCC_FORWARD)?"FOR":"REV",t.speed);
  Serial.printf("%c%c%c%c\r\n",t.F0?'0':'_',t.F1?'1':'_',t.F2?'2':'_',t.F3?'3':'_');
}
