/*
 * File:   main.c
 * Author: Tim Blythman
 */

//see globalPins.h for _XTAL_FREQ and pins

#include "config.h"
#include "globalPins.h"
#include <xc.h>
#include "portbits.h"
#include "io.h"
#include "dcc.h"

//unsigned int vcc=0; //chip supply not needed
unsigned int vm=0;  //motor supply
char i=0;   //generic index
unsigned char temp=0;   //used for function mapping
unsigned char bitTemp=0;//used for function mapping
unsigned char intcon;   //used when disabling interrupts

void main(void) {
    ioInit();
    pwmInit();
    initADC();    
    initFVR_ADC(FVR_2048);
    DAC2CON=DAC_ON|DAC_REF_VDD_GND;
    DAC2DATL=256/VCCFACTOR;    //1/8 of supply
    dccInit();
    GIE=1;
    mapSpeed(0,128,255);    //sensible defaults
    loco.config=nvConfig;
    resetLoco(&loco);
    loco.live.pageReg=1;    //this is not affected by resets
    mapSpeed(loco.config.CV2,loco.config.CV6,loco.config.CV5);    //current values    
    while(1){
        //vcc=(unsigned int)((((unsigned long)getADC(ADC_DAC2))*vccRef)/(4096UL*ADC_OS)); //not used
        vm=(unsigned int)((((unsigned long)getADC(VSENSE))*vmRef)/(4096UL*ADC_OS));
        if(dccRx.len){
            cleanPacket(&dccRx);        //check checksum, void if invalid
            parseDCC(&dccRx,&loco);    
            lastPacket=dccRx;
            dccRx.len=0;
        }        
        //acceleration, using 7ms/unit/step
        if(accelTimer>DCC_ACCEL_PERIOD_COUNT){
            intcon=INTCON;
            GIE=0;
            accelTimer=accelTimer-DCC_ACCEL_PERIOD_COUNT;   //happens often enough to be instant if CV3=0 or CV4=0
            INTCON=intcon;
            if((loco.live.dir!=loco.live.targetDir)||(loco.live.speed>loco.live.targetSpeed)){  //deceleration
                if(loco.config.CV4==0){     //decel disabled
                    loco.live.speed=loco.live.targetSpeed;
                    loco.live.dir=loco.live.targetDir;
                }else{
                    accelCount++;
                    if(accelCount>=loco.config.CV4){
                        accelCount=0;
                        if(loco.live.speed>0){loco.live.speed--;}   //stop wrap around
                        if(loco.live.speed<2){
                            loco.live.speed=0;
                            if(loco.live.dir!=loco.live.targetDir){
                                loco.live.dir=loco.live.targetDir;
                            }
                        }
                    }
                }
            }else if(loco.live.speed<loco.live.targetSpeed){  //acceleration
                if(loco.config.CV3==0){     //accel disabled
                    loco.live.speed=loco.live.targetSpeed;
                    loco.live.dir=loco.live.targetDir;
                }else{
                    accelCount++;
                    if(accelCount>=loco.config.CV3){
                        accelCount=0;
                        if(loco.live.speed<127){loco.live.speed++;}   //stop wrap around
                    }
                }
            }//else speeds and direction match
        }                
        //map to wires
        bitTemp=1;
        for(i=0;i<DCC_FUNCTION_WIRE_COUNT;i++){
            temp=0;
            if(loco.live.dir){
                if(loco.live.F0 && (loco.config.CV33&bitTemp)){temp=255;}
            }else{
                if(loco.live.F0 && (loco.config.CV34&bitTemp)){temp=255;}
            }
            if(loco.live.F1 && (loco.config.CV35&bitTemp)){temp=255;}
            if(loco.live.F2 && (loco.config.CV36&bitTemp)){temp=255;}
            if(loco.live.F3 && (loco.config.CV37&bitTemp)){temp=255;}
            wireState[i]=temp;
            bitTemp=(unsigned char)(bitTemp<<1);    //integer promotion warning
        }
        //action     
        if(loco.live.serviceMode==DCC_MODE_SERVICE){
            latbits.F0FCON=0;
            latbits.F0RCON=0;
            latbits.F1CON =0;
            latbits.F2CON =0;
            if(ackTimer){
                if(ackPol){
                    PWM1S1P1=0;
                    PWM1S1P2=255;            
                }else{
                    PWM1S1P1=255;                            
                    PWM1S1P2=0;
                }
                PWM1CONbits.LD=1;   //load
            }else{
                PWM1S1P1=255;
                PWM1S1P2=255;            
                PWM1CONbits.LD=1;   //load            
            }
        }else if(loco.live.serviceMode==DCC_MODE_OPS){
            //set outputs
            if(loco.config.functionVoltage){
                PWM2S1P1=getFuncPWM(loco.config.functionVoltage,(unsigned char)(vm/100));
                PWM2CONbits.LD=1;   //load
                for(i=0;i<DCC_FUNCTION_WIRE_COUNT;i++){
                    setFunctionState(i,wireState[i]&IO_PWM);       //to 2 or 0
                }                
            }else{
                for(i=0;i<DCC_FUNCTION_WIRE_COUNT;i++){
                    setFunctionState(i,wireState[i]&IO_ON);       //to 1 or 0
                }                
            }
            //motor
            temp=255-getPWM(&loco,(unsigned char)(vm/100));
            if(loco.live.dir){
                //PWM1S1P1=255-speedCurve[loco.live.speed];
                PWM1S1P1=temp;
                PWM1S1P2=255;
                PWM1CONbits.LD=1;   //load
            }else{
                //PWM1S1P2=255-speedCurve[loco.live.speed];
                PWM1S1P2=temp;
                PWM1S1P1=255;
                PWM1CONbits.LD=1;   //load
            }            
        }else{
            latbits.F0FCON=0;
            latbits.F0RCON=0;
            latbits.F1CON =0;
            latbits.F2CON =0;
            PWM1S1P1=255;
            PWM1S1P2=255;            
            PWM1CONbits.LD=1;   //load                        
        }
        if(loco.config.CV11){ //if locoTimeout enabled
            if((locoTimeout/4)>=loco.config.CV11){
                loco.live.targetSpeed=0;    //decelerate
                locoTimeout=0;
            }            
        }//ignore if not set
    }
}

void __interrupt() isr() {
    dccISR();
}
