#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "globalPins.h"
#include "portbits.h"
#include "dcc.h"

//using 255 allows 100% duty
#define PWM_PERIOD (255)
//nominally 125kHz with with divider of 1
#define PWM_FREQ_DIV_MOTOR (3)
#define PWM_FREQ_DIV_FUNCTION (125)
//*11 for 10:1 divider
#define VMFACTOR (11)
#define VCCFACTOR (8)

typedef enum{
    IO_OFF=0,
    IO_ON=1,
    IO_PWM=2
} io_control_state_t;

//from DIA
extern unsigned int adcref1,dacref1;
extern unsigned int adcref2,dacref2;
extern unsigned int adcref4,dacref4;
extern unsigned int vccRef,vmRef;

//ADC
#define ADC_OS (2)

//for FVRCON
#define FVR_OFF (0)
#define FVR_4096 (3)
#define FVR_2048 (2)
#define FVR_1024 (1)
//ADC channels
#define FVRBUF1 0b111110 
#define FVRBUF2 0b111111
#define ADC_VSS 0b111010
#define ADC_DAC1 0b111100
#define ADC_DAC2 0b111101

//for DAC1CON/DAC2CON
//eg DAC1CON=DAC_RA2|DAC_REF_FVR_GND;
#define DAC_RA2 (0b10100000)
#define RAC_RA0 (0b10010000)
#define DAC_OFF (0b00000000)
#define DAC_ON  (0b10000000)
#define DAC_REF_FVR_GND (0b1000)
#define DAC_REF_VDD_GND (0b0000)
#define ADCC_MD_ACCUM (1)
#define ADCC_MD_AVE (2)
#define ADCC_MD_BURST (3)
#define ADCC_MD_LPF (4)
#define ADCC_ALWAYS_INT (7)

void ioInit(void);
void pwmInit(void);
void pwmDeInit(void);
void t0init(void);
void initADC(void);
void deInitADC(void);
unsigned int getADC(char c);
int getADCdiff(char p, char n); //differential
unsigned int getVCC(void);  //in mV
unsigned int readNVM(unsigned int add);
void initFVR_DAC(char n);
void initFVR_ADC(char n);
void deInitFVR(void);
void setFunctionState(char n, io_control_state_t s);
void setPPS(char n, char s);    //set PPS[analogChans_t]=s

#endif	/* IO_H */

