# Remeber to add in the SHEBANG line

#
# <thingspeak.com> graphic site did accept HTTP: packets. They joined with <thingspeak.mathworks.com>
# and now only accept HTTPS: packets to report to graphics. This joining / upgrade means that the small uC
# projects can no longer use the ESP12S module to report to <thingspeak> for graphics.
# The ESP12S with a small uC with C support can not easily organize certificates for HTTPS: 
#
# This Python code accepts a HTTP: from the ESP12S destined to <thingspeak> and bridges it to HTTPS:
# for <thingspeak.mathworks.com>. The reply from the HTTPS: side is bridged to the HTTP: side as a reply
# for the small uC ESP12S module using HTTP:. The reply header is stripped to the <POST> data at the reply.
#
# The intention after development in Windows 10 Visual Studio Python, is the code is to moved to a
# Raspberry Pi Zero W module with python 3 installed. The module will reside on the secure private side
# of the house router. Python library does exist for a DyDNS check in and combined with port forwarding
# on the house router, the module can be made available to the public side via a DDNS for incoming HTTP: hits.
#
# Step (1)
# upon a program start, report to <thingspeak.mathworks.com> &field8 to graphically show program boot.
#
# Step (2)
# Sit and wait on the HTTP: side for a connection via port 3001. Selected to move away from 80: and 8080:
# Any hits are filtered. Only complying packets are responded to when originating from uC ESP12S module.
# Further filtering is applied, only complying packets are forwarded via HTTPS: to <thingspeak.mathworks.com>
#
# Step (3)
# The complying packet details are forwarded HTTPS: then hold and wait for the HTTPS: reply.
#
# Step (4)
# The reply from HTTPS: is stripped down to the POST data.
# This POST data is forwarded HTTP: to the ESP12S module on the original IP and PORT.
#
# Step (5)
# Sit and wait from the next HTTP: incoming
#
#############################################################################################
# FUNCTION
# Create outgoing HTTPS:\\thingspeak.mathwortks.com to create a graphic entry for each time
# this code is started. Check out &field8 graphic. Records time and date per dot.
import socket
import ssl
# 
api_key = '6LFN YOURDATA KEY 0BRNY'                 # provided as link to MH graphic account
field8 = '50.0'                                     # a value for the &field8 graphic dot
print ("HTTPS:      Reporting program start to thingspeak.mathworks.com  &field8=" + field8)
tshost = 'thingspeak.mathworks.com'                 # web site address to resolve via DNS
tsport = 443                                        # port used for HTTPS:
path = f"/update?api_key={api_key}&field8=" + field8   # forms the GET data string  
request = f"GET {path} HTTP/1.1\r\nHost: {tshost}\r\nConnection: close\r\n\r\n" # create HTTPS: packet GET request
context = ssl.create_default_context()              # create HTTP: socket and then wrap socket in HTTPS:
with socket.create_connection((tshost, tsport)) as sock:                # sock created
    with context.wrap_socket(sock, server_hostname=tshost) as ssock:    # wrap sock with certificate
        ssock.sendall(request.encode())                     # send into sock and start waiting for reply HTTPS:
        response = b""                                      # a holder for the response
        while True:                                         # loop blocking, while waiting for sock to complete
            data = ssock.recv(4096)                         # Sock Blocking ends on data or timeout
            if not data:                                    # rely from sock or timeout
                break                                       # sock timeout, so break waiting, nothing to do, FAIL
            response += data                                # append all data in response, until sock finishes
        print ("HTTPS:      Response from  thingspeak.mathsworks.com \r\n")  # help the human
        print(response.decode())                            # show it for human
        # I am not interested in the HTTPS: responses to &field8 logging the program start
        # just show Human something to look at. Be aware that the remote has closed the socket connection
        print ("\r\n")                                      # begin waiting for incoming HTTP: port 3001

##################################################################################################
# FUNCTION: sit waiting on the HTTP: <interface IP> port <3001> as a quiet socket until incoming traffic is heard.
# This means the interface becomes a Server Socket
# Upon a incoming hit, process and start the two bridge HTTP: <-> HTTPS:
inhost = '192.168.0.13'                             # Listen on one interface, this is fixed of the Pi Zero W Module
inport = 3001                                       # Port to listen
server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)   # Create the socket HTTP:
server_socket.bind((inhost, inport))                # bind as a server
server_socket.listen(1)                             # sit and listen. Does not block here, Start listening
print(f"HTTP:       Listening on   {inhost}   port  {inport} ...")  # something for the human to look at
while True:                                         # Loops here forever on the while (1) statement
    client_socket, addr = server_socket.accept()    # Socket provides some information upon a hit, Blocks here
    origin_ip = {addr}                              # Socket had a hit, save this <IP> for later reply HTTPS -> HTTP
    print(f"HTTP:       Connection from " + str (origin_ip))  # show where the HTTP: came from
    request = client_socket.recv(1024).decode()     # collect the data from the origin IP
    print("HTTP:        Received Data. It may have been from ESP12S module:")      # wake up the human
    print(request)                                  # this what arrived. Assume from ESP12 uC, Pull apart.
    for line in request.splitlines():               # Split request into lines and find the GET line
        if line.startswith("GET"):                  # on th line that starts with GET       
            print ("HTTP:       Filtering GET line, extracting KEY")
            discard = line.split (" ")              # split around the <sapce>
            key = discard [1]                       # discard all, but keep the second part
            print (key)                             # show the key to the account in <thingspeak.mathworks.com>
            break                                   # 

    for line in request.splitlines():               # split the request again to find the Host:
        if line.startswith("Host:"):                # it is part of the standard HTTP: header
            print("HTTP:        Filtering GET line, extract HOST")      # wake up the human
            discard, destination_name = line.split (':')                # split around the ":"
            print (destination_name)                # show the human
            break                                   # done
    # FUNCTION:
    # while the HTTP: side is still open and waiting, I have the HTTPS destination and data key
    # to create a new outgoing HTTPS: and get a response back on the HTTPS: side
    tshost = destination_name                       # making copies, this could be cleaned up
    path = key                                      # but it make it easier to read
    print ("HTTPS:      Forwarding HTTP contents onwards")    # Create HTTPS GET request
    request = f"GET {path} HTTP/1.1\r\nHost: {tshost}\r\nConnection: close\r\n\r\n"  # packet is terminate "\r\n\r\n
    context = ssl.create_default_context()                      # Create and wrap a new socket
    with socket.create_connection((tshost, tsport)) as sock:    # Smoke and Mirrors in the operating system
        with context.wrap_socket(sock, server_hostname=tshost) as ssock:
            ssock.sendall(request.encode())         # and send as HTTPS:. Commence waiting for the response
            response = b""                          # a holder for the response
            while True:                             # Stay collecting responses from socket here with while (1)    
                data = ssock.recv(4096)             # socket will finish when remotely closed, or time out
                if not data:                        # socket time out or remotely closed    
                    break                           # break the while (1) waiting for the socket, closed, timeout
                response += data                    # otherwise, continue collecting
            print ("HTTPS:      Response to be decoded")        # wake up the human
            print(response.decode())                # show me
    # FUNCTION:
    # The HTPS: side has now closed by the far end server.
    # The HTTP: side is still open waiting. Create the reply to the ESP12S module
    print ("\r\nHTTP:    Forwarding HTTPS: reply to original HTTP: caller")
    # The response to the original HTTP: ESP12S module does not need to see the header of the HTTPS:
    # The module only needs the POST of the HTTPS: and a message from us here to say were are OK.
    # 
    # to recover the POST data, look for the \r\n\r\n that separates the headers from the body of the HTTPS:
    # The find the mention in the header for the length of the POST
    headers, body = response.split (b"\r\n\r\n")        # in binary, split around the <NULL> line, separates header / POST
    header_text = headers.decode()                      # decode binary for all header lines
    header_lines = header_text.split("\r\n")            # for all the text header lines, split to array of lines
    content_length = 0;                                 # POST length is mentioned in the line "content-length"
    for line in header_lines:                           # For each string in array of header_lines
            if line.startswith ("Content-Length:"):     # for all the lines, this one I want
                content_text = line.split(":")          # Apply the split around the expected ":"
                content_length = content_text [1].strip()   # Strip off trailing \r\n, Be Aware it is still a string
                break;                                  # yeah mate, found the target line, stop looping in for
    length_int = int(content_length)                    # now some Bullshit happens. More checks could be added here 
    replystr = body.decode ()                           # But for the expected reply, the body is a short string   
    replystr = replystr [:length_int]                   # truncate the length of the body string to pay load length
    response = "HTTP/1.1 200 OK\r\nPython Bridge\r\nCOUNT=" + replystr + "\r\n\r\n" # form up the HTTP: packet, with null end
    print (response)                                    # show the human
    client_socket.sendall(response.encode())            # and send
    # FUNCTION:
    # It is expected the HTTP: side originating device will complete the close, being the ESP12S uC project
    # If it does not immediately close, socket will time out from no activity.
    # If it does not time out, the wile (1) will treat it as another incoming hit.
    # Stay looping waiting for the next incoming HTTP: hit on port 3001:
    # The odd numbered port (3001) is selected to avoid port 80 and 8080, allowing this code to hide (just a little) and
    # allows (future) port forwarding to expose this code the public side of the router.
    # Some DyDNS provide Python <inport> for outgoing DyDNS check in, to report the router public side.
# Loop back to while (1)


