//
// Pico BOOTSEL kicker AKA BootHelper
//
// Rev1 - GPIO pulled low, initiated reset cycle
// Rev2 - GPIO monitors heartbeat signal, MMSBasic -Pico RP2040
// PicoMite Heartbeat RP2040 GPIO25 thru to LED
//
// define pins
const int resetPin = 0;                  // PB0 on ATTiny85, pin 5 on 8pin DIP package
const int bootSelPin = 1;                // PB1 on ATTiny85, pin 6 on 8pin DIP package
const int gpioPin = 4;                   // PB4 ATTiny85, pin 3 on 8pin DIP package
int PicoGPIOState = 0;                   // heat beat pin from Pico, input to AtTiny85
long I = 0;                              // counter variable
int FLAG = 1;                            // one shot flag
//
// setup pins/modes                      // ATTiny85 pin setup
void setup() {
  pinMode(resetPin, OUTPUT);             // initialize as output 
  pinMode(bootSelPin, OUTPUT);           // initialize as output 
  pinMode(gpioPin, INPUT);               // initialize as input, heat beat from Pico (TP5)
  digitalWrite(resetPin, HIGH);          // RESET pin on Pico RUN pin 30
  digitalWrite(bootSelPin, HIGH);        // BOOTSEL pin on Pico, bottom of PCB, TP6
}
//                                
// main loop
//
void loop() { 
  PicoGPIOState = digitalRead(gpioPin);  // heartbeat will toggle ON/OFF, read state
    if (PicoGPIOState == LOW) {          // power up pin high, heart beat pulls low
    I = 1;                               // reset counter if heart beat is running      
    }
//  
  if (FLAG == 1) {                       // one shot, reset on power cycle  
    I = I + 1;                           // counter increment
    if (I > 200) {                       // no heartbeat counter runs up, increase value to set delay to UF2      
      digitalWrite(bootSelPin, LOW);
      delay (500);
      digitalWrite(resetPin, LOW);
      delay (500);
      digitalWrite(resetPin, HIGH);
      delay (500);
      digitalWrite(bootSelPin, HIGH);
      FLAG = 0;                          // set FLAG to stop action, iniate UF2 mode once only
    }
  }
  delay(100);                            // delay     
}
