''demo for I2C OLEDs
''connect to I2C as per OPTIONs

''use these OPTIONs
''OPTION SYSTEM I2C GP0,GP1
''OPTION LCDPANEL SSD1306I2C, LANDSCAPE

CLS 0 '' black
Dim I,X,Y As INTEGER
Dim FLOAT vertices(2,7) = (-1,1,-1, 1,1,-1, 1,-1,-1, -1,-1,-1, -1,1,1, 1,1,1, 1,-1,1, -1,-1,1)
Dim INTEGER facecount(5)=(4,4,4,4,4,4)
Dim INTEGER faces(23)=(0,1,2,3, 1,5,6,2, 0,4,5,1, 5,4,7,6, 2,6,7,3, 0,3,7,4)
Dim INTEGER colours(6)=(RGB(blue), RGB(green), RGB(yellow), RGB(cyan), RGB(red), RGB(magenta),RGB(yellow))
Dim INTEGER edge(5)=(6,6,6,6,6,6)
Dim INTEGER fill(5)=(0,1,2,3,4,5)
Dim n=1, nv=8, nf=6, camera=1
Math SCALE vertices(), 35.0, vertices()
'Draw3D CREATE n, nv, nf, camera, vertices(), facecount(), faces(), colours(), edge(), fill()
Draw3D CREATE n, nv, nf, camera, vertices(), facecount(), faces(), colours(), edge()
Dim FLOAT yaw=Rad(1), pitch=Rad(2), roll=Rad(0.5)
Dim FLOAT q(4)
Dim INTEGER viewplane=500
Draw3D CAMERA n, viewplane
Do
  Font 3
  Text 16,20,"FONT 8"
  Pause 1000
  CLS 0
  Font 8:X=4:Y=6
  For I = 0 To 95
    Text (I Mod 16)*X,(I\16)*Y,Chr$(I+32)
  Next I
  Pause 1000
  CLS 0
  Font 3
  Text 16,20,"FONT 7"
  Pause 1000
  CLS 0
  Font 7:X=6:Y=8
  For I = 0 To 95
    Text (I Mod 16)*X,(I\16)*Y,Chr$(I+32)
  Next I
  Pause 1000
  CLS 0
  Font 3
  Text 16,20,"FONT 1"
  Pause 1000
  CLS 0
  Font 1:X=8:Y=12
  For I = 0 To 95
    Text (I Mod 16)*X,(I\16)*Y,Chr$(I+32)
  Next I
  Pause 1000
  CLS 0
  Font 3
  Text 8,20,"CIRCLES"
  Pause 1000
  CLS 0
  For I = 0 To 100
    Circle Rnd*128,Rnd*64,Rnd*48
    Pause 50
  Next I
  Pause 1000
  CLS 0
  Font 3
  Text 8,20,"SQUARES"
  Pause 1000
  CLS 0
  For I = 0 To 100
    X=Rnd*48
    Box Rnd*128,Rnd*64,X,X
    Pause 50
  Next I
  Pause 1000
  CLS 0
  Text 8,20,"3D CUBE"
  Pause 1000
  CLS 0
  FOR I = 0 to 200  
    DOCUBE
	PAUSE 50
  NEXT I
  CLS 0
Loop

SUB DOCUBE
  Math Q_EULER yaw, pitch, roll, q()
  Draw3D ROTATE q(),n
  Draw3D show n,0,0,1000
  Inc yaw,Rad(3)
  Inc pitch,Rad(2)
  Inc roll,Rad(0.5)
END SUB
