//this uses:
//TJpgDec - Tiny JPEG Decompressor R0.03 (C)ChaN, 2021
//see http://elm-chan.org/fsw/tjpgd/00index.html

#include "LCD.h"
#include "Arial_round_16x24.c"
#include <SPI.h>
#include <WiFi.h>
#include <HTTPClient.h>

HTTPClient http;
WiFiClient client;
IPAddress apIP,staIP,camIP; 
const uint16_t httpport = 80;
#define AP_STA_MAX 4

#define AP_NAME "TEST"
#define AP_PASS "88888888"

//tiny JPG decoder from elm-chan
#include "tjpgd.h"
String jpgData;
int sPtr=0;
JRESULT res;      /* Result code of TJpgDec API */
JDEC jdec;        /* Decompression object */
#define SZ_WORK 3500
char work[SZ_WORK];       /* Pointer to the work area */
size_t sz_work = SZ_WORK; /* Size of work area */
size_t in_func(JDEC*, uint8_t*, size_t);

//variables for remote cam parameters
int frameSize=5;
int quality=10;
int brightness=0;
int contrast=0;

button f1=  {340, 70, 35,35,"-",0,1};//x,y,w,h,text,pressed,visible
button f2=  {440, 70, 35,35,"+",0,1};//x,y,w,h,text,pressed,visible
button q1=  {340,140, 35,35,"-",0,1};//x,y,w,h,text,pressed,visible
button q2=  {440,140, 35,35,"+",0,1};//x,y,w,h,text,pressed,visible
button b1=  {340,210, 35,35,"-",0,1};//x,y,w,h,text,pressed,visible
button b2=  {440,210, 35,35,"+",0,1};//x,y,w,h,text,pressed,visible
button c1=  {340,280, 35,35,"-",0,1};//x,y,w,h,text,pressed,visible
button c2=  {440,280, 35,35,"+",0,1};//x,y,w,h,text,pressed,visible
button scan={  2,275,75,40,"Scan",0,1};//x,y,w,h,text,pressed,visible
button capt={ 82,275,75,40,"Capt",0,1};//x,y,w,h,text,pressed,visible
button expt={162,275,75,40,"Expt",0,1};//x,y,w,h,text,pressed,visible
button next={242,275,75,40,"Next",0,1};//x,y,w,h,text,pressed,visible
char num[10]="";

volatile char cmd=0;
int i;
int state=0;
String url;
int httpcode=0;  
unsigned int m;  
char flag=0;

//SD and file
#include <SD.h>
char fn[50]="";
File root,entry;
int sdStatus=0;
char fName[16]="0000000000.JPG";

void setup() {
  Serial.begin(115200);
  //while(!Serial && millis()<5000){}
  displaySetup(); //this inits LCD controller, touch and backlight PWM
  setBacklight(50);
  setrotation(1);
  clear(BLACK);
  showarray(0,0,"ESP32-CAM interface: scan  ",Arial_round_16x24,YELLOW,BLACK);
  showarray(410-32, 40,"Size",Arial_round_16x24,WHITE,BLACK);
  showarray(410-56,110,"Quality",Arial_round_16x24,WHITE,BLACK);
  showarray(410-56,180,"Bright.",Arial_round_16x24,WHITE,BLACK);
  showarray(410-64,250,"Contrast",Arial_round_16x24,WHITE,BLACK);
  drawbutton(&f1);
  drawbutton(&f2);
  drawbutton(&q1);
  drawbutton(&q2);
  drawbutton(&b1);
  drawbutton(&b2);
  drawbutton(&c1);
  drawbutton(&c2);
  drawbutton(&scan);
  drawbutton(&capt);
  drawbutton(&expt);
  drawbutton(&next);
  putNum(frameSize);
  showarray(380,75,num,Arial_round_16x24,WHITE,BLACK);
  putNum(quality);
  showarray(380,145,num,Arial_round_16x24,WHITE,BLACK);
  putNum(brightness);
  showarray(380,215,num,Arial_round_16x24,WHITE,BLACK);
  putNum(contrast);
  showarray(380,285,num,Arial_round_16x24,WHITE,BLACK);
  Serial.println("Starting");
  if(!WiFi.softAP(AP_NAME,AP_PASS,1,0,AP_STA_MAX)){  //channel 1, visible AP, AP_STA_MAX stations (should be no more than DHCPS_MAX_IP)
    Serial.println("Unable to set up AP, rebooting in 10 seconds...");
    showarray(0,0,"Unable to set up AP, rebooting",Arial_round_16x24,YELLOW,BLACK);
    delay(10000);
    rp2040.reboot();
  }
  apIP=WiFi.localIP();
  staIP=apIP;   //assume same subnet, so most octets are the same
  Serial.print("AP up at ");
  Serial.println(apIP);
  sdStatus=SD.begin(SDCS);
  if(sdStatus){
    root = SD.open("/");
  }
  SPIforLCD();     //reload LCD SPI settings for use after SD access
  if(sdStatus){
    Serial.println("SD Card found and inited.");
    Serial.printf("Card is %llu MB.\r\n",SD.size64()>>20);
  }else{
    Serial.println("No SD Card found.");
  }
  doHelp();
}

void loop() {
  int d=0;
  int i;
  if(Serial.available()){
    d=Serial.read();
  }else{
    d=cmd;
    cmd=0;
  }
  if(d=='?'){doHelp();}
  if(d=='s'){
    Serial.println("Scanning for cameras");
    showarray(0,0,"Scan in progress...          ",Arial_round_16x24,YELLOW,BLACK);
    client.setTimeout(500);
    for(i=DHCPS_BASE_IP;i<DHCPS_BASE_IP+AP_STA_MAX;i++){    //DHCPS_BASE_IP defined in dhcpserver.h for Pico W
      if(i!=apIP[3]){   //don't ping host
        staIP[3]=i; 
        if(client.connect(staIP,httpport)){
          client.stop();  
          Serial.print(staIP);
          Serial.println(" OK"); 
          camIP=staIP;
        }
        client.stop();  
      }
    } 
    Serial.print("Scan done. Active IP is ");
    Serial.println(camIP);
    if(camIP.isSet()){
      putNum(camIP[0]);
      num[3]='.';
      num[4]=0;
      showarray(0,0,num,Arial_round_16x24,YELLOW,BLACK);
      putNum(camIP[1]);
      num[3]='.';
      num[4]=0;
      showarray(74,0,num,Arial_round_16x24,YELLOW,BLACK);
      putNum(camIP[2]);
      num[3]='.';
      num[4]=0;
      showarray(138,0,num,Arial_round_16x24,YELLOW,BLACK);
      putNum(camIP[3]);
      showarray(202,0,num,Arial_round_16x24,YELLOW,BLACK);
      showarray(250,0," has camera.  ",Arial_round_16x24,YELLOW,BLACK);
    }else{
      showarray(0,0,"No IP found.                 ",Arial_round_16x24,YELLOW,BLACK);
    }
  }
  if(d=='g'){
    showarray(0,0,"Get in progress...           ",Arial_round_16x24,YELLOW,BLACK);
    url=String("http://")+camIP.toString()+String("/");  
    Serial.println(url);
    state=http.begin(url);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        //String payload = http.getString();
        //Serial.println(payload);
        Serial.printf("%d bytes received.\r\n",http.getSize());
      }else{
        Serial.println("GET FAILED");
      }
    }
  }
  if(d=='f'){
    doCapture();
    doDecode();
  }
  if(d=='c'){
    doCapture();
  }
  if(d=='i'){
    url=String("http://")+camIP.toString()+String("/status");  
    Serial.println(url);
    state=http.begin(url);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        String payload = http.getString();
        Serial.println(payload);
        Serial.printf("%d bytes received.\r\n",http.getSize());
      }else{
        Serial.println("GET FAILED");
      }
    }
  }

  if((d>='0')&&(d<='9')){
    url=String("http://")+camIP.toString()+String("/control?var=framesize&val=")+String((char)d);  
    Serial.println(url);
    state=http.begin(url);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        Serial.printf("%d bytes received.\r\n",http.getSize());
      }else{
        Serial.println("GET FAILED");
      }
    }
  }
  if(d=='d'){ //decode
    doDecode();
  }
  if(d=='e'){ //save to card
    if(sdStatus){
      if(jpgData.length()>0){
        Serial.println("Saving to card.");
        showarray(0,0,"Saving to card.              ",Arial_round_16x24,YELLOW,BLACK);
        setFileName(millis());
        fName[1]='/';
        if(!SD.exists(&fName[1])){
          entry = SD.open(&fName[1],FILE_WRITE);
          if(entry){
            i=entry.write(jpgData.c_str(),jpgData.length());
            Serial.printf("%d bytes written to %s.\r\n",i,&fName[1]);
            showarray(0,0,"Saved to card.               ",Arial_round_16x24,YELLOW,BLACK);
          }else{
            Serial.printf("Could not create file %s\r\n",&fName[1]);
            showarray(0,0,"Could not create file        ",Arial_round_16x24,YELLOW,BLACK);
          }
          entry.close();
          SPIforLCD();     //reload LCD SPI settings for use after SD access
        }else{
          Serial.printf("File with same name already exists.");
          showarray(0,0,"Could not create file        ",Arial_round_16x24,YELLOW,BLACK);
        }
      }else{
        Serial.println("No data to save, perform a capture.");
        showarray(0,0,"No data to save.             ",Arial_round_16x24,YELLOW,BLACK);
      }
    }else{
      Serial.println("Card not ready.");
      showarray(0,0,"Card not ready               ",Arial_round_16x24,YELLOW,BLACK);
    }
    Serial.println();
  }
  if(d=='n'){ //show next file
    Serial.println("Scanning for next file.");
    showarray(0,0,"Scanning for next file       ",Arial_round_16x24,YELLOW,BLACK);
    entry=root.openNextFile();
    while(entry.isDirectory()){
      entry=root.openNextFile();
    }
    if(entry){
      Serial.printf("Found %s.\r\n",entry.name());
      showarray(0,0,"                             ",Arial_round_16x24,YELLOW,BLACK);
      showarray(0,0,entry.name(),Arial_round_16x24,YELLOW,BLACK);
      delay(700);
      if(entry.isDirectory()){
        Serial.println("Directory; can't display.");
        showarray(0,0,"Can't display directory    ",Arial_round_16x24,YELLOW,BLACK);
      }else if(entry.size()>32768){
        Serial.println("File too large.");
        showarray(0,0,"File too large.            ",Arial_round_16x24,YELLOW,BLACK);
      }else{
        jpgData=entry.readString();
        entry.close();
        SPIforLCD();     //reload LCD SPI settings for use after SD access
        doDecode();
      }
    }else{
      root.rewindDirectory();
      Serial.println("Nothing found, rewinding.");
      showarray(0,0,"Nothing found, rewinding     ",Arial_round_16x24,YELLOW,BLACK);
    }
    entry.close();
    SPIforLCD();     //reload LCD SPI settings for use after SD access
  }
  flag=0;
  if(checkDraw(&f1)){
    frameSize=frameSize-1;
    if(frameSize<0){frameSize=0;}
    flag=1;
  }
  if(checkDraw(&f2)){
    frameSize=frameSize+1;
    if(frameSize>6){frameSize=6;}
    flag=1;
  }
  if(flag){
    putNum(frameSize);
    showarray(380,75,num,Arial_round_16x24,WHITE,BLACK);
    setControl("framesize",String(frameSize).c_str());
  }

  flag=0;
  if(checkDraw(&q1)){
    quality=quality-1;
    if(quality<0){quality=0;}
    flag=1;
  }
  if(checkDraw(&q2)){
    quality=quality+1;
    if(quality>63){quality=63;}
    flag=1;
  }
  if(flag){
    putNum(quality);
    showarray(380,145,num,Arial_round_16x24,WHITE,BLACK);
    setControl("quality",String(quality).c_str());
  }

  flag=0;
  if(checkDraw(&b1)){
    brightness=brightness-1;
    if(brightness<-2){brightness=-2;}
    flag=1;
  }
  if(checkDraw(&b2)){
    brightness=brightness+1;
    if(brightness>2){brightness=2;}
    flag=1;
  }
  if(flag){
    putNum(brightness);
    showarray(380,215,num,Arial_round_16x24,WHITE,BLACK);
    setControl("brightness",String(brightness).c_str());
  }

  flag=0;
  if(checkDraw(&c1)){
    contrast=contrast-1;
    if(contrast<-2){contrast=-2;}
    flag=1;
  }
  if(checkDraw(&c2)){
    contrast=contrast+1;
    if(contrast>2){contrast=2;}
    flag=1;
  }
  if(flag){
    putNum(contrast);
    showarray(380,285,num,Arial_round_16x24,WHITE,BLACK);
    setControl("contrast",String(contrast).c_str());
  }

  if(checkDraw(&scan)){
    cmd='s';
  }
  if(checkDraw(&capt)){
    showarray(0,0,"Capture in progress...       ",Arial_round_16x24,YELLOW,BLACK);
    cmd='f';
  }
  if(checkDraw(&expt)){
    cmd='e';
  }
  if(checkDraw(&next)){
    cmd='n';
  }
}


//interface functions for TJPGD
//no need to change this one
size_t in_func (    /* Returns number of bytes read (zero on error) */
    JDEC* jd,       /* Decompression object */
    uint8_t* buff,  /* Pointer to the read buffer (null to remove data) */
    size_t nbyte    /* Number of bytes to read/remove */
){
  size_t n=nbyte; //bytes to grab
  int i;
  if((jpgData.length()-sPtr)<n){n=jpgData.length()-sPtr;}
  if(buff){
    for(i=0;i<n;i++){
      buff[i]=jpgData.c_str()[sPtr+i];
    }
  }
  sPtr=sPtr+n;
  return n;
}

//this is called by the JPG decoder to handle the output bitmap data in small chunks
//it draws to the screen at (x,y+30), clipping above (320,240)
//change this function to change the way the output data is handled
int out_func (      /* Returns 1 to continue, 0 to abort */
    JDEC* jd,       /* Decompression object */
    void* bitmap,   /* Bitmap data to be output */
    JRECT* rect     /* Rectangular region of output image */
){
  int i,n;
  uint8_t* d=(uint8_t*)bitmap;
  //Serial.printf("%d,%d,%d,%d\r\n",rect->left,rect->top,rect->right,rect->bottom);
  if(rect->right>320){return 1;}  //crop
  if(rect->bottom>240){return 1;}  //crop
  setarea(rect->left,rect->top+30,rect->right,rect->bottom+30);
  n=(rect->right-rect->left+1)*(rect->bottom-rect->top+1)*3;  //3 bytes per pixel
  digitalWrite(LCDCS,LOW);
  for(i=0;i<n;i++){
    data8(d[i]);
  }
  digitalWrite(LCDCS,HIGH);
  return 1;    /* Continue to decompress */
}

void putNum(int n){
  if(n<-99){n=-99;}
  if(n>999){n=999;}
  if(n<0){
    num[0]='-';
    n=-n;
  }else{
    num[0]=(n/100)+'0';
    n=n%100;    
  }
  num[1]=n/10+'0';
  n=n%10;
  num[2]=n+'0';
  if(num[0]=='0'){
    num[0]=' ';
    if(num[1]=='0'){
      num[1]=' ';
    }
  }
  if((num[0]=='-')&&(num[1]=='0')){num[1]=' ';}
  num[3]=0; //null term
}

char checkDraw(button* b){    //check, redraw and return result
  checkpress(b);
  if(b->lastchange){drawbutton(b);}          //redraw on change
  if(b->lastchange==BUTTON_DOWN){return 1;}  //down touch
  return 0;  
}

void doDecode(){  
  Serial.println("Clearing");
  showarray(0,0,"Clearing...                  ",Arial_round_16x24,YELLOW,BLACK);
  box(0,30,320,270,BLACK);
  Serial.println("Decoding");
  showarray(0,0,"Decoding...                  ",Arial_round_16x24,YELLOW,BLACK);
  sPtr=0;
  res = jd_prepare(&jdec, in_func, work, sz_work, NULL);
  showResult(res);
  if(res!=JDR_OK){
    showarray(0,0,"Decoding error.              ",Arial_round_16x24,YELLOW,BLACK);
    return ;
  }
  Serial.printf("Image size is %u x %u.\r\n%u bytes of work area is used.\r\n", jdec.width, jdec.height, sz_work - jdec.sz_pool);
  res = jd_decomp(&jdec, out_func, 0);   /* Start to decompress with 1/1 scaling */
  showResult(res);
  if(res==JDR_OK){
    showarray(0,0,"Decoding done.               ",Arial_round_16x24,YELLOW,BLACK);
  }else{
    showarray(0,0,"Decoding error.              ",Arial_round_16x24,YELLOW,BLACK);
  }
}

void doCapture(){
  showarray(0,0,"Get in progress...           ",Arial_round_16x24,YELLOW,BLACK);
  url=String("http://")+camIP.toString()+String("/capture");  
  Serial.println(url);
  state=http.begin(url);
  if(state){
    httpcode=http.GET();
    Serial.printf("HTTP code %d received.\r\n",httpcode);
    if(httpcode==HTTP_CODE_OK){
      Serial.printf("%d bytes received.\r\n",http.getSize());
      jpgData=http.getString();
      showarray(0,0,"Get completed.               ",Arial_round_16x24,YELLOW,BLACK);
    }else{
      Serial.println("GET FAILED");
      showarray(0,0,"Get failed.                  ",Arial_round_16x24,YELLOW,BLACK);
      jpgData=String("");
    }
  }
}

void setControl(const char* p, const char* v){  //parameter, value
    url=String("http://")+camIP.toString()+String("/control?var=")+String(p)+String("&")+String("val=")+String(v);  
    Serial.println(url);
    showarray(0,0,"=============>               ",Arial_round_16x24,YELLOW,BLACK);
    showarray(0,0,p,Arial_round_16x24,YELLOW,BLACK);
    showarray(250,0,v,Arial_round_16x24,YELLOW,BLACK);
    state=http.begin(url);
    if(state){
      httpcode=http.GET();
      Serial.printf("HTTP code %d received.\r\n",httpcode);
      if(httpcode==HTTP_CODE_OK){
        //String payload = http.getString();
        //Serial.println(payload);
        Serial.printf("%d bytes received.\r\n",http.getSize());
        showarray(432,0,"OK",Arial_round_16x24,YELLOW,BLACK);
      }else{
        Serial.println("GET FAILED");
        showarray(0,0,"Get failed.                  ",Arial_round_16x24,YELLOW,BLACK);
      }
    }
}

void doHelp(){
  Serial.println("? for this help");
  Serial.println("s to scan for cameras on WiFi");
  Serial.println("c for capture");
  Serial.println("d for decode and display");
  Serial.println("f for capture, decode and display");
  Serial.println("i for status/info");
  Serial.println("e to export current image to microSD card");
  Serial.println("n to scan for next file on card and display if possible");
  Serial.println("0-9 for framesize");
  Serial.println();
}

void showResult(JRESULT r){
  switch(r){
    case JDR_OK: Serial.println("OK"); break;
    case JDR_INTR: Serial.println("Process interrupted"); break;
    case JDR_INP: Serial.println("Device/stream error"); break;
    case JDR_MEM1: Serial.println("Insufficient memory pool"); break;
    case JDR_MEM2: Serial.println("Insufficient stream buffer"); break;
    case JDR_PAR: Serial.println("JPG parameter error"); break;
    case JDR_FMT1: Serial.println("JPG data format error"); break;
    case JDR_FMT2: Serial.println("JPG format not supported"); break;
    case JDR_FMT3: Serial.println("JPG standard not supported"); break;
    default:  Serial.println("Unknown result code"); break;
  }
}

void setFileName(unsigned long n){
  int i;
  unsigned long p=1000000000UL;
  unsigned long q;
  for(i=0;i<10;i++){
    q=n/p;
    fName[i]=q+'0';
    n=n-p*q;
    p=p/10;
  }
  fName[10]='.';
  fName[11]='J';
  fName[12]='P';
  fName[13]='G';
  fName[14]=0;
}