#include <TinyGPS.h>
#include <Adafruit_GFX.h>
#if defined(_GFXFONT_H_)           //are we using the new library?
#include <Fonts/FreeSans9pt7b.h>
#define ADJ_BASELINE 11            //new fonts setCursor to bottom of letter
#else
#define ADJ_BASELINE 0             //legacy setCursor to top of letter
#endif
#include <MCUFRIEND_kbv.h>

MCUFRIEND_kbv tft;

#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF
#define GREY    0x7BEF
#define mycolor1 0x6BFF
#define mycolor2 0xF71E

#define AVG_NUM 10    // number of iterations of the adc routine to average the adc readings
#include <stdio.h>


int clockCenterX=140;
int clockCenterY=155;
int clockradius=136;
//const float DegreesToRadians = 0.0174533;

int byte1,byte2;
int year,a,t,d,m,y,h,m1,s,sh,h1;
int l,k,p,l1,k1,p1;
byte month, day, hour, minute, second, hundredths;
float flat, flon,falt,fc,fk,fmph,fmps,fkmph,h2,mx1,my1,hx1,hy1,sx1,sy1;
unsigned long age;
unsigned long fix_age;
long lat1,lon1;
String dow;

uint16_t ID;
TinyGPS gps;
void getgps(TinyGPS &gps);

const unsigned char PROGMEM star[] =
{ B00000000, B11000000,
  B00000001, B11000000,
  B00000001, B11000000,
  B00000011, B11100000,
  B11110011, B11100000,
  B11111110, B11111000,
  B01111110, B11111111,
  B00110011, B10011111,
  B00011111, B11111100,
  B00001101, B01110000,
  B00011011, B10100000,
  B00111111, B11100000,
  B00111111, B11110000,
  B01111100, B11110000,
  B01110000, B01110000,
  B00000000, B00110000 };

void setup(void)
{
    Serial.begin(9600);
    tft.reset();
    ID = tft.readID();
 //   Serial.print("TFT ID = 0x");
 //   Serial.println(ID, HEX);
    //    if (ID == 0x00D3) ID = 0x9481; // write-only shield
    if (ID == 0x00D3) ID = 0x9486; // write-only shield  //9486
    tft.begin(ID);
    tft.setRotation(1);
    tft.fillScreen(BLACK);
#if defined(_GFXFONT_H_)
    tft.setFont(&FreeSans9pt7b);
#endif
tft.fillRect(0,0,480,320, BLUE); 
tft.fillRect(10,5,460,310,BLACK);
tft.setTextColor(YELLOW,BLACK);
tft.setTextSize(3);  

for(int i=0;i<=11;i++){
  int theta=i*30;
  
 float sx=clockCenterX+(clockradius)*sin(dtor(theta));
 float sy=clockCenterY-(clockradius)*cos(dtor(theta));
 
  tft.setCursor(sx,sy);
  if(i==0) tft.print("12");
  else tft.print(i);
}
clockCenterX=clockCenterX+10; //Center isslightly shifted right
//clockCenterY=clockCenterY;
//thickarc(375,170,55,15,15,BLUE);

}

void loop(void){
tft.setTextColor(YELLOW);
//
 
int celsius= read_adc(A5)*500L/1024;
//    celsius= (celsius-0.5);

   byte a;
   if ( Serial.available() > 0 ) { // if there is data coming into the serial line
          a = Serial.read();          // get the byte of data
      if(gps.encode(a)) {          // if there is valid GPS data...
        getgps(gps);              // then grab the data and display it on the LCD
 Serial.println(day);
 Serial.println(month);



 //Second
 thickline(clockCenterX,clockCenterY,sx1,sy1,7,BLACK);
 float sx=clockCenterX+(clockradius*0.75)*sin(dtor(s*6) );
 float sy=clockCenterY-(clockradius*0.75)*cos(dtor(s*6) );
 thickline(clockCenterX,clockCenterY,sx,sy,7,RED);

//Hour hand
 thickline(clockCenterX,clockCenterY,hx1,hy1,11,BLACK);
 if(m1>14 && m1<=29) h2=h1+0.25;
 else if(m1>29 && m1<45) h2=h1+0.5;
 else if(m1>45 && m1<=59) h2=h1+0.75;
 else h2=h1;
 float hx=clockCenterX+(clockradius*0.5)*sin(dtor(h2*30));
 float hy=clockCenterY-(clockradius*0.5)*cos(dtor(h2*30));
 thickline(clockCenterX,clockCenterY,hx,hy,11,WHITE);

//Minute hand
 thickline(clockCenterX,clockCenterY,mx1,my1,7,BLACK);
 float mx=clockCenterX+(clockradius*0.7)*sin(dtor(m1*6));
 float my=clockCenterY-(clockradius*0.7)*cos(dtor(m1*6));
 thickline(clockCenterX,clockCenterY,mx,my,7,GREEN);

tft.setTextSize(3);
tft.setTextColor(MAGENTA, BLACK);
char buf[20];
sprintf(buf, "%02d/%02d/%02d", day,month,y);
tft.setCursor(320,10);
tft.print(buf);
char buf1[20];

tft.setTextColor(WHITE, BLACK);
sprintf(buf1, "%02d:%02d:%02d", h, m1, s);
tft.setCursor(320,40);
tft.print(buf1);

if(s>=0 && s<=1.7) {
uint16_t rcolor[]={0x001F,0xF800,0x07E0,0x07FF,0xF81F,0xFFE0,0xFFFF,0x7BEF };
thickcircle(375,170,55,1,rcolor[sizeof(rcolor)]);  //WHITE
spokey_circle(375,170,55,59,1,rcolor[random(7)]); //MAGENTA
tft.drawBitmap(369,160,star,16,16,rcolor[random(sizeof(rcolor))]);

     }

removespoke(375,170,55,s,1);

tft.setCursor(320,70);
tft.setTextColor(GREEN, BLACK);
tft.print("Temp:");
tft.print(celsius);    
tft.print("C");
Serial.println(celsius);
//Buffer numbers         
mx1=mx;  //minute
my1=my; //minute

hx1=hx; //hour
hy1=hy;//hour

sx1=sx;//second
sy1=sy;//second

      }
           }


 }


   void getgps(TinyGPS &gps)   {
   gps.f_get_position(&flat, &flon, &age);
   gps.get_position(&lat1, &lon1, &fix_age);
   falt = gps.f_altitude(); // +/- altitude in meters
   fc = gps.f_course(); // course in degrees
   fk = gps.f_speed_knots(); // speed in knots
   fmph = gps.f_speed_mph(); // speed in miles/hr
   fmps = gps.f_speed_mps(); // speed in m/sec
   fkmph = gps.f_speed_kmph(); // speed in km/hr

       	if (fix_age == TinyGPS::GPS_INVALID_AGE)
        Serial.println("No fix ever detected!");
	else if (fix_age > 2000)
	Serial.println("Data is getting STALE!");
	else
        Serial.println("Latitude and longitude valid!");
        Serial.println("Lat , Lon & Altitude:");
        Serial.println(falt);
        Serial.println(flat);
        Serial.println(flon);
   gps.crack_datetime(&year,&month,&day,&hour,&minute,&second,&hundredths);
   hour=hour+5; 
   minute=minute+30;   // correct for your time zone
   if(minute>59) {
     minute=minute-60;
     hour=hour+1;
     }
     if (hour>23) { 
     hour=hour-24;
     day=day+1;
     if(month==1 && day>31) month = month+1;
     if(month==2 && day>28) month = month+1;
     if(month==3 && day>31) month = month+1;
     if(month==4 && day>30) month = month+1;
     if(month==5 && day>31) month = month+1;
     if(month==6 && day>30) month = month+1;
     if(month==7 && day>31) month = month+1;
     if(month==8 && day>31) month = month+1;
     if(month==9 && day>30) month = month+1;
     if(month==10 && day>31) month = month+1;
     if(month==11 && day>30) month = month+1;
     if(month==12 && day>31) { month = month+1-12; year=year+1; }
     }

    d=day;
    m=month;
    y=year-2000;
    h=hour;
    m1=minute;
    s=second;

    sh=hundredths;
    if(h>=12) h1=h-12;
    else h1=h;
   }
    
void thickline(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int pixel, uint16_t color){
 
for(int i=0;i<=pixel/2;i++){
double l1=atan((y1-y0)/(x1-x0));
tft.drawLine( x0-i/2*sin(l1),y0+i/2*cos(l1),x1-i/2*sin(l1),y1+i/2*cos(l1), color);
tft.drawLine( x0+i/2*sin(l1),y0-i/2*cos(l1),x1+i/2*sin(l1),y1-i/2*cos(l1),color);

  }
}

//convert degrees to radians
double dtor(float fdegrees){
return(fdegrees * PI / 180);
}

//Convert radians to degrees
double rtod(int fradians){
return(fradians * 180.0 / PI);
}

void rotate(int16_t x0, int16_t y0, int16_t x1, int16_t y1, int bita, uint16_t color){
double l1=atan((y1-y0)/(x1-x0));
float  ln=sqrt((y1-y0)*(y1-y0)+(x1-x0)*(x1-x0));
for(int i=0;i<=bita;i++){
  tft.drawLine(x0,y0,ln*cos(l1-i),ln*sin(l1-i),color);
}

}

int read_adc(int adc_parameter){
  int sum = 0;
  int sample ;
  for (int i=0; i<AVG_NUM; i++)   { 
    sample = analogRead(adc_parameter);  
    sum += sample;                  
    delayMicroseconds(50);            
  }
  return(sum / AVG_NUM);
}

void thickcircle(int16_t x0, int16_t y0, int16_t r, int pixel, uint16_t color) {
  for(int i=r;i<=r+pixel;i++){
   tft.drawCircle(x0, y0, i, color);
  }
}

void spokey_circle(int16_t x0, int16_t y0, int16_t r, int16_t n,int pixel, uint16_t color) {
  for(int i=0;i<=n;i++){
 float sx=x0+r*sin(dtor(s*6*i) );
 float sy=y0-r*cos(dtor(s*6*i) );
 thickline(x0,y0,sx,sy,pixel,color);
  }
}

void removespoke(int16_t x0, int16_t y0, int16_t r, int16_t n,int pixel) {
 float sx=x0+r*sin(dtor(n*6) );
 float sy=y0-r*cos(dtor(n*6) );
 thickline(x0,y0,sx,sy,pixel,BLACK);
 }


void thickarc(int16_t x0, int16_t y0, int16_t r, int pixel,int n, uint16_t color) {
for(int i=0;i<=n*6;i++){ 
  
float ax1=x0+r*cos(dtor(n*6-i));
float ay1=y0-r*sin(dtor(n*6-i)); 

float ax=x0+r*cos(dtor(n*6-(i-1)));
float ay=y0-r*sin(dtor(n*6-(i-1)));


thickline(ax1,ay1,ax,ay,pixel,color);
}
}


