// Date and time functions using a DS1307 RTC connected via I2C and Wire lib
// Connections: (5 pin header) SCL to A5,   SDA to A4,  VCC to 5V,   GND to GND.

int check1=1; //This is the weekly toggle to swap LEDs each week.

#include "RTClib.h"

RTC_DS1307 rtc;



char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

void setup () 

{
  pinMode(8,OUTPUT);  // Set Pin 8 as an Output. Used to switch GREEN LED

  pinMode(9,OUTPUT);  // Set Pin 9 as an Output. Used to switch YELLOW LED

  pinMode(10,OUTPUT);  // Set Pin 10 as an Output. Used to switch RED LED

  digitalWrite(8,HIGH); // Turn on GREEN LED // Set these leds for the week when you program and switch the circuit on. Don't do it on a Sunday. Any other day is fine
  
  digitalWrite(9,HIGH);  // Turn on YELLOW LED

  digitalWrite(10,LOW);  // Turn off RED LED

 
  Serial.begin(57600);

#ifndef ESP8266
  while (!Serial); // wait for serial port to connect. Needed for native USB
#endif

  if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    Serial.flush();
    while (1) delay(10);
  }

  if (! rtc.isrunning()) {
    Serial.println("RTC is NOT running, let's set the time!");
    // When time needs to be set on a new device, or after a power loss, the
    // following line sets the RTC to the date & time this sketch was compiled
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
    // This line sets the RTC with an explicit date & time, for example to set
    // January 21, 2014 at 3am you would call:
    // rtc.adjust(DateTime(2014, 1, 21, 3, 0, 0));
  }

  // When time needs to be re-set on a previously configured device, the
  // following line sets the RTC to the date & time this sketch was compiled
  // rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  // This line sets the RTC with an explicit date & time, for example to set
  // January 21, 2014 at 3am you would call:
  // rtc.adjust(DateTime(2014, 1, 21, 3, 0, 0));
}

void loop () {
    DateTime now = rtc.now();

    //Serial.print(now.year(), DEC);
    //Serial.print('/');
   // Serial.print(now.month(), DEC);
    //Serial.print('/');
   // Serial.print(now.day(), DEC);
    //Serial.print(" (");
    //Serial.print(daysOfTheWeek[now.dayOfTheWeek()]);
   // Serial.print(") ");
    //Serial.print(now.hour(), DEC);
    //Serial.print(':');
    //Serial.print(now.minute(), DEC);
   //Serial.print(':');
    //Serial.print(now.second(), DEC);
    //Serial.println();

    //Serial.print(" since midnight 1/1/1970 = ");
    //Serial.print(now.unixtime());
    //Serial.print("s = ");
    //Serial.print(now.unixtime() / 86400L);
    //Serial.println("d");

    

    

    

    //Serial.println();
    
    
    if((now.dayOfTheWeek()==0)&&(now.hour()==1)&&(now.minute()==30)) // Set your change over time here. In this case change over of Leds occurs every Sunday at 1.30 am  *** Note day of week Sunday =0, Monday =1 Tuesday =2, Wednesday =3, Thursday =4, Friday =5, Saturday = 6

    {
      
      check1++;             //increment check1 counter. This advances by 1 each week to keep track of weeks elapsed.
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);
      delay(10000);  //delay 1 Minute 30 Seconds to allow Real time clock to move on from line 93 otherwise Leds will toggle continously at high speed.
    }

  

    if (check1 % 2 == 0) // Modulo function. Divides weeks elapsed by 2 which means LEDs will swap on every second week
    {
       
     digitalWrite(8,HIGH); // Switch on Green LED  // This is bin pattern for second week
     digitalWrite(9,LOW);  // Switch off Yellow LED
     digitalWrite(10,HIGH);  // Switch on Red LED
    }

    else 
    
    {

    digitalWrite(8,HIGH); // Switch on Green LED    //This is bin pattern reverting back to first week setting
    digitalWrite(9,HIGH);  // Switch on Yellow LED
    digitalWrite(10,LOW);  // Switch off Red LED
  }
    
      delay(1000);
      
  }
