from time import sleep
from datetime import datetime
from dateutil import tz
#import RPi.GPIO as GPIO
import serial
import ephem

import pygame
from   pygame.locals import *
from   pygame.time import *

import board
import busio
import adafruit_ads1x15.ads1015 as ADS
from adafruit_ads1x15.analog_in import AnalogIn

ser  = serial.Serial ('/dev/ttyS0')
i2c = busio.I2C(board.SCL, board.SDA)
ads = ADS.ADS1015(i2c)

ads.mode = ADS.Mode.SINGLE       #Wait for conversion command

# initializing pygame
pygame.init()

# create the display surface
screen = pygame.display.set_mode((480, 320))
#screen = pygame.display.set_mode((480, 320), pygame.FULLSCREEN)

# change the window screen title
pygame.display.set_caption('Cara le Van:')

# Create a font file by passing font file with font size
font1 = pygame.font.SysFont('freesanbold.ttf', 250)
font2 = pygame.font.SysFont('chalkduster.ttf', 30)
font3 = pygame.font.SysFont('freesanbold.ttf', 80)

colors = {
    "grey_light"    :   pygame.Color(200, 200, 200),
    "grey_dark"     :   pygame.Color(100, 100, 100),
    "green"         :   pygame.Color(50, 255, 63),
    "red"           :   pygame.Color(220, 30, 30),
    "blue"          :   pygame.Color(0, 255, 255),
    "black"         :   pygame.Color(0,0,0),
    "yellow"        :   pygame.Color(240, 240, 20),
    "orange"        :   pygame.Color(255, 140, 0),
    "white"         :   pygame.Color(255, 255, 255)
}

AEST = tz.gettz('Tasmania/Hobart')
utc_zone = tz.tzutc()
to_zone = tz.tzlocal()

screen_centre = int(screen.get_width()/2)

deg_symbol = '\u00b0'
GPGGA_info = '$GPGGA,'
GPS_buffer = ''
NMEA_buff  = []
sr         = ''
ss         = ''
str_time   = ''
str_date   = ''
altitude   = 0.0
longi      = 0.0
lat        = 0.0

def convert_to_degrees(raw_value):
    decimal_value = raw_value/100.00
    degrees = int(decimal_value)
    mm_mmmm = (decimal_value - int(decimal_value))/0.6
    position = degrees + mm_mmmm
    position = '%.4f' %(position)
    return position

def get_voltage():
    volts = 0.0
    
    for x in range(0, 5):   #Take 5 readings
        chan = AnalogIn(ads, ADS.P0, ADS.P1)
        volts = volts + chan.voltage
        sleep(0.1)
    
    voltage = volts / 5                 #take the average
    return round((voltage * 2.977), 2)  #adjust for 12 volt range 3k3 + 10k Divider

def get_current():
    amps = 0.0
    
    for x in range(0, 5):   #Take 5 readings
        chan = AnalogIn(ads, ADS.P2, ADS.P3)
        amps = amps + chan.voltage
        sleep(0.1)
    
    return round((amps / 5), 2)        #Current sensor provides 0 - 4 volts (0 - 50 amps)

def waiting_gps():
    wait_gps = "Waiting on GPS"
    gps_render  = font3.render(wait_gps, True, colors["red"] )
    gps_msg_Rect = gps_render.get_rect()
    gps_msg_Rect.center = (screen_centre, 90)
    screen.blit(gps_render, gps_msg_Rect)
    pygame.display.update()

Running = True

while Running:

    # add background color using RGB values
    screen.fill((0, 0, 0))

    try:
        received_data = (str)(ser.readline())            #read NMEA string from gps
        while (received_data.find(GPGGA_info) == -1):     #check for NMEA GPGGA string
            print (received_data)
            sleep(0.2)
            received_data = (str)(ser.readline())            #read NMEA string from gps

        GPS_buffer     = received_data.split('$GPGGA,',1)[1]  #store data coming after '$GPGGA,' string
        NMEA_buff      = (GPS_buffer.split(','))

        if(NMEA_buff[5] == '0'):            #Fix indicator.  0 = data not valid, 1,2, 6 = ok
            print ("Waiting for fix\r\n")
            waiting_gps()
            sleep(0.5)
            continue

        nmea_latitude  = NMEA_buff[1]       #extract latitude
        nmea_n_s       = NMEA_buff[2]       #North / South indicator
        nmea_longitude = NMEA_buff[3]       #extract longitude
        nmea_e_w       = NMEA_buff[4]       #East / West indicator
        altitude       = float(NMEA_buff[8])       #Altitude value

        lat = float(nmea_latitude)
        if(nmea_n_s == 'S'):
            lat = -lat                      #negative latitude is South of the equator

        lat = convert_to_degrees(lat)

        longi = float(nmea_longitude)
        if(nmea_e_w == 'W'):
            longi = -longi                  #negative longitude is West

        longi = convert_to_degrees(longi)
        
        print ('NMEA Latitude:', lat,'NMEA Longitude:', longi,'\n')
    except:
        print ("Exception\r\n")
        continue   #start again from while Running

    location = ephem.Observer()
    location.lat = lat
    location.lon = longi
    location.elevation = altitude

    loc_dt = datetime.strptime(str(location.date), '%Y/%m/%d %H:%M:%S').replace(tzinfo=utc_zone)
    loc_dt = loc_dt.astimezone(to_zone)

    str_time = datetime.strftime(loc_dt, '%I:%M')
    str_date = datetime.strftime(loc_dt, '%A %d/%m/%Y')

    sun = ephem.Sun()
    utc = location.next_rising(sun).datetime().replace(tzinfo=utc_zone)
    sunrise = utc.astimezone(to_zone)
    sr = sunrise.strftime('%I:%M')

    utc = location.next_setting(sun).datetime().replace(tzinfo=utc_zone)
    sunset = utc.astimezone(to_zone)
    ss = sunset.strftime('%I:%M')

    print ("Getting Current and Voltage\r\n")

    volts = get_voltage()            #11.7  #dummy values till ADC fitted
    amps  = get_current()

    pt    = 'Power Status              V              A'
    ptv   = '{}'.format(volts)
    pta   = '{}'.format(amps)
    srss  = 'Sunrise {}      Sunset {}'.format(sr, ss)
    alt   = 'Altitude {} Metres'.format(altitude)

    StrTime = font1.render(str_time, True, colors["green"] )
    StrDate = font2.render(str_date, True, colors["green"] )
    StrSun  = font2.render(srss, True, colors["yellow"] )
    PwrText = font2.render(pt,   True, colors["blue"] )
    if (volts >= 11.8):
        VolText = font2.render(ptv,  True, colors["green"])
    else:
        VolText = font2.render(ptv,  True, colors["red"])

    AmpText = font2.render(pta,  True, colors["green"] )
    AltText = font2.render(alt,  True, colors["orange"] )

    # create a rectangular object for the
    # text surface object
    timeRect = StrTime.get_rect()
    dateRect = StrDate.get_rect()
    sunRect  = StrSun.get_rect()
    PtxtRect = PwrText.get_rect()
    PvolRect = VolText.get_rect()
    PampRect = AmpText.get_rect()
    PaltRect = AltText.get_rect()

    timeRect.center = (screen_centre, 90)
    dateRect.center = (screen_centre, 180)
    sunRect.center  = (screen_centre, 220)
    PaltRect.center = (screen_centre, 260)
    PtxtRect.center = (screen_centre, 305)
    PvolRect.center = (260, 305)
    PampRect.center = (355, 305)

    # copying the text surface objects
    # to the display surface objects
    # at the center coordinate.
    screen.blit(StrTime, timeRect)
    screen.blit(StrDate, dateRect)
    screen.blit(StrSun,  sunRect)
    screen.blit(PwrText, PtxtRect)
    screen.blit(VolText, PvolRect)
    screen.blit(AmpText, PampRect)
    screen.blit(AltText, PaltRect)

    # update the display
    pygame.display.update()

    # Look at every event in the queue
    for event in pygame.event.get():
        # Did the user click the window close button? If so, stop the loop.
        if event.type == QUIT or event.type == pygame.MOUSEBUTTONDOWN:
#        if event.type == pygame.MOUSEBUTTONDOWN:
            Running = False
    
    #Pause the system for 200 milliseconds
    sleep(0.2)

pygame.quit()

