'Bascom Avr Code
'Bascom-Avr IDE [2.0.7.5]
'Timer, Counter and Frequency Meter
'Author:Mahmood Alimohammadi

$regfile = "m8def.dat"
$crystal = 8000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portd.0 , Db5 = Portd.1 , Db6 = Portd.2 , Db7 = Portd.3 , Rs = Portd.6 , E = Portd.7

Config Adc = Single , Prescaler = Auto
Config Timer0 = Timer , Prescale = 256                      '256*256*122=7,995,392/8000000=0.999424
Config Timer1 = Counter , Edge = Falling , Capture Edge = Falling

Enable Timer0
Enable Timer1
Enable Interrupts
Enable Icp1

On Ovf0 Timer_ovf0
On Ovf1 Counter_ovf1
On Icp1 Icp_isr

Ddrc.0 = 1
Ddrc.1 = 1

Ddrb = 11000000
Ddrd.5 = 0

Portb.0 = 1 : Portb.1 = 1 : Portb.2 = 1 : Portb.3 = 1 : Portb.4 = 1 : Portb.5 = 1 : Portd.5 = 1       'activate pullup resistor

Dim Setting As Word , Up As Long , Down As Long , Time1 As Word

Dim A As Word , B As Word , C As Word , D As Long , E As Byte , F As Long

Time1_key Alias Pinb.1
Time2_key Alias Pinb.2
Count1_key Alias Pinb.3
Count2_key Alias Pinb.4
Frequency_key Alias Pinb.5

Speaker Alias Portc.0
Alarm_led Alias Portc.1

Stop Timer0
Stop Timer1

Cls
Cursor Off
Home
Lcd "Timer, Counter & "
Lowerline
Lcd "Frequency Meter"
Wait 2

Start Timer0
Start Timer1

'Setting and device selection program
Do
Waitms 50
A = Getadc(5)
B = Getadc(4)
B = B * 10
C = A + B
Setting = C
Down = C

Waitms 100
Cls
Home
Lcd "Set Alarm=" ; Setting
Lowerline
Lcd "Select 1 Device."

If Time1_key = 0 Then Goto Timing1
If Time2_key = 0 Then Goto Timing2
If Count1_key = 0 Then Goto Counting1
If Count2_key = 0 Then Goto Counting2
If Frequency_key = 0 Then Goto Frequency
Loop

Restart:
Waitms 200
Cls
Cursor Off
Home
Lcd "Select 1 Device"
Lowerline
Lcd "And Then Reset."
Goto Restart

'Up-Timer program for Timer0
Timing1:
If Time1_key = 0 And Time2_key = 0 Or Count1_key = 0 Or Count2_key = 0 Or Frequency_key = 0 Then Goto Restart
If Time1_key = 0 And E >= 122 Then
Incr Time1
E = 0
Cls
Home
Lcd "Up-Timer=" ; Time1
Locate 2 , 1
Lcd "Alarm=" ; Setting
End If

If Time1 >= Setting Then
Stop Timer0
Disable Timer0
Cls
Lcd "Time Is Over."
Goto Melody
End If
Goto Timing1

'Down-timer program for Timer0
Timing2:
If Time2_key = 0 And Time1_key = 0 Or Count1_key = 0 Or Count2_key = 0 Or Frequency_key = 0 Then Goto Restart
If Time2_key = 0 And E >= 122 Then
Decr Down
E = 0
Cls
Home
Lcd "Down-Timer=" ; Down
Locate 2 , 1
Lcd "Preset=0"
End If

If Down <= 0 Then
Stop Timer0
Disable Timer0
Cls
Home
Lcd "Time Is=0"
Lowerline
Lcd "Preset=0"
Goto Melody
End If
Goto Timing2

'Up-Counter program for Timer1(As Counter)
Counting1:
If Count1_key = 0 And Count2_key = 0 Or Time1_key = 0 Or Time2_key = 0 Or Frequency_key = 0 Then Goto Restart

If Count1_key = 0 Then
Waitms 100
Cls
Home
Lcd "Counter=" ; Up
Lowerline
Lcd "Alarm=" ; Setting
End If

If Up >= Setting And Count1_key = 0 Then
Stop Timer1
Disable Timer1
Cls
Home
Lcd "Counter Is Full."
Goto Melody
End If
Goto Counting1

'Down-Counter program for Timer1(As Counter)
Counting2:
If Count2_key = 0 And Count1_key = 0 Or Time1_key = 0 Or Time2_key = 0 Or Frequency_key = 0 Then Goto Restart

If Count2_key = 0 Then
Waitms 100
Cls
Home
Lcd "Counter=" ; Down
Lowerline
Lcd "Alarm=0 "
End If

If Down <= 0 And Count2_key = 0 Then
Stop Timer1
Disable Timer1
Cls
Home
Lcd "Counter=0"
Lowerline
Lcd "Alarm=0"
Goto Melody
End If
Goto Counting2

D = 0
'Frequency Meter program for Timer0(as timer) and Timer1(AS Counter)
Frequency:
If Frequency_key = 0 And Count1_key = 0 Or Count2_key = 0 Or Time1_key = 0 Or Time2_key = 0 Then Goto Restart
If Frequency_key = 0 And E >= 122 Then
Stop Timer0
Cls
Home
F = D * 65536
F = F + Counter1
Lcd "Freq:" ; F ; " Hz"
Locate 2 , 1
Lcd "Reset To Repeat."
D = 0
E = 0
Counter1 = 0
Start Timer0
End If
Goto Frequency

Counter_ovf1:
Incr D
Counter1 = 0
Return

Timer_ovf0:
Incr E
Return

Icp_isr:
If Count1_key = 0 Then
Incr Up
End If
If Count2_key = 0 Then
Decr Down
End If
Return

'Melody Code
Melody:
'Corona :: Rythm of The Night
Sound Speaker , 65 , 1274                                   'C2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 87 , 954                                    'F2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 98 , 850                                    'G2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 87 , 954                                    'F2(1/16)
Sound Speaker , 117 , 715                                   'Ais2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 110 , 758                                   'A2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 98 , 850                                    'G2(1/16)
Waitms 125                                                  'P(1/16)
Sound Speaker , 110 , 758                                   'A2(1/16)
Sound Speaker , 87 , 954                                    'F2(1/16)
Waitms 125                                                  'End of Melody
Goto End_program
Goto Melody

End_program:
Waitms 200
Cls
Upperline
Lcd "End of Program."
Lowerline
Lcd "Reset To Repeat."
Toggle Alarm_led
Waitms 500
Toggle Alarm_led
Waitms 500
Goto End_program