  'Function Generator by Dan Amos
  'Licenses under Attribution-NonCommercial-ShareAlike 3.0 Australia license
  ' http://creativecommons.org/licenses/by-nc-sa/3.0/au/
  
  dim win(45,8) 'up to 43 windows with these attributes:
  '0 - left
  '1 - top
  '2 - width
  '3 - height
  '4 - parent window. 0 means no parent (eg dialog)
  '5 - type: 0 = dialog, 1 = button, 3 = edit, 4 = static
  '6 - value: 0 = normal, 1 = down, 2 = red, 3 = green, 4 = blue
  '7 - function code
  
  dim wintext$(45) 'text associated with window
  
  dim activewindow = 0, numwindows = 0, mode = 0, swpSpeed = 2, normWin, swpWin, numpad, running, numpadField
  dim swpInc, value = 0, prevDot, adjMode, courseFine = 0
  'window handles
  dim freqEdit, swpStartEdit, swpEndEdit, numpadEdit, numpadStatic, startStop, swpStart, adjCourse, adjFine
  dim levelText, levelRms,adjModeBtn, adjModeSwp
  dim freq, freqStart, freqEnd, wave, lastbutton = 0, lastcount = 0, adjustmentMode = 0, lastX = 0
  dim adjustInc = 0, adjInitial, atten, freqReg, ctrlReg
  dim favourite(3) 'frequency favourites
  favourite(1) = 1000
  favourite(2) = 100
  favourite(3) = 1000000
  dim favBtn(3)
  dim sweep(3) 'sweep favourites
  sweep(1) = 50
  sweep(2) = 1000
  sweep(3) = 10000
  
start:
  initialize
  do
    CheckTouch
    If mode = 1 then
      UpdateOscillator
      if swpSpeed > 1 then
        pixel prevDot,122,rgb(0,0,128)
        prevDot = (freq - freqStart) / (freqEnd - freqStart) * 209 + 2
        pixel prevDot,122,rgb(white)
      endif
    endif
    if value <> 0 then 'incremental encoder has changed
      if adjMode = 0 then
        f = freq
        if mode = 1 then f = freqStart
        f = f + GetAdjIncrement() * value
        if f < 0.1 then f = 0.1
        if f > 12500000 then f = 12500000
        value = 0
        if mode = 1 then 
          freqStart = f
          wintext$(swpStartEdit) = GetFreqText$(f)
          DrawEdit swpStartEdit, 0
        else
          freq = f
          wintext$(freqEdit) =  GetFreqText$(freq)
          DrawEdit freqEdit, 0
          UpdateOscillator
        end if
      else if adjMode = 1 then
        if courseFine = 1 then
          atten = atten + value
        else
          atten = atten + value * 8
        end if
        if atten < 0 then atten = 0
        if atten > 127 then atten = 127
        value = 0
        WriteLevel atten
        UpdateLevelText
      else
        freqEnd = freqEnd + GetAdjIncrement() * value
        if freqEnd < freqStart then freqEnd = freqStart
        if freqEnd > 12500000 then freqEnd = 12500000
        print "Freq changed to " freqEnd
        value = 0
        wintext$(swpEndEdit) =  GetFreqText$(freqEnd)
        DrawEdit swpEndEdit, 0
        UpdateOscillator     
      end if
    end if
    Pause 5
  loop	'loop indefinitely - everything runs though interrupts
  
sub initialize
  setpin 10,dout
  pin(10) = 1 'pin 10 is connected to Fsync on AD9833
  normWin = createwindow(0,0,320,240,0,0,0," ") 'mainwindow
  freqEdit = createwindow(2,2,211,54,normWin,3,100,GetFreqText$(1000)) 'freq display
  startStop = createwindow(220,6,91,42,normWin,1,101,"Stop") 'start/stop
  win(startStop,6) = 2 'initially on
  x = createwindow(5,70,54,43,normWin,1,102,"SINE") 'sine
  x = createwindow(61,70,54,43,normWin,1,103,"TRI") 'triangle
  x = createwindow(117,70,54,43,normWin,1,104,"SQR") 'square
  favBtn(1) = createwindow(220,92, 91,45,normWin,1,105,"1kHz") 'fav1
  favBtn(2) = createwindow(220, 142,91,43,normWin,1,106,"100Hz") 'fav2
  favBtn(3) = createwindow(220, 189, 91, 43,normWin,1,107,"1MHz") 'fav3
  adjCourse = createwindow(7, 130, 100, 45,normWin,1,109,"Coarse") 'Course adjust
  win(adjCourse,6) = 4
  adjFine = createwindow(110, 130, 100, 45,normWin,1,110,"Fine") 'Fine adjust
  x = createwindow(7, 188, 100, 45,normWin,1,108,"Sweep") 'sweep
  adjModeBtn = createwindow(110, 188, 100, 45,normWin,1,111,"Freq") 'adjustment mode
  levelText = createwindow(220,50,91,24,normWin,4,0," ") 'Static
  levelRms = createwindow(220,67,91,24,normWin,4,0," ") 'Static
  
  swpWin = createwindow(0,0,320,240,0,0,0," ") 'sweep dialog. Window 11
  swpStartEdit = createwindow(2,2,211,54,swpWin,3,200,GetFreqText$(20)) 'freq1
  swpEndEdit = createwindow(2,60,211,54,swpWin,3,209,GetFreqText$(20000)) 'freq2
  swpStart = createwindow(222,6,91,42,swpWin,1,201,"Start") 'start/stop
  win(swpStart,6) = 3
  x = createwindow(5, 130,54,43,swpWin,1,202,"SINE") 'sine
  x = createwindow(61,130,54,43,swpWin,1,203,"TRI") 'tri
  x = createwindow(117,130,54,43,swpWin,1,204,"SQR") 'square
  x = createwindow(7, 188, 100, 45,swpWin,1,205,"Normal") 'normal
  x = createwindow(221,92, 95,45,swpWin,1,206,"50ms") '50ms
  x = createwindow(221, 142,95,43,swpWin,1,207,"1s") '1s
  x = createwindow(221, 189, 95, 43,swpWin,1,208,"10s") '10s
  adjModeSwp = createwindow(110, 188, 100, 45,swpWin,1,210,"St Freq") 'adjustment mode
  
  numpad = createwindow(0,0,320,240,0,0,0," ") 'numpad dialog. Window 22
  x = createwindow(1,1,57,58,numpad,1,307,"7")
  x = createwindow(61,1,57,58,numpad,1,308,"8")
  x = createwindow(121,1,57,58,numpad,1,309,"9")
  x = createwindow(1,61,57,58,numpad,1,304,"4")
  x = createwindow(61,61,57,58,numpad,1,305,"5")
  x = createwindow(121,61,57,58,numpad,1,306,"6")
  x = createwindow(1,121,57,58,numpad,1,301,"1")
  x = createwindow(61,121,57,58,numpad,1,302,"2")
  x = createwindow(121,121,57,58,numpad,1,303,"3")
  x = createwindow(1, 181, 57,57,numpad,1,300,"0")
  x = createwindow(61,181,57,57,numpad,1,310,".")
  x = createwindow(121,181,57,57,numpad,1,314,"C")
  x = createwindow(221,101,95,43,numpad,1,311,"Hz")
  x = createwindow(221,149,95,43,numpad,1,312,"kHz")
  x = createwindow(221,196,95,43,numpad,1,313,"MHz")
  numpadStatic = createwindow(191,9,123,24,numpad,4,0,"Frequency") 'Static
  numpadEdit = createwindow(181,51,135,40,numpad,3,0,"0") 'Edit
  DoNormal 'display normal window
  freq = 1000
  freqStart = 20
  freqEnd = 20000
  freqReg = &H4000 '&H4000 for freq0 and &H8000 for freq1 - alternates between
  wave = 0
  firstWord = &H2000
  atten = 127
  adjMode = 0
  setpin 22, intl, LevelChanged 'Increment A output
  setpin 21, din  'Increment B output
  SETPIN 10,dout 'Potentiometer /CS
  setpin 9,dout 'AD9833 FSYNC
  pin(9)  = 1
  pin(10) = 1
  running = 0
  UpdateOscillator 'reset DDS
  running = 1
  UpdateOscillator
  WriteLevel atten
  UpdateLevelText
end sub
  
function CreateWindow(lft, top, width, height, parent, type, funct, windowtext$)
  numwindows = numwindows + 1
  '  print "Creating window " numWindows " " lft "," top ": " width "x" height
  win(numwindows,0) = lft
  win(numwindows,1) = top
  win(numwindows,2) = width
  win(numwindows,3) = height
  win(numwindows,4) = parent
  win(numwindows,5) = type
  win(numwindows,6) = 0
  win(numwindows,7) = funct
  wintext$(numwindows) = windowtext$
  createwindow = numwindows
end function
  
sub DrawWindow id, clr
  'draws window and child windows. If clr is 1, background is cleared
  if win(id,4) <> 0 then exit sub
  if clr<>0 then cls rgb(0,0,128)
  activewindow = id
  'draw children
  for i = 1 to numwindows
    'print "Draw window " i ", parent is " win(i,4) " window type is " win(i,5)
    if win(i,4) = id then
      if win(i,5) = 1 then
        DrawButton(i)
      elseif win(i,5) = 3 then
        DrawEdit(i, 1)
      elseif win(i,5) = 4 then
        DrawStatic(i)
      endif
    endif
  next i
end sub
  
sub DrawButton b
  local c = 170
  local cr = 230
  col = rgb(c,c,c)
  if win(b,6) = 2 then 'red
    col = rgb(cr,c,c)
  elseif win(b,6) = 3 then 'green
    col = rgb(c,cr,c)
  elseif win(b,6) = 4 then 'blue
    col = rgb(c,c,cr)
  endif
  rbox win(b,0),win(b,1),win(b,2),win(b,3),2,col,col
  text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM, ,1, rgb(white),col
end sub
  
sub DrawButtonGrad b
  local l, offset, h, h2, d, col, c, cr, dark, light, darkr, lightr
  'normal button gradient 160,160,160 to 252,252,252 and back
  'down button gradient 86,86,86 to 182, 182, 182
  dark = 160
  light = 232
  darkr = dark	'dark and light for colour component
  lightr = light
  if win(b,6) = 1 then
    dark = 86
    light = 182
    darkr = dark
    lightr = light
  elseif win(b,6) > 1 then 'colour button
    dark = 115
    darkr = 192
    light = 158
    lightr = 230
  endif
  h = win(b,3) * 0.7 'top gradient
  h2 = win(b,3) - h 'lower gradient
  d = (light - dark) / h
  c = dark
  cr = darkr
  for l = 1 to h
    offset = 0
    if l = 1 then offset = 2 'round top corners
    if l = 2 then offset = 1
    col = rgb(c,c,c)
    if win(b,6) = 2 then 'red
      col = rgb(cr,c,c)
    elseif win(b,6) = 3 then 'green
      col = rgb(c,cr,c)
    elseif win(b,6) = 4 then 'blue
      col = rgb(c,c,cr)
    endif
    if l = int(h) - 4 then textbg = col
    line win(b,0) + offset, win(b,1) + l - 1, win(b,0) + win(b,2) - offset, win(b,1) + l - 1, 1, col
    c = c + d
    if c > 255 then c = 255
    cr = cr + d
    if (cr > 255) then cr = 255
  next l
  d = (light - dark) / h2
  'c = light
  'cr = lightr
  for l = 1 to h2
    offset = 0
    if l = int(h2) then offset = 2 'round top corners
    if l = int(h2) - 1 then offset = 1
    col = rgb(c,c,c)
    if win(b,6) = 2 then 'red
      col = rgb(cr,c,c)
    elseif win(b,6) = 3 then 'green
      col = rgb(c,cr,c)
    elseif win(b,6) = 4 then 'blue
      col = rgb(c,c,cr)
    endif
    line win(b,0) + offset, win(b,1) + h + l - 2, win(b,0) + win(b,2) - offset, win(b,1) + h + l - 2, 1, col
    c = c - d
    if c < 0 then c = 0
    cr = cr - d
    if cr < 0 then cr = 0
  next l
  if wintext$(b) = "SINE" then
    col = rgb(64,64,64)
    if win(b,6)>0 then col = rgb(250,250,250)
    lastx = win(b,0) + win(b,2) / 2 - 10
    lasty = win(b,1) + win(b,3) / 2
    for s = 0 to 63 step 3
      x = win(b,0) + win(b,2) / 2 - 10 + s / 3
      y = win(b,1) + win(b,3) / 2 - 8 * sin(s / 10)
      line lastx,lasty,x,y,2,col-1
      lastx = x
      lasty = y
    next s
  elseif wintext$(b) = "TRI" then
    col = rgb(64,64,64)
    if win(b,6)>0 then col = rgb(250,250,250)
    x = win(b,0) + win(b,2) / 2
    y = win(b,1) + win(b,3) / 2
    line x - 10,y,x-5,y-10,3,col
    line x - 5,y-10,x+5,y+10,3,col
    line x+5,y+10,x+10,y,3,col
  elseif wintext$(b) = "SQR" then
    col = rgb(64,64,64)
    if win(b,6)>0 then col = rgb(250,250,250)
    x = win(b,0) + win(b,2) / 2
    y = win(b,1) + win(b,3) / 2
    line x - 10,y,x-10,y-10,1,col
    line x - 10,y-10,x,y-10,1,col
    line x,y-10,x,y+10,1,col
    line x,y+10,x+10,y+10,1,col
    line x+10,y+10,x+10,y,1,col
  elseif wintext$(b) <> " " then
    text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM, ,1, rgb(white),textbg
  endif
end sub
  
sub DrawEdit b, clr
  if clr = 1 then rbox win(b,0), win(b,1), win(b,2), win(b,3), 6, rgb(128,128,128), rgb(64,64,64)
  text win(b,0) + win(b,2) - 4, win(b,1) + win(b,3) / 2, wintext$(b), RM, ,2, rgb(white), rgb(64,64,64)
end sub
  
sub UpdateEdit b, txt$
  ' updates edit control and minimizes flicker
  text win(b,0) + win(b,2) - 4, win(b,1) + win(b,3) / 2, txt$, RM, ,2, rgb(white), rgb(64,64,64)
  wintext$(b) = txt$
end sub
  
sub DrawStatic b
  text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM, ,1, rgb(white), rgb(0,0,128)
end sub
  
sub CheckTouch
  'processes touch interrupts
  'checks all buttons on active window to determine if one is being touched
  x = touch(x)
  y = touch(y)
  for i = 1 to numwindows
    if win(i,4) = activewindow and win(i,7) > 0 then 'parent window visible and event handler
      if (x >= win(i,0) and x <= win(i,0) + win(i,2) and y >= win(i,1) and y <= win(i,1) + win(i,3)) then
        ButtonHit(i,x,y)
        exit sub
      endif
    endif
  next i
end sub
  
sub ButtonHit btn,x,y
  'process button hit event. May need some debounce capability
  if btn = lastbutton and lastcount < 4 then
    lastcount = lastcount + 1
    exit sub 'Ignore touch events if button already hit
  endif
  lastbutton = btn
  lastcount = 0
  local b = win(btn,7)
'  print "Button hit " btn " command " b
  if (b = 100) then
    Shownumpad btn, "Frequency"
  elseif (b = 101) then
    DoStartStop
  elseif (b = 102) then
    DoSine
  elseif (b = 103) then
    DoTriangle
  elseif (b = 104) then
    DoSquare
  elseif (b = 105) then
    DoFavourite 1
  elseif (b = 106) then
    DoFavourite 2
  elseif (b = 107) then
    DoFavourite 3
  elseif (b = 108) then
    DoSweep
  elseif (b = 109) then
    SetCourse
  elseif (b = 110) then
    SetFine
  elseif (b = 111) then
    ToggleAdjMode
  elseif (b = 200) then
    Shownumpad btn, "Start freq"
  elseif (b = 201) then
    SweepStartStop
  elseif (b = 202) then
    DoSine
  elseif (b = 203) then
    DoTriangle
  elseif (b = 204) then
    DoSquare
  elseif (b = 205) then
    DoNormal
  elseif (b = 206) then
    SetSweep 1
  elseif (b = 207) then
    SetSweep 2
  elseif (b = 208) then
    SetSweep 3
  elseif (b = 209) then
    Shownumpad btn, "End freq"
  elseif (b = 210) then
    ToggleSwpAdjMode
  elseif (b = 300) then
    Digit "0"
  elseif (b = 301) then
    Digit "1"
  elseif (b = 302) then
    Digit "2"
  elseif (b = 303) then
    Digit "3"
  elseif (b = 304) then
    Digit "4"
  elseif (b = 305) then
    Digit "5"
  elseif (b = 306) then
    Digit "6"
  elseif (b = 307) then
    Digit "7"
  elseif (b = 308) then
    Digit "8"
  elseif (b = 309) then
    Digit "9"
  elseif (b = 310) then
    Digit "."
  elseif (b = 311) then
    Range 1
  elseif (b = 312) then
    Range 1000
  elseif (b = 313) then
    Range 1000000
  elseif (b = 314) then
    ClearEntry
  endif
end sub
  
sub Shownumpad b, txt$
  'display numpad dialog
  numpadField = b
  wintext$(numpadStatic) = txt$
  wintext$(numpadEdit) = "0"
  DrawWindow numpad, 1
end sub
  
sub DoStartStop
  'start/stop normal oscillator
  if running = 1 then
    running = 0
    wintext$(startStop) = "Start"
    win(startStop,6) = 3 'green
  else
    running = 1
    wintext$(startStop) = "Stop"
    win(startStop,6) = 2 'red
  endif
  DrawButton startStop
  UpdateOscillator
end sub
  
sub DoSine
  'set oscillator to sine
  if mode = 0 then 'normal
    win(startStop + 1,6) = 4
    win(startStop + 2,6) = 0
    win(startStop + 3,6) = 0
    DrawButton startStop + 1
    DrawButton startStop + 2
    DrawButton startStop + 3
  else
    win(swpStart + 1,6) = 4
    win(swpStart + 2,6) = 0
    win(swpStart + 3,6) = 0
    DrawButton swpStart + 1
    DrawButton swpStart + 2
    DrawButton swpStart + 3
  endif
  if wave = 2 then
    atten = atten * 13
    if atten > 127 then atten = 127    
    WriteLevel atten
  endif
  wave = 0
  ctrlReg = &H00
  UpdateLevelText
  UpdateOscillator
end sub
  
sub DoTriangle
  'set oscillator to triangle
  if mode = 0 then 'normal
    win(startStop + 1,6) = 0
    win(startStop + 2,6) = 4
    win(startStop + 3,6) = 0
    DrawButton startStop + 1
    DrawButton startStop + 2
    DrawButton startStop + 3
  else
    win(swpStart + 1,6) = 0
    win(swpStart + 2,6) = 4
    win(swpStart + 3,6) = 0
    DrawButton swpStart + 1
    DrawButton swpStart + 2
    DrawButton swpStart + 3
  endif
  if wave = 2 then
    atten = atten * 13
    if atten > 127 then atten = 127    
    WriteLevel atten
  endif
  wave = 1
  ctrlReg = &H02
  UpdateLevelText
  UpdateOscillator
end sub
  
sub DoSquare
  'set oscillator to square
  if mode = 0 then 'normal
    win(startStop + 1,6) = 0
    win(startStop + 2,6) = 0
    win(startStop + 3,6) = 4
    DrawButton startStop + 1
    DrawButton startStop + 2
    DrawButton startStop + 3
  else
    win(swpStart + 1,6) = 0
    win(swpStart + 2,6) = 0
    win(swpStart + 3,6) = 4
    DrawButton swpStart + 1
    DrawButton swpStart + 2
    DrawButton swpStart + 3
  endif
  wave = 2
  atten = atten / 13
  WriteLevel atten
  ctrlReg = &H28
  UpdateLevelText
  UpdateOscillator
end sub
  
sub DoFavourite f
  'set oscillator frequency to favourite(f)
  freq = favourite(f)
  UpdateOscillator
  wintext$(freqEdit) = GetFreqText$(freq)
  DrawEdit freqEdit, 0
end sub
  
sub DoSweep
  'engage sweep mode, display dialog
  mode = 1
  DrawWindow swpWin, 1
  SetSweep swpSpeed
  DoSine
  adjMode = 1
  ToggleSwpAdjMode
end sub
  
sub DoNormal
  'return to normal mode (non-sweep), display dialog
  mode = 0
  DrawWindow normWin, 1
  line 2,122,211,122,1,rgb(0,0,128)
  SetTick 0,SweepTimer 'kill sweep
  running = 1
  wintext$(startStop) = "Stop"
  win(startStop,6) = 2 'red
  DrawButton startStop
  DoSine
  adjMode = 1
  ToggleAdjMode
end sub
  
sub SweepStartStop
  'start/stop sweep mode
  if running = 1 then
    running = 0
    wintext$(swpStart) = "Start"
    win(swpStart,6) = 3 'green
    settick 0,SweepTimer
  else
    running = 1
    wintext$(swpStart) = "Stop"
    win(swpStart,6) = 2 'red
    Settick 2,SweepTimer
  endif
  DrawButton swpStart
  'start/stop sweep oscillator
end sub
  
sub SetSweep s
  'set sweep speed to sweeps(s)
  swpSpeed = s
  if s = 1 then
    win(swpStart + 5,6) = 4
  else
    win(swpStart + 5,6) = 0
  endif
  if s = 2 then
    win(swpStart + 6,6) = 4
  else
    win(swpStart + 6,6) = 0
  endif
  if s = 3 then
    win(swpStart + 7,6) = 4
  else
    win(swpStart + 7,6) = 0
  endif
  DrawButton swpStart + 5
  DrawButton swpStart + 6
  DrawButton swpStart + 7
  SweepCalc
end sub
  
sub Digit d$
  print "Digit " d$
  local w$ = wintext$(numpadEdit)
  if len(w$) > 7 then exit sub
  if w$ = "0" and d$ <> "." then w$ = ""
  UpdateEdit numpadEdit, w$ + d$
end sub
  
sub ClearEntry
  UpdateEdit numpadEdit, "       0"
  UpdateEdit numpadEdit, "0"
end sub
  
sub Range r
  'set frequency range to r (x1, x1000, x1000000)
  'parse numpadEdit
  print "Range " r " Numpad " wintext$(numpadEdit)
  local fr = val(wintext$(numpadEdit)) * r
  wintext$(numpadField) = GetFreqText$(fr)
  if numpadField = swpEndEdit then
    freqEnd = fr
    sweepCalc
  elseif numpadField = swpStartEdit then
    freqStart = fr
    sweepCalc
  else
    freq = fr
  endif
  if mode = 0 then
    favourite(3) = favourite(2)
    favourite(2) = favourite(1)
    favourite(1) = freq
    for i = 1 to 3
      wintext$(favBtn(i)) = GetFreqText$(favourite(i))
    next i
    DrawWindow normWin, 1
    UpdateOscillator
  else
    DrawWindow swpWin, 1
  endif
end sub
  
function GetFreqText$(fr)
  local l$ = "Hz"
  local f = fr
  local p = 6, d = 1
  if f >= 1000000 then
    l$ = "MHz"
    f = f / 1000000
    p = 3
    d = 3
  elseif f >= 1000 then
    l$ = "kHz"
    f = f / 1000
    p = 3
    d = 3
  endif
  m$ = str$(f, p, d)
  GetFreqText$ = m$ + l$
end function
  
sub DoAdjust t, x
  win(t,6) = 3
  DrawButton t
  adjustInc = GetAdjIncrement()
  print "Adjustment " adjustInc
  adjustmentMode = 1
  lastX = x
  adjInitial = freq
end sub
  
function GetAdjIncrement()
  local f = freq
  if mode = 1 then
    if adjMode = 2 then
      f = freqEnd
    else
      f = freqStart
    end if
  end if
  adjustInc = int(f / 1000)
  if f >= 10000000 then
    adjustInc = 5000000
  elseif f >= 200000 then
    adjustInc = 50000
  elseif f >= 20000 then
    adjustInc = 5000
  elseif f >= 2000 then
    adjustInc = 500
  elseif f >= 200 then
    adjustInc = 50
  else
    adjustInc = 10
  endif
  if courseFine = 1 then adjustInc = adjustInc / 100
  GetAdjIncrement = adjustInc
end function
  
sub AdjustFrequency x
  freq = adjInitial + (x - lastX) * adjustInc
  if freq < 0.1 then freq = 0.1
  if freq > 12500000 then freq = 12500000
  local l$ = GetFreqText$(freq)
  wintext$(freqEdit) =  l$
  DrawEdit freqEdit, 0
  UpdateOscillator
end sub
  
sub SweepCalc
  'calculate sweep increment
  local t = sweep(swpSpeed) / 2
  swpInc = (freqEnd - freqStart) / t
  freq = freqStart 'reset sweep
  print "Speed ticks " t ", Increment " swpInc
  line 2,122,211,122,1,rgb(0,0,128)
end sub
  
sub SweepTimer
  prevFreq = freq
  freq = freq + swpInc
  if freq > freqEnd then freq = freqStart
end sub
  
sub UpdateOscillator
  'write freq and wave values to oscillator
  '  print "Update oscillator, freq " freq ", waveform " wave " Running " running
  'write to Freq0, output sine 0x2000, 01LL LLLL LLLL LLLL, 01MM MMMM MMMM MMMM
  'for square first WORD is 0x2010, for triangle 0x2002
  local cf = freq / 25000000 * &h10000000
  local hw = freqReg or (cint(cf \ &h4000) and &h3fff)
  local lw = freqReg or (cint(cf) and &h3fff)
  spi open 100000,2,16
  WriteDDS lw
  WriteDDS hw
  if running = 1 then
    if freqReg = &h4000 then
      freqReg = &h8000 'use freq1 next
      WriteDDS &h2000 or ctrlReg
    else
      freqReg = &h4000
      WriteDDS &h2800 or ctrlReg
    endif
  else
    WriteDDS &h2100
  endif
  spi close
end sub
  
sub UpdateLevelText
  Local l = 0.6 * atten / 255
  if wave = 2 then l = 5.5 * atten / 255
  wintext$(levelText) = str$(l,2,3) + "V pk"
  local rms = l / 1.414
  if wave = 1 then
    rms = l / 1.73
  elseif wave = 2 then
    rms = l
  endif
  wintext$(levelRms) = str$(rms,2,3) + "V RMS"
  DrawStatic levelText
  DrawStatic levelRms
end sub
  
sub LevelChanged
  local inc = 1
  if pin(21) = 1 then inc = -1
  value = value + inc
end sub
  
sub ToggleAdjMode
  if adjMode = 0 then
    adjMode = 1
    wintext$(adjModeBtn) = "Level"
  else
    adjMode = 0
    wintext$(adjModeBtn) = "Freq"
  end if
  DrawButton adjModeBtn
end sub
  
sub ToggleSwpAdjMode
  if adjMode = 0 then
    adjMode = 2
    wintext$(adjModeSwp) = "End Freq"
  elseif adjmode = 2 then
    adjmode = 1
    wintext$(adjModeSwp) = "Level"
  else
    adjMode = 0
    wintext$(adjModeSwp) = "Start Freq"
  end if
  DrawButton adjModeSwp
end sub

sub SetCourse
  CourseFine = 0
  win(adjCourse,6) = 4
  win(adjFine,6) = 0
  DrawButton adjCourse
  DrawButton adjFine
end sub

sub SetFine
  CourseFine = 1
  win(adjCourse,6) = 0
  win(adjFine,6) = 4
  DrawButton adjCourse
  DrawButton adjFine
end sub

sub WriteLevel l
  if l < 0 then l = 0
  if l > 127 then l = 127
  pin(10) = 0
  SPI OPEN 100000,0,16
  SPI WRITE 1,&h7f - l
  SPI CLOSE
  Pin(10)=1
end sub

sub WriteDDS v
	Pin(9) = 0
	SPI Write 1,v
	Pin(9) = 1
end sub
