
'                 WIRELESS BASED RAIN ALARM SYSTEM (rain_alarm14m2.bas)

'This program should be down loaded to both transmit and receive microprocessors.  
'The logic level on the B.5 input will select either transmit or receive programs.
'You may select your own alarm code - by altering the 12344321 default alarm code 
'

'******************************* SETUP SEQUENCE ****************************** 

start_up:' ------- set-up micro - run transmit or receive programs 
setfreq m8
b1=1: b2=2: b3=3: b4=4: b5=4: b6=3: b7=2: b8=1' (default alarm code)
let dirsB = %00011110:let pinsB = %00000000
let dirsC = %00000000:let pinsC = %00000000
if pinB.5 = 1 then goto xmit_prog
if pinB.5 = 0 then goto recv_prog


'******************************* TRANSMIT PROGRAM ****************************

xmit_prog:' ------ flash LED1 once and then start 20KHz oscillator
pause 2
pullup %0000111000000000 
high B.1: pause 1000: low B.1
pwmout C.0,99,200
'goto xmit_code


xmit_code:' ------ covert default alarm code to transmit alarm code
pause 2
let b11=b1: b12=b2: b13=b3: b14=b4: b15=b5: b16=b6: b17=b7: b18=b8
'goto xmit_mode


xmit_mode:'-------- monitor voltage from the rain sensor circuit.
b10 = 0
for b0 = 0 to 50
readadc C.4,b9
if b9 > 100 then: inc b10: endif
pause 20
next b0
if b10 > 30 then: goto xmit_alarm: endif
goto xmit_mode


xmit_alarm:'------ each two sec,transmit alarm code and flash LED2
pause 2
high B.4: high B.1
pause 150
rfout B.2, (b11,b12,b13,b14,b15,b16,b17,b18)
pause 150
low B.4: low B.1
pause 2000 
goto xmit_mode


'******************************** RECEIVE PROGRAM ****************************

recv_prog:' ------ flash LED2 once to show the power switch is on
pause 2
pullup %0000111100000000
high B.1: pause 1000: low B.1
'goto recv_links


recv_links:'------ ckeck LK1 and LK2 to adjust the alarm settings
pause 2
if pinC.0 = 0 then: b9 = 12 else b9 = 4:endif
if pinC.2 = 0 then: b19 = 30 else b19 = 10:endif
'goto recv_mode 
 

recv_mode:'------- receiver waits untill code bytes are picked up 
pause 2
rfin C.4,b11,b12,b13,b14,b15,b16,b17,b18
'goto recv_code1


recv_code1:'------- the received and default alarm codes must match
pause 2
if b11=b1:and b12=b2:and b13=b3:and b14=b4 then goto recv_code2
goto recv_links 
recv_code2:
if b15=b5:and b16=b6:and b17=b7:and b18=b8 then goto recv_alarm1
goto recv_links 


recv_alarm1:'------ generate the alarm sound and flash the alarm LED2
for b10 = 1 to b9 
for b0 = 1 to 200
let pinsB = %00000100
let pinsB = %00010000
next b0
let pinsB = %00000000
high B.1: pause 1000: low B.1
next b10


recv_alarm2:'------ flash the alarm LED2 only,without any alarm sound
for b10 = 1 to b19
high B.1: pause 1000: low B.1
pause 1000
next b10
goto recv_links

    
'******************************* VARIABLE LIST ****************************** 
    

' b1, b2, b3, b4, b5, b6, b7,  b8 = defalt alarm codes 
' b11,b12,b13,b14,b15,b16,b17,b18 = transmit alarm code.
' b0, b9, b10, b13                = temporary variables 