' Started....07/01/16
' Microcontroller used:  Microchip Technology PIC16F88
'                        microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
'                    melabs.com 

'--------Program Desciption--------

' The program uses one of the analog-to-digital converters,(AN4), to measure 
' the voltage on the center pin of the calibration potentiometer 
' (an analog signal). It then converts the analog voltage into an 10-bit
' digital value (0 to 1023), divides the answer by 100 and displays 
' the result on an LCD. If the answer is less than 1 ohm the buzzer will sound 
' every 50ms, if it is between 1 and 10 it will sound the same number of times 
' as the interger value ie if the resistance is between 4 and 5 ohm then the 
' buzzer connected to RB6 will beep 4 times. If the resistance is over 10 ohm
' the buzzer stops and over range is displayed. It also detects if the test item 
' is a capacitor or resistor and displays this below the resistance value. The
' buzzer is turned off when a resistor is detected. This enables the operator 
' to detect a shorted capacitor


'
'
' 
   #CONFIG
 __CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 #ENDCONFIG
 
 
 
    define LCD_DREG PORTB'PORTB is LCD data PORT
    define LCD_DBIT 0 'PORTB.0 is the data lowest significanr bit  
    define LCD_RSREG PORTB   ' PORTB - RS port   
    define LCD_RSBIT 4       ' RS bit connects to PORTB.4
    define LCD_EREG PORTB ' PORTB E PORT
    define LCD_EBIT 5    ' E to RB5
    Define LCD_BITS 4 '4 data lines used
    define LCD_LINES 2  'LCD display has 2 lines
    Define LCD_COMMANDUS 1500 'Set data delay time to 1.5ms
    define LCD_DATAUS 44 'Set data delay to 44 micro second
    
    Define  ADC_BITS     10    ' Set number of bits in result
	Define  ADC_CLOCK    3     ' Set clock source (3=rc)
	Define  ADC_SAMPLEUS 50    ' Set sampling time in uS
	 
       
'------------Variables-------------
     i var word      'word for number of beeps
     x  var word     ' word for potentiometer input 
    y var word      'word for reistance cap check
     RES_INT var word  ' whole number value of input voltage  ie 4 for 4.32 Volts
     res_frac var word 'fraction part of input voltage  ie for 0.32 for 4.32 Volts
     
     
'----------Initialization----------

    ANSEL = %00010000  ' Leaves AN4 in analog mode, but                 
                       ' changes other analog bits to digital.
    TRISB = %00000000 ' all outputs                   
    TRISA = %00111100 'RA2, RA3, RA4, RA5 inputs rest outputs                  
   ADCON1 =  %10110000  ' Bit 7 Right justifies 10-bit value of x
                        ' in 16-bit WORD. Adds "0" in the
                        ' 6 Most Significant bits of the Word,
                        ' shifting the 10-bit value of x to
                        ' the right. This changes the LCD
                        ' values to 0 - 1023. Bit 4 and bit 5
                        'make RA2 Vref- and RA3 vre+
'                                                    

'
                                
    OSCCON = $60	            ' Sets the internal oscillator in the
                                ' 16F88 to 4 MHz 
    PORTA.0 = 0' turn oscillator off  	    
   
'-------------Main Code------------
 PORTB.6 = 0 'buzzer off
x = 0 
Y = 0
pause 500  ' Pause to allow LCD to setup
display:
pause 1000
adcin 4, x  'Read the value of the analogue input voltage and stores it as a 10bit word in X
res_INT = X/100 ' find the interger value of reading
res_frac = X//100 ' find the remainder of reading
if X > 1020 then goto over
PORTA.0 = 1 'turn oscillator off
pause 50' oscillator off for 10ms before ADC measurement  was 10
adcin 4, y
PORTA.0 = 0 'oscillator on
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line 
LCDout  DEC RES_INT, ".", dec2 res_frac , " OHM"  ' send interger and remainder to LCD
if y <= X then PORTA.1 = 1' device is a resistor
if Y > X then PORTA.1 = 0' device is a capacitor
if PORTA.1 = 1 then
lcdout $FE,$C0 ' move cursor to begging of second line  
LCDout "RESISTOR"
endif
if PORTA.1 = 0 then
lcdout $FE,$C0 ' move cursor to begging of second line  
LCDout "CAPACITOR"
endif
if RES_INT < 1 then goto contbuzz  '
if x <1020 then goto INTER '

goto display
over:
PORTB.6 = 0  'buzzer off
LCDOUT $FE,$01  'clear display
LCDOUT $FE,$80  ' goto start of first line

lcdout "OVER RANGE" ' send over range to LCD
 goto display
 INTER: 
for i = 1 to RES_INT  ' switch buzzer on and off the same number as interger value
'ie if 4.2ohm buzzer sounds 4 times
PORTB.6 = 1' buzzer on 
pause 100  ' buzzer on time  ms
PORTB.6 = 0 'buzzer off
pause 200  ' buzzer off time  ms
next i
pause 500 ' time sequence repeats ms
goto display
 contbuzz:
 PORTB.6 = 1 ' buzzer on
 pause 50 'buzzer on for 50
 PORTB.6 = 0
 pause 50  ' buzzer off 50ms
 adcin 4, X  'read resitance
 if X < 100 then goto contbuzz  ' resistance less than 1 continue beep
 if X > 100 then   'resistance greater than 1 
 PORTB.6 = 0 'buzzer off
 endif
 
 goto display

