' *******************************
' ***** Stove Sensor *****
' *******************************
' Filename: mm2stovexx.bas
' Date: Dec 2015
' File Version: 1.1
' Written by: M.Ogden, codenquilts.com.au
' Function: uMite Stove left on sensor
' '
' Last Revision:
' Target MM2
' *******************************
'1.1 removed continuious alarm , reduced decrease factor to 5 , changed sleep to 10 secs
'
'
'
'
OPTION EXPLICIT
OPTION DEFAULT INTEGER
OPTION autorun ON
CPU 48
DIM Level,newLevel,resultLevel,prealarmlevel
DIM alarm, ack,increase,alarmtime,starttime

DIM pin.temp=7
DIM pin.redled=22
DIM pin.yellowled=18
DIM pin.button=16
DIM pin.battV=6
DIM pin.pwm=2


CONST adcFactor=0.0032258
DIM threslevel=2
DIM decreasefactor=2

'setup i/o
SETPIN pin.temp, AIN
SETPIN pin.redled, DOUT
SETPIN pin.yellowled, DOUT
SETPIN pin.battv, AIN
SETPIN pin.button, DIN, PULLUP

level=CINT(PIN(7)/adcfactor) 'read sensor to establish ambient level


DO
  adctempSensor
  'If we get back here there has been a Temperature change
  IF Alarm = 1 AND Increase =0 THEN 'temperature has dropped reset the Alarm
  PRINT "Alarm reset - decrease"
    AlarmReset
    GOTO buttonclear
  ELSEIF Increase =1 AND alarm =0 THEN 'new alarm
    alarm=1 'set alarm
    soundAlarm 3
    ack=1
    GOTO buttonclear
  END IF

buttonclear:
  IF PIN(pin.button)=0 THEN GOTO buttonclear
  PAUSE 1000
LOOP

SUB adctempSensor
  LOCAL x
  DO
    'Print "Loop elapsed time"; (Timer-StartTime)/1000
    CPU SLEEP 10
    'StartTime = Timer
    PIN(pin.yellowled)=1
    PAUSE 50
    PIN(pin.yellowled)=0
    'pulse pin.yellowled, 50
    newlevel=0
    FOR x=1 TO 20
      newlevel=newlevel + CINT(PIN(7)/adcfactor)
    NEXT x
    newlevel=newlevel/20
    'read sensor
    IF newlevel>level THEN 'establish new base level
      'Temperature decrease
      resultLevel=(newLevel-level)-decreasefactor ' reduce the swing for decreasing temps
      increase=0
    ELSE
      'Temperature increase
      resultLevel=level-newLevel
      increase=1
    END IF
    IF alarm =0 THEN prealarmlevel=level ' freeze level when in alarm
    level=newlevel
    PRINT "PreAlarmLevel:" + STR$(prealarmlevel)
    PRINT "New Level / swing " + STR$(level) + " / " + STR$(resultlevel)
    IF PIN(pin.button)=0 THEN alarmreset 'during debug change this command to END
    'check if pre alarm tems have been reached if so rsset alarm conditions
    IF alarm=1 AND level=prealarmlevel THEN
      PRINT "PreAlarm reached"
      alarmreset
    END IF
    'if already in Alarm
    IF alarm=1 THEN
      PIN(pin.redled)=1 'flash the red led
      PAUSE 100
      PIN(pin.redled)=0
      alarmtime=alarmtime+1
      IF alarmtime MOD 30 = 0 THEN soundalarm 1 '~5 mins
      PRINT "Alarmtime" + STR$(Alarmtime)
      IF alarmtime>720 THEN repeatalarm 'continuious alarm after ~ 2hrs
    END IF
    checkbattery
  LOOP UNTIL resultlevel>threslevel 'trigger when exceeding base level by threshold value
END SUB

SUB checkbattery
  LOCAL dcv AS FLOAT
  dcv=PIN(pin.battv)
  PRINT "Battery Level:" + STR$(dcv)
  IF dcv <= 2.2 THEN 'battery warning at 2.2 volts
    sound (100,2)
  END IF
END SUB

SUB alarmReset
  PRINT "Alarm Reset"
  alarm=0:ack=0:alarmtime=0
  sound (10,20)
END SUB

SUB repeatalarm
  PRINT "Repeat Alarm"
  alarmtime=0
acknowledgeAlarm:
  soundAlarm 5
  PAUSE 100
  IF PIN(pin.button)=1 THEN GOTO acknowledgealarm 'stay on til acknowledged
END SUB

SUB soundalarm (count)
  LOCAL l
  FOR l = 1 TO count
    sound (100,10)
    PAUSE 200
    sound (100,10)
    PAUSE 200
    sound (100,10)
    PAUSE 1000
  NEXT l
END SUB

SUB sound(note,duration)
  PWM pin.pwm,39*note,50
  PAUSE 10*duration
  PWM pin.pwm,STOP
END SUB
