/*
 * File:           C:\Users\ppros\OneDrive\Documents\Electronics\Silicon_Chip\Digital Preamp\ADAU\Digital_Preamp_IC_1_PARAM.h
 *
 * Created:        Saturday, March 1, 2025 8:16:26 PM
 * Description:    Digital_Preamp:IC 1 parameter RAM definitions.
 *
 * This software is distributed in the hope that it will be useful,
 * but is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * This software may only be used to program products purchased from
 * Analog Devices for incorporation by you into audio products that
 * are intended for resale to audio product end users. This software
 * may not be distributed whole or in any part to third parties.
 *
 * Copyright ©2025 Analog Devices, Inc. All rights reserved.
 */
#ifndef __DIGITAL_PREAMP_IC_1_PARAM_H__
#define __DIGITAL_PREAMP_IC_1_PARAM_H__


/* Module SafeLoadModule - SafeLoadModule*/
#define MOD_SAFELOADMODULE_COUNT                       17
#define MOD_SAFELOADMODULE_DEVICE                      "IC1"
#define MOD_SAFELOADMODULE_DATA_SAFELOAD0_ADDR         24576
#define MOD_SAFELOADMODULE_DATA_SAFELOAD0_MEMORYPAGE   0
#define MOD_SAFELOADMODULE_DATA_SAFELOAD1_ADDR         24577
#define MOD_SAFELOADMODULE_DATA_SAFELOAD1_MEMORYPAGE   0
#define MOD_SAFELOADMODULE_DATA_SAFELOAD2_ADDR         24578
#define MOD_SAFELOADMODULE_DATA_SAFELOAD2_MEMORYPAGE   0
#define MOD_SAFELOADMODULE_DATA_SAFELOAD3_ADDR         24579
#define MOD_SAFELOADMODULE_DATA_SAFELOAD3_MEMORYPAGE   0
#define MOD_SAFELOADMODULE_DATA_SAFELOAD4_ADDR         24580
#define MOD_SAFELOADMODULE_DATA_SAFELOAD4_MEMORYPAGE   0
#define MOD_SAFELOADMODULE_ADDRESS_SAFELOAD_ADDR       24581
#define MOD_SAFELOADMODULE_ADDRESS_SAFELOAD_MEMORYPAGE 0
#define MOD_SAFELOADMODULE_NUM_SAFELOAD_LOWER_ADDR     24582
#define MOD_SAFELOADMODULE_NUM_SAFELOAD_LOWER_MEMORYPAGE 0
#define MOD_SAFELOADMODULE_NUM_SAFELOAD_UPPER_ADDR     24583
#define MOD_SAFELOADMODULE_NUM_SAFELOAD_UPPER_MEMORYPAGE 0

/* Module DCB1 - DC Blocking*/
#define MOD_DCB1_COUNT                                 1
#define MOD_DCB1_DEVICE                                "IC1"
#define MOD_DCB1_DCBLOCKALGDBLPRECS3001POLE_ADDR       36
#define MOD_DCB1_DCBLOCKALGDBLPRECS3001POLE_VALUE      SIGMASTUDIOTYPE_8_24_CONVERT(0.9999)
#define MOD_DCB1_DCBLOCKALGDBLPRECS3001POLE_TYPE       SIGMASTUDIOTYPE_8_24
#define MOD_DCB1_DCBLOCKALGDBLPRECS3001POLE_MEMORYPAGE 0

/* Module DCB2 - DC Blocking*/
#define MOD_DCB2_COUNT                                 1
#define MOD_DCB2_DEVICE                                "IC1"
#define MOD_DCB2_DCBLOCKALGDBLPRECS3002POLE_ADDR       39
#define MOD_DCB2_DCBLOCKALGDBLPRECS3002POLE_VALUE      SIGMASTUDIOTYPE_8_24_CONVERT(0.9999)
#define MOD_DCB2_DCBLOCKALGDBLPRECS3002POLE_TYPE       SIGMASTUDIOTYPE_8_24
#define MOD_DCB2_DCBLOCKALGDBLPRECS3002POLE_MEMORYPAGE 0

/* Module COMM_FILT0 - General Eq (2nd order)*/
#define MOD_COMM_FILT0_COUNT                           6
#define MOD_COMM_FILT0_DEVICE                          "IC1"
#define MOD_COMM_FILT0_ALG0_SLEWMODE_ADDR              45
#define MOD_COMM_FILT0_ALG0_SLEWMODE_FIXPT             0x0000208A
#define MOD_COMM_FILT0_ALG0_SLEWMODE_VALUE             SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_COMM_FILT0_ALG0_SLEWMODE_TYPE              SIGMASTUDIOTYPE_INTEGER
#define MOD_COMM_FILT0_ALG0_SLEWMODE_MEMORYPAGE        0
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB210_ADDR 24602
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB210_MEMORYPAGE 0
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB211_ADDR 24603
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB211_MEMORYPAGE 0
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB212_ADDR 24604
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB212_MEMORYPAGE 0
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB213_ADDR 24605
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB213_MEMORYPAGE 0
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB214_ADDR 24606
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT0_ALG0_EQS300MULTIDPHWSLEWP1ALG2TARGB214_MEMORYPAGE 0

/* Module COMM_FILT1 - General Eq (2nd order)*/
#define MOD_COMM_FILT1_COUNT                           6
#define MOD_COMM_FILT1_DEVICE                          "IC1"
#define MOD_COMM_FILT1_ALG0_SLEWMODE_ADDR              51
#define MOD_COMM_FILT1_ALG0_SLEWMODE_FIXPT             0x0000208A
#define MOD_COMM_FILT1_ALG0_SLEWMODE_VALUE             SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_COMM_FILT1_ALG0_SLEWMODE_TYPE              SIGMASTUDIOTYPE_INTEGER
#define MOD_COMM_FILT1_ALG0_SLEWMODE_MEMORYPAGE        0
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB210_ADDR 24607
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB210_MEMORYPAGE 0
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB211_ADDR 24608
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB211_MEMORYPAGE 0
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB212_ADDR 24609
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB212_MEMORYPAGE 0
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB213_ADDR 24610
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB213_MEMORYPAGE 0
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB214_ADDR 24611
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT1_ALG0_EQS300MULTIDPHWSLEWP1ALG1TARGB214_MEMORYPAGE 0

/* Module COMM_FILT2 - General Eq (2nd order)*/
#define MOD_COMM_FILT2_COUNT                           6
#define MOD_COMM_FILT2_DEVICE                          "IC1"
#define MOD_COMM_FILT2_ALG0_SLEWMODE_ADDR              57
#define MOD_COMM_FILT2_ALG0_SLEWMODE_FIXPT             0x0000208A
#define MOD_COMM_FILT2_ALG0_SLEWMODE_VALUE             SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_COMM_FILT2_ALG0_SLEWMODE_TYPE              SIGMASTUDIOTYPE_INTEGER
#define MOD_COMM_FILT2_ALG0_SLEWMODE_MEMORYPAGE        0
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB210_ADDR 24612
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB210_MEMORYPAGE 0
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB211_ADDR 24613
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB211_MEMORYPAGE 0
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB212_ADDR 24614
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB212_MEMORYPAGE 0
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB213_ADDR 24615
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB213_MEMORYPAGE 0
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB214_ADDR 24616
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_COMM_FILT2_ALG0_EQS300MULTIDPHWSLEWP1ALG3TARGB214_MEMORYPAGE 0

/* Module B0_HPF0 - General Eq (2nd order)*/
#define MOD_B0_HPF0_COUNT                              5
#define MOD_B0_HPF0_DEVICE                             "IC1"
#define MOD_B0_HPF0_ALG0_STAGE0_B2_ADDR                58
#define MOD_B0_HPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_HPF0_ALG0_STAGE0_B1_ADDR                59
#define MOD_B0_HPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99953571029508)
#define MOD_B0_HPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_HPF0_ALG0_STAGE0_B0_ADDR                60
#define MOD_B0_HPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_HPF0_ALG0_STAGE0_A2_ADDR                61
#define MOD_B0_HPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.9995359244295)
#define MOD_B0_HPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_HPF0_ALG0_STAGE0_A1_ADDR                62
#define MOD_B0_HPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99953549616067)
#define MOD_B0_HPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_HPF0 - General Eq (2nd order)*/
#define MOD_B3_HPF0_COUNT                              5
#define MOD_B3_HPF0_DEVICE                             "IC1"
#define MOD_B3_HPF0_ALG0_STAGE0_B2_ADDR                63
#define MOD_B3_HPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_HPF0_ALG0_STAGE0_B1_ADDR                64
#define MOD_B3_HPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.92816582584575)
#define MOD_B3_HPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_HPF0_ALG0_STAGE0_B0_ADDR                65
#define MOD_B3_HPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_HPF0_ALG0_STAGE0_A2_ADDR                66
#define MOD_B3_HPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B3_HPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_HPF0_ALG0_STAGE0_A1_ADDR                67
#define MOD_B3_HPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B3_HPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_HPF0 - General Eq (2nd order)*/
#define MOD_B2_HPF0_COUNT                              5
#define MOD_B2_HPF0_DEVICE                             "IC1"
#define MOD_B2_HPF0_ALG0_STAGE0_B2_ADDR                68
#define MOD_B2_HPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_HPF0_ALG0_STAGE0_B1_ADDR                69
#define MOD_B2_HPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99067421396581)
#define MOD_B2_HPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_HPF0_ALG0_STAGE0_B0_ADDR                70
#define MOD_B2_HPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_HPF0_ALG0_STAGE0_A2_ADDR                71
#define MOD_B2_HPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B2_HPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_HPF0_ALG0_STAGE0_A1_ADDR                72
#define MOD_B2_HPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B2_HPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_HPF0 - General Eq (2nd order)*/
#define MOD_B1_HPF0_COUNT                              5
#define MOD_B1_HPF0_DEVICE                             "IC1"
#define MOD_B1_HPF0_ALG0_STAGE0_B2_ADDR                73
#define MOD_B1_HPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_HPF0_ALG0_STAGE0_B1_ADDR                74
#define MOD_B1_HPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99814156723514)
#define MOD_B1_HPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_HPF0_ALG0_STAGE0_B0_ADDR                75
#define MOD_B1_HPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_HPF0_ALG0_STAGE0_A2_ADDR                76
#define MOD_B1_HPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B1_HPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_HPF0_ALG0_STAGE0_A1_ADDR                77
#define MOD_B1_HPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B1_HPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_HPF1 - General Eq (2nd order)*/
#define MOD_B0_HPF1_COUNT                              5
#define MOD_B0_HPF1_DEVICE                             "IC1"
#define MOD_B0_HPF1_ALG0_STAGE0_B2_ADDR                78
#define MOD_B0_HPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_HPF1_ALG0_STAGE0_B1_ADDR                79
#define MOD_B0_HPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99953571029508)
#define MOD_B0_HPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_HPF1_ALG0_STAGE0_B0_ADDR                80
#define MOD_B0_HPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_HPF1_ALG0_STAGE0_A2_ADDR                81
#define MOD_B0_HPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.9995359244295)
#define MOD_B0_HPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_HPF1_ALG0_STAGE0_A1_ADDR                82
#define MOD_B0_HPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99953549616067)
#define MOD_B0_HPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_HPF1 - General Eq (2nd order)*/
#define MOD_B1_HPF1_COUNT                              5
#define MOD_B1_HPF1_DEVICE                             "IC1"
#define MOD_B1_HPF1_ALG0_STAGE0_B2_ADDR                83
#define MOD_B1_HPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_HPF1_ALG0_STAGE0_B1_ADDR                84
#define MOD_B1_HPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99814156723514)
#define MOD_B1_HPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_HPF1_ALG0_STAGE0_B0_ADDR                85
#define MOD_B1_HPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_HPF1_ALG0_STAGE0_A2_ADDR                86
#define MOD_B1_HPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B1_HPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_HPF1_ALG0_STAGE0_A1_ADDR                87
#define MOD_B1_HPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B1_HPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_HPF1 - General Eq (2nd order)*/
#define MOD_B2_HPF1_COUNT                              5
#define MOD_B2_HPF1_DEVICE                             "IC1"
#define MOD_B2_HPF1_ALG0_STAGE0_B2_ADDR                88
#define MOD_B2_HPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_HPF1_ALG0_STAGE0_B1_ADDR                89
#define MOD_B2_HPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99067421396581)
#define MOD_B2_HPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_HPF1_ALG0_STAGE0_B0_ADDR                90
#define MOD_B2_HPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_HPF1_ALG0_STAGE0_A2_ADDR                91
#define MOD_B2_HPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B2_HPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_HPF1_ALG0_STAGE0_A1_ADDR                92
#define MOD_B2_HPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B2_HPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_HPF1 - General Eq (2nd order)*/
#define MOD_B3_HPF1_COUNT                              5
#define MOD_B3_HPF1_DEVICE                             "IC1"
#define MOD_B3_HPF1_ALG0_STAGE0_B2_ADDR                93
#define MOD_B3_HPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_HPF1_ALG0_STAGE0_B1_ADDR                94
#define MOD_B3_HPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.92816582584575)
#define MOD_B3_HPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_HPF1_ALG0_STAGE0_B0_ADDR                95
#define MOD_B3_HPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_HPF1_ALG0_STAGE0_A2_ADDR                96
#define MOD_B3_HPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B3_HPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_HPF1_ALG0_STAGE0_A1_ADDR                97
#define MOD_B3_HPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B3_HPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_HPF2 - General Eq (2nd order)*/
#define MOD_B0_HPF2_COUNT                              5
#define MOD_B0_HPF2_DEVICE                             "IC1"
#define MOD_B0_HPF2_ALG0_STAGE0_B2_ADDR                98
#define MOD_B0_HPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_HPF2_ALG0_STAGE0_B1_ADDR                99
#define MOD_B0_HPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99953571029508)
#define MOD_B0_HPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_HPF2_ALG0_STAGE0_B0_ADDR                100
#define MOD_B0_HPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_HPF2_ALG0_STAGE0_A2_ADDR                101
#define MOD_B0_HPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.9995359244295)
#define MOD_B0_HPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_HPF2_ALG0_STAGE0_A1_ADDR                102
#define MOD_B0_HPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99953549616067)
#define MOD_B0_HPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_HPF2 - General Eq (2nd order)*/
#define MOD_B1_HPF2_COUNT                              5
#define MOD_B1_HPF2_DEVICE                             "IC1"
#define MOD_B1_HPF2_ALG0_STAGE0_B2_ADDR                103
#define MOD_B1_HPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_HPF2_ALG0_STAGE0_B1_ADDR                104
#define MOD_B1_HPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99814156723514)
#define MOD_B1_HPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_HPF2_ALG0_STAGE0_B0_ADDR                105
#define MOD_B1_HPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_HPF2_ALG0_STAGE0_A2_ADDR                106
#define MOD_B1_HPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B1_HPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_HPF2_ALG0_STAGE0_A1_ADDR                107
#define MOD_B1_HPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B1_HPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_HPF2 - General Eq (2nd order)*/
#define MOD_B2_HPF2_COUNT                              5
#define MOD_B2_HPF2_DEVICE                             "IC1"
#define MOD_B2_HPF2_ALG0_STAGE0_B2_ADDR                108
#define MOD_B2_HPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_HPF2_ALG0_STAGE0_B1_ADDR                109
#define MOD_B2_HPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99067421396581)
#define MOD_B2_HPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_HPF2_ALG0_STAGE0_B0_ADDR                110
#define MOD_B2_HPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_HPF2_ALG0_STAGE0_A2_ADDR                111
#define MOD_B2_HPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B2_HPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_HPF2_ALG0_STAGE0_A1_ADDR                112
#define MOD_B2_HPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B2_HPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_HPF2 - General Eq (2nd order)*/
#define MOD_B3_HPF2_COUNT                              5
#define MOD_B3_HPF2_DEVICE                             "IC1"
#define MOD_B3_HPF2_ALG0_STAGE0_B2_ADDR                113
#define MOD_B3_HPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_HPF2_ALG0_STAGE0_B1_ADDR                114
#define MOD_B3_HPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.92816582584575)
#define MOD_B3_HPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_HPF2_ALG0_STAGE0_B0_ADDR                115
#define MOD_B3_HPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_HPF2_ALG0_STAGE0_A2_ADDR                116
#define MOD_B3_HPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B3_HPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_HPF2_ALG0_STAGE0_A1_ADDR                117
#define MOD_B3_HPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B3_HPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_HPF3 - General Eq (2nd order)*/
#define MOD_B0_HPF3_COUNT                              5
#define MOD_B0_HPF3_DEVICE                             "IC1"
#define MOD_B0_HPF3_ALG0_STAGE0_B2_ADDR                118
#define MOD_B0_HPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_HPF3_ALG0_STAGE0_B1_ADDR                119
#define MOD_B0_HPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99953571029508)
#define MOD_B0_HPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_HPF3_ALG0_STAGE0_B0_ADDR                120
#define MOD_B0_HPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999767855147541)
#define MOD_B0_HPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_HPF3_ALG0_STAGE0_A2_ADDR                121
#define MOD_B0_HPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.9995359244295)
#define MOD_B0_HPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_HPF3_ALG0_STAGE0_A1_ADDR                122
#define MOD_B0_HPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99953549616067)
#define MOD_B0_HPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_HPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_HPF3 - General Eq (2nd order)*/
#define MOD_B1_HPF3_COUNT                              5
#define MOD_B1_HPF3_DEVICE                             "IC1"
#define MOD_B1_HPF3_ALG0_STAGE0_B2_ADDR                123
#define MOD_B1_HPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_HPF3_ALG0_STAGE0_B1_ADDR                124
#define MOD_B1_HPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99814156723514)
#define MOD_B1_HPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_HPF3_ALG0_STAGE0_B0_ADDR                125
#define MOD_B1_HPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.999070783617568)
#define MOD_B1_HPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_HPF3_ALG0_STAGE0_A2_ADDR                126
#define MOD_B1_HPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B1_HPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_HPF3_ALG0_STAGE0_A1_ADDR                127
#define MOD_B1_HPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B1_HPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_HPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_HPF3 - General Eq (2nd order)*/
#define MOD_B2_HPF3_COUNT                              5
#define MOD_B2_HPF3_DEVICE                             "IC1"
#define MOD_B2_HPF3_ALG0_STAGE0_B2_ADDR                128
#define MOD_B2_HPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_HPF3_ALG0_STAGE0_B1_ADDR                129
#define MOD_B2_HPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.99067421396581)
#define MOD_B2_HPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_HPF3_ALG0_STAGE0_B0_ADDR                130
#define MOD_B2_HPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.995337106982905)
#define MOD_B2_HPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_HPF3_ALG0_STAGE0_A2_ADDR                131
#define MOD_B2_HPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B2_HPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_HPF3_ALG0_STAGE0_A1_ADDR                132
#define MOD_B2_HPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B2_HPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_HPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_HPF3 - General Eq (2nd order)*/
#define MOD_B3_HPF3_COUNT                              5
#define MOD_B3_HPF3_DEVICE                             "IC1"
#define MOD_B3_HPF3_ALG0_STAGE0_B2_ADDR                133
#define MOD_B3_HPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_HPF3_ALG0_STAGE0_B1_ADDR                134
#define MOD_B3_HPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-1.92816582584575)
#define MOD_B3_HPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_HPF3_ALG0_STAGE0_B0_ADDR                135
#define MOD_B3_HPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.964082912922874)
#define MOD_B3_HPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_HPF3_ALG0_STAGE0_A2_ADDR                136
#define MOD_B3_HPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B3_HPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_HPF3_ALG0_STAGE0_A1_ADDR                137
#define MOD_B3_HPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B3_HPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_HPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_LPF0 - General Eq (2nd order)*/
#define MOD_B0_LPF0_COUNT                              5
#define MOD_B0_LPF0_DEVICE                             "IC1"
#define MOD_B0_LPF0_ALG0_STAGE0_B2_ADDR                138
#define MOD_B0_LPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_LPF0_ALG0_STAGE0_B1_ADDR                139
#define MOD_B0_LPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(3.42376550928017E-06)
#define MOD_B0_LPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_LPF0_ALG0_STAGE0_B0_ADDR                140
#define MOD_B0_LPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_LPF0_ALG0_STAGE0_A2_ADDR                141
#define MOD_B0_LPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B0_LPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_LPF0_ALG0_STAGE0_A1_ADDR                142
#define MOD_B0_LPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B0_LPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_LPF0 - General Eq (2nd order)*/
#define MOD_B1_LPF0_COUNT                              5
#define MOD_B1_LPF0_DEVICE                             "IC1"
#define MOD_B1_LPF0_ALG0_STAGE0_B2_ADDR                143
#define MOD_B1_LPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_LPF0_ALG0_STAGE0_B1_ADDR                144
#define MOD_B1_LPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(8.52765975625443E-05)
#define MOD_B1_LPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_LPF0_ALG0_STAGE0_B0_ADDR                145
#define MOD_B1_LPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_LPF0_ALG0_STAGE0_A2_ADDR                146
#define MOD_B1_LPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B1_LPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_LPF0_ALG0_STAGE0_A1_ADDR                147
#define MOD_B1_LPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B1_LPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_LPF0 - General Eq (2nd order)*/
#define MOD_B2_LPF0_COUNT                              5
#define MOD_B2_LPF0_DEVICE                             "IC1"
#define MOD_B2_LPF0_ALG0_STAGE0_B2_ADDR                148
#define MOD_B2_LPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_LPF0_ALG0_STAGE0_B1_ADDR                149
#define MOD_B2_LPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00465352673797905)
#define MOD_B2_LPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_LPF0_ALG0_STAGE0_B0_ADDR                150
#define MOD_B2_LPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_LPF0_ALG0_STAGE0_A2_ADDR                151
#define MOD_B2_LPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B2_LPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_LPF0_ALG0_STAGE0_A1_ADDR                152
#define MOD_B2_LPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B2_LPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_LPF0 - General Eq (2nd order)*/
#define MOD_B3_LPF0_COUNT                              5
#define MOD_B3_LPF0_DEVICE                             "IC1"
#define MOD_B3_LPF0_ALG0_STAGE0_B2_ADDR                153
#define MOD_B3_LPF0_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF0_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF0_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_LPF0_ALG0_STAGE0_B1_ADDR                154
#define MOD_B3_LPF0_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.343229459903521)
#define MOD_B3_LPF0_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF0_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_LPF0_ALG0_STAGE0_B0_ADDR                155
#define MOD_B3_LPF0_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF0_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF0_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_LPF0_ALG0_STAGE0_A2_ADDR                156
#define MOD_B3_LPF0_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.544583578348205)
#define MOD_B3_LPF0_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF0_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_LPF0_ALG0_STAGE0_A1_ADDR                157
#define MOD_B3_LPF0_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.858124658541164)
#define MOD_B3_LPF0_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF0_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_LPF1 - General Eq (2nd order)*/
#define MOD_B0_LPF1_COUNT                              5
#define MOD_B0_LPF1_DEVICE                             "IC1"
#define MOD_B0_LPF1_ALG0_STAGE0_B2_ADDR                158
#define MOD_B0_LPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_LPF1_ALG0_STAGE0_B1_ADDR                159
#define MOD_B0_LPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(3.42376550928017E-06)
#define MOD_B0_LPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_LPF1_ALG0_STAGE0_B0_ADDR                160
#define MOD_B0_LPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_LPF1_ALG0_STAGE0_A2_ADDR                161
#define MOD_B0_LPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B0_LPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_LPF1_ALG0_STAGE0_A1_ADDR                162
#define MOD_B0_LPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B0_LPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_LPF1 - General Eq (2nd order)*/
#define MOD_B1_LPF1_COUNT                              5
#define MOD_B1_LPF1_DEVICE                             "IC1"
#define MOD_B1_LPF1_ALG0_STAGE0_B2_ADDR                163
#define MOD_B1_LPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_LPF1_ALG0_STAGE0_B1_ADDR                164
#define MOD_B1_LPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(8.52765975625443E-05)
#define MOD_B1_LPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_LPF1_ALG0_STAGE0_B0_ADDR                165
#define MOD_B1_LPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_LPF1_ALG0_STAGE0_A2_ADDR                166
#define MOD_B1_LPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B1_LPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_LPF1_ALG0_STAGE0_A1_ADDR                167
#define MOD_B1_LPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B1_LPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_LPF1 - General Eq (2nd order)*/
#define MOD_B2_LPF1_COUNT                              5
#define MOD_B2_LPF1_DEVICE                             "IC1"
#define MOD_B2_LPF1_ALG0_STAGE0_B2_ADDR                168
#define MOD_B2_LPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_LPF1_ALG0_STAGE0_B1_ADDR                169
#define MOD_B2_LPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00465352673797905)
#define MOD_B2_LPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_LPF1_ALG0_STAGE0_B0_ADDR                170
#define MOD_B2_LPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_LPF1_ALG0_STAGE0_A2_ADDR                171
#define MOD_B2_LPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B2_LPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_LPF1_ALG0_STAGE0_A1_ADDR                172
#define MOD_B2_LPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B2_LPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_LPF1 - General Eq (2nd order)*/
#define MOD_B3_LPF1_COUNT                              5
#define MOD_B3_LPF1_DEVICE                             "IC1"
#define MOD_B3_LPF1_ALG0_STAGE0_B2_ADDR                173
#define MOD_B3_LPF1_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF1_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF1_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_LPF1_ALG0_STAGE0_B1_ADDR                174
#define MOD_B3_LPF1_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.343229459903521)
#define MOD_B3_LPF1_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF1_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_LPF1_ALG0_STAGE0_B0_ADDR                175
#define MOD_B3_LPF1_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF1_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF1_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_LPF1_ALG0_STAGE0_A2_ADDR                176
#define MOD_B3_LPF1_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.544583578348205)
#define MOD_B3_LPF1_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF1_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_LPF1_ALG0_STAGE0_A1_ADDR                177
#define MOD_B3_LPF1_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.858124658541164)
#define MOD_B3_LPF1_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF1_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_LPF2 - General Eq (2nd order)*/
#define MOD_B0_LPF2_COUNT                              5
#define MOD_B0_LPF2_DEVICE                             "IC1"
#define MOD_B0_LPF2_ALG0_STAGE0_B2_ADDR                178
#define MOD_B0_LPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_LPF2_ALG0_STAGE0_B1_ADDR                179
#define MOD_B0_LPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(3.42376550928017E-06)
#define MOD_B0_LPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_LPF2_ALG0_STAGE0_B0_ADDR                180
#define MOD_B0_LPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_LPF2_ALG0_STAGE0_A2_ADDR                181
#define MOD_B0_LPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B0_LPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_LPF2_ALG0_STAGE0_A1_ADDR                182
#define MOD_B0_LPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B0_LPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_LPF2 - General Eq (2nd order)*/
#define MOD_B1_LPF2_COUNT                              5
#define MOD_B1_LPF2_DEVICE                             "IC1"
#define MOD_B1_LPF2_ALG0_STAGE0_B2_ADDR                183
#define MOD_B1_LPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_LPF2_ALG0_STAGE0_B1_ADDR                184
#define MOD_B1_LPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(8.52765975625443E-05)
#define MOD_B1_LPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_LPF2_ALG0_STAGE0_B0_ADDR                185
#define MOD_B1_LPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_LPF2_ALG0_STAGE0_A2_ADDR                186
#define MOD_B1_LPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B1_LPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_LPF2_ALG0_STAGE0_A1_ADDR                187
#define MOD_B1_LPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B1_LPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_LPF2 - General Eq (2nd order)*/
#define MOD_B2_LPF2_COUNT                              5
#define MOD_B2_LPF2_DEVICE                             "IC1"
#define MOD_B2_LPF2_ALG0_STAGE0_B2_ADDR                188
#define MOD_B2_LPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_LPF2_ALG0_STAGE0_B1_ADDR                189
#define MOD_B2_LPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00465352673797905)
#define MOD_B2_LPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_LPF2_ALG0_STAGE0_B0_ADDR                190
#define MOD_B2_LPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_LPF2_ALG0_STAGE0_A2_ADDR                191
#define MOD_B2_LPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B2_LPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_LPF2_ALG0_STAGE0_A1_ADDR                192
#define MOD_B2_LPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B2_LPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_LPF2 - General Eq (2nd order)*/
#define MOD_B3_LPF2_COUNT                              5
#define MOD_B3_LPF2_DEVICE                             "IC1"
#define MOD_B3_LPF2_ALG0_STAGE0_B2_ADDR                193
#define MOD_B3_LPF2_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF2_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF2_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_LPF2_ALG0_STAGE0_B1_ADDR                194
#define MOD_B3_LPF2_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.343229459903521)
#define MOD_B3_LPF2_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF2_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_LPF2_ALG0_STAGE0_B0_ADDR                195
#define MOD_B3_LPF2_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF2_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF2_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_LPF2_ALG0_STAGE0_A2_ADDR                196
#define MOD_B3_LPF2_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.544583578348205)
#define MOD_B3_LPF2_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF2_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_LPF2_ALG0_STAGE0_A1_ADDR                197
#define MOD_B3_LPF2_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.858124658541164)
#define MOD_B3_LPF2_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF2_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_LPF3 - General Eq (2nd order)*/
#define MOD_B0_LPF3_COUNT                              5
#define MOD_B0_LPF3_DEVICE                             "IC1"
#define MOD_B0_LPF3_ALG0_STAGE0_B2_ADDR                198
#define MOD_B0_LPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B0_LPF3_ALG0_STAGE0_B1_ADDR                199
#define MOD_B0_LPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(3.42376550928017E-06)
#define MOD_B0_LPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B0_LPF3_ALG0_STAGE0_B0_ADDR                200
#define MOD_B0_LPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.71188275464009E-06)
#define MOD_B0_LPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B0_LPF3_ALG0_STAGE0_A2_ADDR                201
#define MOD_B0_LPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.998144991000645)
#define MOD_B0_LPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B0_LPF3_ALG0_STAGE0_A1_ADDR                202
#define MOD_B0_LPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99813814346963)
#define MOD_B0_LPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B0_LPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B1_LPF3 - General Eq (2nd order)*/
#define MOD_B1_LPF3_COUNT                              5
#define MOD_B1_LPF3_DEVICE                             "IC1"
#define MOD_B1_LPF3_ALG0_STAGE0_B2_ADDR                203
#define MOD_B1_LPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B1_LPF3_ALG0_STAGE0_B1_ADDR                204
#define MOD_B1_LPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(8.52765975625443E-05)
#define MOD_B1_LPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B1_LPF3_ALG0_STAGE0_B0_ADDR                205
#define MOD_B1_LPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(4.26382987812722E-05)
#define MOD_B1_LPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B1_LPF3_ALG0_STAGE0_A2_ADDR                206
#define MOD_B1_LPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.990759490563372)
#define MOD_B1_LPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B1_LPF3_ALG0_STAGE0_A1_ADDR                207
#define MOD_B1_LPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.99058893736825)
#define MOD_B1_LPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B1_LPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B2_LPF3 - General Eq (2nd order)*/
#define MOD_B2_LPF3_COUNT                              5
#define MOD_B2_LPF3_DEVICE                             "IC1"
#define MOD_B2_LPF3_ALG0_STAGE0_B2_ADDR                208
#define MOD_B2_LPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B2_LPF3_ALG0_STAGE0_B1_ADDR                209
#define MOD_B2_LPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00465352673797905)
#define MOD_B2_LPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B2_LPF3_ALG0_STAGE0_B0_ADDR                210
#define MOD_B2_LPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.00232676336898953)
#define MOD_B2_LPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B2_LPF3_ALG0_STAGE0_A2_ADDR                211
#define MOD_B2_LPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.932819352583727)
#define MOD_B2_LPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B2_LPF3_ALG0_STAGE0_A1_ADDR                212
#define MOD_B2_LPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(1.92351229910777)
#define MOD_B2_LPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B2_LPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B3_LPF3 - General Eq (2nd order)*/
#define MOD_B3_LPF3_COUNT                              5
#define MOD_B3_LPF3_DEVICE                             "IC1"
#define MOD_B3_LPF3_ALG0_STAGE0_B2_ADDR                213
#define MOD_B3_LPF3_ALG0_STAGE0_B2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF3_ALG0_STAGE0_B2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF3_ALG0_STAGE0_B2_MEMORYPAGE          0
#define MOD_B3_LPF3_ALG0_STAGE0_B1_ADDR                214
#define MOD_B3_LPF3_ALG0_STAGE0_B1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.343229459903521)
#define MOD_B3_LPF3_ALG0_STAGE0_B1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF3_ALG0_STAGE0_B1_MEMORYPAGE          0
#define MOD_B3_LPF3_ALG0_STAGE0_B0_ADDR                215
#define MOD_B3_LPF3_ALG0_STAGE0_B0_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.17161472995176)
#define MOD_B3_LPF3_ALG0_STAGE0_B0_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF3_ALG0_STAGE0_B0_MEMORYPAGE          0
#define MOD_B3_LPF3_ALG0_STAGE0_A2_ADDR                216
#define MOD_B3_LPF3_ALG0_STAGE0_A2_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(-0.544583578348205)
#define MOD_B3_LPF3_ALG0_STAGE0_A2_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF3_ALG0_STAGE0_A2_MEMORYPAGE          0
#define MOD_B3_LPF3_ALG0_STAGE0_A1_ADDR                217
#define MOD_B3_LPF3_ALG0_STAGE0_A1_VALUE               SIGMASTUDIOTYPE_8_24_CONVERT(0.858124658541164)
#define MOD_B3_LPF3_ALG0_STAGE0_A1_TYPE                SIGMASTUDIOTYPE_8_24
#define MOD_B3_LPF3_ALG0_STAGE0_A1_MEMORYPAGE          0

/* Module B0_GEN0 - General Eq (2nd order)*/
#define MOD_B0_GEN0_COUNT                              6
#define MOD_B0_GEN0_DEVICE                             "IC1"
#define MOD_B0_GEN0_ALG0_SLEWMODE_ADDR                 223
#define MOD_B0_GEN0_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B0_GEN0_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B0_GEN0_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B0_GEN0_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB210_ADDR 24617
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1.36670676166497)
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB210_MEMORYPAGE 0
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB211_ADDR 24618
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(-2.77853575732203)
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB211_MEMORYPAGE 0
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB212_ADDR 24619
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1.41779081871859)
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB212_MEMORYPAGE 0
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB213_ADDR 24620
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(-0.971273323660371)
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB213_MEMORYPAGE 0
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB214_ADDR 24621
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1.96705267615672)
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG4TARGB214_MEMORYPAGE 0

/* Module B1_GEN0 - General Eq (2nd order)*/
#define MOD_B1_GEN0_COUNT                              6
#define MOD_B1_GEN0_DEVICE                             "IC1"
#define MOD_B1_GEN0_ALG0_SLEWMODE_ADDR                 229
#define MOD_B1_GEN0_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B1_GEN0_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B1_GEN0_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B1_GEN0_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB210_ADDR 24622
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB210_MEMORYPAGE 0
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB211_ADDR 24623
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB211_MEMORYPAGE 0
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB212_ADDR 24624
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB212_MEMORYPAGE 0
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB213_ADDR 24625
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB213_MEMORYPAGE 0
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB214_ADDR 24626
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG7TARGB214_MEMORYPAGE 0

/* Module B2_GEN0 - General Eq (2nd order)*/
#define MOD_B2_GEN0_COUNT                              6
#define MOD_B2_GEN0_DEVICE                             "IC1"
#define MOD_B2_GEN0_ALG0_SLEWMODE_ADDR                 235
#define MOD_B2_GEN0_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B2_GEN0_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B2_GEN0_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B2_GEN0_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB210_ADDR 24627
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB210_MEMORYPAGE 0
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB211_ADDR 24628
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB211_MEMORYPAGE 0
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB212_ADDR 24629
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB212_MEMORYPAGE 0
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB213_ADDR 24630
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB213_MEMORYPAGE 0
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB214_ADDR 24631
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG10TARGB214_MEMORYPAGE 0

/* Module B3_GEN0 - General Eq (2nd order)*/
#define MOD_B3_GEN0_COUNT                              6
#define MOD_B3_GEN0_DEVICE                             "IC1"
#define MOD_B3_GEN0_ALG0_SLEWMODE_ADDR                 241
#define MOD_B3_GEN0_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B3_GEN0_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B3_GEN0_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B3_GEN0_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB210_ADDR 24632
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB210_MEMORYPAGE 0
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB211_ADDR 24633
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB211_MEMORYPAGE 0
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB212_ADDR 24634
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB212_MEMORYPAGE 0
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB213_ADDR 24635
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB213_MEMORYPAGE 0
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB214_ADDR 24636
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN0_ALG0_EQS300MULTIDPHWSLEWP1ALG13TARGB214_MEMORYPAGE 0

/* Module B0_GEN1 - General Eq (2nd order)*/
#define MOD_B0_GEN1_COUNT                              6
#define MOD_B0_GEN1_DEVICE                             "IC1"
#define MOD_B0_GEN1_ALG0_SLEWMODE_ADDR                 247
#define MOD_B0_GEN1_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B0_GEN1_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B0_GEN1_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B0_GEN1_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB210_ADDR 24637
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB210_MEMORYPAGE 0
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB211_ADDR 24638
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB211_MEMORYPAGE 0
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB212_ADDR 24639
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB212_MEMORYPAGE 0
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB213_ADDR 24640
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB213_MEMORYPAGE 0
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB214_ADDR 24641
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG5TARGB214_MEMORYPAGE 0

/* Module B1_GEN1 - General Eq (2nd order)*/
#define MOD_B1_GEN1_COUNT                              6
#define MOD_B1_GEN1_DEVICE                             "IC1"
#define MOD_B1_GEN1_ALG0_SLEWMODE_ADDR                 253
#define MOD_B1_GEN1_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B1_GEN1_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B1_GEN1_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B1_GEN1_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB210_ADDR 24642
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB210_MEMORYPAGE 0
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB211_ADDR 24643
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB211_MEMORYPAGE 0
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB212_ADDR 24644
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB212_MEMORYPAGE 0
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB213_ADDR 24645
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB213_MEMORYPAGE 0
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB214_ADDR 24646
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG8TARGB214_MEMORYPAGE 0

/* Module B2_GEN1 - General Eq (2nd order)*/
#define MOD_B2_GEN1_COUNT                              6
#define MOD_B2_GEN1_DEVICE                             "IC1"
#define MOD_B2_GEN1_ALG0_SLEWMODE_ADDR                 259
#define MOD_B2_GEN1_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B2_GEN1_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B2_GEN1_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B2_GEN1_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB210_ADDR 24647
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB210_MEMORYPAGE 0
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB211_ADDR 24648
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB211_MEMORYPAGE 0
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB212_ADDR 24649
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB212_MEMORYPAGE 0
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB213_ADDR 24650
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB213_MEMORYPAGE 0
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB214_ADDR 24651
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG11TARGB214_MEMORYPAGE 0

/* Module B3_GEN1 - General Eq (2nd order)*/
#define MOD_B3_GEN1_COUNT                              6
#define MOD_B3_GEN1_DEVICE                             "IC1"
#define MOD_B3_GEN1_ALG0_SLEWMODE_ADDR                 265
#define MOD_B3_GEN1_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B3_GEN1_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B3_GEN1_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B3_GEN1_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB210_ADDR 24652
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB210_MEMORYPAGE 0
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB211_ADDR 24653
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB211_MEMORYPAGE 0
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB212_ADDR 24654
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB212_MEMORYPAGE 0
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB213_ADDR 24655
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB213_MEMORYPAGE 0
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB214_ADDR 24656
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN1_ALG0_EQS300MULTIDPHWSLEWP1ALG14TARGB214_MEMORYPAGE 0

/* Module B0_GEN2 - General Eq (2nd order)*/
#define MOD_B0_GEN2_COUNT                              6
#define MOD_B0_GEN2_DEVICE                             "IC1"
#define MOD_B0_GEN2_ALG0_SLEWMODE_ADDR                 271
#define MOD_B0_GEN2_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B0_GEN2_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B0_GEN2_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B0_GEN2_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB210_ADDR 24657
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB210_MEMORYPAGE 0
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB211_ADDR 24658
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB211_MEMORYPAGE 0
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB212_ADDR 24659
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB212_MEMORYPAGE 0
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB213_ADDR 24660
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB213_MEMORYPAGE 0
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB214_ADDR 24661
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B0_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG6TARGB214_MEMORYPAGE 0

/* Module B1_GEN2 - General Eq (2nd order)*/
#define MOD_B1_GEN2_COUNT                              6
#define MOD_B1_GEN2_DEVICE                             "IC1"
#define MOD_B1_GEN2_ALG0_SLEWMODE_ADDR                 277
#define MOD_B1_GEN2_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B1_GEN2_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B1_GEN2_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B1_GEN2_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB210_ADDR 24662
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB210_MEMORYPAGE 0
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB211_ADDR 24663
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB211_MEMORYPAGE 0
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB212_ADDR 24664
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB212_MEMORYPAGE 0
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB213_ADDR 24665
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB213_MEMORYPAGE 0
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB214_ADDR 24666
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B1_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG9TARGB214_MEMORYPAGE 0

/* Module B2_GEN2 - General Eq (2nd order)*/
#define MOD_B2_GEN2_COUNT                              6
#define MOD_B2_GEN2_DEVICE                             "IC1"
#define MOD_B2_GEN2_ALG0_SLEWMODE_ADDR                 283
#define MOD_B2_GEN2_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B2_GEN2_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B2_GEN2_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B2_GEN2_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB210_ADDR 24667
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB210_MEMORYPAGE 0
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB211_ADDR 24668
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB211_MEMORYPAGE 0
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB212_ADDR 24669
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB212_MEMORYPAGE 0
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB213_ADDR 24670
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB213_MEMORYPAGE 0
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB214_ADDR 24671
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B2_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG12TARGB214_MEMORYPAGE 0

/* Module B3_GEN2 - General Eq (2nd order)*/
#define MOD_B3_GEN2_COUNT                              6
#define MOD_B3_GEN2_DEVICE                             "IC1"
#define MOD_B3_GEN2_ALG0_SLEWMODE_ADDR                 289
#define MOD_B3_GEN2_ALG0_SLEWMODE_FIXPT                0x0000208A
#define MOD_B3_GEN2_ALG0_SLEWMODE_VALUE                SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_B3_GEN2_ALG0_SLEWMODE_TYPE                 SIGMASTUDIOTYPE_INTEGER
#define MOD_B3_GEN2_ALG0_SLEWMODE_MEMORYPAGE           0
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB210_ADDR 24672
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB210_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB210_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB210_MEMORYPAGE 0
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB211_ADDR 24673
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB211_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB211_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB211_MEMORYPAGE 0
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB212_ADDR 24674
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB212_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB212_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB212_MEMORYPAGE 0
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB213_ADDR 24675
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB213_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB213_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB213_MEMORYPAGE 0
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB214_ADDR 24676
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB214_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB214_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_B3_GEN2_ALG0_EQS300MULTIDPHWSLEWP1ALG15TARGB214_MEMORYPAGE 0

/* Module BO_DEL - Delay*/
#define MOD_BO_DEL_COUNT                               1
#define MOD_BO_DEL_DEVICE                              "IC1"
#define MOD_BO_DEL_DELAYAMT_ADDR                       290
#define MOD_BO_DEL_DELAYAMT_FIXPT                      0x0000000A
#define MOD_BO_DEL_DELAYAMT_VALUE                      SIGMASTUDIOTYPE_INTEGER_CONVERT(10)
#define MOD_BO_DEL_DELAYAMT_TYPE                       SIGMASTUDIOTYPE_INTEGER
#define MOD_BO_DEL_DELAYAMT_MEMORYPAGE                 0

/* Module B3_DEL - Delay*/
#define MOD_B3_DEL_COUNT                               1
#define MOD_B3_DEL_DEVICE                              "IC1"
#define MOD_B3_DEL_DELAYAMT_ADDR                       291
#define MOD_B3_DEL_DELAYAMT_FIXPT                      0x00000028
#define MOD_B3_DEL_DELAYAMT_VALUE                      SIGMASTUDIOTYPE_INTEGER_CONVERT(40)
#define MOD_B3_DEL_DELAYAMT_TYPE                       SIGMASTUDIOTYPE_INTEGER
#define MOD_B3_DEL_DELAYAMT_MEMORYPAGE                 0

/* Module B2_DEL - Delay*/
#define MOD_B2_DEL_COUNT                               1
#define MOD_B2_DEL_DEVICE                              "IC1"
#define MOD_B2_DEL_DELAYAMT_ADDR                       292
#define MOD_B2_DEL_DELAYAMT_FIXPT                      0x0000001E
#define MOD_B2_DEL_DELAYAMT_VALUE                      SIGMASTUDIOTYPE_INTEGER_CONVERT(30)
#define MOD_B2_DEL_DELAYAMT_TYPE                       SIGMASTUDIOTYPE_INTEGER
#define MOD_B2_DEL_DELAYAMT_MEMORYPAGE                 0

/* Module B1_DEL - Delay*/
#define MOD_B1_DEL_COUNT                               1
#define MOD_B1_DEL_DEVICE                              "IC1"
#define MOD_B1_DEL_DELAYAMT_ADDR                       293
#define MOD_B1_DEL_DELAYAMT_FIXPT                      0x00000014
#define MOD_B1_DEL_DELAYAMT_VALUE                      SIGMASTUDIOTYPE_INTEGER_CONVERT(20)
#define MOD_B1_DEL_DELAYAMT_TYPE                       SIGMASTUDIOTYPE_INTEGER
#define MOD_B1_DEL_DELAYAMT_MEMORYPAGE                 0

/* Module Bridge_Sw - Stereo Switch Nx2*/
#define MOD_BRIDGE_SW_COUNT                            3
#define MOD_BRIDGE_SW_DEVICE                           "IC1"
#define MOD_BRIDGE_SW_ALG0_SLEW_MODE_ADDR              294
#define MOD_BRIDGE_SW_ALG0_SLEW_MODE_FIXPT             0x0000208A
#define MOD_BRIDGE_SW_ALG0_SLEW_MODE_VALUE             SIGMASTUDIOTYPE_INTEGER_CONVERT(8330)
#define MOD_BRIDGE_SW_ALG0_SLEW_MODE_TYPE              SIGMASTUDIOTYPE_INTEGER
#define MOD_BRIDGE_SW_ALG0_SLEW_MODE_MEMORYPAGE        0
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL00_ADDR 580
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL00_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL00_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL00_MEMORYPAGE 0
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL01_ADDR 581
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL01_VALUE SIGMASTUDIOTYPE_8_24_CONVERT(0)
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL01_TYPE SIGMASTUDIOTYPE_8_24
#define MOD_BRIDGE_SW_ALG0_STEREOMUXSIGMA3001VOL01_MEMORYPAGE 0

/* Module Input_Sel_MCH_SPDIF_ADC - Stereo Switch Nx2*/
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_COUNT              1
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_DEVICE             "IC1"
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_ADDR 295
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_FIXPT 0x00000002
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_VALUE SIGMASTUDIOTYPE_INTEGER_CONVERT(2)
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_TYPE SIGMASTUDIOTYPE_INTEGER
#define MOD_INPUT_SEL_MCH_SPDIF_ADC_STEREOMUXSIGMA300NS4INDEX_MEMORYPAGE 0

/* Module Monitor_Sel_SPDIF_ADC - Stereo Switch Nx2*/
#define MOD_MONITOR_SEL_SPDIF_ADC_COUNT                1
#define MOD_MONITOR_SEL_SPDIF_ADC_DEVICE               "IC1"
#define MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_ADDR 584
#define MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_FIXPT 0x00000002
#define MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_VALUE SIGMASTUDIOTYPE_INTEGER_CONVERT(2)
#define MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_TYPE SIGMASTUDIOTYPE_INTEGER
#define MOD_MONITOR_SEL_SPDIF_ADC_STEREOMUXSIGMA300NS2INDEX_MEMORYPAGE 0

/* Module B0_VOL - Multiple Volume Control*/
#define MOD_B0_VOL_COUNT                               2
#define MOD_B0_VOL_DEVICE                              "IC1"
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_ADDR        585
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_MEMORYPAGE  0
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_ADDR        585
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B0_VOL_ALG0_GAINALGNS145X1GAIN_MEMORYPAGE  0

/* Module B1_VOL - Multiple Volume Control*/
#define MOD_B1_VOL_COUNT                               2
#define MOD_B1_VOL_DEVICE                              "IC1"
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_ADDR        586
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_MEMORYPAGE  0
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_ADDR        586
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B1_VOL_ALG0_GAINALGNS145X2GAIN_MEMORYPAGE  0

/* Module B3_VOL - Multiple Volume Control*/
#define MOD_B3_VOL_COUNT                               2
#define MOD_B3_VOL_DEVICE                              "IC1"
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_ADDR        587
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_MEMORYPAGE  0
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_ADDR        587
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B3_VOL_ALG0_GAINALGNS145X4GAIN_MEMORYPAGE  0

/* Module B2_VOL - Multiple Volume Control*/
#define MOD_B2_VOL_COUNT                               2
#define MOD_B2_VOL_DEVICE                              "IC1"
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_ADDR        588
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_MEMORYPAGE  0
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_ADDR        588
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_VALUE       SIGMASTUDIOTYPE_8_24_CONVERT(0.0001)
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_TYPE        SIGMASTUDIOTYPE_8_24
#define MOD_B2_VOL_ALG0_GAINALGNS145X3GAIN_MEMORYPAGE  0

/* Module B1_Inv_0 - Gain*/
#define MOD_B1_INV_0_COUNT                             1
#define MOD_B1_INV_0_DEVICE                            "IC1"
#define MOD_B1_INV_0_GAINALGNS145X5GAIN_ADDR           589
#define MOD_B1_INV_0_GAINALGNS145X5GAIN_VALUE          SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B1_INV_0_GAINALGNS145X5GAIN_TYPE           SIGMASTUDIOTYPE_8_24
#define MOD_B1_INV_0_GAINALGNS145X5GAIN_MEMORYPAGE     0

/* Module B1_Inv_1 - Gain*/
#define MOD_B1_INV_1_COUNT                             1
#define MOD_B1_INV_1_DEVICE                            "IC1"
#define MOD_B1_INV_1_GAINALGNS145X6GAIN_ADDR           590
#define MOD_B1_INV_1_GAINALGNS145X6GAIN_VALUE          SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B1_INV_1_GAINALGNS145X6GAIN_TYPE           SIGMASTUDIOTYPE_8_24
#define MOD_B1_INV_1_GAINALGNS145X6GAIN_MEMORYPAGE     0

/* Module B0_Inv_0 - Gain*/
#define MOD_B0_INV_0_COUNT                             1
#define MOD_B0_INV_0_DEVICE                            "IC1"
#define MOD_B0_INV_0_GAINALGNS145X7GAIN_ADDR           591
#define MOD_B0_INV_0_GAINALGNS145X7GAIN_VALUE          SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B0_INV_0_GAINALGNS145X7GAIN_TYPE           SIGMASTUDIOTYPE_8_24
#define MOD_B0_INV_0_GAINALGNS145X7GAIN_MEMORYPAGE     0

/* Module B0_Inv_1 - Gain*/
#define MOD_B0_INV_1_COUNT                             1
#define MOD_B0_INV_1_DEVICE                            "IC1"
#define MOD_B0_INV_1_GAINALGNS145X8GAIN_ADDR           592
#define MOD_B0_INV_1_GAINALGNS145X8GAIN_VALUE          SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B0_INV_1_GAINALGNS145X8GAIN_TYPE           SIGMASTUDIOTYPE_8_24
#define MOD_B0_INV_1_GAINALGNS145X8GAIN_MEMORYPAGE     0

/* Module B2_Inv_0 - Gain*/
#define MOD_B2_INV_0_COUNT                             1
#define MOD_B2_INV_0_DEVICE                            "IC1"
#define MOD_B2_INV_0_GAINALGNS145X9GAIN_ADDR           593
#define MOD_B2_INV_0_GAINALGNS145X9GAIN_VALUE          SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B2_INV_0_GAINALGNS145X9GAIN_TYPE           SIGMASTUDIOTYPE_8_24
#define MOD_B2_INV_0_GAINALGNS145X9GAIN_MEMORYPAGE     0

/* Module B2_Inv_1 - Gain*/
#define MOD_B2_INV_1_COUNT                             1
#define MOD_B2_INV_1_DEVICE                            "IC1"
#define MOD_B2_INV_1_GAINALGNS145X10GAIN_ADDR          594
#define MOD_B2_INV_1_GAINALGNS145X10GAIN_VALUE         SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B2_INV_1_GAINALGNS145X10GAIN_TYPE          SIGMASTUDIOTYPE_8_24
#define MOD_B2_INV_1_GAINALGNS145X10GAIN_MEMORYPAGE    0

/* Module B3_Inv_0 - Gain*/
#define MOD_B3_INV_0_COUNT                             1
#define MOD_B3_INV_0_DEVICE                            "IC1"
#define MOD_B3_INV_0_GAINALGNS145X11GAIN_ADDR          595
#define MOD_B3_INV_0_GAINALGNS145X11GAIN_VALUE         SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B3_INV_0_GAINALGNS145X11GAIN_TYPE          SIGMASTUDIOTYPE_8_24
#define MOD_B3_INV_0_GAINALGNS145X11GAIN_MEMORYPAGE    0

/* Module B3_Inv_1 - Gain*/
#define MOD_B3_INV_1_COUNT                             1
#define MOD_B3_INV_1_DEVICE                            "IC1"
#define MOD_B3_INV_1_GAINALGNS145X12GAIN_ADDR          596
#define MOD_B3_INV_1_GAINALGNS145X12GAIN_VALUE         SIGMASTUDIOTYPE_8_24_CONVERT(1)
#define MOD_B3_INV_1_GAINALGNS145X12GAIN_TYPE          SIGMASTUDIOTYPE_8_24
#define MOD_B3_INV_1_GAINALGNS145X12GAIN_MEMORYPAGE    0

/* Module IndirectParamAccessModule - IndirectParamAccessModule*/
#define MOD_INDIRECTPARAMACCESSMODULE_COUNT            17
#define MOD_INDIRECTPARAMACCESSMODULE_DEVICE           "IC1"
#define MOD_INDIRECTPARAMACCESSMODULE_START_ADDRESS_ADDR 24584
#define MOD_INDIRECTPARAMACCESSMODULE_START_ADDRESS_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_NUM_OF_LOADS_AND_TRIGGER_ADDR 24585
#define MOD_INDIRECTPARAMACCESSMODULE_NUM_OF_LOADS_AND_TRIGGER_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_SLEW_MODE_ADDR 24586
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_SLEW_MODE_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_VOL0_ADDR 24587
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_VOL0_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_VOL1_ADDR 24588
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_VOL1_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_CUR0_ADDR 24589
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_CUR0_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_CUR1_ADDR 24590
#define MOD_INDIRECTPARAMACCESSMODULE_BRIDGE_SW_CUR1_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES0_ADDR  24591
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES0_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES1_ADDR  24592
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES1_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES2_ADDR  24593
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES2_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES3_ADDR  24594
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES3_MEMORYPAGE 0
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES4_ADDR  24595
#define MOD_INDIRECTPARAMACCESSMODULE_ADDRESSES4_MEMORYPAGE 0

#endif
