/******************************************************************************/
/******************************************************************************/
/*                                                                            */
/*    ADAU Related HEader items                                               */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/

//Typedefs
typedef unsigned short ADI_DATA_U16;
typedef const unsigned char  ADI_REG_TYPE;

// macros etc

#define ADAU_CselLow SYS_PORTS_Clear(PORTS_ID_0, ADAU_CSEL_PORT, ADAU_CSel_Bit)
#define ADAU_CselHigh SYS_PORTS_Set(PORTS_ID_0, ADAU_CSEL_PORT, ADAU_CSel_Bit, ADAU_CSel_Bit)
// moved to control.h #define ADAU_SPI_Port SPI_ID_2           // EEPROM on SPI 2

/* safeload data */
#define Safeload_Addr_Lower MOD_SAFELOADMODULE_NUM_SAFELOAD_LOWER_ADDR 
#define Safeload_Upper_Lower MOD_SAFELOADMODULE_NUM_SAFELOAD_UPPER_ADDR 



#define Write_8_Bits(Data_Word) WriteSPI(Data_Word,8)
#define Write_16_Bits(Data_Word) WriteSPI((Data_Word&0xFF00)>>8,8); WriteSPI((Data_Word&0xFF),8);
#define Write_16_Bits_Addr(Data_Word) WriteSPI((Data_Word&0xFF00)>>8,8); WriteSPI((Data_Word&0xFF),8);
#define Write_32_Bits(Data_Word) WriteSPI((Data_Word&0xFF000000)>>24,8); WriteSPI((Data_Word&0xFF0000)>>16,8); WriteSPI((Data_Word&0xFF00)>>8,8); WriteSPI((Data_Word&0xFF),8);
#define Write_SPI_Addr(Device_Address, Write_Bit) WriteSPI(((Device_Address << 1)+Write_Bit),8)
#define Write_To_SPI 0
#define Read_From_SPI 1
#define ADAU1467_Address 0

/* Save typing and make things clearer in the code */
#define ClearDSPReset SYS_PORTS_Clear(PORTS_ID_0, ADAU_RESET_PORT, Reset_DSP)
#define SetDSPReset SYS_PORTS_Set(PORTS_ID_0, ADAU_RESET_PORT, Reset_DSP, Reset_DSP)
#define ClearDACReset SYS_PORTS_Clear(PORTS_ID_0, DAC_RESET_PORT, Reset_DAC)
#define SetDACReset SYS_PORTS_Set(PORTS_ID_0, DAC_RESET_PORT, Reset_DAC, Reset_DAC)

#define DAC_Reset_Time 20


/******************************************************************************/
/*   Other defines                                                            */
/******************************************************************************/

/* IIR Parameters */
#define A1 IIR_B0_B1_B2_A1_A2[3]
#define A2 IIR_B0_B1_B2_A1_A2[4]
#define B0 IIR_B0_B1_B2_A1_A2[0]
#define B1 IIR_B0_B1_B2_A1_A2[1]
#define B2 IIR_B0_B1_B2_A1_A2[2]

#define A1_2 IIR2_B0_B1_B2_A1_A2[3]
#define A2_2 IIR2_B0_B1_B2_A1_A2[4]
#define B0_2 IIR2_B0_B1_B2_A1_A2[0]
#define B1_2 IIR2_B0_B1_B2_A1_A2[1]
#define B2_2 IIR2_B0_B1_B2_A1_A2[2]

#define NumBytes_Word_Parms_SW 1  /* single word to write this does nothing*/

/* for Invert channel*/
#define NumBytes_Word_Parms_INV 4  /* single word to write this does nothing*/
#define Output_Normal 0x01000000
#define Output_Inverted 0xFF000000

/* mono / stereo sub */
#define Mono_Sub_Data_0 0x01000000
#define Mono_Sub_Data_1 0x00000000
#define Stereo_Sub_Data_0 0x00000000
#define Stereo_Sub_Data_1 0x01000000
#define NumBytes_Word_Parms_Mono_Sub 8  /* single word to write this does nothing*/
#define Mono_Sub_Slew MOD_BRIDGE_SW_ALG0_SLEW_MODE_FIXPT

/* for DC Block */
#define NumBytes_Word_Parms_DCB 1  /* single word to write this does nothing*/
#define DCB_Value 0x00FFF972

/******************************************************************************/
/******************************************************************************/

extern void WriteSPI(long int, char);

extern void Init_DSP(void);

extern void Write_Filter_Parm(unsigned char, unsigned int, unsigned char, unsigned int, char, char);

void Update_Invert_Set();

void Update_Filter_Set(unsigned int);

void Write_Mono_Sub(char);

void Update_Delay_Set(unsigned int);

void Write_Atten(char, int);

void Write_Delay(unsigned char, int, const unsigned int);

void SIGMA_WRITE_DELAY( char, int, const unsigned char* );


void Write_Dac_Atten(unsigned char);

void ReadSPI(char, int, int, unsigned char *);

void SIGMA_WRITE_REGISTER_BLOCK(char , unsigned int , unsigned int , const unsigned char *);

void Write_Input(char);

void Write_Invert(char, char );

void Init_ADC(void);

void Write_DCBlock(void);

void SIGMA_WRITE_SINGLE_REGISTER(char , unsigned int , int , long int);

void SafeLoad_Write_Single_Parameter(unsigned int, long int, int);

void Update_Atten_Set();
