#include "Adafruit_TinyUSB.h"
#define PS2DT 4
#define PS2CK 5
// in microseconds
#define PS2TMOUT 2000

uint16_t inData=0;
uint8_t bitCt=0;
uint8_t scanCode=0;
uint8_t dt0,dt1,ck0,ck1;
unsigned int t=0;
uint8_t hostTx=0;

const char k[][16]={
"no key","F9","no key","F5","F3","F1","F2","F12","no key","F10","F8","F6","F4","Tab","`~","no key",
"no key","LAlt","LShift","no key","LCtrl","Q","1!","no key","no key","no key","Z","S","A","W","2@","no key",
"no key","C","X","D","E","4$","3#","no key","no key","space","V","F","T","R","5%","no key",
"no key","N","B","H","G","Y","6^","no key","no key","no key","M","J","U","7&","8*","no key",
"no key",",<","K","I","O","0)","9(","no key","no key",".>","/?","L",";:","P","-_","no key",
"no key","no key","'\"","no key","[{","=+","no key","no key","CapsLock","RShift","Enter","]}","no key","\\|","no key","no key",
"no key","no key","no key","no key","no key","no key","Backspace","no key","no key","KP-1 / End","no key","KP-4 / Left","KP-7 / Home","no key","no key","no key",
"KP-0 / Ins","KP-. / Del","KP-2","KP-5","KP-6 / Right","KP-8 / Up","Esc","NumLock","F11","KP-+","KP-3 / PgDn","KP--","KP-*","KP-9","ScrollLock","no key",
"no key","no key","no key","F7","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
"Release","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key","no key",
};

void setup() {
  Serial.begin(115200);
  pinMode(PS2DT,INPUT_PULLUP);
  pinMode(PS2CK,INPUT_PULLUP);
  dt0=1;//idle high
  ck0=1; 
}

uint8_t unHex(uint8_t b){
  if((b>='0')&&(b<='9')){return b-'0';}
  if((b>='a')&&(b<='f')){return b+10-'a';}
  if((b>='A')&&(b<='F')){return b+10-'A';}
  return 0xFF;
}

uint8_t getParity(uint8_t c){
  uint8_t p=0;
  p=c^(c>>4);
  p=p^(p>>2);
  p=(p^(p>>1)^1)&1;   //parity
  return p;
}

uint16_t getPhy(uint8_t c){
  uint16_t p=getParity(c)<<9;
  return (c<<1)|1024|p; //implied start bit at position 0 is 0
}

void sendHost(uint8_t c){
  uint16_t p;
  int i;
  p=getPhy(c);
  digitalWrite(PS2CK,LOW);
  delayMicroseconds(100);
  digitalWrite(PS2DT,LOW);    //this is the implied start bit
  delayMicroseconds(10);
  pinMode(PS2CK,INPUT_PULLUP);
  delayMicroseconds(10);
  while(digitalRead(PS2CK)){}
  delayMicroseconds(1);
  for(i=0;i<9;i++){
    p=p>>1;
    if(p&1){
      pinMode(PS2DT,INPUT_PULLUP);
    }else{
      digitalWrite(PS2DT,LOW);
    }
    while(digitalRead(PS2CK)==0){}
    delayMicroseconds(1);
    while(digitalRead(PS2CK)){}
    delayMicroseconds(1);
  }
  pinMode(PS2DT,INPUT_PULLUP);
  delayMicroseconds(1);
  //device sends ack
  while(digitalRead(PS2CK)==0){}
  delayMicroseconds(1);
  while(digitalRead(PS2CK)){}
  delayMicroseconds(1);
  while(digitalRead(PS2CK)==0){}
  delayMicroseconds(1);
}

void loop() {
  uint8_t p,h;
  uint16_t xData;
  int d;
  if(Serial.available()){
    d=Serial.read();
    h=unHex(d);
    if(h!=0xFF){
      hostTx=(hostTx<<4)|h;
    }
    if(d==13){
      sendHost(hostTx);
      Serial.printf("Send 0x%X\r\n",hostTx);
      hostTx=0;
    }
  }  
  dt1=digitalRead(PS2DT);
  ck1=digitalRead(PS2CK);
  if((ck0==0)&&(ck1==1)){ //rising edge
    inData=(inData>>1);
    if(dt1){
      inData=inData|1024;
    }
    bitCt++;
    t=micros();        //reset timeout
  }  
  if(bitCt==11){
    scanCode=(inData>>1)&0xFF;
    xData=getPhy(scanCode);   //get expected bitstream
    if(xData==inData){  //checksum OK
      Serial.printf("Receive 0x%X OK:%s\r\n",scanCode,k[scanCode]);
    }else{
      Serial.printf("%X=/=%X:%X Checksum error\r\n",xData,inData,scanCode);
    }
    bitCt=0;
    inData=0;
  }
  if((bitCt!=0)&&((micros()-t)>PS2TMOUT)){
    Serial.printf("Timeout at bit %d,%d\r\n",bitCt);
    bitCt=0;
    inData=0;
  }
  dt0=dt1;
  ck0=ck1;
}
