//USB in/PS2 out keyboard adapter for VGA PicoMite (but should work for most PS2 computers)
//using PIO USB Host on GP8/GP9=D+/D-
//PS2 on GP4/GP5=DT/CK
//LED on GP3
#define STATUS_LED 3

// pio-usb is required for rp2040 host
#include "pio_usb.h"
#define HOST_PIN_DP   8   // Pin used as D+ for host, D- = D+ + 1
#include "Adafruit_TinyUSB.h"
#define LANGUAGE_ID 0x0409  // English
// USB Host object
Adafruit_USBH_Host TinyUSBHost;
// holding device descriptor
tusb_desc_device_t desc_device;
#include "keys.h"

void setup() {
  Serial.begin(115200);
  Serial.println("USB to PS2 Keyboard for VGA PicoMite");
  pinMode(STATUS_LED,OUTPUT);
  digitalWrite(STATUS_LED,LOW);
  ps2Init();
  ps2Reset();   //this can also be invoked from a host command
  Serial.println("Press ~ to toggle debugging data.");
}

void loop() {  
  uint16_t ps2code;
  int d;
  keyEvent_t event;
  if(Serial.available()){
    d=Serial.read();
    if(d=='~'){
      if(debugOn){
        debugOn=0;
        Serial.println("Debugging off");
      }else{
        debugOn=1;
        Serial.println("Debugging on");
      }
    }
  }
  if(hostInt>-1){
    hostInt=-1; //flag done
  }
  if(tuh_mounted(keyAdd) && (tuh_hid_interface_protocol(keyAdd, keyInst)==HID_ITF_PROTOCOL_KEYBOARD)){
    //digitalWrite(STATUS_LED,HIGH);
  }else{
    //digitalWrite(STATUS_LED,LOW);
    ledCtr=LEDTIMEOUT;
  }
  if(ledCtr){
    digitalWrite(STATUS_LED,LOW);
  }else{
    digitalWrite(STATUS_LED,HIGH);
  }
  while(eventAvailable()){
    event=getEvent();
    if(debugOn){Serial.printf("0x%x %s %c %c %c %c\r\n",event.key,(event.event==KEYDOWN)?"DOWN":((event.event==KEYUP)?"UP":"????"),(event.mod.lShift|event.mod.rShift)?'S':'_',(event.mod.lCtrl|event.mod.rCtrl)?'C':'_',(event.mod.lAlt|event.mod.rAlt)?'A':'_',(event.lock.capsLock)?'L':'_');}
    ps2code=usb2set2[event.key];
    if((event.key==USB_PAUSEBREAK)&&(event.event==KEYDOWN)){    //this has a null entry in the SET2 table, so handle this odd behaviour specifically here
      ps2Send(0xE1);  //extended
      ps2Send(0x14);  //Ctrl
      ps2Send(0x77);  //NumLock
      ps2Send(0xE1);  //extended
      ps2Send(0xF0);  //release
      ps2Send(0x14);  //Ctrl
      ps2Send(0xF0);  //release
      ps2Send(0x77);  //NumLock
    }
    if(ps2code){
      if(event.event==KEYUP){
        if(ps2code&0xFF00){ps2Send(ps2code>>8);}  //hi byte of extended
        ps2Send(0xF0);  //release
        ps2Send(ps2code);
        tmCode=0;       //cancel typematic
        tmTimer=tmDelay;
      }else if(event.event==KEYDOWN){
        if(ps2code&0xFF00){ps2Send(ps2code>>8);}  //hi byte of extended
        ps2Send(ps2code);
        tmCode=ps2code;//set up typematic
        tmTimer=tmDelay;
        //default behaviour appears to be typematic, even on these keys, so comment out this cancelling
        //if(event.key==USB_CAPSLOCK){tmCode=0;}
        //if(event.key==USB_NUMLOCK){tmCode=0;}
        //if(event.key==USB_SCROLLLOCK){tmCode=0;}
      }
    }    
    //check if LED state needs to be updated; appears host will do this too, but can't hurt
    if(event.event==KEYDOWN){
      if(event.key==USB_CAPSLOCK){  //CAPS LOCK
        lockState.capsLock=lockState.capsLock^1;
        tuh_hid_set_report(keyAdd, keyInst, 0, HID_REPORT_TYPE_OUTPUT,&lockState, 1);
      }else if(event.key==USB_NUMLOCK){  //NUM LOCK
        lockState.numLock=lockState.numLock^1;
        tuh_hid_set_report(keyAdd, keyInst, 0, HID_REPORT_TYPE_OUTPUT,&lockState, 1);
      }else if(event.key==USB_SCROLLLOCK){  //SCROLL LOCK
        lockState.scrollLock=lockState.scrollLock^1;
        tuh_hid_set_report(keyAdd, keyInst, 0, HID_REPORT_TYPE_OUTPUT,&lockState, 1);
      }
    }
  }
  if(hostByteReady){
    if(((getPhy(hostByte>>1)^hostByte)&0x3ff)==0){  //checksum, start stop bits match
      hostByte=(hostByte>>1)&0xFF;
      if(debugOn){Serial.printf("0x%x from host\r\n",hostByte);}
      //send ack or equiv response
      if(hostByte==PS2_CMD_ECHO){
        ps2Send(PS2_CMD_ECHO);    //ack echo with echo
      }else{
        ps2Send(PS2_CMD_ACK);            //ack
      }
      //handle multibyte
      if(hostCmdByte==PS2_CMD_LEDS){
        if(hostByte<8){     //high bits must be clear for this to be valid
          if(hostByte&PS2_CAPSMASK){lockState.capsLock=1;}else{lockState.capsLock=0;}
          if(hostByte&PS2_NUMMASK){lockState.numLock=1;}else{lockState.numLock=0;}
          if(hostByte&PS2_SCROLLMASK){lockState.scrollLock=1;}else{lockState.scrollLock=0;}
          tuh_hid_set_report(keyAdd, keyInst, 0, HID_REPORT_TYPE_OUTPUT,&lockState, 1);
          if(debugOn){Serial.printf("LEDs set to %c %c %c\r\n",(lockState.capsLock?'C':'c'),(lockState.numLock?'N':'n'),(lockState.scrollLock?'S':'s'));}
          hostCmdByte=0;        //reset
        }
      }else if(hostCmdByte==PS2_CMD_TYPEMATIC){
        if(hostByte<128){   //hi bit must be clear
          tmPeriod=tmPeriods[hostByte&0x1f];
          tmDelay=tmDelays[(hostByte>>5)&3];
          if(debugOn){Serial.printf("Typematic set: delay=%dms,period=%dms\r\n",tmDelay/1000,tmPeriod/1000);}
        }
        hostCmdByte=0;        //reset multibyte
      }else{
        hostCmdByte=0;        //reset, probably invalid
        //handle 1st/single byte
        if(hostByte==PS2_CMD_LEDS){ //multibyte command set status indicators
          hostCmdByte=hostByte;
        }else if(hostByte==PS2_CMD_TYPEMATIC){
          hostCmdByte=hostByte;
        }else if(hostByte==PS2_CMD_REQID){
          ps2Send(PS2_KEY_ID_1);            //keyboard
          ps2Send(PS2_KEY_ID_2);            //101 key
        }else if(hostByte==PS2_CMD_RESET){
          ps2Reset();          
        }
      }      
    }else{
      ps2Send(PS2_CMD_RESEND);      //checksum error, request resend
      if(debugOn){Serial.printf("Error byte from host\r\n");}
    }    
    hostByteReady=0;            
  }
  //send typematic if needed
  if(tmCode && (tmTimer==0)){
    if(tmCode&0xFF00){ps2Send(tmCode>>8);}  //hi byte of extended
    ps2Send(tmCode);
    tmTimer=tmPeriod;
  }
}

// core1's setup
void setup1() {
  delay(10);
  //CPU must be 120MHz or 240MHz
  pio_usb_configuration_t pio_cfg = PIO_USB_DEFAULT_CONFIG;
  pio_cfg.pin_dp = HOST_PIN_DP;
  TinyUSBHost.configure_pio_usb(1, &pio_cfg);
  //calling USBHost.begin() on core1 to leave core 0 free
  TinyUSBHost.begin(1);
}

void loop1(){
  TinyUSBHost.task();
}

// Invoked when device with hid interface is mounted
// Report descriptor is also available for use.
// tuh_hid_parse_report_descriptor() can be used to parse common/simple enough
// descriptor. Note: if report descriptor length > CFG_TUH_ENUMERATION_BUFSIZE,
// it will be skipped therefore report_desc = NULL, desc_len = 0
void tuh_hid_mount_cb(uint8_t dev_addr, uint8_t instance, uint8_t const *desc_report, uint16_t desc_len) {
  (void)desc_report;
  (void)desc_len;
  uint16_t vid, pid;
  tuh_vid_pid_get(dev_addr, &vid, &pid);
  if(debugOn){Serial.printf("HID device address = %d, instance = %d is mounted\r\n", dev_addr, instance);}
  if(debugOn){Serial.printf("VID = %04x, PID = %04x\r\n", vid, pid);}
  if (!tuh_hid_receive_report(dev_addr, instance)) {
    if(debugOn){Serial.printf("Error: cannot request to receive report\r\n");}
  }
  if(tuh_hid_interface_protocol(dev_addr, instance)==HID_ITF_PROTOCOL_KEYBOARD){    //check if keyboard
    keyAdd=dev_addr;
    keyInst=instance;
    if(debugOn){Serial.printf("Keyboard found at %d,%d\r\n",keyAdd,keyInst);}
    //tuh_hid_set_report(keyAdd, keyInst, 0, HID_REPORT_TYPE_OUTPUT,&lockState, 1);   //doesn't like this on mount
  }
}

// Invoked when device with hid interface is un-mounted
void tuh_hid_umount_cb(uint8_t dev_addr, uint8_t instance) {
  if(debugOn){Serial.printf("HID device address = %d, instance = %d is unmounted\r\n", dev_addr, instance);}
}

// Invoked when received report from device via interrupt endpoint
void tuh_hid_report_received_cb(uint8_t dev_addr, uint8_t instance, uint8_t const *report, uint16_t len) {
  uint8_t i,j,chg;
  keyEvent_t e;
  report_t* newReport=(report_t*)report;
  if(debugOn){
    Serial.printf("HIDreport : ");
    for (uint16_t i = 0; i < len; i++) {
      Serial.printf("0x%02X ", report[i]);
    }
    Serial.println();
  }
  // continue to request to receive report
  if (!tuh_hid_receive_report(dev_addr, instance)) {
    if(debugOn){Serial.printf("Error: cannot request to receive report\r\n");}
  }
  if(tuh_hid_interface_protocol(dev_addr, instance)==HID_ITF_PROTOCOL_KEYBOARD){    
    modState=newReport->mod;
    e.mod=modState;
    e.lock=lockState;
    if(modState.lCtrl ||modState.rCtrl ){ctrlState=1; }else{ctrlState=0; }
    if(modState.lShift||modState.rShift){shiftState=1;}else{shiftState=0;}
    if(modState.lAlt  ||modState.rAlt  ){altState=1;  }else{altState=0;  }
    if(modState.lGui  ||modState.rGui  ){guiState=1;  }else{guiState=0;  }
    //report modifier key changes; these map to E0..E7
    if(newReport->mod.lCtrl!=lastReport.mod.lCtrl){ //change=event
      if(newReport->mod.lCtrl){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE0;
      queueEvent(e);
    }
    if(newReport->mod.lShift!=lastReport.mod.lShift){ //change=event
      if(newReport->mod.lShift){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE1;
      queueEvent(e);
    }
    if(newReport->mod.lAlt!=lastReport.mod.lAlt){ //change=event
      if(newReport->mod.lAlt){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE2;
      queueEvent(e);
    }
    if(newReport->mod.lGui!=lastReport.mod.lGui){ //change=event
      if(newReport->mod.lGui){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE3;
      queueEvent(e);
    }
    if(newReport->mod.rCtrl!=lastReport.mod.rCtrl){ //change=event
      if(newReport->mod.rCtrl){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE4;
      queueEvent(e);
    }
    if(newReport->mod.rShift!=lastReport.mod.rShift){ //change=event
      if(newReport->mod.rShift){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE5;
      queueEvent(e);
    }
    if(newReport->mod.rAlt!=lastReport.mod.rAlt){ //change=event
      if(newReport->mod.rAlt){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE6;
      queueEvent(e);
    }
    if(newReport->mod.rGui!=lastReport.mod.rGui){ //change=event
      if(newReport->mod.rGui){e.event=KEYDOWN;}else{e.event=KEYUP;}
      e.key=0xE7;
      queueEvent(e);
    }
    //look for key down events
    for(i=0;i<6;i++){
      if(newReport->k[i]){  //only check non-zero
        chg=1;
        for(j=0;j<6;j++){
          if(newReport->k[i]==lastReport.k[j]){chg=0;}
        }
        if(chg){
          e.key=newReport->k[i];
          e.event=KEYDOWN;
          queueEvent(e);
        }
      }
    }
    //look for key up events
    for(i=0;i<6;i++){
      if(lastReport.k[i]){  //only check non-zero
        chg=1;
        for(j=0;j<6;j++){
          if(newReport->k[j]==lastReport.k[i]){chg=0;}
        }
        if(chg){
          e.key=lastReport.k[i];
          e.event=KEYUP;
          queueEvent(e);
        }
      }
    }
    lastReport=*newReport;
  }
}

