'                    MOBILE PHONE RING EXTENDER WITH PAGER
'                           (mobile_pager14m2.bas)

'This program should be down loaded to both transmit and receive microprocessors.  
'The logic level on the B.5 input will select either transmit or receive programs.
'You may select your own system code - by altering the 5678 code found in start_up
'The four user code links must have identical jumpers fitted to the base and pager  


'******************************* SETUP SEQUENCE ****************************** 

start_up:' ------- set-up micro - start transmit or receive programs 
setfreq m8
let dirsB = %00011110: let pinsB = %00000000
let dirsC = %00000000: let pinsC = %00000000
pullup %0000111100000000
b15 = 5: b16 = 6: b17 = 7: b18 = 8' (default system code)
if pinB.5 = 1 then goto xmit_prog
if pinB.5 = 0 then goto recv_prog


'******************************* TRANSMIT PROGRAM ****************************

xmit_prog:' ----- read local user code links and flash LED2 once
pause 2 
if pinC.0 = 1 then: b1 = 1: else b1 = 0: endif
if pinC.1 = 1 then: b2 = 2: else b2 = 0: endif 
if pinC.2 = 1 then: b3 = 3: else b3 = 0: endif
if pinC.3 = 1 then: b4 = 4: else b4 = 0: endif
pulsout B.2,60000
'goto xmit_code


xmit_code:' ------- convert default system code and save in memory
pause 2
let b5 = b15: b6 = b16: b7 = b17: b8 = b18
'goto xmit_mode


xmit_mode:'-------- process input signal - flashing LED1 as needed.
b10 = 0
for b0 = 0 to 50
readadc C.4,b9
if b9 > 80 then: inc b10: endif
if b10 > 5 then: high B.4: endif
pause 20
next b0
low B.4
if b10 > 30 then: goto xmit_alarm: endif
goto xmit_mode


xmit_alarm:'------ transmit the 8 byte alarm code and flash LED2
pause 2
high B.3: high B.2
pause 150
rfout B.1, (b1,b2,b3,b4,b5,b6,b7,b8)
pause 150
low B.3: low B.2
goto xmit_mode


'******************************** RECEIVE PROGRAM ****************************

recv_prog:' ------ read local user code links and flash LED3 once 
pause 2
if pinC.0 = 1 then: b11 = 1: else b11 = 0: endif
if pinC.1 = 1 then: b12 = 2: else b12 = 0: endif 
if pinC.2 = 1 then: b13 = 3: else b13 = 0: endif
if pinC.3 = 1 then: b14 = 4: else b14 = 0: endif
pulsout B.1,60000
'goto recv_mode 
 

recv_mode:'------- receiver waits untill code bytes are picked up 
pause 2
rfin C.4, b1,b2,b3,b4,b5,b6,b7,b8
'goto recv_code1


recv_code1:'------ received user code and local user code must match
if b1 = b11 and b2 = b12 and b3 = b13 and b4 = b14 then goto recv_code2 
goto recv_mode


recv_code2:'----- received system and local system codes must match
if b5 = b15 and b6 = b16 and b7 = b17 and b8 = b18 then goto recv_alarm 
goto recv_mode 


recv_alarm:'------ generate the alarm sound and flash the alarm LED3
for b10 = 1 to 8 
for b0 = 1 to 200
let pinsB = %00000100
let pinsB = %00010000
next b0
let pinsB = %00000000
pulsout B.1,60000
next b10
goto recv_mode

    
'******************************* VARIABLE LIST ****************************** 
    

' b1, b2, b3, b4     =  user code    (xmit) 
' b11, b12, b13, b14 =  user code   (local) 
' b5, b6, b7, b8     =  system code  (xmit)
' b15, b16, b17, b18 =  system code (local) 
' b0, b9, b10        =  temporary variables 