//SSD1306/SH1106 OLED implementation for PIC8 including soft I2C

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "font.h"
#include "portbits.h"
//depends on _XTAL_FREQ=(32000000) in properties

//set these per hardware
#define SDA_PIN b5
#define SCL_PIN b4

//optional soft power pins
//#define OLED_PWR
//#define OLED_GND

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//#define OLED_X_OFFSET (0)
#define OLED_X_OFFSET (2)
//for smaller displays
//#define OLED_X_OFFSET (32)
#define OLED_BIG_PIXEL_WIDTH 7

//for flippable text display
//TEXT_RH is same as original
#define TEXT_RH 1
#define TEXT_LH 2
#define OLED_CONNECTOR_AT_TOP 1
#define OLED_CONNECTOR_AT_BOTTOM 2

//pin primitives
#define SDAHI {trisbits.SDA_PIN=1;}
#define SDALO {trisbits.SDA_PIN=0;}
#define SCLHI {trisbits.SCL_PIN=1;}
#define SCLLO {trisbits.SCL_PIN=0;}
#define BITDELAYUS (2)

extern char col,page; //column variable
char textFlip;        //internal only
#define DBUFSIZE (16)
extern char dBuf[DBUFSIZE]; //buffer for display of numbers

//use I2Cstop as init
void I2Cinit(void);
void I2Cbit(unsigned char n);
void I2Cbyte(unsigned char n);
void I2Cstart(void);
void I2Cstop(void);
void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDclear(void);
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDflip(char c);      //to suit flip orientation according to textFlip
//reused delays
void delay2000(void);                   //reused
void delay200(void);                   //reused
void getDigits(unsigned int n,char* d);    //put digits into array
void getDigitsLong(unsigned long n, char* d);   //same as for a UL
void zeroBlank(char* d, char c);   //replace leading zeros with c
void zeroBlankN(char* d, char c, char n);   //replace leading zeros with c up to n times
void largeFontChar(char c, const char *f); //uses col/page, updates col
void largeFontCharArray(const char *c, const char *f); //uses col/page, updates col
void showV(const char* d);
void OLEDpixelData(unsigned char d);    //send a single column of pixel data, updates col

#endif  //OLED_H

