//Coin Cell Emulator
//Pinout
//RA5   S1
//RA4   S2
//RC5   S3
//RC6   VSHUNT
//RC7   VOUT
//RB7   ILSENSE
//RB6   RST OUT
//RB5   SDA
//RB4   SCL
//RA2   VSET
//RB6   RESET
//an emitter follower connected to VSET (DAC) provides a voltage output
//the current is sensed by a 22# resistor (to emulate internal resistance)
//this is across VSHUNT/VOUT (via 10k#/100nF smoothing)
//a MAX4238/9 op amp also provides current via 10k# resistor; this can be sensed
//at ILSENSE via a 10k#/100nF smoothing pair

// in Properties: _XTAL_FREQ=(32000000)

#include "config.h"
#include <xc.h>
#include "util.h"

unsigned long t;
unsigned int i;

void main(void) {
    ioInit();
    initADC();
    I2Cinit();
    OLEDinit();    
    OLEDflip(OLED_CONNECTOR_AT_TOP);
    __delay_ms(100);
    tmr2Init(); 
    PR2=cur.tPeriod;    //use current
    GIE=1;
    col=0;
    page=0;
    largeFontCharArray("COIN",smallFont);       
    col=28;
    largeFontCharArray("CELL",smallFont);       
    col=56;
    largeFontCharArray("EMULATOR",smallFont);       
    //dacCal();
    while(1){
        if(inSetup){
            while(count==0){}   //limit repeats
            count=0;        //keep this from accumulating
            doSetup();
            if(inSetup==0){
                //reset display
                OLEDclear();
                col=0;
                page=0;
                largeFontCharArray("COIN",smallFont);       
                col=28;
                largeFontCharArray("CELL",smallFont);       
                col=56;
                largeFontCharArray("EMULATOR",smallFont);       
            }
        }else{
            while(count==0){checkSW();}
            doSamples();            
            if(ilsense<(vcc-D1VF)){ //low range is working, ie op amp not saturating
                itot=ilo;
                ihi=0;  //keep everything consistent
            }else{
                itot=(unsigned long)ilo+((unsigned long)ihi*1000UL);
            }
            if(secCtrRun){
                while(count){   //do time based accumulations and repeat if counts missed
                    iaSubSample=iaSubSample+itot;   //accumulating in units of 0.01uA
                    t=iaSubSample/(ACC_SAMPLE_COUNT*COUNTPERSEC*1000UL);    //t in uAh
                    iaCount=iaCount+t;   //handle chunks of accumulation
                    iaSubSample=iaSubSample-(t*(ACC_SAMPLE_COUNT*COUNTPERSEC*1000UL));  //leave a residue to accumulate fractions
                    imSubSample=imSubSample+itot;   //add 'normal' amount
                    imSubSample=imSubSample+capAdjust();      //add 'extra' amount
                    t=imSubSample/(ACC_SAMPLE_COUNT*COUNTPERSEC*1000UL);    //t in uAh
                    imCount=imCount+t;   //handle chunks of accumulation
                    imSubSample=imSubSample-(t*(ACC_SAMPLE_COUNT*COUNTPERSEC*1000UL));  //leave a residue to accumulate fractions
                    count--;
                }                
            }else{
                count=0;
            }
            currentSOC=getSOC();
            currentSagV=getSag();    
            if(cur.vSet-(int)currentSagV<(int)cur.endpointV){secCtrRun=0;}
            setDACbyV(cur.vSet-(int)currentSagV,outputOn);
            sPress.bit1=0;      //ignore these in main mode
            sPress.bit2=0;                    
            if(sPress.bit3){    //check for edge only
                sPress.bit3=0;
                curSet=curSet+1;
                if(curSet>=SET_DUMMY){curSet=0;}
            }       
            col=107;
            page=0;
            if(((vcc>4500)&&(vcc<5500))||(clkCnt&1)){   //flash if out of range
                getDigits(vcc,dBuf);            //supply voltage display
                largeFontChar(dBuf[1],smallFont);
                OLEDpixelData(64);          //a narrow decimal point
                OLEDpixelData(0);
                largeFontChar(dBuf[2],smallFont);
                largeFontChar('V',smallFont);
            }else{
                largeFontChar(' ',smallFont);
                largeFontChar(' ',smallFont);
                largeFontChar(' ',smallFont);                
                OLEDpixelData(0);
                OLEDpixelData(0);
            }
            col=0;
            page=1;
            switch(curSet){
                case SET_VSET: //VSET
                    if(PRESSED(S1)){
                        cur.vSet=cur.vSet-100;
                        if(cur.vSet<0){cur.vSet=0;}
                    }
                    if(PRESSED(S2)){
                        cur.vSet=cur.vSet+100;
                        if(cur.vSet>V_MAX){cur.vSet=V_MAX;}
                    }       
                    largeFontCharArray("V=",arialSmall);
                    getDigits((unsigned int)cur.vSet,dBuf);
                    largeFontChar(dBuf[1],arialSmall);
                    largeFontChar('.',arialSmall);
                    largeFontChar(dBuf[2],arialSmall);
                    largeFontCharArray("V S1- S2+",arialSmall);    
                    break;
                case SET_VOUT_ON:
                    if(PRESSED(S1)){outputOn=0;}
                    if(PRESSED(S2)){outputOn=1;}
                    if(outputOn){
                        largeFontCharArray("V ON (S1 OFF) ",arialSmall);                        
                    }else{
                        largeFontCharArray("V OFF (S2 ON) ",arialSmall);                        
                    }
                    break;
                case SET_COUNTER_RUN_RESET:
                    if(PRESSED(S1)){
                        if(secCtrRun){
                                secCtrRun=0;
                            }else{
                                secCtrRun=1;
                            }
                        }
                    if(PRESSED(S2)){
                        if(secCtrRun==0){   //only reset if paused
                            secCtr=0;
                            iaCount=0;
                            imCount=0;
                        }
                    }
                    if(secCtrRun){
                        largeFontCharArray("S1 PAUSE T/I  ",arialSmall);                        
                    }else{
                        largeFontCharArray("S1 RUN  S2 RST",arialSmall);                        
                    }
                    break;
                case SET_START_STOP:
                    if(PRESSED(S1)){
                        secCtrRun=1;
                        outputOn=1;
                    }
                    if(PRESSED(S2)){
                        secCtrRun=0;
                        outputOn=0;
                    }
                    largeFontCharArray("S1 GO S2 PAUSE",arialSmall);                        
                    break;
                default:
                    largeFontCharArray("ERROR PRESS S3",arialSmall);                        
                    break;
            }
            col=0;
            page=3;
            getDigits((unsigned int)cur.vSet,dBuf);
            largeFontChar(dBuf[1],smallFont);
            largeFontChar('.',smallFont);
            largeFontChar(dBuf[2],smallFont);
            largeFontChar('V',smallFont);    
            largeFontChar(' ',smallFont);    
            if(outputOn){
                largeFontCharArray("ON  ",smallFont);       
            }else{
                largeFontCharArray("OFF ",smallFont);                   
            }
            getDigits((unsigned int)vshunt,dBuf);
            largeFontChar(dBuf[1],smallFont);
            largeFontChar('.',smallFont);
            largeFontChar(dBuf[2],smallFont);
            largeFontChar(dBuf[3],smallFont);
            largeFontChar('V',smallFont);    
            largeFontChar(' ',smallFont);    
            getDigits((unsigned int)vout,dBuf);
            largeFontChar(dBuf[1],smallFont);
            largeFontChar('.',smallFont);
            largeFontChar(dBuf[2],smallFont);
            largeFontChar(dBuf[3],smallFont);
            largeFontChar('V',smallFont);    
            col=0;
            page=4;
            if(ihi==0){
                largeFontCharArray("I(lo)=",arialSmall);       
            }else{
                largeFontCharArray("I(hi)=",arialSmall);                       
            }
            if(itot<100000UL){
                getDigits((unsigned int)(itot/10),dBuf);
                if(dBuf[0]=='0'){
                    dBuf[0]=' ';
                    if(dBuf[1]=='0'){
                        dBuf[1]=' ';  
                        if(dBuf[2]=='0'){
                            dBuf[2]=' ';  
                        }
                    }
                }
                largeFontChar(dBuf[0],arialSmall);
                largeFontChar(dBuf[1],arialSmall);
                largeFontChar(dBuf[2],arialSmall);
                largeFontChar(dBuf[3],arialSmall);    
                largeFontChar('.',arialSmall);
                largeFontChar(dBuf[4],arialSmall);    
                largeFontCharArray("`A",arialSmall);       
            }else{
                getDigits((unsigned int)(itot/1000),dBuf);
                if(dBuf[0]=='0'){
                    dBuf[0]=' ';
                    if(dBuf[1]=='0'){
                        dBuf[1]=' ';  
                    }
                }
                largeFontChar(dBuf[0],arialSmall);    
                largeFontChar(dBuf[1],arialSmall);
                largeFontChar(dBuf[2],arialSmall);
                largeFontChar('.',arialSmall);
                largeFontChar(dBuf[3],arialSmall);
                largeFontChar(dBuf[4],arialSmall);    
                largeFontCharArray("mA",arialSmall);       
                
            }
            col=0;
            page=6;
            getTime(secCtr,dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,smallFont);       
            if(secCtrRun){
                largeFontCharArray(" RUN   ",smallFont);       
            }else{
                largeFontCharArray(" PAUSE ",smallFont);                       
            }
            col=0;
            page=7;            
            if(imCount>9999999UL){
                getDigitsLong(9999999UL,dBuf);
            }else{
                getDigitsLong(iaCount,dBuf);    //use actual count here
            }
            zeroBlankN(dBuf,' ',9);
            //largeFontCharArray(dBuf+3,smallFont);       
            largeFontChar(dBuf[3],smallFont);
            col=8;
            largeFontChar(dBuf[4],smallFont);
            largeFontChar(dBuf[5],smallFont);
            largeFontChar(dBuf[6],smallFont);
            col=28;
            largeFontChar(dBuf[7],smallFont);
            largeFontChar(dBuf[8],smallFont);
            largeFontChar(dBuf[9],smallFont);
            col=48;
            largeFontCharArray("`Ah",smallFont);                   
            col=80;
            page=7;            
            getDigits((currentSOC*25)/(LOG_SCALE/4),dBuf);  //16-bit limits
            largeFontCharArray("SOC:",smallFont);       //modified count is used to show SOC
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf+2,smallFont);       
            largeFontCharArray("%",smallFont);                   
            //do this last to avoid overdraw
            if(PRESSED(S3)){                
                if(s3count==0){             //decremented by timer
                    OLEDclear();            //feedback for user
                    col=0;
                    page=0;
                    largeFontCharArray("SETUP and CALIBRATION",smallFont);       
                    while(PRESSED(S3)){}    //wait for release
                    __delay_ms(10);         //and debounce
                    inSetup=1;   
                    DAC1DATL=0;             //shut down output
                    outputOn=0;
                    secCtrRun=0;            //pause
                    curSet=SET_VSET; 
                }
            }else{
                s3count=S3TMOUT;
            }
        }        
    }
    return;
}
