#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
//RA5   S1
//RA4   S2
//RC5   S3
//RC6   VSHUNT
//RC7   VOUT
//RB7   ILSENSE
//RA2   VSET
//RB6   RESET

//defines use portbits.h
#define S1 a5
#define S2 a4
#define S3 c5
#define VSET a2
#define VSHUNT c6
#define VOUT c7
#define ILSENSE b7
#define RST_PIN b6
#define PRESSED(x) (portbits.x==0)
#define ADC_OS (8U)
#define ADC_MAX (4096U)
#define ADC_OS_MAX (ADC_OS*ADC_MAX)
#define TIMER2_PERIOD (243)

extern unsigned int adcref,dacref;
extern unsigned char clkCnt;

#define DAC_FVR (63)
#define ADC_FVR (62)
#define D1VF (650)

typedef struct {
        unsigned int bit0:1;
        unsigned int bit1:1;
        unsigned int bit2:1;
        unsigned int bit3:1;
        unsigned int bit4:1;
        unsigned int bit5:1;
        unsigned int bit6:1;
        unsigned int bit7:1;
} bitField_t;

extern bitField_t sPress;

void ioInit(void);  //basic IO
void tmr2Init(void);
void initADC(void);
unsigned int getADC(char c); //12-bits
unsigned int getADCOS(char c);  //using ADC_OS
int getdADCOS(char p, char n);  //differential
unsigned int readNVM(unsigned int add);
unsigned int adjust(unsigned int v,unsigned int m);
unsigned int getVCC(void);  //assumes correct reference value in adcref, return mV
void checkSW(void); //check for push-edges

#endif	/* IO_H */

