#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "font.h"

typedef struct {
    int vSet;                       //this in mV
    unsigned int dacVmin;           //VBE in theory
    unsigned int dacVspan;          //~4V in theory
    unsigned int rHi;               //nominal 22# =2200 (units of 1/100 of an ohm)
    unsigned int rLo;               //nominal 10k
    unsigned long batCapacity;      //in uAh
    unsigned long iCapNom;          //point at which capacity is halved (0.01uA steps)
    unsigned int sagRange;          //last sagRange % has voltage taper off to 0.
    unsigned int endpointV;         //causes pause when reached    
    unsigned char tPeriod;          //time calibration
} eeprom_elements_t;

extern __eeprom eeprom_elements_t cur;  //live settings

typedef enum{
    SET_VSET,
    SET_VOUT_ON,
    SET_COUNTER_RUN_RESET,
    SET_START_STOP,
    SET_DUMMY
}settingModes_t;

typedef enum{
    SETUP_BATCAP,
    SETUP_ENDPOINTV,
    SETUP_CAPNOM,
    SETUP_SAGRANGE,
    SETUP_CALIBRATION,
    SETUP_DACVMIN,
    SETUP_DACVSPAN,
    SETUP_RHI,
    SETUP_RLO,
    SETUP_TPERIOD,
    SETUP_RETURN,
    SETUP_DUMMY
}setupModes_t;

#define DEF_ENDPOINT (2000)
#define DEF_SAGRANGE (5)
#define DEF_ICAPNOM (350000UL)
#define DEF_BAT_CAP (10000)
#define VSET_DEFAULT (3000)
#define R_LO_DEFAULT (10000)
//this in hundredths of an ohm
#define R_HI_DEFAULT (2200)
#define V_MAX (3400)
#define S3TMOUT (12)
#define Q1OFFSET_DEFAULT (588)
#define DACSPAN_DEFAULT (4002)
#define COUNTPERSEC (4UL)
#define SECPERMIN (60UL)
#define MINPERHOUR (60UL)
#define HOURPERDAY (24UL)
#define SECIN1000DAYS (1000UL*SECPERMIN*MINPERHOUR*HOURPERDAY)
#define ACC_SAMPLE_COUNT (360UL)
#define NOMINAL_CAP (20)
#define LOG_BITS (11)
#define LOG_SCALE (1<<LOG_BITS)
//#define SET_OPTS (4)

extern unsigned int vcc;
extern unsigned int vshunt,ilsense,vout;
extern unsigned int ilo,ihi;   //lo and hi ranges
extern unsigned long itot;
extern volatile unsigned char count;
extern char outputOn;
extern volatile char s3count;
extern char inSetup;
extern unsigned long secCtr;
extern char secCtrRun;
extern unsigned long iaSubSample,imSubSample,iaCount,imCount;
extern unsigned int currentSOC;      
extern unsigned int currentSagV;
settingModes_t curSet;     //main page settings
setupModes_t setup;        //aux/calibration parameters

void dacCal(void);          //set dacOffset and dacVmax
unsigned char setDACbyV(int v, char on);    //returns DAC setting
void doSamples(void);       //process all needed samples
void getTime(unsigned long n, char* d);      //ddddd:hh:mm:ss format, array needs to have 15 spots
unsigned long capAdjust(void);       //capacity adjustment of itot based on iCapNom
unsigned int getSOC(void);      //uses globals, returns 0=empty 255=full
unsigned int getSag(void);      //in mV scaled off vSet
void doSetup(void);     //tidy up main and put this here

#endif	/* UTIL_H */

