#include "util.h"

unsigned int vcc=0;
unsigned int vshunt,ilsense,vout;
unsigned int ilo,ihi;
unsigned long itot;   //lo and hi ranges
volatile unsigned char count=0;
char outputOn=0;
volatile char s3count=S3TMOUT;
char inSetup=0;
unsigned long secCtr=0;
char secCtrRun=0;
//accumulation is done in two stages as XC8 does not support ints longer than 32 bits
unsigned long iaSubSample=0; //these samples are accumulated over a short period 
unsigned long imSubSample=0; //actual=a, modified=m
unsigned long iaCount=0;     //units are uAh
unsigned long imCount=0;     //units are uAh
unsigned int currentSOC=0;   
unsigned int currentSagV=0;    
settingModes_t curSet=SET_VSET;                  //main page settings
setupModes_t setup=SETUP_BATCAP;                 //aux/calibration parameters

__eeprom eeprom_elements_t cur={
    .vSet=VSET_DEFAULT,
    .dacVmin=Q1OFFSET_DEFAULT,
    .dacVspan=DACSPAN_DEFAULT,
    .rHi=R_HI_DEFAULT,
    .rLo=R_LO_DEFAULT,
    .batCapacity=DEF_BAT_CAP,
    .iCapNom=DEF_ICAPNOM,
    .sagRange=DEF_SAGRANGE,
    .endpointV=DEF_ENDPOINT,    //causes pause when reached
    .tPeriod=TIMER2_PERIOD
};

const unsigned char capCurve[]={    //quadratic:value = i^2/16
    0,0,0,1,1,2,2,3,4,5,6,8,9,11,12,14,
    16,18,20,23,25,28,30,33,36,39,42,46,49,53,56,60,
    64,68,72,77,81,86,90,95,100,105,110,116,121,127,132,138,
    144,150,156,163,169,176,182,189,196,203,210,218,225,233,240,248,
};

const char setupTitles[][15]={
    "Set Cap (mAh) ",
    "Endpoint (mV) ",
    "Current Comp. ",
    "Voltage Fall  ",
    "Calibrate     ",
    "Set Q VBE     ",
    "Set DAC span  ",
    "Set R(hi) 22# ",
    "Set R(lo) 10k#",
    "Trim timer    ",
    "Exit Setup    ",
    "Press S3      "
};

void dacCal(void){          //set dacOffset and dacVmax
    unsigned int a,b,c;
    vcc=getVCC();       // in mV
    DAC1DATL=255;
    __delay_ms(100);
    a=getADCOS(VSHUNT);
    DAC1DATL=127;
    __delay_ms(100);
    b=getADCOS(VSHUNT);
    DAC1DATL=0;    
    cur.dacVspan=adjust((a-b)*2,vcc);
    c=(a-b)>>7;
    a=a+c;      //ie effectively step 256
    b=b+c;      //ie effectively step 128
    cur.dacVmin=adjust(a-b-b,vcc);
}

unsigned char setDACbyV(int v, char on){    //returns DAC setting
    unsigned long d;
    if(on==0){  //switch off
        DAC1DATL=0;
        return 0;                
    }
    if(v<=0){ //ensure off is off
        DAC1DATL=0;
        return 0;        
    }
    d=(unsigned int)v+cur.dacVmin;
    d=d<<8; //*256
    d=d+(cur.dacVspan/2);   //even rounding
    d=d/cur.dacVspan;
    if(d>255){d=255;}
    DAC1DATL=(unsigned char)d;
    return (unsigned char)d;
}

void doSamples(void){   //start assuming ADREF=0;//VDD
    long b;
    unsigned long s;    //for scaling
    vcc=getVCC();       // in mV
    ihi=0;
    vshunt=adjust(getADCOS(VSHUNT),vcc);                //emitter voltage    
    vout=adjust(getADCOS(VOUT),vcc);                    //output voltage    
    ilsense=adjust(getADCOS(ILSENSE),vcc);              //feedback voltage
    b=getdADCOS(VSHUNT,VOUT)-getdADCOS(VOUT,VSHUNT);    //scaled by ADC_OS
    if(b<=0){                                           //ignore negative current
        ihi=0;
    }else{
        //32768=VCC => I = VCC/R (in mA) due to V in mV
        s=((unsigned long)vcc*10000UL)/cur.rHi;               //a good scale is units of 10uA, allows up to 655mA
        ihi=adjust((unsigned int)b,(unsigned int)s);     //s is nominally 22727, ie max is 227.270mA
    }
    b=getdADCOS(ILSENSE,VSHUNT)-getdADCOS(VSHUNT,ILSENSE);  //scaled by ADC_OS
    if(b<=0){                                        //ignore negative current
        ilo=0;
    }else{
        //32768=VCC => I = VCC/R (in mA) due to V in mV
        s=((unsigned long)vcc*100000UL)/cur.rLo;             //a good scale is units of 0.01uA, up to 655.35uA (0.65mA)
        ilo=adjust((unsigned int)b,(unsigned int)s);     //s is nominally 50000, ie max is 500uA
    }
}

void getTime(unsigned long n, char* d){      //ddddd:hh:mm:ss format, array needs to have 15 spots
    unsigned int nDays=0;
    unsigned char h=0,m=0;
    n=n/COUNTPERSEC;
    while(n>=(HOURPERDAY*MINPERHOUR*SECPERMIN)){
        n=n-(HOURPERDAY*MINPERHOUR*SECPERMIN);
        nDays++;
    }
    while(n>=(MINPERHOUR*SECPERMIN)){
        n=n-(MINPERHOUR*SECPERMIN);
        h++;
    }
    while(n>=(SECPERMIN)){
        n=n-(SECPERMIN);
        m++;
    }
    getDigits((char)n,&d[9]); //sets null at d[14] n=seconds should be<60
    getDigits(m,&d[6]);
    getDigits(h,&d[3]);
    getDigits(nDays,d);   
    d[5]=':';
    d[8]=':';
    d[11]=':';    
}

unsigned long capAdjust(void){       //capacity adjustment of itot based on iCapNom
    unsigned long t;
    t=cur.iCapNom>>4;
    if(t<1){return 0;}      //setting off, avoid div/0
    t=itot/t;
    if(t>255){return itot<<4;}
    if(itot>16000000UL){return (((unsigned long)(capCurve[t]))*(itot>>4));}   //order of ops to avoid overflow
    return (((unsigned long)(capCurve[t]))*itot)>>4;
}

unsigned int getSOC(void){      //uses globals, returns 0=empty LOG_SCALE=full
    if(cur.batCapacity==0){return LOG_SCALE;}     //not using capacity calcs
    if(cur.batCapacity<imCount){return 0;}  //past empty
    return (unsigned int)(LOG_SCALE-((imCount*LOG_SCALE)/cur.batCapacity));
}

unsigned int getSag(void){      //in mV scaled off vSet
    unsigned int s;
    if(cur.sagRange==0){return 0;}      //sag off
    s=((cur.sagRange*LOG_SCALE)/100);
    if(currentSOC<s){       //end of range
        return (unsigned int)((((unsigned long)cur.vSet)*(s-currentSOC))/s);
    }else{
        return 0;   //no sag
    }    
}

void doSetup(void){     //tidy up main and put this here
    checkSW();
    if(sPress.bit3){    //check for edge only
        sPress.bit3=0;
        setup=setup+1;
        if(setup>=SETUP_DUMMY){setup=0;}
        OLEDclear();            //tidy display
        col=0;
        page=0;
        largeFontCharArray("SETUP and CALIBRATION",smallFont);       
    }       
    col=0;
    page=1;
    largeFontCharArray(&setupTitles[setup][0],arialSmall);                       
    switch(setup){
        case SETUP_CALIBRATION:            
            col=0;
            page=3;
            if(clkCnt&4){
                largeFontCharArray("Press S1 to calibrate",smallFont);                       
            }else{
                largeFontCharArray("Leave output open!   ",smallFont);                                       
            }
            col=0;
            page=4;
            largeFontCharArray("S2 to load defaults",smallFont);                       
            if(PRESSED(S1)){                
                col=0;
                page=5;
                largeFontCharArray("Calibration running.",smallFont);                                       
                dacCal();
                col=0;
                page=5;
                largeFontCharArray("Calibration done.   ",smallFont);                                       
                col=0;
                page=6;
                largeFontCharArray("Q Vbe=",smallFont);                                       
                getDigits((unsigned int)cur.dacVmin,dBuf);
                zeroBlank(dBuf,' ');
                largeFontCharArray(dBuf,smallFont);                                       
                largeFontCharArray("mV",smallFont);                                                       
                col=0;
                page=7;
                largeFontCharArray("DAC span=",smallFont);                                       
                getDigits((unsigned int)cur.dacVspan,dBuf);
                zeroBlank(dBuf,' ');
                largeFontCharArray(dBuf,smallFont);                                       
                largeFontCharArray("mV",smallFont);                                                       
                __delay_ms(500);
                while(PRESSED(S1)){}
                __delay_ms(20);
            }
            if(PRESSED(S2)){                
                cur.vSet=VSET_DEFAULT;
                cur.dacVmin=Q1OFFSET_DEFAULT;
                cur.dacVspan=DACSPAN_DEFAULT;
                cur.rHi=R_HI_DEFAULT;
                cur.rLo=R_LO_DEFAULT;
                cur.batCapacity=DEF_BAT_CAP;
                cur.iCapNom=DEF_ICAPNOM;
                cur.sagRange=DEF_SAGRANGE;
                cur.endpointV=DEF_ENDPOINT;
                col=0;
                page=5;
                largeFontCharArray("                     ",smallFont);                                       
                col=0;
                page=6;
                largeFontCharArray("                     ",smallFont);                                       
                col=0;
                page=7;
                largeFontCharArray("Defaults loaded.     ",smallFont);                                       
                while(PRESSED(S2)){}
                __delay_ms(20);
            }
            break;
        case SETUP_DACVMIN:
            if(PRESSED(S1)){                
                cur.dacVmin=cur.dacVmin-1;
                if(cur.dacVmin>1000){cur.dacVmin=0;}    //catch unsigned overflow
            }
            if(PRESSED(S2)){                
                cur.dacVmin=cur.dacVmin+1;
                if(cur.dacVmin>1000){cur.dacVmin=1000;}
            }
            col=0;
            page=4;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("Q Vbe=",arialSmall);                                       
            getDigits((unsigned int)cur.dacVmin,dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,arialSmall);                                       
            largeFontCharArray("mV",arialSmall);                                                       
            break;
        case SETUP_DACVSPAN:
            if(PRESSED(S1)){                
                cur.dacVspan=cur.dacVspan-1;
                if(cur.dacVspan<1500){cur.dacVspan=1500;}
            }
            if(PRESSED(S2)){                
                cur.dacVspan=cur.dacVspan+1;
                if(cur.dacVspan>6500){cur.dacVspan=6500;}
            }
            col=0;
            page=4;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("DAC=",arialSmall);                                       
            getDigits((unsigned int)cur.dacVspan,dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,arialSmall);                                       
            largeFontCharArray("mV",arialSmall);                                                       
            break;
        case SETUP_RHI:
            if(PRESSED(S1)){                
                cur.rHi=cur.rHi-1;
                if(cur.rHi<((R_HI_DEFAULT*9)/10)){cur.rHi=((R_HI_DEFAULT*9)/10);}
            }
            if(PRESSED(S2)){                
                cur.rHi=cur.rHi+1;
                if(cur.rHi>((R_HI_DEFAULT*11)/10)){cur.rHi=((R_HI_DEFAULT*11)/10);}
            }
            col=0;
            page=4;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("RHI=",arialSmall);                                       
            getDigits((unsigned int)cur.rHi,dBuf);
            if(dBuf[0]=='0'){dBuf[0]=' ';}
            largeFontChar(dBuf[0],arialSmall);                                       
            largeFontChar(dBuf[1],arialSmall);                                       
            largeFontChar(dBuf[2],arialSmall);                                       
            largeFontChar('.',arialSmall);                                       
            largeFontChar(dBuf[3],arialSmall);                                       
            largeFontChar(dBuf[4],arialSmall);                                       
            largeFontCharArray("#",arialSmall);                                                       
            break;
        case SETUP_RLO:
            if(PRESSED(S1)){                
                cur.rLo=cur.rLo-1;
                if(cur.rLo<(R_LO_DEFAULT-1000)){cur.rLo=(R_LO_DEFAULT-1000);}
            }
            if(PRESSED(S2)){                
                cur.rLo=cur.rLo+1;
                if(cur.rLo>(R_LO_DEFAULT+1000)){cur.rLo=(R_LO_DEFAULT+1000);}
            }
            col=0;
            page=4;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("RLO=",arialSmall);                                       
            getDigits((unsigned int)cur.rLo,dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,arialSmall);                                       
            largeFontCharArray("#",arialSmall);                                                       
            break;
        case SETUP_BATCAP:  //this in uAh
            if(PRESSED(S1)){                
                if(cur.batCapacity>10000UL){
                    cur.batCapacity=cur.batCapacity-5000UL;    //5mAH
                }else if(cur.batCapacity>1000UL){
                    cur.batCapacity=cur.batCapacity-1000UL;    //1mAh
                }
            }
            if(PRESSED(S2)){                
                if(cur.batCapacity<10000UL){
                    cur.batCapacity=cur.batCapacity+1000UL;    //1mAh
                }else if(cur.batCapacity<250000UL){
                    cur.batCapacity=cur.batCapacity+5000UL;    //5mAh
                }
            }
            col=0;
            page=3;
            largeFontCharArray("Nominal battery",smallFont);                       
            col=0;
            page=4;
            largeFontCharArray("capacity.",smallFont);                       
            col=0;
            page=5;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("Cap.=",arialSmall);                                       
            getDigits((unsigned int)(cur.batCapacity/1000UL),dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,arialSmall);                                       
            largeFontCharArray("mAh",arialSmall);                                                       
            break;
        case SETUP_CAPNOM:  //0.01uA steps
            if(PRESSED(S1)){                
                cur.iCapNom=cur.iCapNom-50000UL;    //0.5mA
                if(cur.iCapNom>DEF_ICAPNOM*2){cur.iCapNom=0;}   //unsigned overflow
            }
            if(PRESSED(S2)){                
                cur.iCapNom=cur.iCapNom+50000UL;
                if(cur.iCapNom>DEF_ICAPNOM*2){cur.iCapNom=DEF_ICAPNOM*2;}
            }
            col=0;
            page=3;
            largeFontCharArray("Current at which",smallFont);                       
            col=0;
            page=4;
            largeFontCharArray("battery life halved",smallFont);                       
            col=0;
            page=5;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("Icomp=",arialSmall);                                       
            if(cur.iCapNom){
                getDigits((unsigned int)(cur.iCapNom/100),dBuf);
                zeroBlank(dBuf,' ');
                largeFontCharArray(dBuf,arialSmall);                                       
                largeFontCharArray("`A ",arialSmall);                                                       
            }else{
                largeFontCharArray("Comp off",arialSmall);                                                       
            }
            break;
        case SETUP_SAGRANGE:    //in %
            if(PRESSED(S1)){                
                if(cur.sagRange>10){
                    cur.sagRange=cur.sagRange-10;
                }else if(cur.sagRange>0){
                    cur.sagRange=cur.sagRange-1;
                }
            }
            if(PRESSED(S2)){                
                if(cur.sagRange<10){
                    cur.sagRange=cur.sagRange+1;
                }else if(cur.sagRange<100){
                    cur.sagRange=cur.sagRange+10;
                }
            }
            col=0;
            page=3;
            largeFontCharArray("Range of SOC where",smallFont);                       
            col=0;
            page=4;
            largeFontCharArray("battery voltage drops",smallFont);                       
            col=0;
            page=5;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            if(cur.sagRange){
                largeFontCharArray("Fall=",arialSmall);                                       
                getDigits((unsigned int)(cur.sagRange),dBuf);
                zeroBlank(dBuf,' ');
                largeFontCharArray(dBuf,arialSmall);                                       
                largeFontCharArray("%",arialSmall);                                                                       
            }else{
                largeFontCharArray("No V fall  ",arialSmall);                                                       
            }
            break;
        case SETUP_ENDPOINTV:   //in mV
            if(PRESSED(S1)){                
                cur.endpointV=cur.endpointV-100;
                if(cur.endpointV>4000){cur.endpointV=0;}   //unsigned overflow
            }
            if(PRESSED(S2)){                
                cur.endpointV=cur.endpointV+100;
                if(cur.endpointV>V_MAX){cur.endpointV=V_MAX;}
            }
            col=0;
            page=3;
            largeFontCharArray("Voltage at which",smallFont);                       
            col=0;
            page=4;
            largeFontCharArray("test is stopped.",smallFont);                       
            col=0;
            page=5;
            largeFontCharArray("S1 to dec. S2 to inc.",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("Endpt.=",arialSmall);                                       
            if(cur.endpointV){
                getDigits((unsigned int)(cur.endpointV),dBuf);
                zeroBlank(dBuf,' ');
                largeFontCharArray(dBuf,arialSmall);                                       
                largeFontCharArray("mV",arialSmall);
            }else{
                largeFontCharArray("Off    ",arialSmall);                
            }
            break;
        case SETUP_TPERIOD:
            if(PRESSED(S1)){                
                cur.tPeriod=cur.tPeriod-1;
                if(cur.tPeriod<(TIMER2_PERIOD-10)){cur.tPeriod=(TIMER2_PERIOD-10);}
                PR2=cur.tPeriod;    //use current
            }
            if(PRESSED(S2)){                
                cur.tPeriod=cur.tPeriod+1;
                if(cur.tPeriod>(TIMER2_PERIOD+10)){cur.tPeriod=(TIMER2_PERIOD+10);}
                PR2=cur.tPeriod;    //use current
            }
            col=0;
            page=3;
            largeFontCharArray("Internal timer period",smallFont);                       
            col=0;
            page=4;
            largeFontCharArray("S1 to speed up clock",smallFont);                       
            col=0;
            page=5;
            largeFontCharArray("S2 to slow down clock",smallFont);                       
            col=0;
            page=6;
            largeFontCharArray("Period=",arialSmall);                                       
            getDigits((unsigned int)(cur.tPeriod),dBuf);
            zeroBlank(dBuf,' ');
            largeFontCharArray(dBuf,arialSmall);                                       
            break;            
        case SETUP_RETURN:
            col=0;
            page=4;
            largeFontCharArray("Press S1 to exit",smallFont);                       
            if(PRESSED(S1)){                
                col=0;
                page=6;
                largeFontCharArray("Release S1",smallFont);                                       
                while(PRESSED(S1)){}
                __delay_ms(20);
                inSetup=0;
                setup=SETUP_CALIBRATION;
            }
            break;
        default:
            break;
    }    
}