#include "io.h"
unsigned int adcref,dacref;
unsigned char clkCnt=0;
bitField_t sPress={0,0,0,0,0,0,0,0};

void ioInit(void){
    anselbits.S1=0;
    anselbits.S2=0;
    anselbits.S3=0;
    trisbits.S1=1;
    wpubits.S1=1;
    trisbits.S2=1;
    wpubits.S2=1;
    trisbits.S3=1;
    wpubits.S3=1;    
    anselbits.RST_PIN=0;
    trisbits.RST_PIN=0;
    latbits.RST_PIN=0;
    //FVR
    FVRCONbits.ADFVR=3;    //4.096V nominal
    FVRCONbits.CDAFVR=3;   //4.096V nominal
    FVRCONbits.EN=1;        //on    
    adcref=readNVM(DIA_FVRA4X); //these addresses are found in pic16f18146.h
    dacref=readNVM(DIA_FVRC4X);
    //DAC1, direct drive of RA2
    anselbits.VSET=1;   //DAC output
    DAC1CON=0;      //reset=off, low range, OUT disabled, VDD/VSS ref    
    DAC1CONbits.PSS=2;  //FVR buffer 2
    DAC1CONbits.OE=2;   //RA2
    DAC1CONbits.EN=1;   //on
    DAC1DATL=0;       //set    
}

void tmr2Init(void){
    //TIMER2
    T2CON=0;    //reset
    T2CONbits.T2CKPS=5;     //32
    T2CONbits.T2OUTPS=0;    //1
    //T2CLKCON=1;             //FOSC/4
    T2CLKCON=4;             //LFINTOSC=31kHz
    T2HLT=0;                //free running
    TMR2=0;
    PR2=TIMER2_PERIOD;   //244x32=7808 ~4Hz (actually appears to be 31.25kHz)
    PIR2bits.TMR2IF=0;
    PIE2bits.TMR2IE=1;
    INTCONbits.PEIE=1;
    T2CONbits.TMR2ON=1;    
}

void initADC(void){
    ADCON0=0;           //reset ADC, single ended
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=8;        //bit more acquisition time
    ADCAP=0;            //extra capacitance
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    //ADCON0bits.ADFM1=1; //sign    
    ADREF=0;            //VDD    
    ADCON0bits.ADON=1;  //turn on, ready
}

unsigned int getADC(char c){
    ADPCH=c;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    return ADRES;
}

unsigned int getADCOS(char c){
    unsigned int r=0;
    char i;
    getADC(c);  //discard first, this sets channel too
    for(i=0;i<ADC_OS;i++){
        ADCON0bits.GO=1;
        while(ADCON0bits.GO){}    
        r=r+ADRES;
    }
    return r;
}

int getdADCOS(char p, char n){  //differential
    int r=0;
    char i;
    ADCON0bits.IC=1;    //differential mode
    ADPCH=p;
    ADNCH=n;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    for(i=0;i<(ADC_OS);i++){    //range is only half that of SE mode
        ADCON0bits.GO=1;
        while(ADCON0bits.GO){}    
        r=r+(int)ADRES; //ADRES is signed for differential
    }
    ADCON0bits.IC=0;    //SE mode
    return r;
}

unsigned int readNVM(unsigned int add){ //maps top bit to NVMREGS
    NVMREGS=0;
    if(add&0x8000){NVMREGS=1;}
    NVMADR=add;
    NVMCON1bits.RD=1;   //start read
    return NVMDAT;    
}

unsigned int adjust(unsigned int v,unsigned int m){ //use for known VREF
    unsigned long t;
    t=(unsigned long)v * (unsigned long)m;
    t=t/((unsigned long)ADC_OS_MAX);
    return (unsigned int)t;
}

unsigned int getVCC(void){  //assumes correct reference value in adcref, return mV
    unsigned long s,t;
    s=((unsigned long)adcref)*((unsigned long)ADC_OS_MAX);  //12bit full scale
    t=getADCOS(ADC_FVR);
    if(t<(ADC_OS_MAX/2)){return adcref*2;} //max out
    return (unsigned int)(s/t);
}

void checkSW(void){ //check for push-edges
    static bitField_t old={0,0,0,0,0,0,0,0};
    bitField_t current={0,0,0,0,0,0,0,0};
#ifdef S1
    current.bit1=PRESSED(S1);
    if((current.bit1==1)&&(old.bit1==0)){sPress.bit1=1;}
#endif
#ifdef S2
    current.bit2=PRESSED(S2);
    if((current.bit2==1)&&(old.bit2==0)){sPress.bit2=1;}
#endif
#ifdef S3
    current.bit3=PRESSED(S3);
    if((current.bit3==1)&&(old.bit3==0)){sPress.bit3=1;}
#endif
#ifdef S4
    current.bit4=PRESSED(S4);
    if((current.bit4==1)&&(old.bit4==0)){sPress.bit4=1;}
#endif
#ifdef S5
    current.bit5=PRESSED(S5);
    if((current.bit5==1)&&(old.bit5==0)){sPress.bit5=1;}
#endif
#ifdef S6
    current.bit6=PRESSED(S6);
    if((current.bit6==1)&&(old.bit6==0)){sPress.bit6=1;}
#endif    
#ifdef S7
    current.bit5=PRESSED(S7);
    if((current.bit7==1)&&(old.bit7==0)){sPress.bit7=1;}
#endif
    old=current;
}
