'HOT WIRE CUTTER (hotwire_08m2.bas)

'Heats 270mm of nichrome wire from a fixed 12V supply.
'Controls wire heat using pulse width modulation (PWM).
'Potentiometer VR1 varies the heat beteen 50% and 100%.
'The hot wire must be under spring tension (see diagram)
'Recommended nichrome wire is WW4040 from Jaycar.
'Recommended spring is Century C215 from Bunnings.


set_up:'---- initalize the microcontroller at power_on
pause 10
let dirsC = %00000110
let pinsC = %00000000
pwmout C.2,199,360
'goto read_pot

read_pot:'--- save VR1 setting in b1 using eleven steps 
let b1 = 0
readadc C.4,b0
if b0 > 230 then: b1 = 11: goto test_pot: endif
if b0 > 207 then: b1 = 10: goto test_pot: endif
if b0 > 184 then: b1 =  9: goto test_pot: endif
if b0 > 161 then: b1 =  8: goto test_pot: endif
if b0 > 138 then: b1 =  7: goto test_pot: endif
if b0 > 115 then: b1 =  6: goto test_pot: endif
if b0 >  92 then: b1 =  5: goto test_pot: endif
if b0 >  69 then: b1 =  4: goto test_pot: endif
if b0 >  46 then: b1 =  3: goto test_pot: endif
if b0 >  23 then: b1 =  2: goto test_pot: endif
if b0 <  24 then: b1 =  1: goto test_pot: endif

test_pot:'--- change heat setting only if b1 has changed
pause 10
if b1 = b2 then: goto read_pot: endif
let b2 = b1
'goto set_heat

set_heat:'--- select a heat setting between 50% and 100%
pause 10
if b2 = 11 then: pwmduty C.2,800: endif'  (100%)
if b2 = 10 then :pwmduty C.2,760: endif'  (95%)
if b2 =  9 then :pwmduty C.2,720: endif'  (90%)
if b2 =  8 then: pwmduty C.2,680: endif'  (85%)
if b2 =  7 then: pwmduty C.2,640: endif'  (80%)
if b2 =  6 then: pwmduty C.2,600: endif'  (75%)
if b2 =  5 then: pwmduty C.2,560: endif'  (70%)
if b2 =  4 then: pwmduty C.2,520: endif'  (65%)
if b2 =  3 then: pwmduty C.2,480: endif'  (60%)
if b2 =  2 then: pwmduty C.2,440: endif'  (55%)
if b2 =  1 then: pwmduty C.2,400: endif'  (50%)
goto read_pot

'Definition of Variables
'b0 = temporary variable
'b1 = pot setting
'b2 = heat setting

'Other hot wire cutters
'Silicon Chip April 2000 
'Silicon Chip December 2010