import time
import os
import re

sensor_names = {"011581aefaff": "indoor"}

def list_onewire_sensors():
    path = '/sys/bus/w1/devices'
    return [f for f in os.listdir(path) if not os.path.isfile(os.path.join(path, f)) and f.startswith('28-')]

def read_onewire_sensor(name):
    path = '/sys/bus/w1/devices'
    file = open(os.path.join(path,name,'w1_slave'), 'r')
    line1 = file.readline()
    line2 = file.readline()
    file.close()
    if line1.endswith(' YES\n'):
      info = re.search('(\\d+)\n?$', line2)
      if info and int(info.group(1)) > 0:
        return int(info.group(1)) / 1000.0
    return '?';

def getmsg(entities):
    tm = time.strftime("%d/%m/%Y %H:%M:%S", time.localtime())
    msg = "[%s]" % tm

    deg = "&deg;" if entities else u"\u00B0"

    onewire_sensors = list_onewire_sensors()
    for sensor in onewire_sensors:
      temp = read_onewire_sensor(sensor);
      msg += ' '+( sensor_names[sensor[3:]] if sensor[3:] in sensor_names else sensor[3:])+': '+('?' if temp == '?' else ('%.3f' % temp)+deg+'C')

    return msg

while True:
    print(getmsg(False))
    time.sleep(5)
