/*
   This is a Smart NightLight
   BOARD:  ESP-01S or ESP-01
   Select Generic ESP8266 in Tools/Board
   Added 3.3V active Buzzer and alarm features
   Added 4 x LED digit TM1637 Display and control features

  Arduino 1.8.19
  ArduinoWebSockets GitHub https://github.com/Links2004
  Arduino Dusk2Dawn https://github.com/dmkishi
  Arduino Time library Paul Stoffregen https://github.com/PaulStoffregenstogreffern
  Arduino TM1367Display Download latest Release https://www.arduino.cc/reference/en/libraries/tm1637/
*/

String versionNum = "(C) P J Webb Ver 1.5 3/10/2023 ESP-01 ESP-01S Web Socket";

//For ESP8266
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h> //for esp8266
#include <WebSocketsServer.h> //for ESP8266
#include <TimeLib.h>
#include <WiFiUdp.h>
#include <LittleFS.h> //for ESP8266
#include <Dusk2Dawn.h>
#include <TM1637Display.h>


//IMPORTANT
//READ THE INSTRUCTION MANUAL
//ON FIRST BOOT YOU SET YOUR NETWORK CREDENTIALS USING THE ACCESS POINT WEB PAGE
//THE NETWORK VALUES BELOW ARE DUMMY VALUES AND CHANGING THEM WILL HAVE NO EFFECT
//LOG INTO YOUR ROUTER TO GET YOUR NETWORK DETAILS:
//ON Apple devices go to Settings - WiFi and tap on the (i)Information Icon alongside the connected WiFI name to see the Network Details.  Make ipAdd unique eg if your apple Device is 192.168.1.5 then make the BC ipAdd 192.168.1.120
//ON Android devices do a web search for instructions.  Good luck, you will need it.  No two Android systems are the same.
//ON Windows 7, Click Network Icon in System tray or Search Network Connections, Open Network and Sharing Centre, select Local Area Connection, Select Details.
//ON Windows 7, Search "View Network Connections", Click "View Network Connections Control panel", Right Mouse on the Active Network Icon, Select Details.

//The next 7 lines create variables to suit your network connection
//These values are dummy values.  You will set your network on first boot of the NightLight
//Your NightLight will not find your network and will switch to access point mode
//You then connect to the NightLight network using password of: password
//Open a browser with web address 192.168.4.1:85
// Enter your network values and then re-boot.

//THE FOLLOWING ARE DUMMY VALUES. THEY ARE THERE TO CREATE THE VARIABLES AND VALUES 
//ARE SIMPLY DUMMY VALUES/EXAMPLES ONLY!
String ssid = "";       // 
String password = "";   //
IPAddress ipAdd(10, 0, 0, 60);      //eg The fixed IP Address you want for your ESP8266 eg "192.168.1.60"
IPAddress ipGw(10, 0, 0, 138);      //The IP Address of your Router     eg "192,168,1,1";
IPAddress ipDns(10, 10, 10, 138);   //The IP Address of your Router     eg "192,168,1,1";
IPAddress ipSnm(255, 255, 255, 0);  //SubNet Mask - Usually 255,255,255,0

//SERVER VARIABLES & DECLARATIONS
const unsigned int serverPort = 85;
ESP8266WebServer server(serverPort);//Server on port 85 for esp8266
WebSocketsServer webSocket = WebSocketsServer(81);

//Modes
String htmlMode = "Main";

//Messages
String message = "Smart Night Light."; // General operation messages

//Timers and time variables
unsigned int webSocketRun = 1000;//run webSocket Loop milliseconds
unsigned int webSocketTimerStart;//Start Time for Web Socket Data Response

unsigned long wifiTimer = 30;//To switch WiFi of after timeout minutes
unsigned long wifiTimerStart = 0;//variable for Wifi Timer 
bool wifiOn = true;//Switches WiFi off after wifiTimer minutes, then on for Wifi Timer minutes at 16:30 each day

//Clock
// NTP Servers:
//static const char ntpServerName[] = "us.pool.ntp.org";
static const char ntpServerName[] = "pool.ntp.org";
int timeZone = 95;  // 9.5 hours ahead of GMT Adelaide CST
bool daylightSavings = false;

WiFiUDP Udp;
//unsigned int localPort = 8888;  // local port to listen for UDP packets
//unsigned int localPort = 1337;  // local port to listen for UDP packets
//unsigned int localPort = 1023;  // local port to listen for UDP packets
unsigned int localPort = 1023;  // local port to listen for UDP packets

time_t getNtpTime();

//const int
const int NTP_PACKET_SIZE = 48; // NTP time is in the first 48 bytes of message
byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming & outgoing packets
void sendNTPpacket(IPAddress &address);
String timeString = "";

//Colours
String buttonBackColour = "blue";
String buttonTextColour = "white";
String sliderKnobColour = "white";
String sliderBackColour = "blue";

// Pin Variables
const byte ledPin = 2;
const int buzzPin = 0;

//Default Settings
unsigned int brightness = 50;//%
unsigned int defBrightness = 50;
unsigned int lightOnHour = 17;
unsigned int lightOnMins = 30;
unsigned int lightOffHour = 7;
unsigned int lightOffMins = 30;
unsigned int alarmOnHour = 17;
unsigned int alarmOnMins = 30;
bool clockOn = true;

unsigned int dToDLightOnHour = 17;
unsigned int dToDLightOnMins = 0;
unsigned int dToDLightOffHour = 7;
unsigned int dToDLightOffMins = 0;
bool lightOn = false;
bool manualOn = false;
bool duskToDawn = false;
String location = "Adelaide";//Default location.  Change it in OPtions.
String sunriseTime;
String sunsetTime;
bool alarmOn = false;
unsigned int alarmDuration = 15;
bool alarmRunning = false;

Dusk2Dawn a(-34.9212, 138.5995 , 9.5); //Adelaide. Problem with this Library: 9.5 is 30 mins early, 10.0 is 30 mins late adjust later
Dusk2Dawn b(-27.4705, 153.0260 , 10);// Brisbane
Dusk2Dawn c(-35.2802, 149.1310 , 10);//Canberra
Dusk2Dawn d(-12.4637, 130.8444 , 9.5);//Darwin
Dusk2Dawn m(-37.8136, 144.9631 , 10);//Melbourne
Dusk2Dawn p(-31.9523, 115.8613 , 8);//Perth
Dusk2Dawn s(-33.8688, 151.2093 , 10);//Sydney
Dusk2Dawn h(-42.8826, 147.3257 , 10);//Hobart


byte wifiTimeout = 15; //Seconds before switching to AP
const char WiFiAPPSK[] = "password";//Password for Setup AP
unsigned int syncTime = 10;
unsigned int syncFast = 10;
unsigned int syncSlow = 300;

//Display

#define CLK 3  //Rx Optional: use 390R between ESP-01 and SCL of TM1637
#define DIO 1   // Tx Optional: use 390R between ESP-01 and SDA/DIO of TM1637
TM1637Display display(CLK, DIO);
int clockBrightness = 7;

//function prototypes
void readData();
void writeData();

//=============== SETUP ====================
void setup(void)
{
  pinMode(ledPin, OUTPUT);
  pinMode(buzzPin, OUTPUT);
  digitalWrite(buzzPin, HIGH);
  display.setBrightness(clockBrightness, clockOn); // 0 to 7, true = on
  display.showNumberDec(0, false); // no leading zeros
  //Cannot use Serial and I2C at same time
  //Serial.begin(115200);
  //Serial.begin(115200,SERIAL_8N1,SERIAL_TX_ONLY);
  //Serial.println ("*************************");
  //Serial.println ("Booting Night Light");
  //Serial.println (versionNum);
  //Serial.println ("*************************");
  if (!LittleFS.begin())
  {
    //  Serial.println("Little FS error while mounting.");
  }
  else
  {
    //   Serial.println("Little FS mounted Ok.");
  }
  readData();
  //Serial.println (" ");

  //Serial.println ("**********Configuring WiFi*********** ");
  ipDns = ipGw;//set to router address
  WiFi.config(ipAdd, ipGw, ipSnm, ipDns);
  //Convert String ssid and password to char arays for WiFi.begin
  WiFi.begin(ssid.c_str(), password.c_str());
  // Serial.println ("SSID: " + ssid);
  // Serial.println ("Password: " + password);
  //Serial.print ("IP Add: ");
  //Serial.println (ipAdd );
  //Serial.print ("GW: ");
  //Serial.println (ipGw);
  //Serial.print ("DNS: ");
  //Serial.println (ipDns);
  //Serial.print ("SNM: ");
  //Serial.println (ipSnm);
  //Serial.println("");
  // Wait for connection
  // Serial.println ("**********Connecting WiFi*********** ");
  int counter = 0;
  while (WiFi.status() != WL_CONNECTED)
  {
    analogWrite(ledPin, 200);
    delay(500);
    digitalWrite(ledPin, HIGH);
    delay (500);
    Serial.print(".");
    counter ++;
    display.showNumberDec(counter, false); // Expect:___0  no leading zeros
    if (counter > wifiTimeout)
    {
      // Serial.println ("Cannot find WiFi network. Switching to AP Mode.");
      htmlMode = "AP";
      break;
    }
  }
  if (htmlMode == "AP")
  {
    setupAPMode();
  }
  else
  {
    // Serial.println("");
    //Serial.println("WiFi connected..!");
    //Serial.print("Got IP: ");
    //Serial.println(WiFi.localIP());
    Udp.begin(localPort);
    setSyncProvider(getNtpTime);
    setSyncInterval(syncTime);
    //getNtpTime();

  }
  //server.begin();
  //Serial.println ("**********Starting Web Socket*********** ");
  webSocket.begin();
  webSocket.onEvent(webSocketEvent);
  server.on("/", handlePage);
  server.begin();
  //Serial.println("HTTP server started");
  if (!wifiOn)
  {
    wifiTimerStart = millis();
  }

}
//=============== LOOP ====================
void loop(void)
{
  handleWebSocket();//Typically every 2 seconds
  if (htmlMode == "Main")
  {
    createTimeStr();
    checkLightStatus();//Switch On/Off
    getSunsetSunrise();
  }
  else    //AP mode
  {
    analogWrite(ledPin, 240);
    delay(25);
    digitalWrite(ledPin, HIGH);
    delay (100);
    if (millis() > wifiTimerStart + (6000 * wifiTimer)) //3 minutes if wifiTimer = 30minutes
    { 
      //Reboot and try WiFi connection again after time out.
      //Added to ensure restart if power goes off and Router takes time to re-establish its AP
      //Ok for ESP to change to AP mode but should retry Router after a delay.
      //If all is restored then it will connect and run as normal.
      //Serial.println ("Re-booting");
      delay (2000);
      ESP.restart();
    }
  }
  if (!wifiOn)//turn wifi Off after timeout
  {
    if (millis() > wifiTimerStart + (60000 * wifiTimer))
    {
      //turn off WiFi
      if (WiFi.isConnected())
      {
        //Serial.println ("WiFi is turning Off.");
        WiFi.disconnect(true, false);
      }
    }
    //Re-connect at 4:30pm
    if (WiFi.isConnected() == false and hour() == 16 and minute() == 30 and second() <= 20)
    {
      delay (30000);
      ESP.restart();
    }
  }
}
