void readData()//fName format "/SavedFile.txt"
{
  //Open the file
  File file = LittleFS.open("/Defaults.txt", "r");

  //Check if the file exists
  if (!file)
  {
    //Serial.println ("Couldn't find /Defaults.txt");
    return;
  }
  String inStr = "";
  int counter = 0;
  while (file.available())
  {
    int inData = file.read();
    //Serial.println (inData);
    if (inData == char(10) or inData == char (13))
    {
      if (inData == char (13))
      {
        //Serial.println("Reading " + String (counter) + " " + inStr);
        switch (counter)
        {
          case 0:
            defBrightness = inStr.toInt();
            brightness = defBrightness;
            // Serial.println ("Default Brightness is: " + String (defBrightness));
            break;
          case 1:
            timeZone = inStr.toInt();
            // Serial.println ("Time Zone is: " + String (timeZone));
            break;
          case 2:
            lightOnHour = inStr.toInt();
            // Serial.println ("On Hour is: " + String (lightOnHour));
            break;
          case 3:
            lightOnMins = inStr.toInt();
            // Serial.println ("On Minutes is: " + String (lightOnMins));
            break;
          case 4:
            lightOffHour = inStr.toInt();
            // Serial.println ("Off Hour is: " + String (lightOffHour));
            break;
          case 5:
            lightOffMins = inStr.toInt();
            // Serial.println ("Off Minutes is: " + String (lightOffMins));
            break;
          case 6:
            if ( inStr == "1")
            {
              duskToDawn = true;
              // Serial.println ("Sunset to Sunrise is On.");
            }
            else
            {
              duskToDawn = false;
              // Serial.println ("Sunset to Sunrise is Off.");
            }
            break;
          case 7:
            ssid = inStr;
            //Serial.println ("SSID is:" + ssid);
            break;
          case 8:
            password = inStr;
            //Serial.println ("Password is:" + password);
            break;
          case 9:
            ipAdd = strToIp(inStr);
            // Serial.println ("ipAddress is:" + inStr);
            break;
          case 10:
            ipGw = strToIp(inStr);
            // Serial.println ("ipGW is:" + inStr);
            break;
          case 11:
            location = inStr;
            // Serial.println ("Location is:" + location);
            timeZone = 100;
            if (location == "Adelaide" or location == "Darwin")
            {
              timeZone = 95;
            }
            if (location == "Perth")
            {
              timeZone = 80;
            }

            break;
          case 12:
            if ( inStr == "1")
            {
              daylightSavings = true;
              // Serial.println ("Daylight Savings is On.");
            }
            else
            {
              daylightSavings = false;
              // Serial.println ("Daylight Savings is Off.");
            }
          case 13:
            if ( inStr == "1")
            {
              alarmOn = true;
              // Serial.println ("Alarm is On.");
            }
            else
            {
              alarmOn = false;
              // Serial.println ("Alarm is Off.");
            }
            break;
          case 14:
            alarmOnHour = inStr.toInt();
            // Serial.println ("Alarm Hour is: " + String (alarmOnHour));
            break;
          case 15:
            alarmOnMins = inStr.toInt();
            //Serial.println ("Alarm Minutes is: " + String (alarmOnMins));
            break;
          case 16:
            alarmDuration = inStr.toInt();
            //Serial.println ("Alarm duration is: " + String (alarmDuration));
            break;
          case 17:
            if ( inStr == "1")
            {
              wifiOn = true;
              //Serial.println ("Wifi is On.");
            }
            else
            {
              wifiOn = false;
              //Serial.println ("WiFi is Off after " + String(wifiTimer) + " Mins.");
            }
            break;
          case 18:
            if ( inStr == "1")
            {
              clockOn = true;
              //Serial.println ("Clock is On.");
            }
            else
            {
              clockOn = false;
              //Serial.println ("Clock is Off.");
            }
            break;
             case 19:
            clockBrightness = inStr.toInt();
            if (clockBrightness <0 or clockBrightness >7)
            {
              clockBrightness = 4;
            }
            //Serial.println ("Clock Brightness is:" + String (clockBrightness);
            break;
          default:
            break;
        }
        inStr = "";
        counter ++;
      }

    }
    else
    {
      inStr += char(inData);
    }
  }
  //Close the file
  // Serial.println ("Finished reading / Defaults.txt");
  file.close();
}
