void handleRequest(String request)
{
  //Handles request Strings sent from the Client
  //Serial.println ("State Received is: " + request);

  //Switch Web Page Views
  if (request.indexOf("mainview") > -1)
  {
    htmlMode = "Main";

  }
  else if (request == "butreboot")
  {
    ESP.restart();
  }
  else if (request == "seta15")
  {
    //alarmRunTime = 15
  }

  else if (request.indexOf("atoggleoff") > -1)
  {
    alarmOn = false;
    alarmRunning = false;
    message = "Alarm is Off.";
  }
  else if (request.indexOf("atoggleon") > -1)
  {
    alarmOn = true;
    alarmRunning = false;
    message = "Alarm is On.";

  }
  else if (request.indexOf("mtoggleon") > -1)
  {
    manualOn = true;
    message = "Manual On.";

  }
  else if (request.indexOf("mtoggleoff") > -1)
  {
    manualOn = false;
    message = "Manual Off.";

  }
  else if (request.indexOf("defbrightness=") > -1)
  {
    defBrightness = request.substring (request.indexOf("=") + 1).toInt();
    brightness = defBrightness;
    message = "Default Brightness is now: " + request.substring (request.indexOf("=") + 1) + " %";
   // Serial.println ("Default Brightness is  "  + String (defBrightness) + " %");
    if (lightOn)
    {
      message += " and Light is On.";
      if (brightness > 0)
      {
        analogWrite(ledPin, ((100 - brightness) * 254) / 100);
      }
      else
      {
        digitalWrite(ledPin, HIGH);
      }
    }
    else
    {
      message += " but Light is Off.";
    }
    writeData();
  }
  else if (request.indexOf("brightness=") > -1)
  {
    //textColour = request.substring(8);
    brightness = request.substring( request.indexOf("=") + 1).toInt();
    message = "Brightness is set to " + String (brightness) + " %";
    if (lightOn)
    {
      message += " and Light is On.";
      if (brightness > 0)

      {
        analogWrite(ledPin, ((100 - brightness) * 254) / 100);
      }
      else
      {
        digitalWrite(ledPin, HIGH);
      }
    }
    else
    {
      message += " but Light is Off.";
    }
  }
  else if (request.indexOf("dstoggleoff") > -1) //Daylight Savings
  {
    daylightSavings = false;
    syncTime = syncFast;
    setSyncInterval(syncTime);

    //Serial.println ("Daylight Savings is Off.");
    message = "Daylight Savings is Off.";
    writeData();
  }
  else if (request.indexOf("dstoggleon") > -1) //Daylight Savings
  {

    daylightSavings = true;
    syncTime = syncFast;
    setSyncInterval(syncTime);

    Serial.println ("Daylight Savings is On.");
    message = "Daylight Savings is On.";
    writeData();
  }
//OPTIONS
  else if (request == "options=clockon")
  {
    clockOn = true;
    message = "Clock is On.";
    display.setBrightness(clockBrightness, clockOn); // 0 to 7, true = on
    writeData();
  }

  else if (request == "options=clockoff")
  {
    clockOn = false;
    message = "Clock is Off.";
    display.setBrightness(clockBrightness, clockOn); // 0 to 7, true = on
    writeData();
  }
  else if (request.indexOf("options=cbright" ) > -1)
  {
    clockBrightness = request.substring(request.indexOf("bright") + 6).toInt();
    message = "Setting Clock Brightness to " + String (clockBrightness  + 1);
    writeData();
  }

  else if (request == "options=wifion")
  {
    wifiOn = true;
    message = "WiFi will remain On.";
    writeData();
  }
  else if (request == "options=wifioff")
  {
    wifiOn = false;
    message = "WiFi turning Off in " + String (wifiTimer) + " mins. Then Web Page unresponsive til Night Light reset.";
    wifiTimerStart = millis();
    writeData();
  }

  else if (request == "options=O")//Show current options in message
  {
    message  = "Location: " + location ;
    message +=  ". Alarm duration: " + String (alarmDuration) + " secs." ;
    if ( alarmOn )
    {
      message += " Alarm On." ;
    }
    else
    {
      message += " Alarm Off.";
    }
    if ( wifiOn )
    {
      message += " WiFi On." ;
    }
    else
    {
      message += " WiFi Off.";
    }
    return;
  }
  else if (request == "options=N") //Network Reset
  {
    ssid = "unknown";
    password = "unknown";
    writeData();
    ESP.restart();
  }
  else if (request == "options=R") //Re-Boot
  {
    ESP.restart();
  }
  else if (request == "options=V") //
  {
    message = versionNum;
  }
  else if (request.indexOf ("options=seta") > -1)
  {
    alarmDuration = request.substring (request.indexOf("=") + 5).toInt();
    if (alarmDuration <15 or alarmDuration >120)
    {
      alarmDuration = 15;
    }
    message = "Alarm Duration is " + String (alarmDuration ) + " secs";
    writeData();
  }
  else if (request.indexOf("options=") > -1) //HANDLES LOCATIONS. Make sure this is the last else if for OPtions
  {
    location = request.substring (request.indexOf("=") + 1);
    message = "Location is now : " + location;
    timeZone = 100;
    if (location == "Adelaide" or location == "Darwin")     {
      timeZone = 95;
    }
    if (location == "Perth") {
      timeZone = 80;
    }
    syncTime = syncFast;
    setSyncInterval(syncTime);
    writeData();
  }
  else if (request.indexOf("lightonhour=") > -1)
  {
    unsigned int tempOnH = request.substring (request.indexOf("=") + 1).toInt();
    if (tempOnH == lightOffHour and lightOnMins == lightOffMins)
    {
      message = "Cannot have same On and Off Times";
     // Serial.println (message);
      return;
    }
    lightOnHour =  request.substring (request.indexOf("=") + 1).toInt();
    message = "On Time is:" + cTo2Dig (lightOnHour) + ":" + cTo2Dig(lightOnMins);
    checkLightStatus();
    writeData();
  }

  else if (request.indexOf("lightonmins=") > -1)
  {
    unsigned int tempOnM = request.substring (request.indexOf("=") + 1).toInt();
    if (lightOnHour == lightOffHour and tempOnM == lightOffMins)
    {
      message = "Cannot have same On and Off Times";
     // Serial.println (message);
      return;
    }
    lightOnMins =  request.substring (request.indexOf("=") + 1).toInt();
    message = "On Time is:" + cTo2Dig(lightOnHour) + ":" + cTo2Dig(lightOnMins);
    checkLightStatus();
    writeData();
  }
  else if (request.indexOf("lightoffhour=") > -1)
  {
    unsigned int tempOffH = request.substring (request.indexOf("=") + 1).toInt();
    if (tempOffH == lightOnHour and lightOnMins == lightOffMins)
    {
      message = "Cannot have same On and Off Times";
    //  Serial.println (message);
      return;
    }
    lightOffHour =  request.substring (request.indexOf("=") + 1).toInt();
    message = "Off Time is:" + cTo2Dig (lightOffHour) + ":" + cTo2Dig(lightOffMins);
    checkLightStatus();
    writeData();
  }

  else if (request.indexOf("lightoffmins=") > -1)
  {
    unsigned int tempOffM = request.substring (request.indexOf("=") + 1).toInt();
    if (lightOnHour == lightOffHour and tempOffM == lightOnMins)
    {
      message = "Cannot have same On and Off Times";
    //  Serial.println (message);
      return;
    }
    lightOffMins =  request.substring (request.indexOf("=") + 1).toInt();
    message = "Off Time is:" + cTo2Dig(lightOffHour) + ":" + cTo2Dig(lightOffMins);
    checkLightStatus();
    writeData();
  }
  else if (request.indexOf("alarmonhour=") > -1)
  {

    alarmOnHour =  request.substring (request.indexOf("=") + 1).toInt();
    message = "Alarm On Time is:" + cTo2Dig (alarmOnHour) + ":" + cTo2Dig(alarmOnMins);
    checkLightStatus();
    writeData();
  }

  else if (request.indexOf("alarmonmins=") > -1)
  {

    alarmOnMins =  request.substring (request.indexOf("=") + 1).toInt();
    message = "Alarm On Time is:" + cTo2Dig (alarmOnHour) + ":" + cTo2Dig(alarmOnMins);
    checkLightStatus();
    writeData();
  }
  else if (request.indexOf("sstoggleon") > -1)
  {
    duskToDawn = true;
    message = "Sunset to Sunrise is On.";
    writeData();//saves old times not d2D times

    checkLightStatus();  //check if it should be on or off

  }
  else if (request.indexOf("sstoggleoff") > -1)
  {
    duskToDawn = false;
    message = "Sunset to Sunrise is Off.";
    writeData();
    checkLightStatus();
  }

  //*********SSID and Pasword String to Char
  else if (request.indexOf("ssid=") > -1 )
  {
    ssid = request.substring(request.indexOf("=") + 1);
    writeData();
    wifiTimerStart = millis();

  }
  else if (request.indexOf("password=") > -1)
  {
    password = request.substring(request.indexOf("=") + 1);
    writeData();
    wifiTimerStart = millis();
  }
  else if (request.indexOf("ipaddress=") > -1)
  {
    String tempval = request.substring(request.indexOf("=") + 1);
    ipAdd = strToIp(tempval);
    writeData();
    wifiTimerStart = millis();
  }
  else if (request.indexOf("ipgw=") > -1)
  {
    String tempval = request.substring(request.indexOf("=") + 1);
    ipGw = strToIp(tempval);
    writeData();
    wifiTimerStart = millis();
  }


}
