#include <Wire.h>
#include "RTClib.h"

#define SDA_PIN 21
#define SCL_PIN 15

RTC_DS3231 rtc;

void setup() {
  Serial.begin(115200);
  delay(3000); // wait for Serial to open

  // Initialize I2C with custom pins
  Wire.begin(SDA_PIN, SCL_PIN);

  if (!rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

  // Set RTC time to the time when the sketch was compiled
  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));

  Serial.println("RTC time set to compile time.");
}

void loop() {
  DateTime now = rtc.now();
  Serial.print("Current Time: ");
  Serial.print(now.year(), DEC);
  Serial.print('/');
  Serial.print(now.month(), DEC);
  Serial.print('/');
  Serial.print(now.day(), DEC);
  Serial.print(" ");
  Serial.print(now.hour(), DEC);
  Serial.print(':');
  Serial.print(now.minute(), DEC);
  Serial.print(':');
  Serial.println(now.second(), DEC);

  delay(1000);
}