// ESP32 connections
// BUSY -> 4, RST -> 16 , DC -> 17 , CS -> SS(5), CLK -> SCK(18), DIN -> MOSI(23), GND -> GND, 3.3V -> 3.3V

// RTC Connections
// SDA ->21, SCL ->15

// Power consumptions: 8 mA on a Li-Ion battery during active stage & 0.04 mA during deep sleep state

#include <GxEPD2_BW.h>         // For b/w e-paper displays
//#include <GxEPD2_3C.h>         // For 3-color (black, white, red) displays
#include <U8g2_for_Adafruit_GFX.h>
#include <Fonts/FreeMonoBold18pt7b.h>
#include <Fonts/FreeMonoBold12pt7b.h>
#include <Fonts/FreeSansBold12pt7b.h>
#include <Fonts/FreeSansBold24pt7b.h>
#include <Fonts/FreeSansBold18pt7b.h>
#include <Fonts/FreeSerifBold18pt7b.h>
#include <Fonts/FreeSerifBold24pt7b.h>
#include <Fonts/FreeSerifBold12pt7b.h>
#include <Fonts/FreeSans9pt7b.h>
#include <Fonts/FreeSans12pt7b.h>
#include <Fonts/FreeMonoBold9pt7b.h>
#include <Fonts/FreeMonoBold12pt7b.h>
#include <Fonts/FreeMonoBold24pt7b.h>

#include <WiFi.h>
#include "time.h"
//#include <U8g2_for_Adafruit_GFX.h>
#include <GxEPD2_4C.h>
#include "GxEPD2_display_selection_new_style.h"  // Your e-paper display config
#include <RTClib.h>
#include <Adafruit_AHTX0.h>

U8G2_FOR_ADAFRUIT_GFX u8g2Fonts;
RTC_DS3231 rtc;
Adafruit_AHTX0 aht;
// Use GPIO21 for SDA and GPIO15 for SCL
#define SDA_PIN 21
#define SCL_PIN 15

unsigned long lastUpdate = 0;
const unsigned char raspberryBitmap[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x21, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x07, 0x81, 0xF0,
  0x78, 0x00, 0x00, 0x00, 0x07, 0xF3, 0xF3, 0xFA, 0x00, 0x00, 0x00, 0x03,
  0x7B, 0xF7, 0xB0, 0x00, 0x00, 0x00, 0x01, 0xBB, 0xF7, 0x70, 0x00, 0x00,
  0x00, 0x01, 0xDB, 0xF6, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xE9, 0xE5, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x75, 0xEB, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xCF, 0xFC, 0xFC, 0x00, 0x00, 0x02,
  0x1C, 0x79, 0xE7, 0x8E, 0x00, 0x00, 0x00, 0x18, 0x78, 0xC7, 0x86, 0x00,
  0x00, 0x00, 0x30, 0xE0, 0x41, 0xC3, 0x00, 0x00, 0x00, 0x30, 0xE0, 0x41,
  0xC3, 0x10, 0x00, 0x00, 0x30, 0xF0, 0x43, 0xC3, 0x00,
};
// Width: 50, Height: 50
void setup() {
  WiFi.mode(WIFI_OFF);
  btStop();  // disables Bluetooth if not needed
  Serial.begin(115200); 
  delay(50);  // small delay if needed
  setCpuFrequencyMhz(40);

  Serial.begin(115200);
  // Init Display
  display.init(115200, true, 2, false);
  display.setRotation(0);
  display.setFullWindow();
  u8g2Fonts.begin(display);
  delay(50);

 // Initialize I2C on custom pins
  Wire.begin(SDA_PIN, SCL_PIN);
  Wire.setClock(100000); // Lower clock speed (optional)
  // Init RTC
  if (!rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);  // Stop execution
  }

// Set RTC time to the time when the sketch was compiled
//  rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));


  if (rtc.lostPower()) {
    Serial.println("RTC lost power, setting time to compile time");
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));  // Set to sketch compile time
  }

// Start AHT10
  if (!aht.begin(&Wire)) {
    Serial.println("Couldn't find AHT10 sensor!");
    while (1);
  }

  Serial.println("AHT10 + DS3231 initialized successfully.");
  // Read time from RTC
  DateTime now = rtc.now();
  Serial.println("RTC Time:");
  Serial.printf("%02d:%02d:%02d  %02d/%02d/%04d\n",
                now.hour(), now.minute(), now.second(),
                now.day(), now.month(), now.year());
  lastUpdate = millis();
  drawClock();  // Assumes this uses rtc.now() now instead of getLocalTime()
  Serial.println("Setup complete.");
  Serial.end();  //May causes the switch on / blinking of the on_board LED. 
  esp_sleep_enable_timer_wakeup(1 * 45 * 1000000);
  esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH, ESP_PD_OPTION_OFF);  // Turn off ADC & other RTC peripherals; Don't use this as it Increases active current
  esp_deep_sleep_start();
}
  
float dew_point(float temperature, float humidity) {
  float a = 17.62;
  float b = 243.12;
  float gamma = log(humidity / 100.0) + (a * temperature) / (b + temperature);
  return (b * gamma) / (a - gamma);
}

void loop() {
  if (millis() - lastUpdate > 60000) { // Update every 1 min
    lastUpdate = millis();
    drawClock();
  }
}

#define DEG_TO_RAD 0.0174532925

void drawClock() {
DateTime now = rtc.now();
struct tm timeinfo;
timeinfo.tm_sec = now.second();
timeinfo.tm_min = now.minute();
timeinfo.tm_hour = now.hour();
timeinfo.tm_mday = now.day();
timeinfo.tm_mon = now.month() - 1;
timeinfo.tm_year = now.year() - 1900;
timeinfo.tm_wday = now.dayOfTheWeek();  // 0 = Sunday

 // Read temperature and humidity
  sensors_event_t humidity, temp;
  aht.getEvent(&humidity, &temp);

  // Print to Serial
  Serial.print("Time: ");
  Serial.print(now.year()); Serial.print("-");
  Serial.print(now.month()); Serial.print("-");
  Serial.print(now.day()); Serial.print(" ");
  Serial.print(now.hour()); Serial.print(":");
  Serial.print(now.minute()); Serial.print(":");
  Serial.println(now.second());

  Serial.print("Temperature: ");
  Serial.print(temp.temperature);
  Serial.println(" °C");

  Serial.print("Humidity: ");
  Serial.print(humidity.relative_humidity);
  Serial.println(" %");

  Serial.print("Dew_Point: ");
  Serial.print(dew_point(temp.temperature, humidity.relative_humidity));
  Serial.println(" C");
  Serial.println("----------------------");
  //delay(2000);
  // Time (HH:MM:SS)
  char timeStr[9];
  sprintf(timeStr, "%02d:%02d:%02d", timeinfo.tm_hour, timeinfo.tm_min, timeinfo.tm_sec);

  // Date
  char dateStr[30];
  strftime(dateStr, sizeof(dateStr), "%a, %d %b %Y", &timeinfo);

  int thisDay = timeinfo.tm_mday;
  int thisMonth = timeinfo.tm_mon + 1; // tm_mon is 0-based
  int thisYear = timeinfo.tm_year + 1900;

  display.firstPage();
  do {
    display.fillScreen(GxEPD_WHITE);
    // Colors
    uint16_t bg = GxEPD_WHITE;
    uint16_t fg = GxEPD_RED;
    uint16_t bl = GxEPD_BLACK;
    uint16_t yl = GxEPD_YELLOW;

    // ------------------ Digital Clock ------------------
    u8g2Fonts.setFontMode(1);
    u8g2Fonts.setFontDirection(0);
    u8g2Fonts.setBackgroundColor(bg);  //bg

    u8g2Fonts.setFont(u8g2_font_fub25_tf); //30_tf
    u8g2Fonts.setForegroundColor(fg);
    int timeW = u8g2Fonts.getUTF8Width(timeStr);
    int timeX = (display.width() - timeW) / 2;
    int timeY = 38;
    u8g2Fonts.setCursor(timeX , timeY);
    u8g2Fonts.print(timeStr);

    u8g2Fonts.setFont(u8g2_font_ncenB14_tf);
    u8g2Fonts.setForegroundColor(bl);
    int dateW = u8g2Fonts.getUTF8Width(dateStr);
    int dateX = (display.width() - dateW) / 2;
    int dateY = timeY + 20;
    u8g2Fonts.setCursor(dateX, dateY);
    u8g2Fonts.print(dateStr);
//AHT10 data
u8g2Fonts.setFont(u8g2_font_ncenB12_tf);  // B12 
u8g2Fonts.setForegroundColor(fg);

// First line: Temperature and Humidity
char line1[32];
sprintf(line1, "T:%.1fC  RH:%.1f%%", temp.temperature, humidity.relative_humidity);
int line1X = (display.width() - u8g2Fonts.getUTF8Width(line1)) / 2;
int line1Y = dateY + 18;
u8g2Fonts.setCursor(line1X, line1Y);
u8g2Fonts.print(line1);

// Second line: Dew Point
char line2[32];
u8g2Fonts.setForegroundColor(bl);
sprintf(line2, "Dew_point:%.1fC", dew_point(temp.temperature, humidity.relative_humidity));
int line2X = (display.width() - u8g2Fonts.getUTF8Width(line2)) / 2;
int line2Y = line1Y + 16;  // Adjust vertical spacing
u8g2Fonts.setCursor(line2X, line2Y);
u8g2Fonts.print(line2);
//AHT10 data ends here

    // ------------------ Analog Clock ------------------
    int centerX = display.width() / 2;
    int centerY = 170;
    int radius = 70;

    display.drawCircle(centerX, centerY, radius, bl);

    for (int i = 1; i <= 12; i++) {
      float angle = (i - 3) * 30 * DEG_TO_RAD;
      int tx = centerX + cos(angle) * (radius - 15);
      int ty = centerY + sin(angle) * (radius - 15);
      char buf[3];
      sprintf(buf, "%d", i);
      u8g2Fonts.setFont(u8g2_font_ncenB08_tr);
      int textWidth = u8g2Fonts.getUTF8Width(buf);
      u8g2Fonts.setCursor(tx - textWidth / 2, ty + 4);
      u8g2Fonts.print(buf);
    }

    for (int h = 0; h < 12; h++) {
      float angle = (h / 12.0) * 2 * PI - PI / 2;
      int x1 = centerX + cos(angle) * (radius - 6);
      int y1 = centerY + sin(angle) * (radius - 6);
      int x2 = centerX + cos(angle) * radius;
      int y2 = centerY + sin(angle) * radius;
      display.drawLine(x1, y1, x2, y2, bl);
    }

    float secAngle = (timeinfo.tm_sec / 60.0) * 2 * PI - PI / 2;
    float minAngle = (timeinfo.tm_min / 60.0 + timeinfo.tm_sec / 3600.0) * 2 * PI - PI / 2;
    float hourAngle = ((timeinfo.tm_hour % 12) / 12.0 + timeinfo.tm_min / 720.0) * 2 * PI - PI / 2;

    auto drawThickLine = [&](int x0, int y0, float angle, int length, int thickness, uint16_t color) {
      int x1 = x0 + cos(angle) * length;
      int y1 = y0 + sin(angle) * length;
      for (int i = -thickness / 2; i <= thickness / 2; i++) {
        int dx = i * sin(angle);
        int dy = -i * cos(angle);
        display.drawLine(x0 + dx, y0 + dy, x1 + dx, y1 + dy, color);
      }
    };

    drawThickLine(centerX, centerY, hourAngle, radius - 40, 8, fg);
    drawThickLine(centerX, centerY, minAngle, radius - 20, 6, yl);
    drawThickLine(centerX, centerY, secAngle, radius - 10, 4, bl);
    display.fillCircle(centerX, centerY, 3, bl);
    //display.drawBitmap(centerX-20, centerY-20, b_balloonIcon, 40,40, GxEPD_RED);  //100,100
    //drawRandomBalloon(centerX, centerY, b_balloonIcon);
    raspberry(centerX, centerY);
// ------------------ Calendar ------------------
int calendarTop = centerY + radius + 10 +15-10 ;
int daySize = 22;
int spacing = 4;
int colStart = (display.width() - (7 * daySize + 6 * spacing)) / 2;

// Day names
u8g2Fonts.setFont(u8g2_font_helvB08_tf);
u8g2Fonts.setForegroundColor(bl);
const char* days[] = {"S", "M", "T", "W", "T", "F", "S"};
for (int i = 0; i < 7; i++) {
  u8g2Fonts.setCursor(colStart + i * (daySize + spacing) + 6, calendarTop);
  u8g2Fonts.print(days[i]);
}

// Extract current day/month/year
int thisDay = timeinfo.tm_mday;
int thisMonth = timeinfo.tm_mon + 1;  // 1-based
int thisYear = timeinfo.tm_year + 1900;

// Get first day of the month
struct tm firstDay = timeinfo;
firstDay.tm_mday = 1;
mktime(&firstDay);
int startWday = firstDay.tm_wday;  // Sunday=0

// Days in current month
int daysInMonth;
if (thisMonth == 2) {
  daysInMonth = ((thisYear % 4 == 0 && thisYear % 100 != 0) || (thisYear % 400 == 0)) ? 29 : 28;
} else if (thisMonth == 4 || thisMonth == 6 || thisMonth == 9 || thisMonth == 11) {
  daysInMonth = 30;
} else {
  daysInMonth = 31;
}
// Fill 5 rows only = 35 cells
int totalCells = 35;
int day = 1;
int nextMonthDay = 1;

for (int cell = 0; cell < totalCells; cell++) {
  int row = cell / 7;
  int col = cell % 7;

  int x = colStart + col * (daySize + spacing);
  int y = calendarTop + 15 + row * (daySize + 4);

  char buf[3];

  if (cell < startWday) {
    // Optional: Leave empty or show previous month days
    continue;
  } else if (day <= daysInMonth) {
    sprintf(buf, "%2d", day);
    if (day == thisDay) {
      display.drawCircle(x + daySize / 2, y + daySize / 2, daySize / 2, fg);
    }
    day++;
    u8g2Fonts.setForegroundColor(bl);
  } else {
    // Next month days
    sprintf(buf, "%2d", nextMonthDay);
    u8g2Fonts.setForegroundColor(GxEPD_RED);  // Show next month in red
    nextMonthDay++;
  }

  u8g2Fonts.setCursor(x + 6, y + 16);
  u8g2Fonts.print(buf);
  u8g2Fonts.setForegroundColor(bl);  // Reset

}

  } while (display.nextPage());
  display.hibernate();
  //AHT10.Reset();
  Serial.printf("Updated: %s %s\n", timeStr, dateStr);
}

void raspberry(int centerX, int centerY) {
  float angle = random(0, 628) / 100.0; // 0 to 2π
  int r = random(0, 70);
  int x = centerX + r * cos(angle) - 20;
  int y = centerY + r * sin(angle) - 20;

  uint16_t color;
  switch (random(0, 3)) {
    case 0: color = GxEPD_RED; break;
    case 1: color = GxEPD_YELLOW; break;
    default: color = GxEPD_BLACK;
  }

  display.drawBitmap(x, y, raspberryBitmap, 50, 50, color);
}