from sense_hat import SenseHat
import time
import os

def get_cpu_temp():
    t = os.popen('/opt/vc/bin/vcgencmd measure_temp')
    cpu_temp = t.read()
    t.close()
    cpu_temp = cpu_temp.replace('temp=','')
    cpu_temp = cpu_temp.replace('\'C\n','')
    return float(cpu_temp)

def getmsg(entities, compensate = 0.75):
    sense = SenseHat()
    tm = time.strftime("%d/%m/%Y %H:%M:%S", time.localtime())

    t = 0
    ct = 0
    p = 0
    h = 0
    n = 5
    nr = 0
    retries = 5
    for x in range(0, n):
        a = sense.get_temperature()
        b = get_cpu_temp()
        c = sense.get_pressure()
        d = sense.get_humidity()
        if a > 0 and b > 0 and c > 0:
          t += a
          ct += b
          p += c
          h += d
          nr += 1
          if( x < n-1 ):
            time.sleep(0.5)
        elif retries > 0:
          retries -= 1
          n += 1
          if( x < n-1 ):
            time.sleep(0.2)

    if nr > 0:
      t = round((t-(ct-t)*compensate)/nr,1)
      ct = round(ct/nr,1)
      p = round(p/nr,1)
      h = round(h/nr,1)

      if entities:
        deg = "&deg;"
      else:
        deg = "\u00B0"
      msg = "[%s] Temperature = %s" % (tm,t) + deg + "C, Pressure = %shPA, Relative humidity = %s%%, CPU=%s" % (p,h,ct) + deg + "C"
      if nr < n:
        msg += " (%s/%s samples)" % (nr,n)
    else:
      msg = "Error, unable to query sensors"

    return msg

def index(max_msgs = 10,interval=5,compensate=0.75):
    msg = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">"
    msg += "<title>Silicon Chip Temperature/Pressure/Humidity</title></head><body>"
    msg += "<iframe style=\"width: 0px; height: 0px; border: 0px\" src=\"index.py/readtemp?max_msgs="+str(max_msgs)+"&interval="+str(interval)+"&compensate="+str(compensate)+"\"></iframe>"
    msg += getmsg(True, float(compensate))
    msg += "</body></html>";

    return msg

def readtemp(max_msgs = 10,interval=5,compensate=0.75):
    msg = "<html><body><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">"
    msg += "<meta http-equiv=\"refresh\" content=\""+str(interval)+"\"></head>"
    msg += "<script>parent.document.body.appendChild(parent.document.createElement('BR'));"
    msg += "parent.document.body.appendChild(parent.document.createTextNode('"+getmsg(False, float(compensate))+"'));"
    msg += "if( parent.document.getElementsByTagName('br').length >= "+str(max_msgs)+" ) {"
    msg +=   "var br = parent.document.getElementsByTagName('br').item(0);";
    msg +=   "br.parentNode.removeChild(br.previousSibling);";
    msg +=   "br.parentNode.removeChild(br);";
    msg += "}"
    msg += "</script></body></html>"
    return msg