'           GAMES TIMER AND ELECTRONIC DICE  (timer_dice20m2.bas)

'*********************** SET-UP AND SELECT A PROGRAM ***********************

power_up:' ---------- initialize the microprocessor with start-up beep 
setfreq m16
let dirsB = %00011111: let pinsB = %00000000
let dirsC = %10111111: let pinsC = %00000000
pullup %0100000011100000
if pinB.5 = 0 or pinB.6 = 0 or pinB.7 = 0 or pinC.6 = 0 then gosub de_fault
read 2,b4: if b4 = 0 then: write 2,4: endif
sound C.7,(60,30)
'goto prog_select

prog_select:' ------- random number loop - wait for PB to start a program.
for b1 = 1 to 6
for b2 = 1 to 6
if pinB.5 = 0  then: goto prog_1: endif' (games timer)
if pinB.6 = 0  then: goto prog_2: endif' (single dice)
if pinB.7 = 0  then: goto prog_3: endif' (double dice)
if pinC.6 = 0  then: goto prog_4: endif' (two-up mode)
next b2
next b1
goto prog_select

de_fault:' ---------- hold a PB at power_up saves default move time/count  
pause 10 
if pinB.5 = 0 then: b2 = 1: b1 = 0: endif' (10 sec count)
if pinB.6 = 0 then: b2 = 2: b1 = 0: endif' (20 sec count)
if pinB.7 = 0 then: b2 = 4: b1 = 0: endif' (40 sec count)
if pinC.6 = 0 then: b2 = 6: b1 = 0: endif' (60 sec count)
write 2,b2: write 1,b1
gosub loop_1
return
 
loop_1:' ----------- all four PB must be released before program continues.
pause 10
if pinB.5 = 0 or pinB.6 = 0 or pinB.7 = 0 or pinC.6 = 0 then loop_1
return

'*********************** RUN THE GAMES TIMER PROGRAM_1 *********************

prog_1:'------------ load the saved count and clear microprocessor clock 
read 1,b1: read 2,b2
let w4 = 0: time = 0
'goto display_1

display_1:'--------- show current count and monitor all pb and micro clock
for b4 = 0 to 10
on b1 gosub zero1,one1,two1,three1,four1,five1,six1,seven1,eight1,nine1'(timer_units)
on b2 gosub blank2,one2,two2,three2,four2,five2,six2,seven2,eight2,nine2'(timer_tens) 
next b4
if pinB.5 = 0 then prog_1 
if pinB.6 = 0 or pinB.7 = 0 or pinC.6 = 0 then loop_2
let w6 = time
if w6 > w4 then: goto count_down: endif
goto display_1

loop_2:' ----------- all four PB must be released before program continues.
pause 10
if pinB.5 = 0 or pinB.6 = 0 or pinB.7 = 0 or pinC.6 = 0 then loop_2
goto prog_select

count_down:'-------- decrement the count each second including a clock tick
let w4 = time
pulsout C.7,1000
dec b1
if b1 <= 9 then goto all_zeros' (units)  
b1 = 9
dec b2 
if b2 <= 9 then goto all_zeros' (tens)
b2 = 9
goto display_1

all_zeros:'--------- at zero count - beep twice and then stop the counter
pause 10
if b1 = 0 and b2 = 0 then: sound C.7,(60,80,20,80): goto prog_select: endif
goto display_1

'********************** RUN SINGLE DICE PROGRAM_2 ***********************

prog_2:'------------ single dice - rolling sound until the PB is released
pulsout C.7,4000
for b4 = 1 to 50
if pinB.6 = 1 then: pause 100: endif
if pinB.6 = 1 then: goto display_2: endif
next b4
goto prog_2

display_2:'--------- single dice face shown on the dot matrix for 3 seconds  
for b4 = 0 to 150
on b1 gosub blank3,blank3,blank3,blank3,blank3,blank3,blank3'(dice_units)
on b2 gosub blank4,one4,two4,three4,four4,five4,six4'(dice_tens) 
next b4
goto prog_select

'********************** RUN DOUBLE DICE PROGRAM_3 ***********************

prog_3:'------------ double dice - rolling sound until the PB is released.
pulsout C.7,4000
for b4 = 1 to 50
if pinB.7 = 1 then: pause 100: endif
if pinB.7 = 1 then: goto display_3: endif
next b4
goto prog_3

display_3:'--------- double dice face shown on the dot matrix for 3 seconds  
for b4 = 0 to 150
on b1 gosub blank3,one3,two3,three3,four3,five3,six3'(dice_units)
on b2 gosub blank4,one4,two4,three4,four4,five4,six4'(dice_tens) 
next b4
goto prog_select

'********************* RUN TWO-UP MODE PROGRAM_4 **********************

prog_4:'------------ two-up mode - rolling sound until the PB is released 
pulsout C.7,4000
for b4 = 1 to 50
if pinC.6 = 1 then: pause 100: endif
if pinC.6 = 1 then: goto display_4: endif
next b4
goto prog_4

display_4:'--------- heads and tails shown on the dot matrix for 3 seconds  
for b4 = 0 to 150
on b1 gosub blank3,heads3,tails3,heads3,tails3,heads3,tails3'(dice_units)
on b2 gosub blank4,tails4,heads4,tails4,heads4,tails4,heads4'(dice_tens) 
next b4
goto prog_select

'*********************** DOT MATRIX CHARACTER TABLES **********************

'-------------- timer_units -------------
zero1:
let pinsB = %00011111: pulsout C.3,1000
let pinsB = %00010001: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return   
one1:
let pinsB = %00000000: pulsout C.3,1000
let pinsB = %00011111: pulsout C.4,1000
let pinsB = %00000000: pulsout C.5,1000:return
two1:
let pinsB = %00011101: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00010111: pulsout C.5,1000:return
three1:
let pinsB = %00010101: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return
four1:
let pinsB = %00000111: pulsout C.3,1000
let pinsB = %00000100: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return
five1:
let pinsB = %00010111: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00011101: pulsout C.5,1000:return
six1:
let pinsB = %00011111: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00011101: pulsout C.5,1000:return
seven1:
let pinsB = %00000001: pulsout C.3,1000
let pinsB = %00000001: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return
eight1:
let pinsB = %00011111: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return
nine1:
let pinsB = %00010111: pulsout C.3,1000
let pinsB = %00010101: pulsout C.4,1000
let pinsB = %00011111: pulsout C.5,1000:return

'-------------- timer_tens --------------:
blank2:
let pinsB = %00000000: pulsout C.0,1000
let pinsB = %00000000: pulsout C.1,1000
let pinsB = %00000000: pulsout C.2,1000:return   
one2:
let pinsB = %00000000: pulsout C.0,1000
let pinsB = %00011111: pulsout C.1,1000
let pinsB = %00000000: pulsout C.2,1000:return
two2:
let pinsB = %00011101: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00010111: pulsout C.2,1000:return
three2:
let pinsB = %00010101: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00011111: pulsout C.2,1000:return
four2:
let pinsB = %00000111: pulsout C.0,1000
let pinsB = %00000100: pulsout C.1,1000
let pinsB = %00011111: pulsout C.2,1000:return
five2:
let pinsB = %00010111: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00011101: pulsout C.2,1000:return
six2:
let pinsB = %00011111: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00011101: pulsout C.2,1000:return
seven2:
let pinsB = %00000001: pulsout C.0,1000
let pinsB = %00000001: pulsout C.1,1000
let pinsB = %00011111: pulsout C.2,1000:return
eight2:
let pinsB = %00011111: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00011111: pulsout C.2,1000:return
nine2:
let pinsB = %00010111: pulsout C.0,1000
let pinsB = %00010101: pulsout C.1,1000
let pinsB = %00011111: pulsout C.2,1000:return

'-------------- dice_units -------------
blank3:
let pinsB = %00000000: pulsout C.3,1000
let pinsB = %00000000: pulsout C.4,1000
let pinsB = %00000000: pulsout C.5,1000:return   
one3:
let pinsB = %00000000: pulsout C.3,1000
let pinsB = %00000100: pulsout C.4,1000
let pinsB = %00000000: pulsout C.5,1000:return
two3:
let pinsB = %00000010: pulsout C.3,1000
let pinsB = %00000000: pulsout C.4,1000
let pinsB = %00001000: pulsout C.5,1000:return
three3:
let pinsB = %00001000: pulsout C.3,1000
let pinsB = %00000100: pulsout C.4,1000
let pinsB = %00000010: pulsout C.5,1000:return
four3:
let pinsB = %00001010: pulsout C.3,1000
let pinsB = %00000000: pulsout C.4,1000
let pinsB = %00001010: pulsout C.5,1000:return
five3:
let pinsB = %00001010: pulsout C.3,1000
let pinsB = %00000100: pulsout C.4,1000
let pinsB = %00001010: pulsout C.5,1000:return
six3:
let pinsB = %00001010: pulsout C.3,1000
let pinsB = %00001010: pulsout C.4,1000
let pinsB = %00001010: pulsout C.5,1000:return
heads3:
let pinsB = %00001110: pulsout C.3,1000
let pinsB = %00000100: pulsout C.4,1000
let pinsB = %00001110: pulsout C.5,1000:return
tails3:
let pinsB = %00000010: pulsout C.3,1000
let pinsB = %00001110: pulsout C.4,1000
let pinsB = %00000010: pulsout C.5,1000:return

'-------------- dice_tens --------------:
blank4:
let pinsB = %00000000: pulsout C.0,1000
let pinsB = %00000000: pulsout C.1,1000
let pinsB = %00000000: pulsout C.2,1000:return   
one4:
let pinsB = %00000000: pulsout C.0,1000
let pinsB = %00000100: pulsout C.1,1000
let pinsB = %00000000: pulsout C.2,1000:return
two4:
let pinsB = %00000010: pulsout C.0,1000
let pinsB = %00000000: pulsout C.1,1000
let pinsB = %00001000: pulsout C.2,1000:return
three4:
let pinsB = %00001000: pulsout C.0,1000
let pinsB = %00000100: pulsout C.1,1000
let pinsB = %00000010: pulsout C.2,1000:return
four4:
let pinsB = %00001010: pulsout C.0,1000
let pinsB = %00000000: pulsout C.1,1000
let pinsB = %00001010: pulsout C.2,1000:return
five4:
let pinsB = %00001010: pulsout C.0,1000
let pinsB = %00000100: pulsout C.1,1000
let pinsB = %00001010: pulsout C.2,1000:return
six4:
let pinsB = %00001010: pulsout C.0,1000
let pinsB = %00001010: pulsout C.1,1000
let pinsB = %00001010: pulsout C.2,1000:return
heads4:
let pinsB = %00001110: pulsout C.0,1000
let pinsB = %00000100: pulsout C.1,1000
let pinsB = %00001110: pulsout C.2,1000:return
tails4:
let pinsB = %00000010: pulsout C.0,1000
let pinsB = %00001110: pulsout C.1,1000
let pinsB = %00000010: pulsout C.2,1000:return


' Definition of variables

'    w4 = time old
'    w6 = time new'    
'    b1 = units count
'    b2 = tens count       
'    b4 = temp variable

