#include <Ticker.h>

Ticker rfTXtimerInt;
#define RF_TX_TIMER_PERIOD 30
#define RF_TX_PIN 3
//don't use this with Pico W, since it is too slow
//#define RF_TX_LED_PIN LED_BUILTIN

volatile bool rfTXbusy=0;
volatile bool rfTXreadyToSend=0; //set this when ready, will be cleared when sending starts
unsigned int rfTXData=0;  //set this to data

void rfTXsend(unsigned int data){ //blocking
  while(rfTXbusy || rfTXreadyToSend){}  
  rfTXData=data;
  rfTXreadyToSend=1;
  delay(1);  
}

void rfTXCallBack(void){
  static unsigned int txData;
  static int phase=-1; //idle
  if(rfTXreadyToSend && (rfTXbusy==0)){ //wait till current complete
    rfTXbusy=1;
    txData=rfTXData & 0xFFFFFF; //24 bits only
    rfTXreadyToSend=0;
    phase=0;  //start
  }
  if(phase>-1){
    if(phase==0){
      digitalWrite(RF_TX_PIN,HIGH); //start sync
    }else if(phase==1){
      digitalWrite(RF_TX_PIN,LOW); //end sync
    }else if(phase>31){
      switch(phase%4){
        case 0: digitalWrite(RF_TX_PIN,HIGH); break; //start each bit
        case 1:
          if((txData&(1<<23))==0){digitalWrite(RF_TX_PIN,LOW);}  //short pulse on 0 bit
          txData=txData<<1; //move next into position
          break;
        case 3: digitalWrite(RF_TX_PIN,LOW);break; //end each bit          
      }
      if(phase>=127){phase=-2;}
    }
    phase++;
    rfTXbusy=1;
  }else{
    digitalWrite(RF_TX_PIN,LOW);  //force low
    rfTXbusy=0;
  }
#ifdef RF_TX_LED_PIN
  if(rfTXbusy){
    digitalWrite(RF_TX_LED_PIN,HIGH);
  }else{
    digitalWrite(RF_TX_LED_PIN,LOW);
  }
#endif  
}

void rfTXStart(void){
  pinMode(RF_TX_PIN,OUTPUT);
  digitalWrite(RF_TX_PIN,LOW);
#ifdef RF_TX_LED_PIN
  pinMode(RF_TX_LED_PIN,OUTPUT);
  digitalWrite(RF_TX_LED_PIN,LOW);
#endif  
  rfTXtimerInt.attach_us(RF_TX_TIMER_PERIOD,rfTXCallBack);  //expect this as float in us
}


void rfTXStop(void){
  pinMode(RF_TX_PIN,INPUT);
#ifdef RF_TX_LED_PIN
  pinMode(RF_TX_LED_PIN,INPUT);
#endif  
  rfTXtimerInt.detach();
  rfTXbusy=0;
}

char getHex(char a){  //ascii to hex nybble
  if((a>='0')&&(a<='9')){return a-'0';}
  if((a>='a')&&(a<='f')){return a-'a'+10;}
  if((a>='A')&&(a<='F')){return a-'A'+10;}
  return 0xFF;
}
