#include <Ticker.h>

Ticker rfRXtimerInt;
#define RF_RX_TIMER_PERIOD 10
#define RF_RX_SYNC_TIME_MIN 700
#define RF_RX_PIN 2

bool rfRXReady=0;
unsigned int rfRXReceived=0;
unsigned int rfRXSyncTime=0;

void rfRXCallBack(void){
  static unsigned int rfResult=0;
  static unsigned int lastSync=0;
  static int bits=-1;
  static unsigned long tHi=0;
  static unsigned long tLo=0;
  static int count=0;
  static bool lastState=0;
  static int pulseTotal=0;
  bool thisState=digitalRead(RF_RX_PIN);
  count=count+RF_RX_TIMER_PERIOD;
  if(thisState!=lastState){
    if(thisState){  //rising edge, end of low
      tLo=count;
      count=0;
      if(tLo>RF_RX_SYNC_TIME_MIN){bits=0;rfResult=0;lastSync=tLo;pulseTotal=0;}  //assume sync on long low
      if(bits>-1){
        //Serial.printf("%2d:%6d %6d %c\r\n",bits,tHi,tLo,((tLo<tHi)?'1':'0'));
        rfResult=rfResult<<1;
        if(tLo<tHi){rfResult=rfResult|1;} //should give a 0 for sync
        pulseTotal=pulseTotal+tLo+tHi;
        bits++;
        if(bits>24){ //sync is counted
          if(rfRXReady==0){ //don't clobber unread result
            rfRXReceived=rfResult;
            rfRXSyncTime=lastSync;
            rfRXReady=1;
            //Serial.printf("%6d: %6d\r\n",pulseTotal,(pulseTotal*31)/lastSync);    //(pulseTotal*31)/lastSync should be ~128 for valid 1527 protocol
          }
          bits=-1;
          rfResult=0;
          pulseTotal=0;
        }
      }
    }else{          //falling edge, end of high
      tHi=count;
      count=0;
    }
    lastState=thisState;
  }  
}

void rfRXStart(void){
  pinMode(RF_RX_PIN,INPUT);
  rfRXtimerInt.attach_us(RF_RX_TIMER_PERIOD,rfRXCallBack);  //expect this as float in us
}

void rfRXStop(void){
  rfRXtimerInt.detach();
}
