from sense_hat import SenseHat
import time
import os

def get_cpu_temp():
    t = os.popen('/opt/vc/bin/vcgencmd measure_temp')
    cpu_temp = t.read()
    t.close()
    cpu_temp = cpu_temp.replace('temp=','')
    cpu_temp = cpu_temp.replace('\'C\n','')
    return float(cpu_temp)

sense = SenseHat()

while True:
    t = 0
    p = 0
    h = 0
    ct = 0
    n = 5
    for x in range(0, n):
        t += sense.get_temperature()
        p += sense.get_pressure()
        h += sense.get_humidity()
        ct += get_cpu_temp()
        time.sleep(0.5)
    t /= n
    p /= n
    h /= n
    ct /= n

    ta = round((t-(ct-t)*0.8),1)
    p = round(p,1)
    h = round(h,1)

    msg = "Temperature = %s, Pressure = %s, Humidity = %s" % (ta,p,h)

    print(msg)
    time.sleep(2)
