void runDiode(String type)
{
  int diodeCurrent = 0;
  int diodeVoltage = 0;
  int fwdVoltage = 0;
  sCounter = 0;
  dacWrite(cSetPin, 0);
  dacWrite(bSetPin, 255);

  for (int j = 10; j < 240; j += 2) //Voltage Ramp
  {
    dacWrite(cSetPin, j);
    delay (1);

    diodeVoltage = analogReadScaled(nLoPin);
    diodeCurrent = (analogReadScaled(nHiPin) - diodeVoltage) / 10; //Volts im mV, 100 Ohm resistor thus /10 = ma times 10
    Serial.println ("Diode Current: " + String (diodeCurrent / 10));
    if (diodeCurrent < 0)
    {
      diodeCurrent = 0;
    }
    //Adjust for emitter diode
    diodeVoltage =  diodeVoltage - adjustEmitterVoltage (diodeCurrent );

    if (diodeVoltage < 0)diodeVoltage = 0;

    //Serial.println("VFwd: " + String (diodeVoltage) + "mV  I: " + String (diodeCurrent / 10) + " mA");
    //delay (3);
    sCounter ++;
    if (diodeCurrent > 0)
    {
      cData[0][sCounter] = diodeCurrent;
    }
    else
    {
      cData[0][sCounter] = 0;

    }
    if (diodeVoltage > 0)
    {
      cData[1][sCounter] = diodeVoltage;
    }
    else
    {
      cData[1][sCounter] = 0;
    }
    if (fwdVoltage == 0 and diodeCurrent >= 95 and type != "Zener") //10mA Diode/LED fwd voltage
    {
      fwdVoltage = diodeVoltage;
    }
    if (fwdVoltage == 0 and diodeCurrent >= 195 and type == "Zener") //20mA
    {
      fwdVoltage = diodeVoltage;
    }
    if (diodeCurrent > 1545 and type == "LED")//15mA
    {
      break;
    }

    else if (diodeCurrent > 450)//45mA
    {
      break;
    }
  }
  sCounter ++;
  Serial.println ("Writing 9999 EoF");
  cData[0][sCounter] = 9999;
  cData[1][sCounter] = fwdVoltage;
  drawGraph = true;
  //delay (4000);
  Serial.println("Setting DAC 1 & 2 to zero");
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
}
