void runPNP()
{
  //set a base current, then scans V Collector
  //set new base and then rescan
  //unsigned long baseVoltage;
  long baseCurrent;
  int collectorCurrent;
  int collectorVoltage;
  int pHiPinmV;
  sCounter = 0;
  //base current loop
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
  delay (1);
  for (int i = 250; i >= 46; i -= 45)// Base Current Ramp curves
  {
    dacWrite(bSetPin, i);
    delay (1);
    Serial.println ("Increasing Base current:" + String (i));
    //baseVoltage = 9000-analogReadScaled(bLoPin);//For PNP bLoPin is higher than bHiPin
    baseCurrent = (1000 * (analogReadScaled(bLoPin) - analogReadScaled(bHiPin))) / 22000;//uA  22k base resistor
    if (baseCurrent < 0)
    {
      baseCurrent = 0;
    }
    for (int j = 250; j >= 5; j -= 5) //Collector Voltage Ramp
    {
      dacWrite(cSetPin, j);
      delay (1);
      pHiPinmV = analogReadScaled(pHiPin);
      //Serial.println ("pHiPin = " + String (pHiPinmV));
      collectorVoltage = 9000 - pHiPinmV;
      if (collectorVoltage < 0)
      {
        collectorVoltage = 0;
      }
      message = "Running PNP. Setting Base Current = -" + String (baseCurrent ) + " uA";
      handleWebSocket();
      collectorCurrent = (analogReadScaled(pHiPin) - analogReadScaled(pLoPin) ) / 10; //ma times 10
      if (collectorCurrent < 0)
      {
        collectorCurrent = 0;
      }
      //Serial.println(" VCE: -" + String (collectorVoltage) + "mV   -" + String (collectorCurrent / 10) + " mA");
      //delay (3);
      if (collectorCurrent > 500)//>50mA
      {
        break;
      }
      sCounter ++;
      if (collectorCurrent > 0)
      {
        cData[0][sCounter] = collectorCurrent;
      }
      else
      {
        cData[0][sCounter] = 0;

      }
      if (collectorVoltage > 0)
      {
        cData[1][sCounter] = collectorVoltage;
      }
      else
      {
        cData[1][sCounter] = 0;
      }
    }
    sCounter ++;
    Serial.println ("Writing 9999 EoF");
    cData[0][sCounter] = 9999;
    cData[1][sCounter] = baseCurrent;
    if (collectorCurrent > 500)
    {
      break;
    }
  }
  drawGraph = true;
  dacWrite(bSetPin, 255);
  dacWrite(cSetPin, 255);
}
