void runNMosfet1()//RdsOn vs Vgs
{
  //Graphs Rds On against V gate source
  //set drain current about 50mA
  //then ramp Vgs
  long gateVoltage;
  long gateCurrent;
  long rdsOn; // in milli Ohm
  int drainCurrent;
  int gateThreshold = 0;
  int drainVoltage;
  sCounter = 0;
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
  //Set drain current maximum
  dacWrite(cSetPin, 255);//100 ~ 30mA

  //gate voltage loop
  for (int i = 5; i <= 255; i++)//Gate Voltage Ramp curves
  {
    dacWrite(bSetPin, i);
    delay (1);
    //Serial.println ("Setting new Gate Voltage:"+ String (i));
    drainCurrent = (analogReadScaled(nHiPin) - analogReadScaled(nLoPin)) / 10;//10 times mA 100 ohm resistor
    if (drainCurrent < 0) drainCurrent = 0;
    drainVoltage = analogReadScaled(nLoPin) - adjustEmitterVoltage(drainCurrent);
    if (drainVoltage < 0) drainVoltage = 0;
    //Serial.print(analogReadScaled(bLoPin));
    //Serial.print ("  ");
    //Serial.println (adjustEmitterVoltage(drainCurrent / 10));
    gateVoltage = analogReadScaled(bLoPin) - adjustEmitterVoltage(drainCurrent );
    //Serial.println ("Vgs mV:" + String (gateVoltage) + " Drain current: " + String (drainCurrent/10) + " mA" );
    if (gateVoltage < 0)gateVoltage = 0;
    if (drainCurrent > 0)
    {
      rdsOn = drainVoltage * 1000 / drainCurrent; //222 == 2.22 ohm
    }
    else
    {
      rdsOn = 500;
    }
    if (rdsOn > 500)
    {
      rdsOn = 500;
    }
    Serial.println ("RDSOn: >" + String (rdsOn));
    message = "Running NMosfet. Setting Gate Voltage = " + String (gateVoltage ) + " mV";
    handleWebSocket();
    //if (drainCurrent > 50)
    //{
    //  break;
    //}
    if (drainCurrent > 50 and gateThreshold == 0) //5 mA
    {
      gateThreshold = gateVoltage;
      Serial.println ("Gate Threshold is:" + String (gateThreshold));
      //Serial.println ("Drain Voltage is:" + String (drainVoltage) + "mV");
      //Serial.println ("Drain Current is:" + String (drainCurrent/10) + "mA");
      //Serial.println ("RDS: " + String ((drainVoltage *10)/drainCurrent) +"Ohm");
    }
    if (rdsOn > 0)
    {
      cData[0][sCounter] = rdsOn;
    }
    else
    {
      cData[0][sCounter] = 0;
    }

    if (gateVoltage > 0)
    {
      cData[1][sCounter] = gateVoltage;
    }
    else
    {
      cData[1][sCounter] = 0;
    }
    sCounter ++;
  }
  Serial.println ("Gate Threshold is:" + String (gateThreshold));
  Serial.println ("Drain Voltage is:" + String (drainVoltage) + "mV");
  Serial.println ("Drain Current is:" + String (drainCurrent / 10) + "mA");
  if (drainCurrent > 0) //other wise divide by zero
  {
    Serial.println ("RDS On: " + String (drainVoltage  / (drainCurrent / 10)) + " Ohm");
    message = "RDS On: " + String (drainVoltage / (drainCurrent / 10)) + "Ohm";
  }
  cData[0][sCounter] = 9999;
  cData[1][sCounter] = gateThreshold;
  drawGraph = true;
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
}
