void runNMosfet0()//Id vs Vgs
{
  //set a base current, then scan V Collector
  //set new base and then rescan
  long gateVoltage;
  long gateCurrent;
  int drainCurrent;
  int gateThreshold = 0;
  int drainVoltage;
  sCounter = 0;
  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
  //Set load voltage/current
  dacWrite(cSetPin, 150);//100 ~ 30mA

  //gate voltage loop
  for (int i = 5; i <= 255; i++)//Gate Voltage Ramp curves
  {
    dacWrite(bSetPin, i);
    delay (1);
    //Serial.println ("Setting new Gate Voltage:"+ String (i));
    drainCurrent = (analogReadScaled(nHiPin) - analogReadScaled(nLoPin)) / 10;//10 times mA 100 ohm resistor
    if (drainCurrent < 0) drainCurrent = 0;
    drainVoltage = analogReadScaled(nLoPin) - adjustEmitterVoltage(drainCurrent);
    if (drainVoltage < 0) drainVoltage = 0;
    //Serial.print(analogReadScaled(bLoPin));
    //Serial.print ("  ");
    //Serial.println (adjustEmitterVoltage(drainCurrent ));
    
    gateVoltage = analogReadScaled(bLoPin) - adjustEmitterVoltage(drainCurrent );
    //Serial.println ("ADC Raw= " + String (adcRaw) +" B Lo Pin = " + String (analogReadScaled(bLoPin)) +"Vgs = "+ String (gateVoltage) +" Id = "  + String (drainCurrent) + "   Emitter Diode drop = " + String (adjustEmitterVoltage(drainCurrent )));
    //Serial.println ("Vgs mV:" + String (gateVoltage) + " Drain current: " + String (drainCurrent/10) + " mA" );
    if (gateVoltage < 0)
    {
      gateVoltage = 0;
      //Serial.println ("GATE VOLTAGE NEGATIVE");
    }
    message = "Running NMosfet. Setting Gate Voltage = " + String (gateVoltage ) + " mV";
    handleWebSocket();
    //if (drainCurrent > 50)
    //{
    //  break;
    //}
    if (drainCurrent > 50 and gateThreshold == 0) //5 mA
    {
      gateThreshold = gateVoltage;
     // Serial.println ("Gate Threshold is:" + String (gateThreshold));
      //Serial.println ("Drain Voltage is:" + String (drainVoltage) + "mV");
      //Serial.println ("Drain Current is:" + String (drainCurrent/10) + "mA");
      //Serial.println ("RDS: " + String ((drainVoltage *10)/drainCurrent) +"Ohm");
    }
    if (drainCurrent > 0)
    {
      cData[0][sCounter] = drainCurrent;
    }
    else
    {
      cData[0][sCounter] = 0;

    }

    if (gateVoltage > 0)
    {
      cData[1][sCounter] = gateVoltage;
    }
    else
    {
      cData[1][sCounter] = 0;
    }
    sCounter ++;
  }
  Serial.println ("Gate Threshold is:" + String (gateThreshold));
  Serial.println ("Drain Voltage is:" + String (drainVoltage) + "mV");
  Serial.println ("Drain Current is:" + String (drainCurrent / 10) + "mA");
  if (drainCurrent >0) //other wise divide by zero
  {
  Serial.println ("RDS On: " + String (drainVoltage  / (drainCurrent / 10)) + " Ohm");
  message = "RDS On: " + String (drainVoltage / (drainCurrent / 10)) + "Ohm";
  }
  cData[0][sCounter] = 9999;
  cData[1][sCounter] = gateThreshold;
  drawGraph = true;


  dacWrite(bSetPin, 0);
  dacWrite(cSetPin, 0);
}
