int analogReadScaled(int readPin)
{ //Gets the analogRead count for the readPin
  //and Returns an integer reprenting millivolts scaled in acordance with the calibration array.
  //Array set up in the Calibration Page.
  
  double raw = 0;
  int samples = adcOverSampling;
  float adc = 0; // is ADC count averaged
  unsigned long volts = 0;
  //Average the ADC readings with over sampling
  for (int i = 0; i < samples; i++)
  {
    raw = raw + analogRead(readPin);
  }
  adc =  raw / samples;// get the average
  if (readPin == bLoPin)
  {
    adcRaw = adc;//This raw count is used in the Calibration routine
    //Serial.println (String (adcRaw));
  }
  //adcCal[2][adcCalMax]; [0][X] == count,  [1][X]== mV  0 to 51 adcCalMax = 52
  //SCALE RAW COUNT
  for (int i = 0 ; i < adcCalMax - 1; i ++)//adcCalMax = 52 0 to 50
  {
    if (adc < adcCal[0][i + 1] )
    {
      // Serial.println(adc);
      //Serial.println(adcCal[0][i]);
      // Serial.println(adcCal[0][i + 1]);
      float ratio = (adc - adcCal[0][i]) / (adcCal[0][i + 1] - adcCal[0][i]);
      // Serial.println(adcCal[1][i]);
      // Serial.println(adcCal[1][i + 1]);
      volts = int (adcCal[1][i] + ((adcCal[1][i + 1] - adcCal[1][i]) * ratio));
      // Serial.println ("Ratio " + String (ratio) + " volts " + String (volts));
      //  delay (1000);
      break;
    }
    else  // if cunt is higher than the calibration array then set it to 9000mV
    {
      volts = 9000;
    }
  }

  //Now apply scaling factors for each pin in case of variance between ADC inputs
  //Such as might be due to differences in the ADC input scaling resistors.
  //Serial.println(  "  Raw volts; " + String (output));
  //9V/3.1V  Scaled up to real values
  if (readPin == nHiPin)
  {
    return (volts * vScaleFactorNHi) / 1000;
  }
  else if (readPin == nLoPin)
  {
    return (volts * vScaleFactorNLo) / 1000;
  }
  else if (readPin == pHiPin)
  {
    Serial.println ("pHiPin: Count " + String (adc));
    return (volts * vScaleFactorPHi) / 1000;
  }
  else if (readPin == pLoPin)
  {
    Serial.println ("pLoPin: Count " + String (adc));
    return (volts * vScaleFactorPLo) / 1000;
  }
  else if (readPin == bHiPin)
  {
    return (volts * vScaleFactorBHi) / 1000;
  }
  else if (readPin == bLoPin)
  {
    return (volts * vScaleFactorBLo) / 1000;
  }
  return 0; //values returned are dependant on readPin
}
