String  get_MAIN_page()
{
  //NOTES:
  //Creates a string for HTML Page Load and Refresh. More difficult to read than
  //Using progmem string but more flexible
  //use escape(\) and quote(") for ClientToServer eg: \"ClientToServer('timeminus')\"
  //All other instances can use the single quote(')
  // escape and n before closing quotes  ...\n"; provides HTML line feed formatting

  String ht = "";

  ht += insertHTMLHead(""); //HTML Head Text and CSS Styles

  ht +=  "<body  id ='appBody'>\n";
  //ht +=  "<h3><span id = 'pagetitle'><span> </h3>\n";

  //Message Table
  ht += insertMessagesTable("Curve Tracer Messages:");
  //Buttons
  int optLen = 2;
  String values[optLen];
  values[0] = "Id vs Vgs";
  values[1] = "RdsOn vs Vgs";

  ht += "<table><tr>\n";
  ht += insertButton( "npn", "NPN", "Table");
  ht += "<td>\n";
  ht += insertButton( "nmosfet", "N Mosfet", "");
  ht += insertSelectArray("", "nmosfetoption", values, 2, 0);
  ht += " </td> \n";
  ht += insertButton( "pnp", "PNP", "Table");
  ht += "<td>\n";
  ht += insertButton( "pmosfet", "P Mosfet", "");
  ht += insertSelectArray("", "pmosfetoption", values, 2, 0);
  ht += " </td> \n";
  ht += insertButton( "diode", "Diode", "Table");
  ht += insertButton( "led", "LED", "Table");
  ht += insertButton( "zener", "Zener", "Table");
  ht += "<td><button type = 'button' onclick = 'window.print()'>Print Page </button> </td> \n";
  ht += insertButton( "calibrateview", "Calibrate", "Table");
  ht += " </tr>\n";

  ht += " </table>\n";
  ht +=  insertSelectArray("Select Device: ", "devicelist", devices, 100, 0);
  ht += insertButton( "deletedevice", "Delete", "");
  ht += insertTextBox("devicename", "New/Edit Device: ", "", "Enter & Clear");

  //GRAPH

  ht += " <canvas id = 'myCanvas' width = '900'  height = '600' style = 'border:1px solid black;'> < / canvas > \n";
  ht += "\n";
  ht += insertGraph();


  //Client to Server
  ht +=  "<script>\n";
  ht +=  "function ClientToServer(out) \n";
  ht +=  " {\n";
  ht +=      "connection.send(out + ':'); \n";
  ht +=      "if (out.indexOf('devicelist=') > -1)\n";
  ht +=      "{\n";
  ht +=      "     document.getElementById('devicename').value = out.substring(out.indexOf('=') + 1); \n";
  //ht +=    "     alert('Gotcha'); \n";
  ht +=      "}\n";
  ht +=      "if (out.indexOf('calibrateview') > -1 || out.indexOf('devicename') > -1 || out.indexOf('deletedevice') > -1 )\n";
  ht +=      "{\n";
  ht +=        "document.getElementById('devicename').value = ''; \n";
  ht +=        "location.reload(); \n"; //refresh the whole page if new HTML Web Page data is sent
  ht +=        "}\n";
  ht +=   "}\n";


  //Server to Client Web Socket Connection Data Comma Separated String
  ht +=  "var connection = new WebSocket('ws://' + location.hostname + ':81/', ['arduino']); \n";
  ht +=  "connection.onmessage = function (state) \n";
  ht +=  " {\n";
  ht +=  "  var str = state.data.split(','); \n";
  //State Array Items
  //htmlMode #0
  //pagetitle #1 not used
  //message #2
  //Graph Type #3
  //Draw Graph #4
  //Selected Device #5
  //Spare #6
  //Spare #7
  //Spare #8
  //sample Counts #9
  //Graph Data #10 +




  ht +=  "  var htmlMode = str[0]; \n";
  ht +=  "  if (htmlMode.indexOf('Main') > -1)\n";
  ht +=  "  {\n";
  //ht +=  "    var pT = document.getElementById('pagetitle'); \n";
  //ht +=  "    if (pT.innerHTML != str[1] ) pT.innerHTML = str[1]; \n";
  ht +=  "    var m1 = document.getElementById('message'); \n";
  ht +=  "    if (m1.innerHTML != str[2] ) m1.innerHTML = str[2]; \n";
  ht +=  "    graphType = str[3]; \n";
  // ht +=  "     document.getElementById('devicename').value = str[5]; \n";

  //DRAW GRAPH
  ht +=  "    if (str[4] == 1)\n";
  ht +=  "     {\n";
  ht +=  "    deviceType = str[5]; \n";
  ht +=  "       numS = str[9]; \n";
  ht +=  "       for (var i = 0; i < numS ; i++)\n";
  ht +=  "       {\n";
  ht +=  "         db1[i] = str[(i * 2) + 10]; \n";
  ht +=  "         db2[i] = str[(i * 2) + 11]; \n";
  ht +=  "       }\n";
  ht +=  "       drawGraph(); \n";
  ht +=  "       }\n";

  ht +=  "  }\n";//If HTML Mode closing Brace
  ht +=  "}\n";//Function (state) closing Brace
  ht +=  " </script> \n";
  ht +=  " </body> \n";
  ht +=  " </html> \n";
  return ht;
}
